/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.ide.ui.internal.util.JFaceObservables;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.CopyFileAreaCombo;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SandboxNamespacePart;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SelectItemsToLoadPart;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public abstract class SelectItemsToLoadPage
extends BaseWizardPage
implements IPropertyChangeListener {
    private final LoadWizardInput input;
    private SelectItemsToLoadPart selectionPart;
    private final CombinedStatus validationStatus = new CombinedStatus();
    private DataBindingContext dataBindingContext;
    private final boolean showAdvancedTwistie;

    protected SelectItemsToLoadPage(String pageName, String title, ImageDescriptor titleImage, LoadWizardInput input, boolean showAdvancedTwistie) {
        super(pageName, title, titleImage);
        this.input = input;
        this.showAdvancedTwistie = showAdvancedTwistie;
    }

    public LoadWizardInput getInput() {
        return this.input;
    }

    protected void createBody(Composite composite) {
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        this.dataBindingContext = new DataBindingContext();
        this.selectionPart = this.createItemSelectionPart(composite);
        this.validationStatus.addStatus(this.input.getValidationStatus());
        this.createCopyFileAreaExpander(composite, context);
        DatabindingUtil.bindMessage((DialogPage)this, (IObservableValue)this.validationStatus);
        this.input.addPropertyChangeListener(this);
        Dialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_load_selectfolders");
    }

    private void createCopyFileAreaExpander(final Composite parent, WidgetFactoryContext context) {
        if (this.showAdvancedTwistie) {
            WidgetToolkit toolkit = context.getToolkit();
            ExpandableComposite copyFileAreaPart = toolkit.createExpandableComposite(parent, 18);
            copyFileAreaPart.setText(Messages.SelectFoldersToLoadPage_advanacedFeatures);
            copyFileAreaPart.setLayoutData((Object)new GridData(4, 4, true, false));
            copyFileAreaPart.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    parent.layout();
                    IWizardContainer container = SelectItemsToLoadPage.this.getContainer();
                    if (container instanceof IWizardContainer2) {
                        ((IWizardContainer2)container).updateSize();
                    }
                }
            });
            Composite composite = new Composite((Composite)copyFileAreaPart, 0);
            copyFileAreaPart.setClient((Control)composite);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createCopyFileAreaPart(composite, context);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
            copyFileAreaPart.setExpanded(this.input.useParentFolder() || !this.isEclipseSandboxSelected() || (this.input.getEclipseSpecificOptions() & 1) == 0);
        } else {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createCopyFileAreaPart(composite, context);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        }
    }

    private boolean isEclipseSandboxSelected() {
        ILocation curSandboxPath = this.input.getSandboxPath();
        Object adapted = curSandboxPath.getAdapter(IPath.class);
        if (adapted == null) {
            return false;
        }
        IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        return rootPath.equals((Object)rootPath);
    }

    public void dispose() {
        super.dispose();
        this.dataBindingContext.dispose();
        this.input.removePropertyChangeListener(this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getDataBindingContext().updateModels();
            this.selectionPart.initialize();
            this.selectionPart.getControl().setFocus();
            this.getContainer().updateButtons();
        }
    }

    protected void createCopyFileAreaPart(Composite composite, WidgetFactoryContext context) {
        CopyFileAreaCombo copyFileAreaCombo = new CopyFileAreaCombo(composite, context, this.getCopyFileAreaComboDescription()){

            @Override
            protected boolean filterSandbox(ISandbox sandbox) {
                return !SelectItemsToLoadPage.this.getStorageIdForPage().equals(sandbox.getRoot().getStorageId());
            }

            @Override
            protected ILocation createSandboxLocation(Shell shell) {
                return SelectItemsToLoadPage.this.createSandboxLocation(shell);
            }
        };
        IObservableValue connectionStatus = copyFileAreaCombo.connectLoadInput(this.getInput(), this.dataBindingContext);
        this.validationStatus.addStatus(connectionStatus);
        this.validationStatus.addStatus(this.input.getValidationStatus());
        SandboxNamespacePart workspaceNamespacePart = new SandboxNamespacePart(composite, context, this.getInput(), this.getContainer());
        workspaceNamespacePart.initNamespace();
        SelectItemsToLoadPage.createPreserveFileTimestampCheckbox(composite, this.getDataBindingContext(), this.getInput());
    }

    protected String getStorageIdForPage() {
        return "com.ibm.team.filesystem.hfs";
    }

    protected ILocation createSandboxLocation(Shell shell) {
        DirectoryDialog dialog = new DirectoryDialog(shell);
        dialog.setFilterPath(new PathLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation()).toOSString());
        String pathString = dialog.open();
        if (pathString != null) {
            IPath path = Path.fromOSString((String)pathString);
            return new PathLocation(path);
        }
        return null;
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.input.getSandboxPath() != null && this.getStorageIdForPage().equals(this.input.getSandboxPath().getStorageId());
    }

    protected final DataBindingContext getDataBindingContext() {
        return this.dataBindingContext;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.ibm.team.filesystem.ide.ui.ErrorMessageProperty")) {
            this.getContainer().updateButtons();
        }
    }

    protected abstract SelectItemsToLoadPart createItemSelectionPart(Composite var1);

    protected abstract String getCopyFileAreaComboDescription();

    public static void createPreserveFileTimestampCheckbox(Composite parent, DataBindingContext dataBindingContext, LoadOperationInput input) {
        Button preserveFileTimestamps = new Button(parent, 96);
        preserveFileTimestamps.setText(Messages.SelectItemsToLoadPage_0);
        GridDataFactory.defaultsFor((Control)preserveFileTimestamps).grab(true, false).align(4, 0x1000000).span(3, 1).applyTo((Control)preserveFileTimestamps);
        ISWTObservableValue value = WidgetProperties.widgetSelection().observe((Widget)preserveFileTimestamps);
        value.setValue((Object)input.isPreserveFileTimestamps());
        IObservableValue modelValue = JFaceObservables.observeProperty((Object)input, "preserveFileTimestamps", "com.ibm.team.filesystem.ide.ui.PreserveFileTimestampsProperty");
        dataBindingContext.bindValue((IObservableValue)value, modelValue, null, null);
    }
}

