/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SelectItemsToLoadPart;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesView;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class SelectFoldersToLoadPart
extends SelectItemsToLoadPart {
    private SimpleTreeViewer viewer;

    public SelectFoldersToLoadPart(Composite parent, LoadWizardInput loadOperation, IRunnableContext runnableContext) {
        super(parent, loadOperation, runnableContext, false);
    }

    @Override
    protected String getSelectAllButtonText() {
        return Messages.SelectFoldersToLoadPart_SelectAllFoldersButton;
    }

    @Override
    protected void addExtraButtons(Composite composite) {
        Button selectAllComponentsButton = new Button(composite, 8);
        selectAllComponentsButton.setText(Messages.SelectFoldersToLoadPart_SelectAllComponentsButton);
        selectAllComponentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectFoldersToLoadPart.this.viewer != null && !SelectFoldersToLoadPart.this.viewer.getTree().isDisposed()) {
                    TreeItem[] treeItemArray = SelectFoldersToLoadPart.this.viewer.getTree().getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem treeItem = treeItemArray[n2];
                        Object data = treeItem.getData();
                        if (data instanceof WorkspaceComponentWrapper) {
                            WorkspaceComponentWrapper component = (WorkspaceComponentWrapper)data;
                            SelectFoldersToLoadPart.this.updateSelectedFolders(component, true);
                            treeItem.setChecked(true);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    @Override
    protected SimpleTreeViewer createViewer(Composite composite) {
        this.viewer = super.createViewer(composite);
        RepositoryFilesView.makeAutoExpandable(this.viewer);
        this.viewer.getTree().addListener(13, new Listener(){

            public void handleEvent(final Event event) {
                if (event.detail == 32) {
                    BusyIndicator.showWhile((Display)event.display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreeItem item = (TreeItem)event.item;
                            Object data = item.getData();
                            if (data instanceof WorkspaceComponentWrapper) {
                                WorkspaceComponentWrapper component = (WorkspaceComponentWrapper)data;
                                SelectFoldersToLoadPart.this.updateSelectedFolders(component, item.getChecked());
                            }
                            if (data instanceof NamedSiloedItem) {
                                SelectFoldersToLoadPart.this.updateSelectedFolders((NamedSiloedItem)((Object)data), item.getChecked());
                            }
                        }
                    });
                }
            }
        });
        this.viewer.getKnownElements().addListener((ISetListener)new ISetListener<Object>(){

            public void changed(SetDiff<Object> diff) {
                SelectFoldersToLoadPart.this.getLoadOperation().updateFolderTree(diff.getAdditions());
            }
        });
        return this.viewer;
    }

    void updateSelectedFolders(NamedSiloedItem item, boolean selected) {
        if (selected) {
            this.getLoadOperation().getSelectedFolders().add(item, true);
        } else {
            this.getLoadOperation().getSelectedFolders().remove(item, true);
        }
    }

    void updateSelectedFolders(WorkspaceComponentWrapper component, boolean selected) {
        LoadWizardInput loadOp = this.getLoadOperation();
        NamedSiloedItem componentItem = new NamedSiloedItem(component.getComponent(), "", (IVersionableHandle)component.getComponent().getRootFolder());
        if (selected) {
            loadOp.getSelectedFolders().add(componentItem, true);
        } else if (loadOp.getSelectedFolders().contains(componentItem)) {
            Map<String, IFolderHandle> folders = loadOp.getFolders(component);
            if (folders.isEmpty()) {
                loadOp.getSelectedFolders().remove(componentItem, true);
            } else {
                HashSet<NamedSiloedItem> items = new HashSet<NamedSiloedItem>(folders.size());
                for (Map.Entry<String, IFolderHandle> folderEntry : folders.entrySet()) {
                    items.add(new NamedSiloedItem(component.getComponent(), folderEntry.getKey(), (IVersionableHandle)folderEntry.getValue()));
                }
                loadOp.getSelectedFolders().addAll(items, true);
            }
        } else {
            Set<NamedSiloedItem> items = loadOp.getSelectedFolders().getFoldersFor(component.getComponent());
            loadOp.getSelectedFolders().removeAll(items);
        }
    }
}

