/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SelectItemsToLoadPart;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesView;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class SelectFilesToLoadPart
extends SelectItemsToLoadPart {
    public SelectFilesToLoadPart(Composite parent, LoadWizardInput loadOperation, IRunnableContext runnableContext) {
        super(parent, loadOperation, runnableContext, true);
    }

    @Override
    protected SimpleTreeViewer createViewer(Composite composite) {
        SimpleTreeViewer viewer = super.createViewer(composite);
        RepositoryFilesView.makeAutoExpandable(viewer);
        viewer.getTree().addListener(13, new Listener(){

            public void handleEvent(final Event event) {
                if (event.detail == 32) {
                    BusyIndicator.showWhile((Display)event.display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreeItem item = (TreeItem)event.item;
                            Object data = item.getData();
                            if (data instanceof WorkspaceComponentWrapper) {
                                WorkspaceComponentWrapper component = (WorkspaceComponentWrapper)data;
                                SelectFilesToLoadPart.this.updateSelectedItems(component, item.getChecked());
                            }
                            if (data instanceof NamedSiloedItem) {
                                SelectFilesToLoadPart.this.updateSelectedItems((NamedSiloedItem)((Object)data), item.getChecked());
                            }
                        }
                    });
                }
            }
        });
        viewer.getKnownElements().addListener((ISetListener)new ISetListener<Object>(){

            public void changed(SetDiff<Object> diff) {
                SelectFilesToLoadPart.this.getLoadOperation().updateFolderTree(diff.getAdditions());
            }
        });
        return viewer;
    }

    void updateSelectedItems(NamedSiloedItem item, boolean selected) {
        if (selected) {
            this.getLoadOperation().getSelectedFolders().add(item, true);
        } else {
            this.getLoadOperation().getSelectedFolders().remove(item, true);
        }
    }

    void updateSelectedItems(WorkspaceComponentWrapper component, boolean selected) {
        LoadWizardInput loadOp = this.getLoadOperation();
        NamedSiloedItem componentItem = new NamedSiloedItem(component.getComponent(), "", (IVersionableHandle)component.getComponent().getRootFolder());
        if (selected) {
            loadOp.getSelectedFolders().add(componentItem, true);
        } else if (loadOp.getSelectedFolders().contains(componentItem)) {
            Map<String, IFolderHandle> folders = loadOp.getFolders(component);
            if (folders.isEmpty()) {
                loadOp.getSelectedFolders().remove(componentItem, true);
            } else {
                HashSet<NamedSiloedItem> items = new HashSet<NamedSiloedItem>(folders.size());
                for (Map.Entry<String, IFolderHandle> folderEntry : folders.entrySet()) {
                    items.add(new NamedSiloedItem(component.getComponent(), folderEntry.getKey(), (IVersionableHandle)folderEntry.getValue()));
                }
                loadOp.getSelectedFolders().addAll(items, true);
            }
        } else {
            Set<NamedSiloedItem> items = loadOp.getSelectedFolders().getFoldersFor(component.getComponent());
            loadOp.getSelectedFolders().removeAll(items);
        }
    }
}

