/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ui.changes.RenameChangeSetUtil;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SandboxNamespacePart {
    private final Button useParentFolder;
    private final Text folderText;
    private final Button browseButton;
    private final IWizardContainer fWizardContainer;
    private final Label fSubfolderWarningLabel;
    private final Label fWarningImage;
    private final Composite fSubFolderWarningComposite;
    private final ResourceManager fResourceManager;
    private final LoadWizardInput loadWizardInput;

    public SandboxNamespacePart(final Composite parent, WidgetFactoryContext context, LoadWizardInput input, IWizardContainer wizardContainer) {
        int width;
        this.loadWizardInput = input;
        WidgetToolkit toolkit = context.getToolkit();
        this.fWizardContainer = wizardContainer;
        this.useParentFolder = new Button(parent, 96);
        this.useParentFolder.setText(Messages.WorkspaceNamespace_FOLDER_LABEL);
        GridDataFactory.defaultsFor((Control)this.useParentFolder).grab(true, false).align(4, 0x1000000).span(3, 1).applyTo((Control)this.useParentFolder);
        this.useParentFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Boolean selected = SandboxNamespacePart.this.useParentFolder.getSelection();
                if (SandboxNamespacePart.this.folderText != null) {
                    SandboxNamespacePart.this.folderText.setEnabled(selected.booleanValue());
                }
                if (SandboxNamespacePart.this.browseButton != null) {
                    SandboxNamespacePart.this.browseButton.setEnabled(selected.booleanValue());
                }
                if (selected.booleanValue()) {
                    SandboxNamespacePart.this.loadWizardInput.setAndRefreshPathWithinSandbox(SandboxNamespacePart.this.folderText.getText());
                } else {
                    SandboxNamespacePart.this.loadWizardInput.unuseParentFolder();
                    ((GridData)((SandboxNamespacePart)SandboxNamespacePart.this).fSubFolderWarningComposite.getLayoutData()).exclude = true;
                    SandboxNamespacePart.this.fSubFolderWarningComposite.setVisible(false);
                    if (parent != null && !parent.isDisposed()) {
                        parent.layout(true, true);
                    }
                }
            }
        });
        this.folderText = new Text(parent, 2052);
        GridData textData = new GridData(4, 4, true, false);
        textData.widthHint = width = RenameChangeSetUtil.computeTextHeight(this.folderText, 300);
        textData.heightHint = RenameChangeSetUtil.computeTextHeight(this.folderText, width, 1);
        this.folderText.setLayoutData((Object)textData);
        this.folderText.setFocus();
        this.folderText.selectAll();
        this.folderText.setEditable(false);
        if (!this.useParentFolder.getSelection()) {
            this.folderText.setEnabled(false);
        }
        GridDataFactory.defaultsFor((Control)this.folderText).grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)this.folderText);
        this.browseButton = toolkit.createButton(parent, Messages.WorkspaceNamespace_BROWSE_BUTTON, 72);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell shell = parent.getShell();
                final ILocation location = SandboxNamespacePart.this.createSandboxSubfolderLocation(shell);
                if (location != null) {
                    SandboxNamespacePart.this.run(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            final IRelativeLocation relativePath = location.getLocationRelativeTo(SandboxNamespacePart.this.loadWizardInput.getSandboxPath());
                            final String subFolderName = location.getName();
                            final IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(subFolderName);
                            if (!shell.isDisposed()) {
                                SWTUtil.greedyExec((Display)shell.getDisplay(), (Control)shell, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        IWizardContainer container;
                                        if (!SandboxNamespacePart.this.fWarningImage.isDisposed() && !SandboxNamespacePart.this.fSubfolderWarningLabel.isDisposed()) {
                                            SandboxNamespacePart.this.updateSubFolderWarningMessage(relativePath);
                                        }
                                        if (resource == null || MessageDialog.openQuestion((Shell)shell, (String)Messages.LoadAsWizardInput_CONFIRM_USE_MULTIPLE_FOLDER_DIALOG_TITLE, (String)Messages.LoadAsWizardInput_CONFIRM_USE_MULTIPLE_FOLDER_DIALOG_MESSAGE)) {
                                            SandboxNamespacePart.this.loadWizardInput.setAndRefreshPathWithinSandbox(subFolderName);
                                            if (!SandboxNamespacePart.this.folderText.isDisposed()) {
                                                SandboxNamespacePart.this.folderText.setText(subFolderName);
                                            }
                                        }
                                        if (parent != null && !parent.isDisposed()) {
                                            parent.getShell().layout(true, true);
                                        }
                                        if ((container = SandboxNamespacePart.this.fWizardContainer) instanceof IWizardContainer2) {
                                            ((IWizardContainer2)container).updateSize();
                                        }
                                    }
                                });
                            }
                        }
                    }, parent.getShell());
                }
            }
        });
        this.browseButton.setLayoutData((Object)new GridData(4, 2, false, false));
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fSubFolderWarningComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(this.fSubFolderWarningComposite);
        GridDataFactory.fillDefaults().grab(true, false).span(4, 1).applyTo((Control)this.fSubFolderWarningComposite);
        this.fWarningImage = new Label(this.fSubFolderWarningComposite, 0);
        this.fSubfolderWarningLabel = new Label(this.fSubFolderWarningComposite, 64);
        GridDataFactory.defaultsFor((Control)this.fSubfolderWarningLabel).grab(true, false).align(4, 4).applyTo((Control)this.fSubfolderWarningLabel);
        this.fWarningImage.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SandboxNamespacePart.this.dispose();
            }
        });
        if (!this.useParentFolder.getSelection()) {
            this.folderText.setEnabled(false);
            this.browseButton.setEnabled(false);
            ((GridData)this.fSubFolderWarningComposite.getLayoutData()).exclude = true;
            this.fSubFolderWarningComposite.setVisible(false);
        }
    }

    public void initNamespace() {
        this.useParentFolder.setSelection(this.loadWizardInput.useParentFolder());
        String folderString = this.loadWizardInput.getPathWithinSandbox();
        this.folderText.setText(folderString);
        Boolean selected = this.useParentFolder.getSelection();
        if (this.folderText != null) {
            this.folderText.setEnabled(selected.booleanValue());
        }
        if (this.browseButton != null) {
            this.browseButton.setEnabled(selected.booleanValue());
        }
    }

    protected ILocation createSandboxSubfolderLocation(Shell shell) {
        DirectoryDialog dialog = new DirectoryDialog(shell);
        String osStringPath = this.loadWizardInput.getSandboxPath().toOSString();
        IPath sandboxPath = Path.fromOSString((String)osStringPath);
        dialog.setFilterPath(osStringPath);
        String pathString = dialog.open();
        if (pathString != null) {
            IPath path = Path.fromOSString((String)pathString);
            if (sandboxPath.isPrefixOf(path) && !sandboxPath.equals((Object)path)) {
                return new PathLocation(path);
            }
            ErrorDialog.openError((Shell)shell, null, (String)Messages.WorkspaceNamespace_SELECT_FOLDER_FAILURE, (IStatus)StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.WorkspaceNamespace_SELECT_FOLDER_FAILURE_REASON, (Object)path.toOSString())));
        }
        return null;
    }

    private boolean run(IRunnableWithProgress runnable, Shell shell) {
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnable);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                CoreException ce = (CoreException)t;
                StatusUtil.log((Object)this, (Throwable)ce);
                ErrorDialog.openError((Shell)shell, null, null, (IStatus)ce.getStatus());
            } else {
                ErrorDialog.openError((Shell)shell, null, null, (IStatus)StatusUtil.newStatus((Object)this, (Throwable)t));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    private void updateSubFolderWarningMessage(IRelativeLocation relativePath) {
        if (relativePath.segmentCount() != 1) {
            ((GridData)this.fSubFolderWarningComposite.getLayoutData()).exclude = false;
            this.fSubFolderWarningComposite.setVisible(true);
            this.fWarningImage.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.WARNING_ICON));
            this.fSubfolderWarningLabel.setText(Messages.LoadAsWizardInput_WARNING_MESSAGE_WHEN_NESTED_SUBFOLDER_SELECTED_WHILE_LOAD);
        } else if (this.fSubfolderWarningLabel != null && this.fWarningImage != null) {
            ((GridData)this.fSubFolderWarningComposite.getLayoutData()).exclude = true;
            this.fSubFolderWarningComposite.setVisible(false);
        }
    }

    private void dispose() {
        this.fResourceManager.dispose();
    }
}

