/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.ILoadRuleFactory;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class RemoteLoadRuleWrapper {
    Map<IComponentHandle, IFileItemHandle> fLoadRuleFile = new HashMap<IComponentHandle, IFileItemHandle>();
    private static final String COMPONENT = "component=";
    private static final String FILEITEM = "fileitem=";

    public RemoteLoadRuleWrapper(Map<IComponentHandle, IFileItemHandle> files) {
        if (files != null) {
            HashSet<UUID> componentIds = new HashSet<UUID>();
            for (Map.Entry<IComponentHandle, IFileItemHandle> entry : files.entrySet()) {
                if (!componentIds.add(entry.getKey().getItemId())) {
                    throw new IllegalArgumentException();
                }
                this.fLoadRuleFile.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public RemoteLoadRuleWrapper(String propertySetting) {
        if (propertySetting == null || propertySetting.length() == 0) {
            return;
        }
        String UUIDs = propertySetting.trim();
        while (UUIDs.length() > 0) {
            UUID fileUUID;
            String fileID;
            UUID componentUUID;
            if (!UUIDs.startsWith(COMPONENT)) {
                throw new IllegalArgumentException(NLS.bind((String)"Malformed load rules property setting {0}", (Object)propertySetting));
            }
            int idx = (UUIDs = UUIDs.substring(COMPONENT.length())).indexOf(FILEITEM);
            if (idx == -1) {
                throw new IllegalArgumentException(NLS.bind((String)"Malformed load rules property setting {0}", (Object)propertySetting));
            }
            String componentID = UUIDs.substring(0, idx);
            try {
                componentUUID = UUID.valueOf((String)componentID);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(NLS.bind((String)"Malformed UUID {0} in load rules parameter {1}", (Object)componentID, (Object)propertySetting));
            }
            if (idx + FILEITEM.length() + 1 > UUIDs.length()) {
                throw new IllegalArgumentException(NLS.bind((String)"Malformed load rules property setting {0}", (Object)propertySetting));
            }
            if ((idx = (UUIDs = UUIDs.substring(idx + FILEITEM.length())).indexOf(COMPONENT)) == -1) {
                fileID = UUIDs;
                UUIDs = "";
            } else {
                fileID = UUIDs.substring(0, idx);
                UUIDs = UUIDs.substring(idx);
            }
            try {
                fileUUID = UUID.valueOf((String)fileID);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(NLS.bind((String)"Malformed File UUID {0} in load rules parameter {1}", (Object)fileID, (Object)propertySetting));
            }
            this.fLoadRuleFile.put((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUUID, null), (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(fileUUID, null));
        }
    }

    public Collection<ILoadRule2> getLoadRules(ITeamRepository teamRepository, IWorkspace workspace, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)monitor.newChild(10));
        return this.getLoadRules(workspaceConnection, (IProgressMonitor)monitor.newChild(90));
    }

    public Collection<ILoadRule2> getLoadRules(IWorkspaceConnection workspaceConnection, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.fLoadRuleFile.size());
        ArrayList<ILoadRule2> loadRules = new ArrayList<ILoadRule2>(this.fLoadRuleFile.size());
        for (Map.Entry<IComponentHandle, IFileItemHandle> entry : this.fLoadRuleFile.entrySet()) {
            ILoadRule2 rule = ILoadRuleFactory.loadRuleFactory.getLoadRule(workspaceConnection, entry.getKey(), entry.getValue(), (IProgressMonitor)monitor.newChild(1));
            loadRules.add(rule);
        }
        return loadRules;
    }

    public ILoadRule2 getLoadRule(ITeamRepository teamRepository, IWorkspace workspace, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)monitor.newChild(10));
        return this.getLoadRule((IConnection)workspaceConnection, true, (IProgressMonitor)monitor.newChild(90));
    }

    public ILoadRule2 getLoadRule(IConnection connection, boolean allowNestedShares, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.fLoadRuleFile.size());
        ILoadRule2 loadRule = null;
        if (this.fLoadRuleFile.size() > 0) {
            IBaselineConnection bc;
            Map.Entry<IComponentHandle, IFileItemHandle> entry = this.fLoadRuleFile.entrySet().iterator().next();
            if (connection instanceof IWorkspaceConnection) {
                IWorkspaceConnection wc = (IWorkspaceConnection)connection;
                loadRule = ILoadRuleFactory.loadRuleFactory.getLoadRule(wc, entry.getKey(), entry.getValue(), allowNestedShares, (IProgressMonitor)monitor.newChild(1));
            }
            if (connection instanceof IBaselineConnection && (bc = (IBaselineConnection)connection).getComponent().sameItemId((IItemHandle)entry.getKey())) {
                loadRule = ILoadRuleFactory.loadRuleFactory.getLoadRule(bc, entry.getValue(), allowNestedShares, (IProgressMonitor)monitor.newChild(1));
            }
        }
        return loadRule;
    }

    public Map<IComponentHandle, IFileItemHandle> getLoadRuleFiles() {
        return Collections.unmodifiableMap(this.fLoadRuleFile);
    }

    public String getDialogSettingProperty() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<IComponentHandle, IFileItemHandle> entry : this.fLoadRuleFile.entrySet()) {
            builder.append(COMPONENT);
            builder.append(entry.getKey().getItemId().getUuidValue());
            builder.append(' ');
            builder.append(FILEITEM);
            builder.append(entry.getValue().getItemId().getUuidValue());
            builder.append(' ');
        }
        return builder.toString();
    }
}

