/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.ide.ui.internal.util.JFaceObservables;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadAsWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProjectOptionsRadioPart {
    private static final int CREATE_PROJECTS_FOR_SELECTED_FOLDERS = 1;
    private static final int CREATE_PROJECTS_FOR_ECLIPSE_PROJECTS = 2;
    private static final int DO_NOT_CREATE_ECLIPSE_PROJECTS = 0;
    private static final int USE_NAME_IN_DOT_PROJECT_FILE = 8;
    private final Button createProjectsForSelectedFolder;
    private final Button createProjectsForEclipseProject;
    private final Button createNoProjects;
    private final Button useNameInDotProjectFileButton;
    private final WritableValue projectCreationPolicy = new WritableValue();
    private final LoadOperationInput loadWizardInput;

    public ProjectOptionsRadioPart(Composite parent, WidgetFactoryContext context, LoadOperationInput input, int columns, boolean isSingleFolder) {
        this.loadWizardInput = input;
        WidgetToolkit toolkit = context.getToolkit();
        this.createProjectsForSelectedFolder = toolkit.createButton(parent, isSingleFolder ? Messages.SelectFoldersToLoadPage_createEclipseProject : Messages.SelectFoldersToLoadPage_createEclipseProjects, 16);
        GridDataFactory.defaultsFor((Control)this.createProjectsForSelectedFolder).grab(true, false).align(4, 0x1000000).span(columns, 1).applyTo((Control)this.createProjectsForSelectedFolder);
        this.createProjectsForSelectedFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectOptionsRadioPart.this.updateUseNameInDotProjectFileButtonEnablement();
                ProjectOptionsRadioPart.this.updateProjectCreationPolicy();
            }
        });
        this.createProjectsForEclipseProject = toolkit.createButton(parent, isSingleFolder ? Messages.SelectFoldersToLoadPage_FindAndLoadEclipseProject : Messages.SelectFoldersToLoadPage_FindAndLoadEclipseProjects, 16);
        GridDataFactory.defaultsFor((Control)this.createProjectsForEclipseProject).grab(true, false).align(4, 0x1000000).span(columns, 1).applyTo((Control)this.createProjectsForEclipseProject);
        this.createProjectsForEclipseProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectOptionsRadioPart.this.updateUseNameInDotProjectFileButtonEnablement();
                ProjectOptionsRadioPart.this.updateProjectCreationPolicy();
            }
        });
        this.createNoProjects = toolkit.createButton(parent, isSingleFolder ? Messages.SelectFoldersToLoadPage_doNotCreateEclipseProject : Messages.SelectFoldersToLoadPage_doNotCreateEclipseProjects, 16);
        GridDataFactory.defaultsFor((Control)this.createNoProjects).grab(true, false).align(4, 0x1000000).span(columns, 1).applyTo((Control)this.createNoProjects);
        this.createNoProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectOptionsRadioPart.this.updateUseNameInDotProjectFileButtonEnablement();
                ProjectOptionsRadioPart.this.updateProjectCreationPolicy();
            }
        });
        this.useNameInDotProjectFileButton = toolkit.createButton(parent, Messages.ProjectOptionsRadioPart_UseNameInDotProjectFileButton, 32);
        GridDataFactory.defaultsFor((Control)this.useNameInDotProjectFileButton).grab(true, false).align(4, 0x1000000).span(columns, 1).applyTo((Control)this.useNameInDotProjectFileButton);
        this.useNameInDotProjectFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectOptionsRadioPart.this.updateProjectCreationPolicy();
            }
        });
        this.useNameInDotProjectFileButton.setSelection((input.getEclipseSpecificOptions() & 8) == 8);
        if (!(this.loadWizardInput instanceof LoadAsWizardInput)) {
            this.useNameInDotProjectFileButton.setSelection(false);
            this.useNameInDotProjectFileButton.setVisible(false);
            GridDataFactory.defaultsFor((Control)this.useNameInDotProjectFileButton).exclude(true).applyTo((Control)this.useNameInDotProjectFileButton);
        }
        this.projectCreationPolicy.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                int flags = (Integer)ProjectOptionsRadioPart.this.projectCreationPolicy.getValue();
                ProjectOptionsRadioPart.this.createProjectsForSelectedFolder.setSelection(true);
                if ((flags & 1) == 1) {
                    ProjectOptionsRadioPart.this.createProjectsForSelectedFolder.setSelection(true);
                    ProjectOptionsRadioPart.this.createProjectsForEclipseProject.setSelection(false);
                    ProjectOptionsRadioPart.this.createNoProjects.setSelection(false);
                } else if ((flags & 2) == 2) {
                    ProjectOptionsRadioPart.this.createProjectsForSelectedFolder.setSelection(false);
                    ProjectOptionsRadioPart.this.createProjectsForEclipseProject.setSelection(true);
                    ProjectOptionsRadioPart.this.createNoProjects.setSelection(false);
                } else if (flags == 0 || flags == 8) {
                    ProjectOptionsRadioPart.this.createProjectsForSelectedFolder.setSelection(false);
                    ProjectOptionsRadioPart.this.createProjectsForEclipseProject.setSelection(false);
                    ProjectOptionsRadioPart.this.createNoProjects.setSelection(true);
                }
                ProjectOptionsRadioPart.this.updateUseNameInDotProjectFileButtonEnablement();
                if (ProjectOptionsRadioPart.this.useNameInDotProjectFileButton.isEnabled()) {
                    ProjectOptionsRadioPart.this.useNameInDotProjectFileButton.setSelection((flags & 8) == 8);
                }
            }
        });
        this.projectCreationPolicy.setValue((Object)input.getEclipseSpecificOptions());
        this.updateUseNameInDotProjectFileButtonEnablement();
    }

    public void connectToInput(DataBindingContext dataBindingContext, LoadOperationInput input) {
        IObservableValue createProjectModelValue = JFaceObservables.observeProperty((Object)input, "eclipseSpecificOptions", "com.ibm.team.filesystem.ide.ui.EclipseSpecificOptionsProperty");
        dataBindingContext.bindValue((IObservableValue)this.projectCreationPolicy, createProjectModelValue, null, null);
        this.projectCreationPolicy.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                int type = (Integer)ProjectOptionsRadioPart.this.projectCreationPolicy.doGetValue();
                ProjectOptionsRadioPart.this.loadWizardInput.setEclipseSpecificOptions(type);
            }
        });
        IObservableValue sandboxModelValue = JFaceObservables.observeProperty((Object)input, "sandboxPath", "com.ibm.team.filesystem.ide.ui.SandboxPathProperty");
        sandboxModelValue.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ProjectOptionsRadioPart.this.updateUseNameInDotProjectFileButtonEnablement();
                ProjectOptionsRadioPart.this.updateProjectCreationPolicy();
            }
        });
        IObservableValue localPathModelValue = JFaceObservables.observeProperty((Object)input, "pathWithinSandbox", "com.ibm.team.filesystem.ide.ui.PathWithinSandboxProperty");
        localPathModelValue.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ProjectOptionsRadioPart.this.updateUseNameInDotProjectFileButtonEnablement();
                ProjectOptionsRadioPart.this.updateProjectCreationPolicy();
            }
        });
    }

    private void updateProjectCreationPolicy() {
        int originalValue;
        if (this.useNameInDotProjectFileButton.isDisposed()) {
            return;
        }
        int newValue = originalValue = this.loadWizardInput.getEclipseSpecificOptions();
        if (this.createProjectsForSelectedFolder.getSelection()) {
            newValue = 1;
        } else if (this.createProjectsForEclipseProject.getSelection()) {
            newValue = 2;
        } else if (this.createNoProjects.getSelection()) {
            newValue = 0;
        }
        newValue = this.useNameInDotProjectFileButton.isEnabled() && this.useNameInDotProjectFileButton.getSelection() ? (newValue |= 8) : (newValue &= 0xFFFFFFF7);
        if (newValue != originalValue) {
            this.projectCreationPolicy.setValue((Object)newValue);
        }
    }

    private void updateUseNameInDotProjectFileButtonEnablement() {
        if (this.useNameInDotProjectFileButton.isDisposed()) {
            return;
        }
        boolean enableButton = false;
        if (this.createProjectsForSelectedFolder.getSelection() || this.createProjectsForEclipseProject.getSelection()) {
            if (this.isRenamingFile()) {
                enableButton = true;
            }
            if (this.isLoadingDirectlyInEclipseWorkspace()) {
                enableButton = false;
            }
        } else if (this.createNoProjects.getSelection()) {
            enableButton = false;
        }
        this.useNameInDotProjectFileButton.setEnabled(enableButton);
    }

    private boolean isRenamingFile() {
        boolean isRenamingFile = false;
        if (this.loadWizardInput instanceof LoadAsWizardInput) {
            String newName;
            LoadAsWizardInput loadAswizardInput = (LoadAsWizardInput)this.loadWizardInput;
            String originalName = loadAswizardInput.isLoadingComponentRoot() ? loadAswizardInput.getItem().getTargetProjectName() : loadAswizardInput.getItem().getName();
            IRelativeLocation locationWithinSandbox = this.loadWizardInput.getRelativeLocationWithinSandbox();
            String string = newName = locationWithinSandbox != null ? locationWithinSandbox.getName() : "";
            if (!originalName.equals(newName)) {
                isRenamingFile = true;
            }
        }
        return isRenamingFile;
    }

    private boolean isLoadingDirectlyInEclipseWorkspace() {
        boolean inWorkspace = false;
        ILocation sandboxRoot = this.loadWizardInput.getSandboxPath();
        IPath eclipseWorkspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (sandboxRoot.toOSString().equals(eclipseWorkspace.toOSString())) {
            try {
                if (this.loadWizardInput.getRelativeLocationWithinSandbox().segmentCount() == 1) {
                    inWorkspace = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inWorkspace;
    }
}

