/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.AncestorReportWrapper;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SelectItemsToLoadPart;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SharesOnDisk;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProblemReport {
    private final Map<String, Set<NamedSiloedItem>> collisionsMap = new HashMap<String, Set<NamedSiloedItem>>();
    private final Map<NamedSiloedItem, Set<NamedSiloedItem>> overlapMap = new HashMap<NamedSiloedItem, Set<NamedSiloedItem>>();
    private String errorMessage;
    private final LoadWizardInput loadOperationInput;
    private final boolean fromLoadOp;
    private boolean hasCollisions;

    private static String[][] getOverlaps(LoadOperationInput input, ILoadOverlap overlap) {
        HashSet<String> sharePaths = new HashSet<String>();
        HashSet<String> folderPaths = new HashSet<String>();
        for (IShare share : overlap.getOverlappingShares()) {
            sharePaths.add(share.getSandbox().getRoot().append(share.getPath()).toOSString());
        }
        for (String[] folder : overlap.getOverlappingItems().values()) {
            String folderPath = PathUtils.getString((String[])folder);
            String componentName = input.getComponentName(overlap.getComponent().getItemId());
            if (componentName != null) {
                folderPath = PathUtils.appendPath((String)componentName, (String)folderPath);
            }
            folderPaths.add(folderPath);
        }
        Object[] shares = sharePaths.toArray(new String[sharePaths.size()]);
        Arrays.sort(shares);
        Object[] folders = folderPaths.toArray(new String[folderPaths.size()]);
        Arrays.sort(folders);
        return new String[][]{shares, folders};
    }

    public static String[][] getOverlapMessages(LoadOperationInput input, ILoadOverlap overlap) {
        String folderPath = PathUtils.getString((String[])overlap.getPath());
        String componentName = input.getComponentName(overlap.getComponent().getItemId());
        if (componentName != null) {
            folderPath = PathUtils.appendPath((String)componentName, (String)folderPath);
        }
        String[][] overlaps = ProblemReport.getOverlaps(input, overlap);
        int i = 0;
        while (i < overlaps[0].length) {
            overlaps[0][i] = NLS.bind((String)Messages.SelectFromRepoPart_22, (Object)folderPath, (Object)overlaps[0][i]);
            ++i;
        }
        i = 0;
        while (i < overlaps[1].length) {
            overlaps[1][i] = NLS.bind((String)Messages.SelectFromRepoPart_23, (Object)folderPath, (Object)overlaps[1][i]);
            ++i;
        }
        return overlaps;
    }

    public ProblemReport(LoadWizardInput loadOperationInput, boolean fromLoadOp) {
        this.loadOperationInput = loadOperationInput;
        this.fromLoadOp = fromLoadOp;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public Map<String, Set<NamedSiloedItem>> getCollisionsMap() {
        return this.collisionsMap;
    }

    public Map<NamedSiloedItem, Set<NamedSiloedItem>> getOverlapMap() {
        return this.overlapMap;
    }

    private void generateErrorLabelsFromLoadOp(Map<NamedSiloedItem, String> collisionLabels, Map<NamedSiloedItem, String> overlapLabels) {
        for (ICollision collision : this.loadOperationInput.getCollisions()) {
            Collection locations = collision.getLocations();
            if (locations.size() <= 1) continue;
            String collisionText = this.toStringLocations(locations);
            for (ILoadLocation loadLocation : locations) {
                NamedSiloedItem item = new NamedSiloedItem(loadLocation.getRootToLoad().getItemId(), loadLocation.getComponent().getItemId());
                collisionLabels.put(item, collisionText);
            }
        }
        for (ILoadOverlap loadOverlap : this.loadOperationInput.getLoadOverlaps()) {
            String string = this.toString(loadOverlap);
            UUID component = loadOverlap.getComponent().getItemId();
            NamedSiloedItem item = new NamedSiloedItem(loadOverlap.getItem().getItemId(), component);
            overlapLabels.put(item, string);
            for (IVersionableHandle versionable : loadOverlap.getOverlappingItems().keySet()) {
                item = new NamedSiloedItem(versionable.getItemId(), component);
                overlapLabels.put(item, string);
            }
            String componentName = this.loadOperationInput.getComponentName(component);
            this.recordOverlap(componentName, component, loadOverlap.getItem(), loadOverlap.getPath(), loadOverlap, overlapLabels);
            for (Map.Entry entry : loadOverlap.getOverlappingItems().entrySet()) {
                this.recordOverlap(componentName, component, (IVersionableHandle)entry.getKey(), (String[])entry.getValue(), loadOverlap, overlapLabels);
            }
        }
    }

    private void recordOverlap(String componentName, UUID componentUUID, IVersionableHandle handle, String[] segments, ILoadOverlap loadOverlap, Map<NamedSiloedItem, String> overlapLabels) {
        HashSet<String> overlaps = new HashSet<String>();
        if (!loadOverlap.getItem().sameItemId((IItemHandle)handle)) {
            overlaps.add(SelectItemsToLoadPart.toString(loadOverlap.getPath()));
        }
        for (Map.Entry entry : loadOverlap.getOverlappingItems().entrySet()) {
            if (((IVersionableHandle)entry.getKey()).sameItemId((IItemHandle)loadOverlap.getItem())) continue;
            overlaps.add(SelectItemsToLoadPart.toString((String[])entry.getValue()));
        }
        Object[] overlapArray = overlaps.toArray(new String[overlaps.size()]);
        Arrays.sort(overlapArray);
        String string = ProblemReport.commaSeparate((String[])overlapArray);
        NamedSiloedItem item = new NamedSiloedItem(componentName, componentUUID, handle.getItemId(), PathUtils.getString((String[])segments));
        overlapLabels.put(item, string);
    }

    private void generateErrorsLabelsFromFolderMap(Map<NamedSiloedItem, String> collisionLabels, Map<NamedSiloedItem, String> overlapLabels) {
        for (Map.Entry<NamedSiloedItem, Set<NamedSiloedItem>> entry : this.overlapMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            HashSet adjustedSet = new HashSet(entry.getValue());
            adjustedSet.remove((Object)entry.getKey());
            overlapLabels.put(entry.getKey(), this.toStringFolders(adjustedSet));
        }
        for (Set set : this.collisionsMap.values()) {
            if (set.size() <= 1) continue;
            String collisionText = this.toStringFolders(set);
            for (NamedSiloedItem report : set) {
                collisionLabels.put(report, collisionText);
            }
        }
    }

    public void generateErrorLabels(Map<NamedSiloedItem, String> collisionLabels, Map<NamedSiloedItem, String> overlapLabels) {
        if (this.isFromLoadOperation()) {
            this.generateErrorLabelsFromLoadOp(collisionLabels, overlapLabels);
        } else {
            this.generateErrorsLabelsFromFolderMap(collisionLabels, overlapLabels);
        }
    }

    private boolean isFromLoadOperation() {
        return this.fromLoadOp;
    }

    public void setHasProjectCollisions(boolean hasCollisions) {
        this.hasCollisions = hasCollisions;
    }

    public boolean hasProjectCollisions() {
        return this.hasCollisions;
    }

    public IStatus evaluate() {
        IProject[] projects;
        Collection selected = this.loadOperationInput.getSelectedFolders().toCollection();
        if (this.fromLoadOp) {
            this.processLoadOperationEvaluationResults(this.loadOperationInput.getLoadOperation());
            this.updateOverlapAndCollisionMap(selected);
        } else {
            this.validateSelection(selected);
        }
        if ((this.loadOperationInput.getEclipseSpecificOptions() & 1) > 0 && (projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()).length != 0) {
            HashSet<String> names = new HashSet<String>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                names.add(project.getName());
                ++n2;
            }
            for (NamedSiloedItem namedSiloedItem : selected) {
                String name = namedSiloedItem.getName();
                if (!names.contains(name)) continue;
                this.setHasProjectCollisions(true);
                break;
            }
        }
        if (this.getErrorMessage() != null) {
            return StatusUtil.newStatus((Object)this, (String)this.getErrorMessage());
        }
        if (selected.isEmpty() && this.loadOperationInput.getLoadType() != 6) {
            return StatusUtil.newStatus((Object)this, (int)1, (String)Messages.SelectFoldersToLoadPage_nothingSelected);
        }
        return Status.OK_STATUS;
    }

    private void processLoadOperationEvaluationResults(ILoadOperation operation) {
        Collection loadOverlaps;
        if (this.getErrorMessage() == null && (loadOverlaps = operation.getLoadOverlaps()).size() > 0) {
            ILoadOverlap first = (ILoadOverlap)loadOverlaps.iterator().next();
            String[][] messages = ProblemReport.getOverlapMessages(this.loadOperationInput, first);
            if (messages[0].length > 0) {
                this.setErrorMessage(messages[0][0]);
            } else if (messages[1].length > 0) {
                this.setErrorMessage(messages[1][0]);
            }
        }
        if (this.getErrorMessage() == null) {
            for (ICollision collision : operation.getCollisions()) {
                if (collision.getLocations().size() <= 1) continue;
                StringBuilder message = new StringBuilder();
                message.append(Messages.SelectFromRepoPart_25);
                Collection locations = collision.getLocations();
                message.append(this.toStringLocations(locations));
                this.setErrorMessage(message.toString());
                break;
            }
        }
    }

    private void validateSelection(Collection<NamedSiloedItem> selected) {
        this.updateOverlapAndCollisionMap(selected);
        int count = 0;
        for (Set<NamedSiloedItem> overlaps : this.getOverlapMap().values()) {
            if (overlaps.size() <= 1) continue;
            if (this.getErrorMessage() == null) {
                Iterator<NamedSiloedItem> iterator = overlaps.iterator();
                this.setErrorMessage(NLS.bind((String)Messages.SelectFromRepoPart_23, (Object)SelectItemsToLoadPart.singleQuotePath(this.getPath((Object)iterator.next())), (Object)this.getPath((Object)iterator.next())));
            }
            ++count;
        }
        if (this.getErrorMessage() != null && count > 2) {
            this.setErrorMessage(NLS.bind((String)Messages.SelectFromRepoPart_21, (Object)this.getErrorMessage(), (Object)(count - 2)));
        }
        if (this.getErrorMessage() == null) {
            for (Set<NamedSiloedItem> collisions : this.getCollisionsMap().values()) {
                if (collisions.size() <= 1) continue;
                StringBuilder message = new StringBuilder();
                message.append(Messages.SelectFromRepoPart_25);
                message.append(this.toStringFolders(collisions));
                this.setErrorMessage(message.toString());
                break;
            }
        }
        if (this.loadOperationInput.getLoadType() != 1) {
            this.checkForOverlapsOnDisk();
        }
    }

    private void updateOverlapAndCollisionMap(Collection<NamedSiloedItem> selected) {
        HashMap<SiloedItemId<IFolder>, NamedSiloedItem> projectFolders = new HashMap<SiloedItemId<IFolder>, NamedSiloedItem>();
        HashSet<UUID> componentIds = new HashSet<UUID>();
        for (NamedSiloedItem namedSiloedItem : selected) {
            String projectName = namedSiloedItem.getTargetProjectName();
            Set<NamedSiloedItem> nameCollision = this.getCollisionsMap().get(projectName);
            if (nameCollision == null) {
                nameCollision = new HashSet<NamedSiloedItem>();
                this.getCollisionsMap().put(projectName, nameCollision);
            }
            nameCollision.add(namedSiloedItem);
            projectFolders.put(namedSiloedItem.asSiloedItem(), namedSiloedItem);
            componentIds.add(namedSiloedItem.getComponentUUID());
            this.getOverlapMap().put(namedSiloedItem, new HashSet());
        }
        for (UUID componentId : componentIds) {
            Collection<SharesOnDisk.ShareWrapper> shares = this.getSharesOnDisk().getShares(this.loadOperationInput.getSandboxPath(), componentId);
            for (SharesOnDisk.ShareWrapper shareWrapper : shares) {
                UUID folderId = shareWrapper.getRootFolderId();
                NamedSiloedItem shared = new NamedSiloedItem(shareWrapper.getComponentName(), componentId, folderId, shareWrapper.getFQName());
                SiloedItemId<IFolder> siloedFolderID = shared.asSiloedItem();
                if (projectFolders.get(siloedFolderID) != null) continue;
                this.getOverlapMap().put(shared, new HashSet());
                projectFolders.put(siloedFolderID, shared);
            }
        }
        this.buildOverlapSets(projectFolders, selected);
    }

    private SharesOnDisk getSharesOnDisk() {
        return this.loadOperationInput.getSharesOnDisk();
    }

    private synchronized void checkForOverlapsOnDisk() {
        IObservableValue overlapsOnDiskStatus = this.loadOperationInput.getOverlapsOnDiskStatus();
        IStatus currentStatus = (IStatus)overlapsOnDiskStatus.getValue();
        if (currentStatus.isOK()) {
            HashSet<NamedSiloedItem> allSharedOverlaps = new HashSet<NamedSiloedItem>();
            for (Set<NamedSiloedItem> overlaps : this.overlapMap.values()) {
                if (overlaps.size() <= 1) continue;
                boolean allShared = true;
                for (NamedSiloedItem folder : overlaps) {
                    Set<UUID> sharedUUIDs = this.getSharesOnDisk().getSharedUUIDs(this.loadOperationInput.getSandboxPath(), folder.getComponentUUID());
                    if (sharedUUIDs != null && sharedUUIDs.contains(folder.getItemUUID())) continue;
                    allShared = false;
                    break;
                }
                if (!allShared || allSharedOverlaps.size() >= overlaps.size()) continue;
                allSharedOverlaps.clear();
                allSharedOverlaps.addAll(overlaps);
            }
            if (allSharedOverlaps.size() > 1) {
                overlapsOnDiskStatus.setValue((Object)FileSystemStatusUtil.getStatusFor((int)4, (String)this.toStringFolders(allSharedOverlaps)));
            }
        }
    }

    private void buildOverlapSets(Map<SiloedItemId<IFolder>, NamedSiloedItem> projectFolders, Collection<NamedSiloedItem> selected) {
        if (this.loadOperationInput.getLoadType() == 1) {
            for (NamedSiloedItem namedSiloedItem : selected) {
                IAncestorReport report = this.loadOperationInput.getAncestorReport(namedSiloedItem);
                if (report == null) continue;
                ProblemReport.buildOverlapSets(this.overlapMap, projectFolders, report, namedSiloedItem);
            }
        } else {
            Map<NamedSiloedItem, List<NamedSiloedItem>> ancestors = this.loadOperationInput.getAncestorsFromTree(this.overlapMap.keySet());
            for (Object e : this.overlapMap.keySet()) {
                if (!(e instanceof NamedSiloedItem)) continue;
                NamedSiloedItem namedSiloedItem = (NamedSiloedItem)((Object)e);
                this.buildOverlapSets(projectFolders, ancestors.get((Object)namedSiloedItem), namedSiloedItem);
            }
        }
        for (NamedSiloedItem namedSiloedItem : selected) {
            Collection<NamedSiloedItem> additionalOverlaps = this.getSharesOnDisk().findDescendantsFor(this.loadOperationInput.getSandboxPath(), namedSiloedItem);
            if (additionalOverlaps.isEmpty()) continue;
            Set<NamedSiloedItem> set = this.overlapMap.get((Object)namedSiloedItem);
            set.addAll(additionalOverlaps);
        }
    }

    private void buildOverlapSets(Map<SiloedItemId<IFolder>, NamedSiloedItem> projectFolders, List<NamedSiloedItem> ancestors, NamedSiloedItem namedSiloedItem) {
        this.overlapMap.get((Object)namedSiloedItem).add(namedSiloedItem);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < ancestors.size()) {
            NamedSiloedItem ancestor = ancestors.get(i);
            UUID uuid = ancestor.getItemUUID();
            String name = ancestor.getName();
            if (i == 0) {
                name = "/";
            } else {
                builder.append(name);
                if (i < ancestors.size() - 1) {
                    builder.append('/');
                }
            }
            NamedSiloedItem otherItem = projectFolders.get(new SiloedItemId(IFolder.ITEM_TYPE, uuid, namedSiloedItem.getComponentUUID()));
            if (otherItem != null) {
                this.overlapMap.get((Object)namedSiloedItem).add(otherItem);
                Set<NamedSiloedItem> otherSet = this.overlapMap.get((Object)otherItem);
                if (otherSet != null) {
                    NamedSiloedItem shared;
                    otherSet.add(namedSiloedItem);
                    if (otherItem instanceof NamedSiloedItem && (shared = otherItem).getFQName() == null) {
                        shared.setPath(builder.toString());
                    }
                }
            }
            ++i;
        }
    }

    public static void buildOverlapSets(Map<NamedSiloedItem, Set<NamedSiloedItem>> overlapMap, Map<SiloedItemId<IFolder>, NamedSiloedItem> projectFolders, IAncestorReport report, NamedSiloedItem reportKey) {
        overlapMap.get((Object)reportKey).add(reportKey);
        List pairs = report.getNameItemPairs();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < pairs.size() - 2) {
            NamedSiloedItem otherReport;
            INameItemPair pair = (INameItemPair)pairs.get(i);
            UUID uuid = pair.getItem().getItemId();
            String name = pair.getName();
            if (i > 0) {
                if (i > 1) {
                    builder.append('/');
                }
                builder.append(name);
            }
            if ((otherReport = projectFolders.get(new SiloedItemId(IFolder.ITEM_TYPE, uuid, reportKey.getComponentUUID()))) != null) {
                overlapMap.get((Object)reportKey).add(otherReport);
                Set<NamedSiloedItem> otherSet = overlapMap.get((Object)otherReport);
                if (otherSet != null) {
                    NamedSiloedItem shared;
                    otherSet.add(reportKey);
                    if (otherReport instanceof NamedSiloedItem && (shared = otherReport).getFQName() == null) {
                        shared.setPath(builder.toString());
                    }
                }
            }
            ++i;
        }
    }

    private String toStringFolders(Set<? extends Object> folders) {
        Object[] strings = new String[folders.size()];
        int i = 0;
        for (Object object : folders) {
            strings[i++] = this.getSingleQuotePath(object);
        }
        Arrays.sort(strings);
        return ProblemReport.commaSeparate((String[])strings);
    }

    private String getSingleQuotePath(Object o) {
        return SelectItemsToLoadPart.singleQuotePath(this.getPath(o));
    }

    private String getPath(Object o) {
        if (o instanceof IAncestorReport) {
            IAncestorReport report = (IAncestorReport)o;
            return this.toString(report);
        }
        if (o instanceof NamedSiloedItem) {
            NamedSiloedItem siloed = (NamedSiloedItem)((Object)o);
            if (siloed.getComponentName() == null) {
                return siloed.getFQName();
            }
            if (siloed.isComponentRoot()) {
                return PathUtils.normalizePath((String)siloed.getComponentName(), (boolean)false, (boolean)true);
            }
            return PathUtils.appendPath((String)siloed.getComponentName(), (String)siloed.getFQName());
        }
        if (o instanceof AncestorReportWrapper) {
            AncestorReportWrapper reportWrapper = (AncestorReportWrapper)o;
            return reportWrapper.getPath();
        }
        throw new IllegalArgumentException();
    }

    static String commaSeparate(String[] strings) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(string);
            ++n2;
        }
        return builder.toString();
    }

    private String toStringLocations(Collection<ILoadLocation> locations) {
        Object[] strings = new String[locations.size()];
        int i = 0;
        for (ILoadLocation loadLocation : locations) {
            strings[i++] = this.toString(loadLocation);
        }
        Arrays.sort(strings);
        return ProblemReport.commaSeparate((String[])strings);
    }

    private String toString(ILoadLocation location) {
        return String.valueOf(this.toString(location.getComponent())) + "/.../" + location.getLoadPath().toString();
    }

    private String toString(ILoadOverlap loadOverlap) {
        HashSet<String> overlaps = new HashSet<String>();
        overlaps.add(SelectItemsToLoadPart.toString(loadOverlap.getPath()));
        for (String[] segments : loadOverlap.getOverlappingItems().values()) {
            overlaps.add(SelectItemsToLoadPart.toString(segments));
        }
        Object[] overlapArray = overlaps.toArray(new String[overlaps.size()]);
        Arrays.sort(overlapArray);
        return ProblemReport.commaSeparate((String[])overlapArray);
    }

    private String toString(IComponent component) {
        return "[" + component.getName() + "]";
    }

    private String toString(IAncestorReport report) {
        StringBuilder builder = new StringBuilder();
        List pairs = report.getNameItemPairs();
        int i = 1;
        while (i < pairs.size() - 1) {
            INameItemPair pair = (INameItemPair)pairs.get(i);
            String name = pair.getName();
            if (i > 1) {
                builder.append('/');
            }
            builder.append(name);
            ++i;
        }
        String path = builder.toString();
        return path;
    }
}

