/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collections;
import java.util.List;

public class NamedSiloedItem
extends SiloedItemId<IFolder> {
    private String componentName;
    private String name;
    private String fqName;

    public static NamedSiloedItem createFor(IComponent component, AbstractFileSystemItemWrapper fileOrFolder) {
        return new NamedSiloedItem(component, fileOrFolder);
    }

    public static NamedSiloedItem createFor(IComponent component, IVersionableHandle handle, String path) {
        return new NamedSiloedItem(component, handle, path);
    }

    public static NamedSiloedItem createFor(IShareOutOfSync outOfSync) {
        return new NamedSiloedItemWithShare(outOfSync.getShare());
    }

    public static INameItemPair getProjectFolder(IAncestorReport report) {
        List pairs = report.getNameItemPairs();
        return (INameItemPair)pairs.get(pairs.size() - 2);
    }

    public NamedSiloedItem(UUID folderUUID, UUID componentID) {
        super(IFolder.ITEM_TYPE, folderUUID, componentID);
    }

    public NamedSiloedItem(IItemType itemType, UUID folderUUID, UUID componentID) {
        super(itemType, folderUUID, componentID);
    }

    public NamedSiloedItem(IComponent component, AbstractFileSystemItemWrapper folder) {
        super(folder.getFileItem().getItemType(), folder.getFileItem().getItemUUID(), component.getItemId());
        this.componentName = component.getName();
        this.name = folder.getName();
        this.fqName = folder.getFQName();
    }

    public NamedSiloedItem(IComponent component, IAncestorReport report) {
        this(NamedSiloedItem.getProjectFolder(report).getItem().getItemId(), component.getItemId());
        List pairs = report.getNameItemPairs();
        if (pairs.size() == 2) {
            this.name = "";
            this.fqName = "";
        } else {
            StringBuilder builder = new StringBuilder();
            int i = 1;
            while (i < pairs.size() - 1) {
                INameItemPair pair = (INameItemPair)pairs.get(i);
                String name = pair.getName();
                if (i > 1) {
                    builder.append('/');
                }
                builder.append(name);
                ++i;
            }
            this.name = NamedSiloedItem.getProjectFolder(report).getName();
            this.fqName = builder.toString();
        }
        this.componentName = component.getName();
    }

    public NamedSiloedItem(IComponent component, String folderName, IVersionableHandle folderHandle) {
        this(folderHandle.getItemType(), folderHandle.getItemId(), component.getItemId());
        this.componentName = component.getName();
        this.name = folderName;
        this.fqName = folderName;
    }

    public NamedSiloedItem(String componentName, UUID componentUuid, UUID folderUUID, String fqName) {
        this(folderUUID, componentUuid);
        this.componentName = componentName;
        this.fqName = fqName;
        if (fqName != null) {
            this.name = PathUtils.getBaseName((String)fqName);
        }
    }

    public NamedSiloedItem(IItemType itemType, String componentName, UUID componentUuid, UUID folderUUID, String fqName) {
        this(itemType, folderUUID, componentUuid);
        this.componentName = componentName;
        this.fqName = fqName;
        if (fqName != null) {
            this.name = PathUtils.getBaseName((String)fqName);
        }
    }

    private NamedSiloedItem(IComponent component, IVersionableHandle handle, String path) {
        super(handle.getItemType(), handle.getItemId(), component.getItemId());
        this.componentName = component.getName();
        this.name = PathUtils.getBaseName((String)path);
        this.fqName = path;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getName() {
        return this.name;
    }

    public String getFQName() {
        return this.fqName;
    }

    public void setPath(String path) {
        this.fqName = path;
        if (path != null) {
            this.name = PathUtils.getBaseName((String)path);
        }
    }

    public boolean isParentOf(NamedSiloedItem other) {
        return other.getComponentUUID().equals((Object)this.getComponentUUID()) && PathUtils.isParentFolder((String)this.fqName, (String)other.getFQName());
    }

    public boolean isContainedInComponent(IComponent component) {
        return this.getComponentUUID().equals((Object)component.getItemId());
    }

    public String getTargetProjectName() {
        if (this.isComponentRoot()) {
            return this.getComponentName();
        }
        return this.getName();
    }

    public boolean isComponentRoot() {
        return this.name == null || this.getName().length() == 0;
    }

    public boolean isChildOf(String folderPath) {
        return PathUtils.isParentFolder((String)folderPath, (String)this.getFQName());
    }

    public IFolderHandle toFolderHandle() {
        return (IFolderHandle)this.toHandle();
    }

    public boolean isFolder() {
        return this.getItemType().equals(IFolder.ITEM_TYPE);
    }

    public boolean isFile() {
        return this.getItemType().equals(IFileItem.ITEM_TYPE);
    }

    public void requestLoad(LoadOperationInput loadOperationInput) {
        if (this.isComponentRoot()) {
            ILocation sandboxPath = loadOperationInput.getSandboxPath();
            if (sandboxPath == null) {
                return;
            }
            ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(sandboxPath, false);
            RelativeLocation relativeLocation = RelativeLocation.EMPTY_LOCATION;
            String currentSubFolderinSandBox = loadOperationInput.getPathWithinSandbox();
            if (loadOperationInput.useParentFolder() && currentSubFolderinSandBox != null && !currentSubFolderinSandBox.isEmpty()) {
                relativeLocation = new RelativeLocation(currentSubFolderinSandBox);
            }
            loadOperationInput.getLoadOperation().requestLoadAs(sandbox, (IRelativeLocation)relativeLocation, this.getComponentName(), loadOperationInput.getWorkspaceConnection(), this.getComponentHandle(), this.toHandle());
        } else {
            loadOperationInput.requestLoad(this.getComponentHandle(), Collections.singletonList(this.toHandle()));
        }
    }

    public SiloedItemId<IFolder> asSiloedItem() {
        return new SiloedItemId(IFolder.ITEM_TYPE, this.getItemUUID(), this.getComponentUUID());
    }

    private static class NamedSiloedItemWithShare
    extends NamedSiloedItem {
        private final IShare share;

        public NamedSiloedItemWithShare(IShare share) {
            super(share.getSharingDescriptor().getComponentName(), share.getSharingDescriptor().getConnectionHandle().getItemId(), share.getSharingDescriptor().getRootVersionable().getItemId(), null);
            this.share = share;
        }

        @Override
        public void requestLoad(LoadOperationInput loadOperationInput) {
            ISharingDescriptor sharingDescriptor = this.share.getSharingDescriptor();
            loadOperationInput.getLoadOperation().requestLoadAs(this.share.getSandbox(), this.share.getPath().removeLastSegments(1), this.share.getPath().getName(), loadOperationInput.getWorkspaceConnection(), sharingDescriptor.getComponent(), sharingDescriptor.getRootVersionable(), true);
        }
    }
}

