/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILoadRuleFactory;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.ContextNameUtil;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.FileItem;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.DilemmaHandlerConfiguration;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.IExtraLoadWizard;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.ProblemReport;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.RemoteLoadRuleWrapper;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SharesOnDisk;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentizedAncestorList;
import com.ibm.team.scm.common.internal.Folder;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class LoadWizardInput
extends LoadOperationInput {
    private static final String LOAD_TYPE_PREFERENCE = "com.ibm.team.filesystem.ide.ui.LoadTypePreference";
    private static final String EXTRA_LOAD_WIZARD_ID = "com.ibm.team.filesystem.ide.ui.ExtraLoadWizardPreference";
    private static final String DO_NOT_USE_PARENT_FOLDER = "_dO_NoT_uSe_PaReNt_FoLdEr_";
    public static final int LOAD_ECLIPSE_PROJECTS = 1;
    public static final int LOAD_TOP_LEVEL_FOLDERS = 2;
    public static final int BROWSE_FOR_FOLDERS_TO_LOAD = 3;
    public static final int DO_NOT_LOAD_ANYTHING = 4;
    public static final int RELOAD_OUT_OF_SYNC = 5;
    public static final int LOAD_FROM_LOAD_RULE_FILE = 6;
    public static final int LOAD_FROM_EXTRA_WIZARD = 7;
    public static final int LOCAL_LOAD_RULE_TYPE = 1;
    public static final int REMOTE_LOAD_RULE_TYPE = 2;
    public static final String LOAD_TYPE_PROPERTY = "com.ibm.team.filesystem.ide.ui.LoadTypeProperty";
    public static final String PROBLEM_REPORT_PROPERTY = "com.ibm.team.filesystem.ide.ui.ErrorMessageProperty";
    public static final String DILEMMA_HANDLER_CONFIGURATION_PROPERTY = "com.ibm.team.filesystem.ide.ui.DilemmaHandlerConfigurationProperty";
    public static final String LOAD_RULE_LOCATION_TYPE_PROPERTY = "com.ibm.team.filesystem.ide.ui.LoadRuleLocationTypeProperty";
    public static final String LOCAL_LOAD_RULE_LOCATION_PROPERTY = "com.ibm.team.filesystem.ide.ui.LocalLoadRuleLocationProperty";
    public static final String REMOTE_LOAD_RULE_PROPERTY = "com.ibm.team.filesystem.ide.ui.RemoteLoadRuleProperty";
    public static final String PRESERVE_LOCAL_CHANGES_PROPERTY = "com.ibm.team.filesystem.ide.ui.RemoteLoadRuleProperty";
    private int loadType;
    private String extraLoadWizardId;
    private IExtraLoadWizard extraLoadWizard;
    private Set<ItemId<IComponent>> components;
    private Map<WorkspaceComponentWrapper, Map<String, IVersionableHandle>> childrenForRoots;
    private Map<UUID, WorkspaceComponentWrapper> componentWrappers;
    private Map<WorkspaceComponentWrapper, Map<UUID, IAncestorReport>> dotProjectsMap;
    private Map<WorkspaceComponentWrapper, Set<IAncestorReport>> outerDotProjectsMap;
    private SelectedFoldersSet selectedFolders;
    Collection<NamedSiloedItem> elements = new HashSet<NamedSiloedItem>();
    private IObservableValue overlapsOnDiskStatus;
    private ProblemReport problems;
    private boolean hasInitialSelection;
    private final FolderTree folderTree = new FolderTree();
    private final SharesOnDisk sharesOnDisk = new SharesOnDisk();
    private Collection<IShareOutOfSync> sharesOutOfSync;
    private boolean loadOpEvaluated;
    private DilemmaHandlerConfiguration dilemmaHandlerConfiguration;
    private int fLoadRuleLocationType;
    private PathLocation fLocalLoadRuleLocation;
    private RemoteLoadRuleWrapper fRemoteLoadRule;
    private boolean overwriteLocalChanges;
    private boolean useSandboxSubfolderAsDefault = false;
    private String currentSandboxSubfolder;
    private String storedPathWithinSandbox;
    private IConnection connection;
    private boolean workspaceSelected;

    public LoadWizardInput(IConnection connection, Collection<? extends IComponentHandle> components, Set<NamedSiloedItem> initialSelection, IProgressMonitor monitor) throws TeamRepositoryException {
        this.initializeLoadType();
        this.initializeLoadRuleData();
        this.initializeConnection(connection, components, monitor);
        this.initializeSelection(initialSelection);
    }

    private void initializeSelection(Set<NamedSiloedItem> initialSelection) {
        if (initialSelection != null) {
            if (this.loadType != 7) {
                this.loadType = 3;
                this.extraLoadWizard = null;
                this.extraLoadWizardId = null;
            }
            this.hasInitialSelection = true;
            this.elements.addAll(initialSelection);
        }
    }

    private void initializeConnection(IConnection connection, Collection<? extends IComponentHandle> components, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.connection = connection;
        if (components == null) {
            this.workspaceSelected = true;
            this.initializeComponentsFromConnection(connection);
        } else {
            this.components = new HashSet<ItemId<IComponent>>();
            for (IComponentHandle iComponentHandle : components) {
                ItemId component = ItemId.create((IItemHandle)iComponentHandle);
                this.components.add((ItemId<IComponent>)component);
            }
        }
        this.sharesOnDisk.initialize(connection, (IProgressMonitor)progress.newChild(30));
        if (this.currentSandboxSubfolder == null) {
            this.useSandboxSubfolderAsDefault = this.getWorkspaceConnection().getWorkspaceParentFolderConfigurationData((IProgressMonitor)progress.newChild(70));
            this.currentSandboxSubfolder = "";
            if (connection != null && connection instanceof IWorkspaceConnection) {
                IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)connection;
                this.currentSandboxSubfolder = iWorkspaceConnection.getParentFolder();
            }
        }
    }

    public String getCurrentExtraLoadWizardId() {
        return this.extraLoadWizardId;
    }

    public IExtraLoadWizard getCurrentExtraLoadWizard() {
        return this.extraLoadWizard;
    }

    /*
     * Unable to fully structure code
     */
    private void initializeLoadType() {
        block7: {
            try {
                this.loadType = this.getSettings().getInt("com.ibm.team.filesystem.ide.ui.LoadTypePreference");
                this.extraLoadWizard = null;
                this.extraLoadWizardId = null;
                if (this.loadType == 7) {
                    this.extraLoadWizardId = this.getSettings().get("com.ibm.team.filesystem.ide.ui.ExtraLoadWizardPreference");
                }
                this.ensureLoadTypeValid();
                break block7;
            }
            catch (NumberFormatException e) {
                ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.team.filesystem.ide.ui", "extraLoadWizards");
                var6_3 = ep.getExtensions();
                var5_4 = var6_3.length;
                var4_5 = 0;
                ** while (var4_5 < var5_4)
            }
lbl-1000:
            // 1 sources

            {
                extension = var6_3[var4_5];
                var10_10 = extension.getConfigurationElements();
                var9_9 = var10_10.length;
                var8_8 = 0;
                while (var8_8 < var9_9) {
                    ce = var10_10[var8_8];
                    isDefault = ce.getAttribute("default");
                    if (isDefault != null && "true".equals(isDefault)) {
                        this.loadType = 7;
                        this.extraLoadWizardId = ce.getAttribute("id");
                        this.extraLoadWizard = null;
                        break;
                    }
                    ++var8_8;
                }
                ++var4_5;
                continue;
            }
lbl31:
            // 1 sources

            if (this.loadType == 0) {
                this.loadType = 1;
                this.extraLoadWizardId = null;
                this.extraLoadWizard = null;
            }
        }
        this.adjustEclipseSpecificOptions();
    }

    private void initializeLoadRuleData() {
        try {
            this.fLoadRuleLocationType = this.sanitizeLoadRuleLocationType(this.getSettings().getInt(LOAD_RULE_LOCATION_TYPE_PROPERTY));
        }
        catch (NumberFormatException e) {
            this.fLoadRuleLocationType = 1;
        }
        String remoteLoadRulesValue = this.getSettings().get("com.ibm.team.filesystem.ide.ui.RemoteLoadRuleProperty");
        try {
            this.fRemoteLoadRule = new RemoteLoadRuleWrapper(remoteLoadRulesValue);
        }
        catch (Exception e) {
            this.fRemoteLoadRule = new RemoteLoadRuleWrapper(new HashMap<IComponentHandle, IFileItemHandle>());
        }
        this.fLocalLoadRuleLocation = this.sanitizeLocalLoadRuleLocation(this.getSettings().get(LOCAL_LOAD_RULE_LOCATION_PROPERTY));
    }

    private void ensureLoadTypeValid() {
        if (this.loadType <= 0) {
            this.loadType = 1;
            this.extraLoadWizard = null;
            this.extraLoadWizardId = null;
        }
        if (this.loadType > 7) {
            this.loadType = 1;
            this.extraLoadWizard = null;
            this.extraLoadWizardId = null;
        }
        if (this.loadType == 4) {
            this.loadType = 1;
            this.extraLoadWizard = null;
            this.extraLoadWizardId = null;
        }
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    private void initializeComponentsFromConnection(IConnection connection) throws TeamRepositoryException {
        this.components = new HashSet<ItemId<IComponent>>();
        if (connection instanceof IWorkspaceConnection) {
            IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)connection;
            List handles = workspaceConnection.getComponents();
            for (IComponentHandle handle : handles) {
                ItemId component = ItemId.create((IItemHandle)handle);
                this.components.add((ItemId<IComponent>)component);
            }
        } else if (connection instanceof IBaselineConnection) {
            IBaselineConnection baselineConnection = (IBaselineConnection)connection;
            ItemId component = ItemId.create((IItemHandle)baselineConnection.getComponent());
            this.components.add((ItemId<IComponent>)component);
        }
    }

    private void initWrappers(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.componentWrappers == null) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LoadComponentsAction_0, (int)100);
            this.login((IProgressMonitor)sub.newChild(1));
            sub.setWorkRemaining(this.components.size());
            HashMap<UUID, WorkspaceComponentWrapper> wrappers = new HashMap<UUID, WorkspaceComponentWrapper>();
            for (ItemId<IComponent> component : this.components) {
                if (sub.isCanceled()) {
                    monitor.done();
                    return;
                }
                WorkspaceComponentWrapper wrapper = WorkspaceComponentWrapper.constructFrom(WorkspaceNamespace.create((IWorkspaceConnection)this.getWorkspaceConnection(), (IComponentHandle)((IComponentHandle)component.toHandle())), (IProgressMonitor)sub.newChild(1));
                wrappers.put(component.getItemUUID(), wrapper);
            }
            this.componentWrappers = wrappers;
            monitor.done();
        }
    }

    public boolean isProjectsNull() {
        return this.dotProjectsMap == null;
    }

    public void initProjects(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.isProjectsNull()) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LoadOperationInput_0, (int)100);
            this.login((IProgressMonitor)sub.newChild(1));
            this.initWrappers((IProgressMonitor)sub.newChild(50));
            sub.setWorkRemaining(this.components.size());
            HashMap<WorkspaceComponentWrapper, Map<UUID, IAncestorReport>> map = new HashMap<WorkspaceComponentWrapper, Map<UUID, IAncestorReport>>();
            List fetchAncestorsByName = this.getWorkspaceConnection().configuration().fetchAncestorsByName(".project", (IProgressMonitor)sub.newChild(this.components.size()));
            HashSet<UUID> fetchedAncestorComponents = new HashSet<UUID>();
            for (IComponentizedAncestorList iComponentizedAncestorList : fetchAncestorsByName) {
                fetchedAncestorComponents.add(iComponentizedAncestorList.getComponent().getItemId());
            }
            for (ItemId itemId : this.components) {
                UUID selectedComponentUUID = itemId.getItemUUID();
                if (fetchedAncestorComponents.contains(itemId.getItemUUID())) continue;
                this.componentWrappers.remove(selectedComponentUUID);
            }
            if (fetchedAncestorComponents.size() < this.components.size()) {
                this.initSharesOutOfSync((IProgressMonitor)sub.newChild(1));
            }
            for (IComponentizedAncestorList iComponentizedAncestorList : fetchAncestorsByName) {
                Collection reports = iComponentizedAncestorList.getAncestorReports().values();
                HashMap<UUID, IAncestorReport> filteredReports = new HashMap<UUID, IAncestorReport>();
                for (IAncestorReport report : reports) {
                    int size = report.getNameItemPairs().size();
                    if (size < 2) {
                        IllegalArgumentException e = new IllegalArgumentException(Messages.CheckoutSelectedAction_8);
                        StatusUtil.log((IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
                        continue;
                    }
                    filteredReports.put(NamedSiloedItem.getProjectFolder(report).getItem().getItemId(), report);
                }
                WorkspaceComponentWrapper wrapper = this.componentWrappers.get(iComponentizedAncestorList.getComponent().getItemId());
                if (wrapper == null) continue;
                map.put(wrapper, filteredReports);
            }
            this.outerDotProjectsMap = new HashMap<WorkspaceComponentWrapper, Set<IAncestorReport>>();
            Map<SiloedItemId<IFolder>, NamedSiloedItem> map2 = this.buildFolderId2ItemMap(map);
            for (Map.Entry projectEntry : map.entrySet()) {
                WorkspaceComponentWrapper componentWrapper = (WorkspaceComponentWrapper)projectEntry.getKey();
                Set<IAncestorReport> outerReports = this.findOuterDotProjects(componentWrapper.getComponent(), ((Map)projectEntry.getValue()).values(), map2);
                this.outerDotProjectsMap.put(componentWrapper, outerReports);
            }
            this.dotProjectsMap = map;
            monitor.done();
        }
    }

    public void initSharesOutOfSync(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        OutOfSyncDilemmaHandler dilemmaHandler = new OutOfSyncDilemmaHandler(){

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                LoadWizardInput.this.sharesOutOfSync = sharesOutOfSync;
                return 0;
            }
        };
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LoadWizardInput_VERIFYING_SYNCRONIZATION, (int)3);
        sub.setTaskName(Messages.LoadWizardInput_VERIFYING_SYNCRONIZATION);
        this.initWrappers((IProgressMonitor)sub.newChild(1));
        IWorkspaceConnection workspaceConnection = this.getWorkspaceConnection();
        IVerifyInSyncOperation verifyInSyncOperation = IOperationFactory.instance.getVerifyInSyncOperation(dilemmaHandler);
        for (ItemId<IComponent> componentId : this.getComponents()) {
            IComponentHandle componentHandle = (IComponentHandle)componentId.toHandle();
            verifyInSyncOperation.addToVerify((IConnection)workspaceConnection, componentHandle);
        }
        verifyInSyncOperation.run((IProgressMonitor)sub.newChild(1));
        if (this.sharesOutOfSync == null) {
            this.sharesOutOfSync = Collections.emptySet();
        }
    }

    private Map<SiloedItemId<IFolder>, NamedSiloedItem> buildFolderId2ItemMap(Map<WorkspaceComponentWrapper, Map<UUID, IAncestorReport>> map) {
        HashMap<SiloedItemId<IFolder>, NamedSiloedItem> inverseProjectFolders = new HashMap<SiloedItemId<IFolder>, NamedSiloedItem>();
        for (Map.Entry<WorkspaceComponentWrapper, Map<UUID, IAncestorReport>> entry : map.entrySet()) {
            WorkspaceComponentWrapper component = entry.getKey();
            for (IAncestorReport report : entry.getValue().values()) {
                NamedSiloedItem item = new NamedSiloedItem(component.getComponent(), report);
                inverseProjectFolders.put(item.asSiloedItem(), item);
            }
        }
        return inverseProjectFolders;
    }

    private Set<IAncestorReport> findOuterDotProjects(IComponent component, Collection<IAncestorReport> reports, Map<SiloedItemId<IFolder>, NamedSiloedItem> inverseProjectFolders) {
        NamedSiloedItem item;
        HashSet<IAncestorReport> outerReports = new HashSet<IAncestorReport>();
        HashMap<NamedSiloedItem, Set<NamedSiloedItem>> overlapMap = new HashMap<NamedSiloedItem, Set<NamedSiloedItem>>();
        HashMap<NamedSiloedItem, IAncestorReport> itemToReportMap = new HashMap<NamedSiloedItem, IAncestorReport>();
        for (IAncestorReport iAncestorReport : reports) {
            item = new NamedSiloedItem(component, iAncestorReport);
            itemToReportMap.put(item, iAncestorReport);
            overlapMap.put(item, new HashSet());
        }
        for (IAncestorReport iAncestorReport : reports) {
            ProblemReport.buildOverlapSets(overlapMap, inverseProjectFolders, iAncestorReport, new NamedSiloedItem(component, iAncestorReport));
        }
        for (Map.Entry entry : overlapMap.entrySet()) {
            item = (NamedSiloedItem)((Object)entry.getKey());
            IAncestorReport report = (IAncestorReport)itemToReportMap.get((Object)item);
            int size = report.getNameItemPairs().size();
            Set overlaps = (Set)entry.getValue();
            if (overlaps.size() == 1) {
                outerReports.add(report);
                continue;
            }
            boolean reportIsOutermost = true;
            for (NamedSiloedItem overlapingItem : overlaps) {
                IAncestorReport overlap = (IAncestorReport)itemToReportMap.get((Object)overlapingItem);
                int overlapSize = overlap.getNameItemPairs().size();
                if (overlapSize >= size) continue;
                reportIsOutermost = false;
                break;
            }
            if (!reportIsOutermost) continue;
            outerReports.add(report);
        }
        return outerReports;
    }

    public boolean isRootsNull() {
        return this.childrenForRoots == null;
    }

    public void initRoots(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.isRootsNull()) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LoadOperationInput_0, (int)100);
            this.login((IProgressMonitor)sub.newChild(1));
            this.initWrappers((IProgressMonitor)sub.newChild(50));
            sub.setWorkRemaining(this.components.size());
            HashMap<WorkspaceComponentWrapper, Map<String, IVersionableHandle>> map = new HashMap<WorkspaceComponentWrapper, Map<String, IVersionableHandle>>();
            Map childEntriesForRoots = this.getWorkspaceConnection().configuration().childEntriesForRoots((IProgressMonitor)sub.newChild(this.components.size()));
            for (ItemId<IComponent> itemId : this.components) {
                UUID selectedComponentUUID = itemId.getItemUUID();
                if (childEntriesForRoots.keySet().contains(itemId.getItemUUID())) continue;
                this.componentWrappers.remove(selectedComponentUUID);
            }
            if (this.componentWrappers.size() < this.components.size()) {
                this.initSharesOutOfSync((IProgressMonitor)sub.newChild(1));
            }
            for (Map.Entry entry : childEntriesForRoots.entrySet()) {
                Map children = (Map)entry.getValue();
                HashMap<String, IVersionableHandle> versionables = new HashMap<String, IVersionableHandle>();
                for (Map.Entry child : children.entrySet()) {
                    IVersionableHandle versionable = (IVersionableHandle)child.getValue();
                    if (!IFolder.ITEM_TYPE.equals(versionable.getItemType()) && !IFileItem.ITEM_TYPE.equals(versionable.getItemType())) continue;
                    versionables.put((String)child.getKey(), versionable);
                }
                WorkspaceComponentWrapper wrapper = this.componentWrappers.get(entry.getKey());
                if (wrapper == null) continue;
                map.put(wrapper, versionables);
            }
            this.childrenForRoots = map;
            monitor.done();
        }
    }

    @Override
    protected IStatus doValidate() {
        IStatus superStatus = super.doValidate();
        if (superStatus.getSeverity() == 4) {
            return superStatus;
        }
        IStatus localStatus = this.checkForProblems(this.loadOpEvaluated);
        this.loadOpEvaluated = false;
        if (localStatus.isOK()) {
            return superStatus;
        }
        return localStatus;
    }

    IStatus checkForProblems(boolean fromLoadOp) {
        ProblemReport previous = this.problems;
        this.problems = new ProblemReport(this, fromLoadOp);
        IStatus status = this.problems.evaluate();
        if (fromLoadOp) {
            this.calculateDilemmaHandlerModel();
        }
        this.firePropertyChange(PROBLEM_REPORT_PROPERTY, previous, this.problems);
        return status;
    }

    public Map<NamedSiloedItem, List<NamedSiloedItem>> getAncestorsFromTree(Set<NamedSiloedItem> set) {
        if (this.folderTree == null) {
            HashMap<NamedSiloedItem, List<NamedSiloedItem>> result = new HashMap<NamedSiloedItem, List<NamedSiloedItem>>();
            for (NamedSiloedItem o : set) {
                if (!(o instanceof NamedSiloedItem)) continue;
                NamedSiloedItem item = o;
                result.put(item, Collections.singletonList(item));
            }
            return result;
        }
        return this.folderTree.getAncestors(set);
    }

    public IAncestorReport getAncestorReport(NamedSiloedItem namedSiloedItem) {
        WorkspaceComponentWrapper component = this.getComponent(namedSiloedItem);
        return this.getAncestorReport(component, namedSiloedItem);
    }

    private IAncestorReport getAncestorReport(WorkspaceComponentWrapper component, NamedSiloedItem namedSiloedItem) {
        if (this.isProjectsNull()) {
            return null;
        }
        Map<UUID, IAncestorReport> reports = this.dotProjectsMap.get(component);
        return reports.get(namedSiloedItem.getItemUUID());
    }

    private WorkspaceComponentWrapper getComponent(NamedSiloedItem namedSiloedItem) {
        return this.componentWrappers.get(namedSiloedItem.getComponentUUID());
    }

    private WorkspaceComponentWrapper getComponent(UUID componentId) {
        return this.componentWrappers.get(componentId);
    }

    private void calculateDilemmaHandlerModel() {
        DilemmaHandlerConfiguration old = this.dilemmaHandlerConfiguration;
        this.dilemmaHandlerConfiguration = new DilemmaHandlerConfiguration(this.getLoadOperation(), this.getLoadDilemmaHandler(), this.getLoadType() == 5);
        this.firePropertyChange(DILEMMA_HANDLER_CONFIGURATION_PROPERTY, old, this.dilemmaHandlerConfiguration);
    }

    public DilemmaHandlerConfiguration getDilemmaHandlerConfiguration() {
        return this.dilemmaHandlerConfiguration;
    }

    public Collection<WorkspaceComponentWrapper> getComponentWrappers() {
        if (this.componentWrappers == null) {
            return null;
        }
        return this.componentWrappers.values();
    }

    public Set<ItemId<IComponent>> getComponents() {
        return this.components;
    }

    public Collection<IAncestorReport> getProjects(WorkspaceComponentWrapper component) {
        return this.dotProjectsMap.get(component).values();
    }

    public Map<String, IFolderHandle> getFolders(WorkspaceComponentWrapper wrapper) {
        HashMap<String, IFolderHandle> foldersOnly = new HashMap<String, IFolderHandle>();
        Map<String, IVersionableHandle> children = this.childrenForRoots.get(wrapper);
        if (children == null) {
            return null;
        }
        for (Map.Entry<String, IVersionableHandle> entry : children.entrySet()) {
            if (!(entry.getValue() instanceof IFolderHandle)) continue;
            foldersOnly.put(entry.getKey(), (IFolderHandle)entry.getValue());
        }
        return foldersOnly;
    }

    public Map<String, IVersionableHandle> getVersionables(WorkspaceComponentWrapper wrapper) {
        return this.childrenForRoots.get(wrapper);
    }

    public Set<IAncestorReport> getOuterDotProjects(WorkspaceComponentWrapper component) {
        return this.outerDotProjectsMap.get(component);
    }

    public ProblemReport getProblems() {
        return this.problems;
    }

    public int getLoadType() {
        return this.loadType;
    }

    public void setLoadType(int loadType) {
        if (this.loadType != loadType) {
            int oldType = this.loadType;
            this.loadType = loadType;
            if (this.normalizeLoadType(oldType) != this.normalizeLoadType(loadType)) {
                this.getSelectedFolders().makeStale();
            }
            this.extraLoadWizard = null;
            this.extraLoadWizardId = null;
            this.removeAllRequests();
            this.firePropertyChange(LOAD_TYPE_PROPERTY, oldType, loadType);
            this.adjustEclipseSpecificOptions();
            this.adjustLocalChangePreservationOption();
        }
    }

    private void adjustLocalChangePreservationOption() {
        if (this.getLoadType() == 5) {
            this.setOverwriteLocalChanges(false);
        }
    }

    public void setExtraWizard(IExtraLoadWizard extraLoadWizard, String wizardId) {
        this.extraLoadWizardId = wizardId;
        this.extraLoadWizard = extraLoadWizard;
        if (this.loadType != 7) {
            this.getSelectedFolders().makeStale();
        }
        this.loadType = 7;
    }

    private void adjustEclipseSpecificOptions() {
        int originalOptions;
        int newOptions = originalOptions = this.getEclipseSpecificOptions();
        if (this.getLoadType() == 1) {
            newOptions = 1;
        }
        if (this.getLoadType() == 5) {
            newOptions |= 4;
        } else if ((newOptions & 4) != 0) {
            newOptions -= 4;
        }
        if ((originalOptions & 8) == 8) {
            newOptions |= 8;
        }
        this.setEclipseSpecificOptions(newOptions);
    }

    @Override
    protected void rememberEclipseLoadPreference() {
        if (this.getLoadType() == 5 || this.getLoadType() == 1) {
            return;
        }
        super.rememberEclipseLoadPreference();
    }

    private int normalizeLoadType(int loadType) {
        if (loadType == 3) {
            return 2;
        }
        return loadType;
    }

    @Override
    public void finished() {
        super.finished();
        if (this.loadType != 4 && this.loadType != 5) {
            this.getSettings().put(LOAD_TYPE_PREFERENCE, this.loadType);
        }
        if (this.loadType == 6) {
            int locationType = this.sanitizeLoadRuleLocationType(this.getLoadRuleLocationType());
            this.getSettings().put(LOAD_RULE_LOCATION_TYPE_PROPERTY, locationType);
            if (locationType == 1) {
                IPath path = (IPath)this.getLocalLoadRuleLocation().getAdapter(IPath.class);
                if (path != null) {
                    this.getSettings().put(LOCAL_LOAD_RULE_LOCATION_PROPERTY, path.toPortableString());
                }
            } else if (locationType == 2) {
                this.getSettings().put("com.ibm.team.filesystem.ide.ui.RemoteLoadRuleProperty", this.fRemoteLoadRule.getDialogSettingProperty());
            }
        }
        if (this.loadType == 7) {
            this.getSettings().put(EXTRA_LOAD_WIZARD_ID, this.extraLoadWizardId);
        }
    }

    public SelectedFoldersSet getSelectedFolders() {
        return this.selectedFolders;
    }

    public void refreshSelectedFolders(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LoadOperationInput_3, (int)3);
        this.login((IProgressMonitor)sub.newChild(1));
        if (this.getLoadType() == 1) {
            this.initProjects((IProgressMonitor)sub.newChild(1));
        } else if (this.getLoadType() == 5) {
            this.initSharesOutOfSync((IProgressMonitor)sub.newChild(1));
        } else if (this.getLoadType() == 6) {
            this.initWrappers((IProgressMonitor)sub.newChild(1));
        } else {
            this.initRoots((IProgressMonitor)sub.newChild(1));
        }
        if (this.selectedFolders != null && this.getLoadType() != 6) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (LoadWizardInput.this.selectedFolders.isStale()) {
                        LoadWizardInput.this.selectAll();
                    }
                }
            });
        }
    }

    public void selectAll() {
        IExtraLoadWizard extraLoadWizard;
        ArrayList<NamedSiloedItem> elements = new ArrayList<NamedSiloedItem>();
        if (this.getLoadType() == 1) {
            for (WorkspaceComponentWrapper component : this.dotProjectsMap.keySet()) {
                Set<IAncestorReport> reports = this.getOuterDotProjects(component);
                for (IAncestorReport report : reports) {
                    elements.add(new NamedSiloedItem(component.getComponent(), report));
                }
            }
        } else if (this.getLoadType() == 5) {
            for (IShareOutOfSync outOfSync : this.sharesOutOfSync) {
                NamedSiloedItem item = this.toNamedSiloedItem(outOfSync);
                elements.add(item);
            }
        } else if (this.getLoadType() != 7) {
            for (Map.Entry<WorkspaceComponentWrapper, Map<String, IVersionableHandle>> entry : this.childrenForRoots.entrySet()) {
                WorkspaceComponentWrapper component = entry.getKey();
                Map<String, IVersionableHandle> value = entry.getValue();
                for (Map.Entry<String, IVersionableHandle> folderEntry : value.entrySet()) {
                    if (folderEntry.getValue().getItemType() != Folder.ITEM_TYPE) continue;
                    elements.add(new NamedSiloedItem(component.getComponent(), folderEntry.getKey(), folderEntry.getValue()));
                }
            }
        } else if (this.getLoadType() == 7 && (extraLoadWizard = this.getCurrentExtraLoadWizard()) != null) {
            boolean selectFiles = extraLoadWizard.canLoadFiles();
            for (Map.Entry<WorkspaceComponentWrapper, Map<String, IVersionableHandle>> entry : this.childrenForRoots.entrySet()) {
                WorkspaceComponentWrapper component = entry.getKey();
                Map<String, IVersionableHandle> value = entry.getValue();
                for (Map.Entry<String, IVersionableHandle> folderEntry : value.entrySet()) {
                    if (folderEntry.getValue().getItemType() != Folder.ITEM_TYPE && (folderEntry.getValue().getItemType() != FileItem.ITEM_TYPE || !selectFiles)) continue;
                    elements.add(new NamedSiloedItem(component.getComponent(), folderEntry.getKey(), folderEntry.getValue()));
                }
            }
        }
        this.selectedFolders.update(elements);
    }

    private NamedSiloedItem toNamedSiloedItem(IShareOutOfSync outOfSync) {
        return NamedSiloedItem.createFor(outOfSync);
    }

    public boolean hasInitialSelection() {
        return this.hasInitialSelection;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getLoadOperation().setPreserveLocalChanges(!this.overwriteLocalChanges);
        this.overlapsOnDiskStatus = new WritableValue();
        this.overlapsOnDiskStatus.setValue((Object)Status.OK_STATUS);
        if (this.selectedFolders == null) {
            this.selectedFolders = new SelectedFoldersSet();
            this.selectedFolders.addListener((ISetListener)new ISetListener<NamedSiloedItem>(){

                public void changed(SetDiff<NamedSiloedItem> diff) {
                    LoadWizardInput.this.handleSelectionChange();
                }
            });
            this.problems = new ProblemReport(this, false);
            this.dilemmaHandlerConfiguration = new DilemmaHandlerConfiguration(this.getLoadOperation(), this.getLoadDilemmaHandler(), this.getLoadType() == 5);
            this.handleSelectionChange();
        }
    }

    public IFolderTree getFolderTree() {
        return this.folderTree;
    }

    public void updateFolderTree(Set<Object> additions) {
        FolderTree tree = this.folderTree;
        for (Object object : additions) {
            if (!(object instanceof NamedSiloedItem)) continue;
            tree.addFolder((NamedSiloedItem)((Object)object));
        }
        if (!this.selectedFolders.isEmpty()) {
            this.validate();
        }
    }

    private void handleSelectionChange() {
        this.updateLoadRequests();
        this.validate();
    }

    private void updateLoadRequests() {
        this.removeAllRequests();
        for (NamedSiloedItem namedSiloedItem : this.selectedFolders.toCollection()) {
            namedSiloedItem.requestLoad(this);
        }
    }

    @Override
    protected void handleSandboxPathChange() {
        super.handleSandboxPathChange();
        this.updateLoadRequests();
    }

    @Override
    protected boolean requiresValidationOnChange(String property) {
        if (property.equals(PROBLEM_REPORT_PROPERTY) || property.equals(DILEMMA_HANDLER_CONFIGURATION_PROPERTY)) {
            return false;
        }
        return super.requiresValidationOnChange(property);
    }

    public IObservableValue getOverlapsOnDiskStatus() {
        return this.overlapsOnDiskStatus;
    }

    public SharesOnDisk getSharesOnDisk() {
        return this.sharesOnDisk;
    }

    protected void storeSandboxSubfolder(IProgressMonitor monitor) {
        if (this.storedPathWithinSandbox != null && !this.storedPathWithinSandbox.equals(this.currentSandboxSubfolder)) {
            IWorkspaceConnection wsConnection = (IWorkspaceConnection)this.connection;
            try {
                if (this.storedPathWithinSandbox.equals(DO_NOT_USE_PARENT_FOLDER)) {
                    wsConnection.setParentFolder("", monitor);
                } else {
                    wsConnection.setParentFolder(this.storedPathWithinSandbox, monitor);
                }
            }
            catch (PermissionDeniedException e) {
                StatusUtil.log((Object)((Object)this), (int)2, (String)e.getMessage());
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
        }
    }

    @Override
    protected void loadRequestEvaluated(IProgressMonitor monitor) {
        this.sharesOnDisk.updateAfterEvaluation(this.getSandboxPath(), this.getLoadOperation());
        this.loadOpEvaluated = true;
        super.loadRequestEvaluated(monitor);
    }

    @Override
    protected String findFolder(IComponentHandle component, IFolderHandle folderToLoad) {
        if (this.getFolderTree() == null) {
            return null;
        }
        return this.getFolderTree().findFolder(component, folderToLoad);
    }

    @Override
    protected String getName(IVersionableHandle handle) {
        Collection folders = this.getSelectedFolders().toCollection();
        for (NamedSiloedItem namedSiloedItem : folders) {
            if (!handle.sameItemId((IItemHandle)namedSiloedItem.toHandle())) continue;
            return namedSiloedItem.getName();
        }
        return super.getName(handle);
    }

    @Override
    public String getComponentName(UUID component) {
        WorkspaceComponentWrapper wrapper = this.componentWrappers.get(component);
        if (wrapper != null) {
            return wrapper.getComponent().getName();
        }
        return null;
    }

    @Override
    protected void handlePropertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.ibm.team.filesystem.ide.ui.SandboxPathProperty") || event.getProperty().equals("com.ibm.team.filesystem.ide.ui.PathWithinSandboxProperty") || event.getProperty().equals("com.ibm.team.filesystem.ide.ui.EclipseSpecificOptionsProperty")) {
            this.getLoadDilemmaHandler().reset();
        }
        super.handlePropertyChange(event);
    }

    public int getLoadRuleLocationType() {
        return this.fLoadRuleLocationType;
    }

    public void setLoadRuleLocationType(int newType) {
        int oldType = this.fLoadRuleLocationType;
        if (newType != oldType) {
            this.fLoadRuleLocationType = newType;
            this.firePropertyChange(LOAD_RULE_LOCATION_TYPE_PROPERTY, oldType, newType);
        }
    }

    protected int sanitizeLoadRuleLocationType(int locationType) {
        int type = 1;
        if (locationType == 1 || locationType == 2) {
            type = locationType;
        }
        return type;
    }

    public PathLocation getLocalLoadRuleLocation() {
        return this.fLocalLoadRuleLocation;
    }

    public void setLocalLoadRuleLocation(PathLocation newLocation) {
        PathLocation oldLocation;
        if (!(newLocation = (PathLocation)newLocation.getCanonicalForm()).equals((Object)(oldLocation = this.fLocalLoadRuleLocation))) {
            this.fLocalLoadRuleLocation = newLocation;
            this.firePropertyChange(LOCAL_LOAD_RULE_LOCATION_PROPERTY, oldLocation, newLocation);
        }
    }

    protected PathLocation sanitizeLocalLoadRuleLocation(String localLoadRuleString) {
        PathLocation location = null;
        if (localLoadRuleString != null && localLoadRuleString.length() > 0) {
            try {
                location = (PathLocation)new PathLocation(Path.fromPortableString((String)localLoadRuleString)).getCanonicalForm();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return location;
    }

    public RemoteLoadRuleWrapper getRemoteLoadRule() {
        return this.fRemoteLoadRule;
    }

    public void setRemoteLoadRule(RemoteLoadRuleWrapper newRemoteLoadRule) {
        RemoteLoadRuleWrapper oldRemoteLoadRule = this.fRemoteLoadRule;
        if (!newRemoteLoadRule.equals(oldRemoteLoadRule)) {
            this.fRemoteLoadRule = newRemoteLoadRule;
            this.firePropertyChange("com.ibm.team.filesystem.ide.ui.RemoteLoadRuleProperty", oldRemoteLoadRule, newRemoteLoadRule);
        }
    }

    @Override
    public void evaluateLoadRequests(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, null, (int)7);
        this.login((IProgressMonitor)sub.newChild(1));
        if (this.getLoadType() == 6) {
            ILoadRule2 loadRule = null;
            if (this.getLoadRuleLocationType() == 1 && this.fLocalLoadRuleLocation != null) {
                BufferedReader input = null;
                File file = new File(this.fLocalLoadRuleLocation.toOSString());
                try {
                    FileInputStream fis = new FileInputStream(file);
                    CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    input = new BufferedReader(new InputStreamReader((InputStream)fis, decoder));
                }
                catch (FileNotFoundException e) {
                    throw new FileSystemException(NLS.bind((String)Messages.LoadWizardInput_LocalLoadRuleNotFound, (Object)this.fLocalLoadRuleLocation.toOSString()), (Throwable)e);
                }
                loadRule = ILoadRuleFactory.loadRuleFactory.getLoadRule(this.getWorkspaceConnection(), (Reader)input, true, (IProgressMonitor)sub.newChild(1));
            } else if (this.getLoadRuleLocationType() == 2 && this.fRemoteLoadRule != null) {
                loadRule = this.fRemoteLoadRule.getLoadRule(this.connection, true, (IProgressMonitor)sub.newChild(1));
            }
            if (loadRule != null) {
                ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(this.getSandboxPath(), false);
                String subfolder = null;
                if (this.useParentFolder()) {
                    subfolder = this.getPathWithinSandbox();
                }
                ILoadOperation loadOp = null;
                if (this.workspaceSelected) {
                    loadOp = loadRule.getLoadOp(sandbox, subfolder, (LoadDilemmaHandler)this.getLoadDilemmaHandler(), (IProgressMonitor)sub.newChild(1));
                } else {
                    ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(this.components.size());
                    for (ItemId<IComponent> item : this.components) {
                        IComponentHandle handle = (IComponentHandle)item.toHandle();
                        componentHandles.add(handle);
                    }
                    loadOp = loadRule.getLoadOp(sandbox, subfolder, componentHandles, (LoadDilemmaHandler)this.getLoadDilemmaHandler(), (IProgressMonitor)sub.newChild(1));
                }
                loadOp.setPreserveFileTimestamps(this.isPreserveFileTimestamps());
                this.setLoadOperation(loadOp);
            } else {
                throw new FileSystemException(Messages.LoadWizardInput_ErrorCreatingLoadRule);
            }
        }
        sub.setWorkRemaining(2);
        this.getLoadOperation().evaluateLoadRequests((IProgressMonitor)sub.newChild(1));
        this.loadRequestEvaluated((IProgressMonitor)sub.newChild(1));
    }

    public boolean isOverwriteLocalChanges() {
        return this.overwriteLocalChanges;
    }

    public void setOverwriteLocalChanges(boolean overwriteLocalChanges) {
        if (this.overwriteLocalChanges != overwriteLocalChanges) {
            this.overwriteLocalChanges = overwriteLocalChanges;
            this.getLoadOperation().setPreserveLocalChanges(!this.overwriteLocalChanges);
            this.firePropertyChange("com.ibm.team.filesystem.ide.ui.RemoteLoadRuleProperty", !overwriteLocalChanges, overwriteLocalChanges);
        }
    }

    public String getConnectionName() {
        if (this.connection instanceof IWorkspaceConnection) {
            IWorkspaceConnection wc = (IWorkspaceConnection)this.connection;
            return wc.getName();
        }
        if (this.connection instanceof IBaselineConnection) {
            IBaselineConnection bc = (IBaselineConnection)this.connection;
            return ContextNameUtil.getContextName((IBaseline)bc.getResolvedBaseline());
        }
        return null;
    }

    @Override
    public boolean useParentFolder() {
        if (this.storedPathWithinSandbox != null) {
            return !this.storedPathWithinSandbox.equals(DO_NOT_USE_PARENT_FOLDER) && !this.storedPathWithinSandbox.equals("");
        }
        if (this.currentSandboxSubfolder != null) {
            return !this.currentSandboxSubfolder.equals(DO_NOT_USE_PARENT_FOLDER) && !this.currentSandboxSubfolder.equals("");
        }
        return this.useSandboxSubfolderAsDefault;
    }

    @Override
    public String getPathWithinSandbox() {
        if (this.storedPathWithinSandbox != null && !this.storedPathWithinSandbox.equals("") && !this.storedPathWithinSandbox.equals(DO_NOT_USE_PARENT_FOLDER)) {
            return this.storedPathWithinSandbox;
        }
        if (this.connection != null) {
            if (this.useParentFolder() && this.currentSandboxSubfolder != null && !this.currentSandboxSubfolder.equals("")) {
                return this.currentSandboxSubfolder;
            }
            return this.connection.getName();
        }
        return "";
    }

    public void unuseParentFolder() {
        this.setAndRefreshPathWithinSandbox(DO_NOT_USE_PARENT_FOLDER);
    }

    public void setAndRefreshPathWithinSandbox(String newLocation) {
        String old = this.pathWithinSandbox;
        this.pathWithinSandbox = newLocation;
        this.storedPathWithinSandbox = newLocation;
        this.updateLoadRequests();
        this.firePropertyChange("com.ibm.team.filesystem.ide.ui.PathWithinSandboxProperty", old, newLocation);
    }

    private abstract class FolderNode {
        private final FolderNode parent;
        private final Map<String, FolderNode> children = new HashMap<String, FolderNode>();

        protected FolderNode(FolderNode parent) {
            this.parent = parent;
        }

        public abstract NamedSiloedItem toNamedSiloedItem();

        public abstract String getPath();

        public FolderNode getNode(String path) {
            if (PathUtils.isEmptyPath((String)path)) {
                return this;
            }
            String[] segments = PathUtils.getSegments((String)path);
            FolderNode node = this;
            int i = 0;
            while (i < segments.length) {
                String segment = segments[i];
                if ((node = node.getChild(segment)) == null) {
                    return null;
                }
                ++i;
            }
            return node;
        }

        private FolderNode getChild(String segment) {
            return this.children.get(segment);
        }

        public FolderNode getParent() {
            return this.parent;
        }

        public abstract String getName();

        public abstract UUID getItemId();

        public FolderNode addChild(NamedSiloedItem namedSiloesItem) {
            NamedItemWrapperNode child = new NamedItemWrapperNode(this, namedSiloesItem);
            this.children.put(((FolderNode)child).getName(), child);
            return child;
        }
    }

    private class FolderTree
    implements IFolderTree {
        private final Map<UUID, FolderNode> componentRoots = new HashMap<UUID, FolderNode>();
        private final Map<SiloedItemId<IFolder>, FolderNode> allFolders = new HashMap<SiloedItemId<IFolder>, FolderNode>();

        private FolderTree() {
        }

        @Override
        public String findFolder(IComponentHandle component, IFolderHandle folderToLoad) {
            FolderNode folderNode = this.allFolders.get(new SiloedItemId(IFolder.ITEM_TYPE, folderToLoad.getItemId(), component.getItemId()));
            if (folderNode != null) {
                return folderNode.getPath();
            }
            return null;
        }

        public Map<NamedSiloedItem, List<NamedSiloedItem>> getAncestors(Set<NamedSiloedItem> set) {
            HashMap<NamedSiloedItem, List<NamedSiloedItem>> result = new HashMap<NamedSiloedItem, List<NamedSiloedItem>>();
            for (NamedSiloedItem o : set) {
                if (!(o instanceof NamedSiloedItem)) continue;
                NamedSiloedItem item = o;
                result.put(item, this.getAncestors(item));
            }
            return result;
        }

        private List<NamedSiloedItem> getAncestors(NamedSiloedItem item) {
            FolderNode node = this.componentRoots.get(item.getComponentUUID());
            ArrayList<NamedSiloedItem> result = new ArrayList<NamedSiloedItem>();
            if (node != null) {
                FolderNode folderNode;
                String path = item.getFQName();
                if (path == null && (folderNode = this.allFolders.get(new SiloedItemId(IFolder.ITEM_TYPE, item.getItemUUID(), item.getComponentUUID()))) != null) {
                    path = folderNode.getPath();
                }
                if (path != null) {
                    String[] segments = PathUtils.getSegments((String)path);
                    result.add(node.toNamedSiloedItem());
                    int i = 0;
                    while (i < segments.length) {
                        String segment = segments[i];
                        if ((node = node.getChild(segment)) == null) break;
                        result.add(node.toNamedSiloedItem());
                        ++i;
                    }
                }
            }
            if (result.isEmpty()) {
                result.add(item);
            }
            return result;
        }

        public void addFolder(NamedSiloedItem namedSiloesItem) {
            UUID componentId;
            FolderNode componentRoot;
            FolderNode parent;
            if (this.allFolders.get((Object)namedSiloesItem) == null && (parent = (componentRoot = this.getRoot(componentId = namedSiloesItem.getComponentUUID())).getNode(PathUtils.getParentFolderPath((String)namedSiloesItem.getFQName()))) != null) {
                FolderNode folderNode = parent.addChild(namedSiloesItem);
                this.allFolders.put((SiloedItemId<IFolder>)new SiloedItemId(IFolder.ITEM_TYPE, folderNode.getItemId(), componentId), folderNode);
            }
        }

        private FolderNode getRoot(UUID componentId) {
            FolderNode folderNode = this.componentRoots.get(componentId);
            if (folderNode == null) {
                IComponent component = LoadWizardInput.this.getComponent(componentId).getComponent();
                folderNode = new RootNode(componentId, component.getRootFolder().getItemId(), component.getName());
                this.componentRoots.put(componentId, folderNode);
                this.allFolders.put((SiloedItemId<IFolder>)new SiloedItemId(IFolder.ITEM_TYPE, folderNode.getItemId(), componentId), folderNode);
            }
            return folderNode;
        }
    }

    public static interface IFolderTree {
        public String findFolder(IComponentHandle var1, IFolderHandle var2);
    }

    private class NamedItemWrapperNode
    extends FolderNode {
        private final NamedSiloedItem namedSiloedItem;

        public NamedItemWrapperNode(FolderNode parent, NamedSiloedItem folderWrapper) {
            super(parent);
            this.namedSiloedItem = folderWrapper;
        }

        @Override
        public UUID getItemId() {
            return this.namedSiloedItem.getItemUUID();
        }

        @Override
        public String getName() {
            return this.namedSiloedItem.getName();
        }

        @Override
        public NamedSiloedItem toNamedSiloedItem() {
            return this.namedSiloedItem;
        }

        @Override
        public String getPath() {
            return PathUtils.appendPath((String)this.getParent().getPath(), (String)this.getName());
        }
    }

    private class RootNode
    extends FolderNode {
        private final UUID componentId;
        private final UUID itemId;
        private final String componentName;

        public RootNode(UUID componentId, UUID itemId, String componentName) {
            super(null);
            this.componentId = componentId;
            this.itemId = itemId;
            this.componentName = componentName;
        }

        @Override
        public UUID getItemId() {
            return this.itemId;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public NamedSiloedItem toNamedSiloedItem() {
            return new NamedSiloedItem(this.componentName, this.componentId, this.itemId, "");
        }

        @Override
        public String getPath() {
            return this.getName();
        }
    }

    public final class SelectedFoldersSet
    extends AbstractSetWithListeners<NamedSiloedItem> {
        public SelectedFoldersSet() {
            if (LoadWizardInput.this.elements.isEmpty()) {
                this.setStale(true);
            }
        }

        protected Collection<NamedSiloedItem> computeElements() {
            return LoadWizardInput.this.elements;
        }

        public void update(Collection<NamedSiloedItem> newElements) {
            this.checkRealm();
            HashSet<NamedSiloedItem> added = new HashSet<NamedSiloedItem>();
            HashSet<NamedSiloedItem> removed = new HashSet<NamedSiloedItem>();
            for (NamedSiloedItem item : newElements) {
                if (item == null || LoadWizardInput.this.elements.contains((Object)item)) continue;
                LoadWizardInput.this.elements.add(item);
                added.add(item);
            }
            Iterator<NamedSiloedItem> iterator = LoadWizardInput.this.elements.iterator();
            while (iterator.hasNext()) {
                NamedSiloedItem item = iterator.next();
                if (newElements.contains((Object)item)) continue;
                iterator.remove();
                removed.add(item);
            }
            this.setStale(false);
            this.fireDiff(SetDiff.create(removed, added));
        }

        public void makeStale() {
            this.setStale(true);
        }

        public void add(NamedSiloedItem item, boolean removeOverlapingItems) {
            if (item != null && !LoadWizardInput.this.elements.contains((Object)item)) {
                HashSet<NamedSiloedItem> removed = new HashSet<NamedSiloedItem>();
                this.internalAdd(item, removeOverlapingItems, removed);
                Set<NamedSiloedItem> added = Collections.singleton(item);
                this.fireDiff(SetDiff.create(removed, added));
            }
        }

        public void addAll(Set<NamedSiloedItem> items, boolean removeOverlapingItems) {
            HashSet<NamedSiloedItem> removed = new HashSet<NamedSiloedItem>();
            HashSet<NamedSiloedItem> added = new HashSet<NamedSiloedItem>();
            for (NamedSiloedItem item : items) {
                if (item == null || LoadWizardInput.this.elements.contains((Object)item)) continue;
                this.internalAdd(item, removeOverlapingItems, removed);
                added.add(item);
            }
            if (removed.size() > 0 || added.size() > 0) {
                this.fireDiff(SetDiff.create(removed, added));
            }
        }

        private void internalAdd(NamedSiloedItem item, boolean removeOverlapingItems, Collection<NamedSiloedItem> removed) {
            if (removeOverlapingItems) {
                Iterator<NamedSiloedItem> iterator = LoadWizardInput.this.elements.iterator();
                while (iterator.hasNext()) {
                    NamedSiloedItem other = iterator.next();
                    if (!item.isParentOf(other) && !other.isParentOf(item)) continue;
                    removed.add(other);
                    iterator.remove();
                }
            }
            LoadWizardInput.this.elements.add(item);
        }

        public void remove(NamedSiloedItem item, boolean removeChildren) {
            if (LoadWizardInput.this.elements.contains((Object)item)) {
                LoadWizardInput.this.elements.remove((Object)item);
                this.fireCollectionRemoved(Collections.singleton(item));
            } else {
                HashSet<NamedSiloedItem> removed = new HashSet<NamedSiloedItem>();
                Iterator<NamedSiloedItem> iterator = LoadWizardInput.this.elements.iterator();
                while (iterator.hasNext()) {
                    NamedSiloedItem other = iterator.next();
                    if (!item.isParentOf(other)) continue;
                    removed.add(other);
                    iterator.remove();
                }
                if (removed.size() > 0) {
                    this.fireCollectionRemoved(removed);
                }
            }
        }

        public void removeAll(Set<NamedSiloedItem> items) {
            HashSet<NamedSiloedItem> removed = new HashSet<NamedSiloedItem>();
            for (NamedSiloedItem item : items) {
                if (!LoadWizardInput.this.elements.contains((Object)item)) continue;
                LoadWizardInput.this.elements.remove((Object)item);
                removed.add(item);
            }
            if (removed.size() > 0) {
                this.fireCollectionRemoved(removed);
            }
        }

        public Set<NamedSiloedItem> getFoldersFor(IComponent component) {
            HashSet<NamedSiloedItem> result = new HashSet<NamedSiloedItem>();
            for (NamedSiloedItem item : LoadWizardInput.this.elements) {
                if (!item.isContainedInComponent(component)) continue;
                result.add(item);
            }
            return result;
        }

        public boolean contains(NamedSiloedItem namedSiloedItem) {
            return LoadWizardInput.this.elements.contains((Object)namedSiloedItem);
        }

        public void clear() {
            HashSet<NamedSiloedItem> removed = new HashSet<NamedSiloedItem>();
            removed.addAll(LoadWizardInput.this.elements);
            LoadWizardInput.this.elements.clear();
            if (!removed.isEmpty()) {
                this.fireCollectionRemoved(removed);
            }
        }

        public boolean isEmpty() {
            return LoadWizardInput.this.elements.isEmpty();
        }

        public boolean containsChildOf(NamedSiloedItem parent) {
            for (NamedSiloedItem item : LoadWizardInput.this.elements) {
                if (!parent.isParentOf(item)) continue;
                return true;
            }
            return false;
        }
    }
}

