/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.BlindLoadPage;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.IExtraLoadWizard;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadHandlerIncomingPage;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadHandlerRemovePage;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadRulePage;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SelectFoldersToLoadPage;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SelectProjectsToLoadPage;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class LoadWizard
extends Wizard
implements IPageChangingListener,
IValueChangeListener {
    private static final int CLOSE_WIZARD_CODE = 1476;
    private BlindLoadPage blindLoadPage;
    private SelectFoldersToLoadPage foldersToLoadPage;
    private SelectProjectsToLoadPage projectsToLoadPage;
    private LoadRulePage loadRulePage;
    private LoadHandlerIncomingPage loadHandlerIncomingPage;
    private LoadHandlerRemovePage loadHandlerRemovePage;
    boolean needsEvaluation;
    LoadWizardInput loadOp;

    static String selectionString(int[] selection) {
        return NLS.bind((String)Messages.CheckoutSelectedWizard_6, (Object)selection[0], (Object)selection[1]);
    }

    public LoadWizard(LoadWizardInput loadOp) {
        this.loadOp = loadOp;
        this.setWindowTitle(Messages.CheckoutSelectedWizard_7);
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        loadOp.getOverlapsOnDiskStatus().addValueChangeListener((IValueChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        this.loadOp.getOverlapsOnDiskStatus().removeValueChangeListener((IValueChangeListener)this);
    }

    public void addPages() {
        this.setDefaultPageImageDescriptor(ImagePool.CHECKOUT_SELECTED_WIZBAN);
        this.blindLoadPage = new BlindLoadPage(this.loadOp);
        this.foldersToLoadPage = new SelectFoldersToLoadPage(this.loadOp);
        this.projectsToLoadPage = new SelectProjectsToLoadPage(this.loadOp);
        this.loadRulePage = new LoadRulePage(this.loadOp);
        this.loadHandlerIncomingPage = new LoadHandlerIncomingPage(this.loadOp);
        this.loadHandlerRemovePage = new LoadHandlerRemovePage(this.loadOp);
        this.addPage((IWizardPage)this.blindLoadPage);
        this.addPage((IWizardPage)this.foldersToLoadPage);
        this.addPage((IWizardPage)this.projectsToLoadPage);
        this.addPage((IWizardPage)this.loadRulePage);
        this.addPage((IWizardPage)this.loadHandlerIncomingPage);
        this.addPage((IWizardPage)this.loadHandlerRemovePage);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        int loadType = this.loadOp.getLoadType();
        IExtraLoadWizard extraLoadWizard = this.loadOp.getCurrentExtraLoadWizard();
        if (currentPage == this.blindLoadPage) {
            if (loadType == 3 || loadType == 6) {
                return false;
            }
            if (loadType == 7) {
                return false;
            }
            if (loadType == 5) {
                return this.loadOp.getSandboxPath() != null;
            }
            return this.loadOp.getSandboxPath() != null && "com.ibm.team.filesystem.hfs".equals(this.loadOp.getSandboxPath().getStorageId());
        }
        if (currentPage == this.foldersToLoadPage) {
            return this.foldersToLoadPage.isPageComplete() && this.foldersToLoadPage.getNextPage() == null;
        }
        if (currentPage == this.projectsToLoadPage) {
            return this.projectsToLoadPage.isPageComplete() && this.projectsToLoadPage.getNextPage() == null;
        }
        if (currentPage == this.loadRulePage) {
            return this.loadRulePage.isPageComplete() && this.loadRulePage.getNextPage() == null;
        }
        if (loadType != 7) {
            boolean allComplete;
            boolean bl = allComplete = (loadType == 1 && this.projectsToLoadPage.isPageComplete() || loadType == 6 && this.loadRulePage.isPageComplete() || loadType != 1 && loadType != 6 && this.loadOp.getSandboxPath() != null) && this.loadHandlerIncomingPage.isPageComplete() && this.loadHandlerRemovePage.isPageComplete();
            return allComplete && currentPage.getNextPage() == null;
        }
        if (extraLoadWizard != null) {
            return extraLoadWizard.canFinish();
        }
        return false;
    }

    public IWizardPage getStartingPage() {
        if (this.loadOp.hasInitialSelection() && this.loadOp.getLoadType() != 7) {
            return this.foldersToLoadPage;
        }
        return super.getStartingPage();
    }

    public boolean performFinish() {
        if (this.loadOp.getLoadType() != 7) {
            boolean finish = this.performFinish2();
            if (finish) {
                this.loadOp.finished();
            }
            return finish;
        }
        return true;
    }

    private boolean performFinish2() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.blindLoadPage ? this.loadOp.getLoadType() == 4 : currentPage != this.foldersToLoadPage && currentPage != this.projectsToLoadPage && currentPage != this.loadRulePage) {
            return true;
        }
        IStatus status = this.evaluate(currentPage);
        if (status == Status.CANCEL_STATUS) {
            if (this.loadOp.getLoadType() == 1) {
                this.getContainer().showPage((IWizardPage)this.projectsToLoadPage);
            } else if (this.loadOp.getLoadType() != 6) {
                this.getContainer().showPage((IWizardPage)this.foldersToLoadPage);
            }
        } else if (status.isOK()) {
            IPreferenceStore store;
            boolean prompt;
            WizardPage nextPage = null;
            String message = null;
            if (this.loadOp.getLoadType() != 5) {
                if (this.loadOp.getCollisions().size() > 0) {
                    nextPage = this.loadHandlerIncomingPage;
                    message = Messages.CheckoutSelectedWizard_14;
                } else if (this.loadOp.getSharesToBeRemoved().size() > 0) {
                    nextPage = this.loadHandlerRemovePage;
                    message = Messages.CheckoutSelectedWizard_15;
                }
            }
            if (nextPage != null) {
                MessageDialogWithToggle dialog;
                this.getContainer().showPage(nextPage);
                IPreferenceStore store2 = UiPlugin.getDefault().getPreferenceStore();
                boolean prompt2 = store2.getBoolean("info_load_problems");
                if (prompt2 && (dialog = MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)Messages.CheckoutSelectedWizard_13, (String)message, (String)Messages.CheckoutSelectedWizard_18, (boolean)false, null, null)).getReturnCode() == 0) {
                    store2.setValue("info_load_problems", !dialog.getToggleState());
                }
                return false;
            }
            if ((this.loadOp.getEclipseSpecificOptions() == 0 || this.loadOp.getEclipseSpecificOptions() == 8) && (prompt = (store = UiPlugin.getDefault().getPreferenceStore()).getBoolean("prompt_load_without_project_creation"))) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)Messages.LoadWizard_ConfirmNoProjectsTitle, (String)Messages.LoadWizard_ConfirmNoProjectsMessage, (String)Messages.CheckoutSelectedWizard_18, (boolean)false, null, null);
                if (dialog.getReturnCode() != 0) {
                    return false;
                }
                store.setValue("prompt_load_without_project_creation", !dialog.getToggleState());
            }
        }
        return status.isOK() || status.getCode() == 1476;
    }

    private IStatus evaluate(final IWizardPage currentPage) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CheckoutSelectedWizard_17, (int)3);
                    try {
                        LoadWizard.this.loadOp.storeSandboxSubfolder((IProgressMonitor)sub);
                        if (currentPage == LoadWizard.this.blindLoadPage) {
                            LoadWizard.this.loadOp.refreshSelectedFolders((IProgressMonitor)sub.newChild(1));
                        }
                        sub.setWorkRemaining(1);
                        LoadWizard.this.loadOp.evaluateLoadRequests((IProgressMonitor)sub.newChild(1));
                        LoadWizard.this.needsEvaluation = false;
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            this.loadOp.promptInvalidLoadRequests(this.getShell());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            IStatus status = cause != null ? FileSystemStatusUtil.getStatusFor((Throwable)cause) : FileSystemStatusUtil.getStatusFor((Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.SelectFromRepoPart_0, null, (IStatus)status);
            return status;
        }
        catch (InterruptedException e) {
            Throwable cause = e.getCause();
            IStatus status = cause != null ? FileSystemStatusUtil.getStatusFor((Throwable)cause) : FileSystemStatusUtil.getStatusFor((Throwable)e);
            return status;
        }
        String message = this.loadOp.getProblems().getErrorMessage();
        if (message != null) {
            String description = this.loadOp.getLoadType() == 6 ? Messages.CheckoutSelectedWizard_22 : Messages.CheckoutSelectedWizard_19;
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CheckoutSelectedWizard_13, (String)description, (IStatus)FileSystemStatusUtil.getStatusFor((int)1, (String)message, null));
            return Status.CANCEL_STATUS;
        }
        if (this.loadOp.getLoadType() == 5 && this.loadOp.getSelectedFolders().isEmpty()) {
            IStatus status = StatusUtil.newStatus((Object)((Object)this), (int)4, (int)1476, (String)Messages.LoadWizard_NoOutOfSyncMessage);
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.LoadWizard_NoOutOfSyncTitle, (String)status.getMessage());
            return status;
        }
        return Status.OK_STATUS;
    }

    public void handlePageChanging(PageChangingEvent event) {
        Object targetPage = event.getTargetPage();
        IWizardPage currentPage = (IWizardPage)event.getCurrentPage();
        if (targetPage == this.foldersToLoadPage || targetPage == this.projectsToLoadPage || targetPage == this.loadRulePage) {
            event.doit = this.ensureSelectionAvailable();
        } else if (targetPage == this.loadHandlerIncomingPage) {
            if (currentPage != this.loadHandlerRemovePage && this.needsEvaluation) {
                IStatus status = this.evaluate(currentPage);
                event.doit = status.isOK();
            }
        } else if (currentPage == this.blindLoadPage && this.loadOp.getLoadType() == 7) {
            event.doit = this.ensureSelectionAvailable();
        }
    }

    private boolean ensureSelectionAvailable() {
        if (this.loadOp.getSelectedFolders().isStale()) {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            LoadWizard.this.loadOp.refreshSelectedFolders(monitor);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                IStatus status = cause != null ? FileSystemStatusUtil.getStatusFor((Throwable)cause) : FileSystemStatusUtil.getStatusFor((Throwable)e);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.SelectFromRepoPart_0, null, (IStatus)status);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int loadType = this.loadOp.getLoadType();
        if (page == this.blindLoadPage) {
            if (loadType == 4) {
                return null;
            }
            if (loadType == 1) {
                return this.projectsToLoadPage;
            }
            if (loadType == 5) {
                this.needsEvaluation = true;
                return this.loadHandlerIncomingPage;
            }
            if (loadType == 6) {
                return this.loadRulePage;
            }
            if (loadType == 7 && this.loadOp.getCurrentExtraLoadWizard() != null) {
                return this.loadOp.getCurrentExtraLoadWizard().getStartingPage();
            }
            return this.foldersToLoadPage;
        }
        if (page == this.foldersToLoadPage || page == this.projectsToLoadPage) {
            if (!page.isPageComplete()) {
                return null;
            }
            if (this.loadOp.getProblems().hasProjectCollisions()) {
                this.needsEvaluation = true;
                return this.loadHandlerIncomingPage;
            }
            this.needsEvaluation = false;
            return null;
        }
        if (page == this.loadRulePage) {
            return null;
        }
        if (page == this.loadHandlerIncomingPage) {
            if (this.loadOp.getSharesToBeRemoved().size() == 0) {
                return null;
            }
            return this.loadHandlerRemovePage;
        }
        if (loadType == 7 && this.loadOp.getCurrentExtraLoadWizard() != null) {
            return this.loadOp.getCurrentExtraLoadWizard().getNextPage(page);
        }
        return super.getNextPage(page);
    }

    private void showOverlapsOnDiskError(IStatus status) {
        ErrorDialog.openError((Shell)this.getShell(), (String)Messages.SelectFromRepoPart_19, (String)Messages.SelectFromRepoPart_20, (IStatus)status);
    }

    public void handleValueChange(ValueChangeEvent event) {
        this.showOverlapsOnDiskError((IStatus)event.getObservableValue().getValue());
    }
}

