/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.ide.ui.internal.util.JFaceObservables;
import com.ibm.team.filesystem.ide.ui.internal.util.PathLocationToStringConverter;
import com.ibm.team.filesystem.ide.ui.internal.util.PathValidator;
import com.ibm.team.filesystem.ide.ui.internal.util.StringToPathLocationConverter;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.CopyFileAreaCombo;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.RemoteLoadRuleWrapper;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SandboxNamespacePart;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SelectItemsToLoadPage;
import com.ibm.team.filesystem.ui.FileSelectionDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerOutput;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

class LoadRulePage
extends BaseWizardPage
implements IPropertyChangeListener {
    private final LoadWizardInput fInput;
    private final CombinedStatus fCombinedValidationStatus = new CombinedStatus();
    private DataBindingContext fDataBindingContext;
    private boolean isOKToShowMessage;
    private Button fLocalLocationTypeButton;
    private Button fRemoteLocationTypeButton;
    private ISWTObservableValue fLocalPathValue;
    private Text fLocalLoadRuleTextField;
    private Button fLocalBrowseButton;
    private IChangeListener fLocalLoadRuleStatusListener;
    private Text fRemoteLoadRuleTextField;
    private Button fRemoteBrowseButton;
    public static final String REMOTE_PATH_SEPARATOR = "/";
    private IChangeListener fCopyFileAreaStatusListener;

    public LoadRulePage(LoadWizardInput loadWizardInput) {
        super(LoadRulePage.class.getName(), Messages.LoadRulePage_PageTitle, null);
        this.setDescription(Messages.LoadRulePage_PageDescription);
        this.fInput = loadWizardInput;
    }

    protected void createBody(Composite composite) {
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).numColumns(3).generateLayout(composite);
        Dialog.applyDialogFont((Control)composite);
        this.fDataBindingContext = new DataBindingContext();
        WidgetToolkit toolkit = context.getToolkit();
        int previousLocationType = this.fInput.sanitizeLoadRuleLocationType(this.fInput.getLoadRuleLocationType());
        this.fInput.setLoadRuleLocationType(previousLocationType);
        String localLocation = Messages.LoadRulePage_LocalTypeButtonLabel;
        this.fLocalLocationTypeButton = toolkit.createButton(composite, localLocation, 16);
        this.fLocalLocationTypeButton.addSelectionListener((SelectionListener)this.getLocalTypeButtonListener());
        this.fLocalLocationTypeButton.setSelection(previousLocationType == 1);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)this.fLocalLocationTypeButton);
        this.createLocalLoadRuleWidgets(composite, context);
        String remoteLocation = Messages.LoadRulePage_RemoteTypeButtonLabel;
        this.fRemoteLocationTypeButton = toolkit.createButton(composite, remoteLocation, 16);
        this.fRemoteLocationTypeButton.addSelectionListener((SelectionListener)this.getRemoteTypeButtonListener());
        this.fRemoteLocationTypeButton.setSelection(previousLocationType == 2);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)this.fRemoteLocationTypeButton);
        if (!this.fLocalLocationTypeButton.getSelection() && !this.fRemoteLocationTypeButton.getSelection()) {
            this.fLocalLocationTypeButton.setSelection(true);
            this.fInput.setLoadRuleLocationType(1);
        }
        this.createRemoteLoadRuleWidgets(composite, context);
        this.createAdvancedOptionsExpander(composite, context);
        DatabindingUtil.bindMessage((DialogPage)this, (IObservableValue)this.fCombinedValidationStatus);
        this.fInput.addPropertyChangeListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getHelpId());
    }

    private SelectionAdapter getLocalTypeButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    LoadRulePage.this.fInput.setLoadRuleLocationType(1);
                    LoadRulePage.this.fLocalLoadRuleTextField.setEnabled(true);
                    LoadRulePage.this.fLocalBrowseButton.setEnabled(true);
                    LoadRulePage.this.fRemoteLoadRuleTextField.setEnabled(false);
                    LoadRulePage.this.fRemoteBrowseButton.setEnabled(false);
                }
            }
        };
    }

    private SelectionAdapter getRemoteTypeButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    LoadRulePage.this.fInput.setLoadRuleLocationType(2);
                    LoadRulePage.this.fLocalLoadRuleTextField.setEnabled(false);
                    LoadRulePage.this.fLocalBrowseButton.setEnabled(false);
                    LoadRulePage.this.fRemoteLoadRuleTextField.setEnabled(true);
                    LoadRulePage.this.fRemoteBrowseButton.setEnabled(true);
                }
            }
        };
    }

    private void createLocalLoadRuleWidgets(Composite composite, WidgetFactoryContext context) {
        WidgetToolkit toolkit = context.getToolkit();
        Group localLoadRuleGroup = new Group(composite, 0);
        localLoadRuleGroup.setText(Messages.LoadRulePage_LocalLoadRuleGroupLabel);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(3).generateLayout((Composite)localLoadRuleGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)localLoadRuleGroup);
        String descriptionText = Messages.LoadRulePage_LocalLoadRuleGroupDescription;
        Label descriptionLabel = toolkit.createLabel((Composite)localLoadRuleGroup, descriptionText, 64);
        GridDataFactory.defaultsFor((Control)descriptionLabel).grab(true, false).align(4, 4).span(3, 1).applyTo((Control)descriptionLabel);
        String labelText = Messages.LoadRulePage_LocalLoadRulePathLabel;
        Label label = toolkit.createLabel((Composite)localLoadRuleGroup, labelText);
        GridDataFactory.defaultsFor((Control)label).grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.fLocalLoadRuleTextField = new Text((Composite)localLoadRuleGroup, 2048);
        this.fLocalLoadRuleTextField.setEnabled(this.fLocalLocationTypeButton.getSelection());
        GridDataFactory.defaultsFor((Control)this.fLocalLoadRuleTextField).grab(true, false).align(4, 0x1000000).span(1, 1).applyTo((Control)this.fLocalLoadRuleTextField);
        String sandboxPathString = this.fInput.getSettings().get("com.ibm.team.filesystem.ide.ui.LocalLoadRuleLocationProperty");
        this.bindLocalLoadRulePathFieldToModel(this.fLocalLoadRuleTextField);
        if (sandboxPathString != null && this.validateLocalLoadRulePath(sandboxPathString).getSeverity() == 4) {
            this.fLocalLoadRuleTextField.setText("");
            this.fInput.getSettings().put("com.ibm.team.filesystem.ide.ui.LocalLoadRuleLocationProperty", "");
        }
        this.fLocalBrowseButton = toolkit.createButton((Composite)localLoadRuleGroup, Messages.LoadRulePage_LocalLoadRuleBrowseButtonLabel, 8);
        this.fLocalBrowseButton.setEnabled(this.fLocalLocationTypeButton.getSelection());
        this.fLocalBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LoadRulePage.this.fLocalBrowseButton.getShell());
                dialog.setFilterPath((String)LoadRulePage.this.fLocalPathValue.getValue());
                String path = dialog.open();
                if (path != null) {
                    LoadRulePage.this.fLocalPathValue.setValue((Object)path);
                }
            }
        });
        this.fLocalBrowseButton.setLayoutData((Object)new GridData(4, 2, false, false));
    }

    private void bindLocalLoadRulePathFieldToModel(Text loadPathField) {
        this.fLocalPathValue = WidgetProperties.text((int)24).observe((Widget)loadPathField);
        IObservableValue localPathModelValue = JFaceObservables.observeProperty((Object)this.fInput, "localLoadRuleLocation", "com.ibm.team.filesystem.ide.ui.LocalLoadRuleLocationProperty");
        UpdateValueStrategy targetToModelUpdateStrategy = new UpdateValueStrategy();
        targetToModelUpdateStrategy.setAfterGetValidator(this.getLocalLoadRuleFileValidator());
        targetToModelUpdateStrategy.setConverter((IConverter)new StringToPathLocationConverter());
        UpdateValueStrategy modelToTargetUpdateStrategy = new UpdateValueStrategy();
        modelToTargetUpdateStrategy.setConverter((IConverter)new PathLocationToStringConverter());
        final Binding binding = this.fDataBindingContext.bindValue((IObservableValue)this.fLocalPathValue, localPathModelValue, targetToModelUpdateStrategy, modelToTargetUpdateStrategy);
        IObservableValue localLoadRuleObservableValue = binding.getValidationStatus();
        this.fCombinedValidationStatus.addStatus(localLoadRuleObservableValue);
        this.fLocalLoadRuleStatusListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                IWizardContainer container;
                IStatus status = (IStatus)LoadRulePage.this.fInput.getValidationStatus().getValue();
                if (status.getSeverity() == 4 && (container = LoadRulePage.this.getContainer()) instanceof IWizardContainer2) {
                    ((IWizardContainer2)container).updateSize();
                }
            }
        };
        this.fLocalLocationTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                binding.validateTargetToModel();
            }
        });
        this.fInput.getValidationStatus().addChangeListener(this.fLocalLoadRuleStatusListener);
    }

    private IValidator getLocalLoadRuleFileValidator() {
        return new PathValidator(){

            @Override
            public IStatus validate(Object value) {
                if (LoadRulePage.this.fLocalLocationTypeButton.getSelection()) {
                    IStatus status = super.validate(value);
                    if (!status.isOK()) {
                        return status;
                    }
                    return LoadRulePage.this.validateLocalLoadRulePath((String)value);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private IStatus validateLocalLoadRulePath(String path) {
        if (this.fLocalLocationTypeButton.getSelection()) {
            if (path == null || path.length() == 0) {
                return FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LoadRulePage_LocalLoadRuleNotSpecifiedError);
            }
            File file = new File(path);
            if (!file.exists()) {
                return FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LoadRulePage_LocalLoadRuleDoesNotExistError);
            }
            if (!file.isFile()) {
                return FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LoadRulePage_LocalLoadRuleNotAFileError);
            }
        }
        return Status.OK_STATUS;
    }

    private void createRemoteLoadRuleWidgets(Composite composite, WidgetFactoryContext context) {
        WidgetToolkit toolkit = context.getToolkit();
        Group remoteLoadRuleGroup = new Group(composite, 0);
        remoteLoadRuleGroup.setText(Messages.LoadRulePage_RemoteLoadRuleGroupLabel);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(3).generateLayout((Composite)remoteLoadRuleGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)remoteLoadRuleGroup);
        String workspaceName = this.fInput.getConnectionName();
        if (workspaceName == null) {
            workspaceName = Messages.LoadRulePage_UnknownWorkspace;
        }
        String descriptionText = NLS.bind((String)Messages.LoadRulePage_RemoteLoadRuleGroupDescription, (Object)workspaceName);
        Label descriptionLabel = toolkit.createLabel((Composite)remoteLoadRuleGroup, descriptionText, 64);
        GridDataFactory.defaultsFor((Control)descriptionLabel).grab(true, false).align(4, 4).span(3, 1).applyTo((Control)descriptionLabel);
        String labelText = Messages.LoadRulePage_RemoteLoadRuleLabel;
        Label label = toolkit.createLabel((Composite)remoteLoadRuleGroup, labelText);
        GridDataFactory.defaultsFor((Control)label).grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.fRemoteLoadRuleTextField = new Text((Composite)remoteLoadRuleGroup, 2048);
        this.fRemoteLoadRuleTextField.setEnabled(this.fRemoteLocationTypeButton.getSelection());
        this.fRemoteLoadRuleTextField.setEditable(false);
        RemoteLoadRuleWrapper remoteLoadRule = this.getRemoteLoadRule();
        this.createJobToCalculateRemoteLoadRuleString(remoteLoadRule.getLoadRuleFiles());
        GridDataFactory.defaultsFor((Control)this.fRemoteLoadRuleTextField).grab(true, false).align(4, 0x1000000).span(1, 1).applyTo((Control)this.fRemoteLoadRuleTextField);
        this.fRemoteBrowseButton = toolkit.createButton((Composite)remoteLoadRuleGroup, Messages.LoadRulePage_RemoteLoadRuleBrowseButtonLabel, 8);
        this.fRemoteBrowseButton.setEnabled(this.fRemoteLocationTypeButton.getSelection());
        this.fRemoteBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SiloedItemId siloedItem;
                RemoteLoadRuleWrapper remoteLoadRules = LoadRulePage.this.getRemoteLoadRule();
                Map<Object, Object> initialSelection = remoteLoadRules != null ? remoteLoadRules.getLoadRuleFiles() : Collections.emptyMap();
                Map<IComponentHandle, IFileItemHandle> previousLoadRule = remoteLoadRules.getLoadRuleFiles();
                RepositoryFilesPickerOutput pickerOutput = LoadRulePage.this.openRemoteLoadRuleSelectionDialog(initialSelection);
                if (pickerOutput != null && pickerOutput.getItemIds() != null && pickerOutput.getItemIds().size() > 0 && (siloedItem = pickerOutput.getItemIds().iterator().next()).toHandle() instanceof IFileItemHandle) {
                    HashMap<IComponentHandle, IFileItemHandle> selectedRemoteLoadRule = new HashMap<IComponentHandle, IFileItemHandle>(1);
                    IComponentHandle componentHandle = siloedItem.getComponentHandle();
                    IFileItemHandle fileItemHandle = (IFileItemHandle)siloedItem.toHandle();
                    selectedRemoteLoadRule.put(componentHandle, fileItemHandle);
                    if (!LoadRulePage.this.isSameRemoteLoadRule(selectedRemoteLoadRule, previousLoadRule)) {
                        LoadRulePage.this.setRemoteLoadRule(new RemoteLoadRuleWrapper(selectedRemoteLoadRule));
                        IComponent owningComponent = pickerOutput.getOwningComponent((SiloedItemId<IVersionable>)siloedItem);
                        VersionablePath path = pickerOutput.getFilePath((SiloedItemId<IVersionable>)siloedItem);
                        if (owningComponent != null && path != null) {
                            String fullPath = String.valueOf(owningComponent.getName()) + LoadRulePage.REMOTE_PATH_SEPARATOR + path.toPath().toPortableString();
                            LoadRulePage.this.fRemoteLoadRuleTextField.setText(fullPath);
                            LoadRulePage.this.setPageComplete(LoadRulePage.this.isPageComplete());
                        } else {
                            LoadRulePage.this.createJobToCalculateRemoteLoadRuleString(selectedRemoteLoadRule);
                        }
                    }
                }
            }
        });
        this.fRemoteBrowseButton.setLayoutData((Object)new GridData(4, 2, false, false));
    }

    private boolean isSameRemoteLoadRule(Map<IComponentHandle, IFileItemHandle> map1, Map<IComponentHandle, IFileItemHandle> map2) {
        boolean equals = true;
        if (map1 == null && map2 != null || map1 != null && map2 == null) {
            equals = false;
        }
        if (map1 != null && map2 != null && map1.size() == map2.size()) {
            if (map1.size() > 0 && map2.size() > 0) {
                IComponentHandle component1 = map1.entrySet().iterator().next().getKey();
                IComponentHandle component2 = map2.entrySet().iterator().next().getKey();
                IFileItemHandle fileItem1 = map1.entrySet().iterator().next().getValue();
                IFileItemHandle fileItem2 = map2.entrySet().iterator().next().getValue();
                if (!component1.sameItemId((IItemHandle)component2) || !fileItem1.sameItemId((IItemHandle)fileItem2)) {
                    equals = false;
                }
            }
        } else {
            equals = false;
        }
        return equals;
    }

    private void createJobToCalculateRemoteLoadRuleString(Map<IComponentHandle, IFileItemHandle> loadRuleFiles) {
        if (loadRuleFiles != null && loadRuleFiles.size() > 0) {
            final IComponentHandle componentHandle = loadRuleFiles.entrySet().iterator().next().getKey();
            final IFileItemHandle fileItemHandle = loadRuleFiles.entrySet().iterator().next().getValue();
            if (componentHandle != null && fileItemHandle != null) {
                JobRunner operationRunner = new JobRunner(false);
                operationRunner.enqueue(Messages.LoadRulePage_CalculateRemoteLoadRuleStringJobName, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        IComponent component = null;
                        try {
                            component = (IComponent)LoadRulePage.this.fInput.getRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(40));
                            if (component != null) {
                                IConnection connection = LoadRulePage.this.fInput.getConnection();
                                IConfiguration configuration = null;
                                if (connection instanceof IWorkspaceConnection) {
                                    IWorkspaceConnection wc = (IWorkspaceConnection)connection;
                                    configuration = wc.configuration(componentHandle);
                                } else if (connection instanceof IBaselineConnection) {
                                    IBaselineConnection bc = (IBaselineConnection)connection;
                                    configuration = bc.configuration();
                                }
                                if (configuration != null) {
                                    IAncestorReport ancestors = (IAncestorReport)configuration.locateAncestors(Collections.singletonList(fileItemHandle), (IProgressMonitor)progress.newChild(40)).get(0);
                                    if (ancestors != null && !ancestors.getNameItemPairs().isEmpty()) {
                                        String[] repositoryPath = new String[ancestors.getNameItemPairs().size() - 1];
                                        Iterator i = ancestors.getNameItemPairs().iterator();
                                        i.next();
                                        int j = 0;
                                        while (i.hasNext()) {
                                            INameItemPair pair = (INameItemPair)i.next();
                                            repositoryPath[j] = pair.getName();
                                            ++j;
                                        }
                                        StringBuilder fullPath = new StringBuilder(component.getName());
                                        int k = 0;
                                        while (k < repositoryPath.length) {
                                            fullPath.append(LoadRulePage.REMOTE_PATH_SEPARATOR);
                                            fullPath.append(repositoryPath[k]);
                                            ++k;
                                        }
                                        LoadRulePage.this.handleUpdateRemoteLoadRuleText(fullPath.toString());
                                    } else {
                                        LoadRulePage.this.handleErrorFetchingRemoteLoadRule();
                                    }
                                }
                            } else {
                                LoadRulePage.this.handleErrorFetchingRemoteLoadRule();
                            }
                        }
                        catch (Exception e) {
                            LoadRulePage.this.handleErrorFetchingRemoteLoadRule();
                            return;
                        }
                    }
                });
            } else {
                this.fRemoteLoadRuleTextField.setText("");
                this.setRemoteLoadRule(new RemoteLoadRuleWrapper(new HashMap<IComponentHandle, IFileItemHandle>()));
            }
        } else {
            this.fRemoteLoadRuleTextField.setText("");
        }
    }

    private void handleUpdateRemoteLoadRuleText(final String displayText) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!LoadRulePage.this.fRemoteLoadRuleTextField.isDisposed()) {
                    LoadRulePage.this.fRemoteLoadRuleTextField.setText(displayText);
                    LoadRulePage.this.setPageComplete(LoadRulePage.this.isPageComplete());
                }
            }
        });
    }

    private void handleErrorFetchingRemoteLoadRule() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LoadRulePage.this.setRemoteLoadRule(new RemoteLoadRuleWrapper(new HashMap<IComponentHandle, IFileItemHandle>()));
                if (!LoadRulePage.this.fRemoteLoadRuleTextField.isDisposed()) {
                    LoadRulePage.this.fRemoteLoadRuleTextField.setText("");
                    LoadRulePage.this.setPageComplete(LoadRulePage.this.isPageComplete());
                }
            }
        });
    }

    protected RepositoryFilesPickerOutput openRemoteLoadRuleSelectionDialog(Map<IComponentHandle, IFileItemHandle> initialSelection) {
        return FileSelectionDialog.pickFile(this.fRemoteBrowseButton.getShell(), this.fInput.getWorkspaceConnection().teamRepository(), this.fInput.getWorkspaceConnection().getResolvedWorkspace(), Messages.LoadRulePage_RemoteLoadRuleSelectionDialogDescription, initialSelection, false);
    }

    private synchronized void setRemoteLoadRule(RemoteLoadRuleWrapper remoteLoadRule) {
        this.fInput.setRemoteLoadRule(remoteLoadRule);
    }

    private synchronized RemoteLoadRuleWrapper getRemoteLoadRule() {
        return this.fInput.getRemoteLoadRule();
    }

    private void createAdvancedOptionsExpander(final Composite parent, WidgetFactoryContext context) {
        WidgetToolkit toolkit = context.getToolkit();
        ExpandableComposite advancedOptions = toolkit.createExpandableComposite(parent, 18);
        advancedOptions.setText(Messages.LoadRulePage_AdvancedOptionsExpanderLabel);
        GridDataFactory.defaultsFor((Control)advancedOptions).grab(true, false).align(4, 4).span(3, 1).applyTo((Control)advancedOptions);
        advancedOptions.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.layout();
                IWizardContainer container = LoadRulePage.this.getContainer();
                if (container instanceof IWizardContainer2) {
                    ((IWizardContainer2)container).updateSize();
                }
            }
        });
        advancedOptions.setExpanded(this.fInput.useParentFolder());
        Composite composite = new Composite((Composite)advancedOptions, 0);
        advancedOptions.setClient((Control)composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createCopyFileAreaPart(composite, context);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
    }

    private void createCopyFileAreaPart(Composite parent, WidgetFactoryContext context) {
        CopyFileAreaCombo copyFileAreaCombo = new CopyFileAreaCombo(parent, context, Messages.LoadRulePage_CopyFileAreaDescription);
        this.bindCopyFileAreaCombo(copyFileAreaCombo);
        SandboxNamespacePart workspaceNamespacePart = new SandboxNamespacePart(parent, context, this.fInput, this.getContainer());
        workspaceNamespacePart.initNamespace();
        SelectItemsToLoadPage.createPreserveFileTimestampCheckbox(parent, this.fDataBindingContext, this.fInput);
    }

    private void bindCopyFileAreaCombo(CopyFileAreaCombo copyFileAreaCombo) {
        IObservableValue connectionStatus = copyFileAreaCombo.connectLoadInput(this.fInput, this.fDataBindingContext);
        this.fCombinedValidationStatus.addStatus(connectionStatus);
        this.fCopyFileAreaStatusListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                IWizardContainer container;
                IStatus status = (IStatus)LoadRulePage.this.fInput.getValidationStatus().getValue();
                if (status.getSeverity() == 4 && (container = LoadRulePage.this.getContainer()) instanceof IWizardContainer2) {
                    ((IWizardContainer2)container).updateSize();
                }
            }
        };
        this.fInput.getValidationStatus().addChangeListener(this.fCopyFileAreaStatusListener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("com.ibm.team.filesystem.ide.ui.LoadRuleLocationTypeProperty") || property.equals("com.ibm.team.filesystem.ide.ui.LocalLoadRuleLocationProperty") || property.equals("com.ibm.team.filesystem.ide.ui.RemoteLoadRuleProperty") || property.equals("com.ibm.team.filesystem.ide.ui.SandboxPathProperty")) {
            this.getContainer().updateButtons();
        }
    }

    public void dispose() {
        super.dispose();
        this.fDataBindingContext.dispose();
        if (this.fCopyFileAreaStatusListener != null) {
            this.fInput.getValidationStatus().removeChangeListener(this.fCopyFileAreaStatusListener);
        }
        if (this.fLocalLoadRuleStatusListener != null) {
            this.fInput.getValidationStatus().removeChangeListener(this.fLocalLoadRuleStatusListener);
        }
        this.fInput.removePropertyChangeListener(this);
    }

    protected String getHelpId() {
        return "com.ibm.team.filesystem.ide.ui.wizard_load_loadrules";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpId());
    }

    public boolean isPageComplete() {
        boolean isComplete = super.isPageComplete();
        if (this.fLocalLocationTypeButton.getSelection()) {
            isComplete = this.validateLocalLoadRulePath(this.fLocalLoadRuleTextField.getText()).getSeverity() != 4;
        } else if (this.fRemoteLocationTypeButton.getSelection()) {
            isComplete = this.fRemoteLoadRuleTextField.getText().length() > 0;
        }
        return isComplete;
    }

    public void setMessage(String newMessage, int newType) {
        if (this.isOKToShowMessage) {
            super.setMessage(newMessage, newType);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.isOKToShowMessage = true;
        }
    }
}

