/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IComponentSyncManager;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.filesystem.rcp.ui.internal.util.PropertyChangeNotifier;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PreparedLoadHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class LoadOperationInput
extends PropertyChangeNotifier {
    public static final String SANDBOX_PATH_PROPERTY = "com.ibm.team.filesystem.ide.ui.SandboxPathProperty";
    public static final String ECLIPSE_SPECIFIC_OPTIONS_PROPERTY = "com.ibm.team.filesystem.ide.ui.EclipseSpecificOptionsProperty";
    private static final String SETTINGS_SECTION = "com.ibm.team.filesystem.ide.ui.LoadOperationInput";
    private static final String SANDBOX_PATH_PREFERENCE = "com.ibm.team.filesystem.ide.ui.SandboxPath";
    private static final String ECLIPSE_LOAD_PREFERENCE = "com.ibm.team.filesystem.ide.ui.EclipseLoadPreference";
    protected static final String PATH_WITHIN_SANDBOX_PROPERTY = "com.ibm.team.filesystem.ide.ui.PathWithinSandboxProperty";
    protected static final String PRESERVE_FILE_TIMESTAMPS_PROPERTY = "com.ibm.team.filesystem.ide.ui.PreserveFileTimestampsProperty";
    private final PreparedLoadHandler loadHandler = new PreparedLoadHandler(this);
    private ILoadOperation loadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)this.loadHandler);
    private ILocation sandboxPath;
    private WritableValue validationStatus;
    private Runnable validationRunnable;
    protected String pathWithinSandbox;
    private PostLoadCallback postLoadCallback;

    protected LoadOperationInput() {
        String sandboxPathString = this.getSettings().get(SANDBOX_PATH_PREFERENCE);
        if (sandboxPathString == null || sandboxPathString.length() == 0) {
            this.sandboxPath = new PathLocation(this.getWorkspaceRootPath()).getCanonicalForm();
        } else if (sandboxPathString.startsWith("storageId:")) {
            int storageBegin = sandboxPathString.indexOf("storageId:") + "storageId:".length();
            int storageEnd = sandboxPathString.indexOf(47);
            String storageId = sandboxPathString.substring(storageBegin, storageEnd);
            String restOfLocation = sandboxPathString.substring(storageEnd + 1);
            this.sandboxPath = SharingManager.getInstance().getStorageManager(storageId).createLocation(restOfLocation);
        } else {
            IPath path = Path.fromPortableString((String)sandboxPathString);
            this.sandboxPath = new PathLocation(path);
        }
        int eclipseLoadPreference = 1;
        try {
            eclipseLoadPreference = this.getSettings().getInt(ECLIPSE_LOAD_PREFERENCE);
        }
        catch (NumberFormatException storageEnd) {
            // empty catch block
        }
        this.loadOp.setEclipseSpecificLoadOptions(eclipseLoadPreference);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LoadOperationInput.this.handlePropertyChange(event);
            }
        });
        boolean preserveFileTimestamps = this.getSettings().getBoolean(PRESERVE_FILE_TIMESTAMPS_PROPERTY);
        this.loadOp.setPreserveFileTimestamps(preserveFileTimestamps);
    }

    public void initialize() {
        this.validationStatus = new WritableValue();
        this.validationStatus.setValue((Object)Status.OK_STATUS);
        this.validationRunnable = new Runnable(){

            @Override
            public void run() {
                LoadOperationInput.this.validationStatus.setValue((Object)LoadOperationInput.this.doValidate());
            }
        };
    }

    protected boolean requiresValidationOnChange(String property) {
        return true;
    }

    protected IDialogSettings getSettings() {
        IDialogSettings parentSettings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = parentSettings.getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = parentSettings.addNewSection(SETTINGS_SECTION);
        }
        return settings;
    }

    public ILoadOperation getLoadOperation() {
        return this.loadOp;
    }

    public void setLoadOperation(ILoadOperation op) {
        this.loadOp = op;
    }

    public PreparedLoadHandler getLoadDilemmaHandler() {
        return this.loadHandler;
    }

    public void evaluateLoadRequests(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, null, (int)3);
        this.login((IProgressMonitor)sub.newChild(1));
        this.getLoadOperation().evaluateLoadRequests((IProgressMonitor)sub.newChild(1));
        this.loadRequestEvaluated((IProgressMonitor)sub.newChild(1));
    }

    protected void loadRequestEvaluated(IProgressMonitor monitor) {
        this.validate();
    }

    public void doLoad(IOperationRunner operationRunner) {
        if (this.loadOp.getLoadRequests().size() > 0) {
            operationRunner.enqueue(Messages.CheckoutSelectedWizard_8, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    IComponentSyncManager syncMgr = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncManager();
                    IWorkspaceConnection workspaceConnection = LoadOperationInput.this.getWorkspaceConnection();
                    syncMgr.loading(workspaceConnection);
                    try {
                        try {
                            LoadOperationInput.this.loadHandler.trimAnswersFor(LoadOperationInput.this.loadOp);
                            LoadOperationInput.this.loadOp.run((IProgressMonitor)progress.newChild(90));
                        }
                        catch (TeamRepositoryException e) {
                            if (LoadOperationInput.this.postLoadCallback != null) {
                                LoadOperationInput.this.postLoadCallback.loadFailed((IProgressMonitor)progress.newChild(10));
                            }
                            throw e;
                        }
                    }
                    finally {
                        syncMgr.loadingDone(workspaceConnection);
                    }
                    if (LoadOperationInput.this.postLoadCallback != null) {
                        LoadOperationInput.this.postLoadCallback.loadSucceeded((IProgressMonitor)progress.newChild(10));
                    }
                }
            });
        }
    }

    public void setPostLoadCallback(PostLoadCallback runnable) {
        this.postLoadCallback = runnable;
    }

    public Collection<IInvalidLoadRequest> getInvalidLoadRequests() {
        return this.getLoadOperation().getInvalidLoadRequests();
    }

    public Collection<ICollision> getCollisions() {
        return this.getLoadOperation().getCollisions();
    }

    public Collection<ILoadOverlap> getLoadOverlaps() {
        return this.getLoadOperation().getLoadOverlaps();
    }

    public Collection<IShareableToLoad> getNewSharesToLoad() {
        return this.getLoadOperation().getNewSharesToLoad();
    }

    public Collection<IShareOutOfSync> getSharesOutOfSync() {
        return this.getLoadOperation().getSharesOutOfSync();
    }

    public Collection<IRemovedShare> getSharesToBeRemoved() {
        return this.getLoadOperation().getSharesToBeRemoved();
    }

    protected void removeAllRequests() {
        this.getLoadOperation().removeLoadRequests(this.getLoadOperation().getLoadRequests());
    }

    protected void requestLoad(IComponentHandle component, Collection<IVersionableHandle> folders) {
        ILocation sandboxPath = this.getSandboxPath();
        if (sandboxPath != null) {
            ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(this.getSandboxPath(), false);
            RelativeLocation relativeLocation = null;
            if (this.useParentFolder()) {
                relativeLocation = new RelativeLocation(this.getPathWithinSandbox());
            }
            this.getLoadOperation().requestLoad(sandbox, (IRelativeLocation)relativeLocation, this.getWorkspaceConnection(), component, folders, true);
        } else {
            this.removeAllRequests();
        }
    }

    protected IPath getWorkspaceRootPath() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    public Collection<ISandbox> getKnownSandboxes() {
        ISharingManager mgr = FileSystemCore.getSharingManager();
        HashSet<ISandbox> sandboxes = mgr.getRegisteredSandboxes();
        ISandbox workspaceSandbox = mgr.getSandbox((ILocation)new PathLocation(this.getWorkspaceRootPath()), true);
        if (workspaceSandbox == null) {
            workspaceSandbox = mgr.getSandbox((ILocation)new PathLocation(this.getWorkspaceRootPath()), false);
            sandboxes = new HashSet<ISandbox>(sandboxes);
            sandboxes.add(workspaceSandbox);
        }
        return sandboxes;
    }

    public ILocation getSandboxPath() {
        return this.sandboxPath;
    }

    public void setSandboxPath(ILocation sandboxPath) {
        ILocation iLocation = sandboxPath = sandboxPath != null ? sandboxPath.getCanonicalForm() : null;
        if (sandboxPath == null) {
            return;
        }
        if (!sandboxPath.equals((Object)this.sandboxPath)) {
            ILocation oldValue = this.sandboxPath;
            this.sandboxPath = sandboxPath;
            this.handleSandboxPathChange();
            this.firePropertyChange(SANDBOX_PATH_PROPERTY, oldValue, this.sandboxPath);
        }
    }

    protected void handleSandboxPathChange() {
    }

    public void finished() {
        if ("com.ibm.team.filesystem.hfs".equals(this.getSandboxPath().getStorageId())) {
            IPath path = (IPath)this.getSandboxPath().getAdapter(IPath.class);
            if (path == null || path.equals((Object)this.getWorkspaceRootPath())) {
                this.getSettings().put(SANDBOX_PATH_PREFERENCE, null);
            } else {
                this.getSettings().put(SANDBOX_PATH_PREFERENCE, path.toPortableString());
            }
        } else {
            String storageId = this.getSandboxPath().getStorageId();
            this.getSettings().put(SANDBOX_PATH_PREFERENCE, "storageId:" + storageId + '/' + this.getSandboxPath().toString());
        }
        this.rememberEclipseLoadPreference();
        this.getSettings().put(PRESERVE_FILE_TIMESTAMPS_PROPERTY, this.getLoadOperation().isPreserveFileTimestamps());
    }

    protected void rememberEclipseLoadPreference() {
        this.getSettings().put(ECLIPSE_LOAD_PREFERENCE, this.loadOp.getEclipseSpecificLoadOptions());
    }

    public int getEclipseSpecificOptions() {
        return this.getLoadOperation().getEclipseSpecificLoadOptions();
    }

    public void setEclipseSpecificOptions(int options) {
        int oldOptions = this.getEclipseSpecificOptions();
        if (options != oldOptions) {
            this.getLoadOperation().setEclipseSpecificLoadOptions(options);
            this.firePropertyChange(ECLIPSE_SPECIFIC_OPTIONS_PROPERTY, oldOptions, options);
        }
    }

    protected void validate() {
        if (this.validationRunnable != null) {
            SWTUtil.runOnce((Display)Display.getDefault(), (Runnable)this.validationRunnable);
        }
    }

    protected IStatus doValidate() {
        return Status.OK_STATUS;
    }

    public IObservableValue getValidationStatus() {
        return this.validationStatus;
    }

    public void login(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = this.getRepository();
        if (!repo.loggedIn()) {
            repo.login(monitor);
        }
    }

    public ITeamRepository getRepository() {
        IConnection connection = this.getConnection();
        if (connection != null) {
            return connection.teamRepository();
        }
        return null;
    }

    public void promptInvalidLoadRequests(final Shell shell) {
        final List<IStatus> status = this.processInvalidLoadRequests();
        if (!status.isEmpty()) {
            SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)Messages.SelectFromRepoPart_6, null, (IStatus)StatusUtil.newStatus((Object)this, (String)Messages.SelectFromRepoPart_7, (Collection)status));
                }
            });
        }
    }

    protected List<IStatus> processInvalidLoadRequests() {
        ArrayList<ILoadRequest> requests = new ArrayList<ILoadRequest>();
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        Collection invalids = this.loadOp.getInvalidLoadRequests();
        for (IInvalidLoadRequest invalidLoadRequest : invalids) {
            this.accumulateStatus(invalidLoadRequest, status);
            requests.add(invalidLoadRequest.getInvalidRequest());
        }
        Collection invalidLoadLocations = this.loadOp.getInvalidLoadLocations();
        for (IInvalidLoadLocation invalidLoadLocation : invalidLoadLocations) {
            this.accumulateStatus(invalidLoadLocation, status);
            requests.add(invalidLoadLocation.getLoadRequest());
        }
        this.getLoadDilemmaHandler().setInvalidLoadRequests(requests);
        return status;
    }

    protected String findFolder(IComponentHandle component, IFolderHandle folderToLoad) {
        return null;
    }

    private void accumulateStatus(IInvalidLoadRequest invalidLoadRequest, List<IStatus> status) {
        ILoadRequest request = invalidLoadRequest.getInvalidRequest();
        String path = null;
        if (request.getVersionableToLoad() instanceof IFolderHandle) {
            path = this.findFolder(request.getComponent(), (IFolderHandle)request.getVersionableToLoad());
        }
        if (path == null) {
            status.add(invalidLoadRequest.getStatus());
        } else {
            String message = null;
            switch (invalidLoadRequest.getReason()) {
                case InvalidProjectName: {
                    message = NLS.bind((String)Messages.SelectFromRepoPart_8, (Object)path);
                    status.add(FileSystemStatusUtil.getStatusFor((int)2, (String)message));
                    break;
                }
                case NonExistantItem: {
                    message = NLS.bind((String)Messages.SelectFromRepoPart_9, (Object)path);
                    status.add(FileSystemStatusUtil.getStatusFor((int)2, (String)message));
                    break;
                }
                case InvalidSandbox: {
                    status.add(invalidLoadRequest.getStatus());
                    break;
                }
                default: {
                    message = NLS.bind((String)Messages.SelectFromRepoPart_10, (Object)path, (Object)invalidLoadRequest.getReason().toString());
                    status.add(FileSystemStatusUtil.getStatusFor((int)2, (String)message));
                }
            }
        }
    }

    public Collection<IStatus> accumulateStatus(IInvalidLoadLocation invalidLoadLocation, List<IStatus> statusList) {
        IShareable share2;
        ILoadRequest loadRequest = invalidLoadLocation.getLoadRequest();
        for (ISandbox sandbox : invalidLoadLocation.getSandboxesOverlapped()) {
            statusList.add(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.PreparedLoadHandler_SandboxOverlap, (Object)loadRequest.getSandbox().getRoot().toOSString(), (Object)sandbox.getRoot().toOSString())));
        }
        for (ILoadRequest request : invalidLoadLocation.getLoadRequestsOverlapped()) {
            statusList.add(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.PreparedLoadHandler_LoadLocationRequestOverlap, (Object)this.toString(loadRequest), (Object)this.toString(request))));
        }
        for (IShareable share2 : invalidLoadLocation.getSharesOverlapped()) {
            String sandboxRelativeLoadPath = loadRequest.getRelativeLoadPath().append(this.getVersionableName(loadRequest)).toString();
            statusList.add(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.PreparedLoadHandler_LoadLocationShareOverlap, (Object[])new Object[]{sandboxRelativeLoadPath, loadRequest.getSandbox().getRoot().toOSString(), share2.getPath().toString()})));
        }
        share2 = invalidLoadLocation.getPresentLoadLocation();
        if (share2 != null) {
            String sandboxRelativeLoadPath = loadRequest.getRelativeLoadPath().append(this.getVersionableName(loadRequest)).toString();
            statusList.add(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.PreparedLoadHandler_LoadLocationShareOverlap, (Object[])new Object[]{sandboxRelativeLoadPath, loadRequest.getSandbox().getRoot().toOSString(), share2.getLocalPath().toString()})));
        }
        return statusList;
    }

    public Collection<IStatus> accumulateStatus(ILoadOverlap loadOverlap, List<IStatus> statusList) {
        Collection overlappingShares = loadOverlap.getOverlappingShares();
        String componentName = this.getComponentName(loadOverlap.getComponent().getItemId());
        for (IShare share : overlappingShares) {
            statusList.add(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.PreparedLoadHandler_LoadLocationShareOverlap, (Object[])new Object[]{PathUtils.appendPath((String)componentName, (String)PathUtils.getString((String[])loadOverlap.getPath()).toString()), loadOverlap.getSandbox().getRoot().toOSString(), share.getPath().toString()})));
        }
        return statusList;
    }

    public abstract String getComponentName(UUID var1);

    private String toString(ILoadRequest loadRequest) {
        return loadRequest.getSandbox().getRoot().append(loadRequest.getRelativeLoadPath()).append(this.getVersionableName(loadRequest)).toOSString();
    }

    private String getVersionableName(ILoadRequest loadRequest) {
        if (loadRequest.getAlternativeName() != null && loadRequest.getAlternativeName().length() > 0) {
            return loadRequest.getAlternativeName();
        }
        return this.getName(loadRequest.getVersionableToLoad());
    }

    protected String getName(IVersionableHandle handle) {
        if (handle instanceof IVersionable) {
            IVersionable v = (IVersionable)handle;
            return v.getName();
        }
        return Messages.PreparedLoadHandler_UnknownVersionableName;
    }

    public void accumulateStatus(IMultipleSandboxLoad location, List<IStatus> info) {
        if (location.isRemoteLoadConflict()) {
            IWorkspaceConnection workspaceConnection = location.getRemoteLoadConflictWorkspace();
            info.add(StatusUtil.newStatus((Object)((Object)this), (int)2, (String)NLS.bind((String)Messages.LoadOperationInput_MultipleSandboxRemoteLoadEncountered, (Object[])new String[]{workspaceConnection.getName(), workspaceConnection.getLastLoadPath(), workspaceConnection.getLastLoadHost()}), null));
        } else {
            Collection sandboxes = location.getSandboxes();
            Collection loadLocations = location.getLoadLocations();
            for (ILoadLocation loadLocation : loadLocations) {
                String workspaceName = loadLocation.getConnection().getName();
                String componentName = loadLocation.getComponent().getName();
                String versionableName = this.getName(loadLocation.getRootToLoad());
                for (ISandbox sandbox : sandboxes) {
                    if (sandbox.equals(loadLocation.getSandbox())) continue;
                    info.add(StatusUtil.newStatus((Object)((Object)this), (int)2, (String)NLS.bind((String)Messages.LoadOperationInput_MultipleSandboxLoadEncountered, (Object[])new String[]{versionableName, workspaceName, componentName, sandbox.getRoot().toOSString()}), null));
                }
            }
        }
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        if (this.requiresValidationOnChange(event.getProperty())) {
            this.validate();
        }
    }

    public IRelativeLocation getRelativeLocationWithinSandbox() throws IllegalArgumentException {
        char[] chars = this.pathWithinSandbox.toCharArray();
        StringBuffer current = new StringBuffer();
        ArrayList<String> segments = new ArrayList<String>();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '/' || chars[i] == '\\') {
                if (current.length() > 0) {
                    segments.add(current.toString());
                    current = new StringBuffer();
                }
            } else {
                current.append(chars[i]);
            }
            ++i;
        }
        if (current.length() > 0) {
            segments.add(current.toString());
        }
        return new RelativeLocation(segments);
    }

    public void setPathWithinSandbox(String newLocation) {
        if (!newLocation.equals(this.pathWithinSandbox)) {
            String old = this.pathWithinSandbox;
            this.pathWithinSandbox = newLocation;
            this.firePropertyChange(PATH_WITHIN_SANDBOX_PROPERTY, old, newLocation);
        }
    }

    public String getPathWithinSandbox() {
        return this.pathWithinSandbox;
    }

    public ILocation getLocalLocation() {
        return this.getSandboxPath().append(this.getRelativeLocationWithinSandbox());
    }

    public boolean useParentFolder() {
        return false;
    }

    public boolean isPreserveFileTimestamps() {
        return this.getLoadOperation().isPreserveFileTimestamps();
    }

    public void setPreserveFileTimestamps(boolean preserveFileTimestamps) {
        if (this.isPreserveFileTimestamps() != preserveFileTimestamps) {
            this.getLoadOperation().setPreserveFileTimestamps(preserveFileTimestamps);
            this.firePropertyChange(PRESERVE_FILE_TIMESTAMPS_PROPERTY, !preserveFileTimestamps, preserveFileTimestamps);
        }
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        IConnection connection = this.getConnection();
        if (connection instanceof IWorkspaceConnection) {
            return (IWorkspaceConnection)connection;
        }
        return null;
    }

    public abstract IConnection getConnection();

    public static interface PostLoadCallback {
        public void loadSucceeded(IProgressMonitor var1) throws FileSystemException;

        public void loadFailed(IProgressMonitor var1) throws FileSystemException;
    }
}

