/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.DilemmaHandlerConfiguration;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PreparedLoadHandler;
import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LoadHandlerRemoveSharePart
implements IPropertyChangeListener {
    private Composite composite;
    private PreparedLoadHandler loadHandler;
    private LoadOperationInput loadOp;
    private CheckboxTableViewer viewer;
    private String errorMessage;
    private ChangeListenerList changeListenerList = new ChangeListenerList();
    public static final String SELECTION = "LoadHandlerRemovedSharePart SELECTION";
    private static final String ERROR_MESSAGE = "LoadHandlerRemovedSharePart ERROR_MESSAGE";

    public void add(IChangeListener l) {
        this.changeListenerList.add(l);
    }

    public LoadHandlerRemoveSharePart(Composite parent, LoadOperationInput loadOperation) {
        this.loadOp = loadOperation;
        this.loadHandler = this.loadOp.getLoadDilemmaHandler();
        this.composite = new Composite(parent, 0);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LoadHandlerRemoveSharePart.this.loadOp.removePropertyChangeListener(LoadHandlerRemoveSharePart.this);
            }
        });
        this.loadOp.addPropertyChangeListener(this);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)this.composite, (int)2080);
        final Table table = this.viewer.getTable();
        int NUM_COLUMNS = 2;
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new RemoveShareLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                LoadWizardInput loadOperation = (LoadWizardInput)((Object)inputElement);
                return loadOperation.getDilemmaHandlerConfiguration().getRemovedElements().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)this.loadOp);
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                DilemmaHandlerConfiguration.RemoveElement removeElement = (DilemmaHandlerConfiguration.RemoveElement)item.getData();
                if (event.detail == 32) {
                    removeElement.setRemoved(item.getChecked());
                    LoadHandlerRemoveSharePart.this.calculateIsFinished();
                    LoadHandlerRemoveSharePart.this.changeListenerList.notifyListeners((Object)this, (Object)LoadHandlerRemoveSharePart.SELECTION);
                }
            }
        });
        Composite buttons = new Composite(this.composite, 0);
        Button selectAllButton = new Button(buttons, 8);
        selectAllButton.setText(Messages.LoadHandlerRemoveSharePart_4);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    DilemmaHandlerConfiguration.RemoveElement removeElement = (DilemmaHandlerConfiguration.RemoveElement)item.getData();
                    item.setChecked(true);
                    removeElement.setRemoved(true);
                    ++n2;
                }
                LoadHandlerRemoveSharePart.this.calculateIsFinished();
                LoadHandlerRemoveSharePart.this.changeListenerList.notifyListeners((Object)this, (Object)LoadHandlerRemoveSharePart.SELECTION);
            }
        });
        Button deselectAllButton = new Button(buttons, 8);
        deselectAllButton.setText(Messages.LoadHandlerRemoveSharePart_5);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(false);
                    ++n2;
                }
                LoadHandlerRemoveSharePart.this.loadHandler.clearRemoveShare();
                LoadHandlerRemoveSharePart.this.calculateIsFinished();
                LoadHandlerRemoveSharePart.this.changeListenerList.notifyListeners((Object)this, (Object)LoadHandlerRemoveSharePart.SELECTION);
            }
        });
        Dialog.applyDialogFont((Control)this.composite);
        GridLayoutFactory.fillDefaults().generateLayout(buttons);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(this.composite);
    }

    public int[] getSelectionCount() {
        Table table = this.viewer.getTable();
        int[] nArray = new int[2];
        nArray[1] = table.getItemCount();
        int[] count = nArray;
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                count[0] = count[0] + 1;
            }
            ++n2;
        }
        return count;
    }

    public Control getControl() {
        return this.composite;
    }

    private void calculateIsFinished() {
        this.errorMessage = null;
        List<IStatus> stats = this.loadHandler.isPreparedForRemovedShares(this.loadOp.getLoadOperation());
        if (stats.size() > 0) {
            this.errorMessage = stats.get(0).getMessage();
        }
        this.changeListenerList.notifyListeners((Object)this.errorMessage, (Object)ERROR_MESSAGE);
    }

    private void refresh() {
        this.viewer.refresh();
        Table table = this.viewer.getTable();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            DilemmaHandlerConfiguration.RemoveElement removeElement = (DilemmaHandlerConfiguration.RemoveElement)item.getData();
            item.setChecked(removeElement.isRemoved());
            ++n2;
        }
        this.calculateIsFinished();
        this.changeListenerList.notifyListeners((Object)this, (Object)SELECTION);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.ibm.team.filesystem.ide.ui.DilemmaHandlerConfigurationProperty")) {
            this.refresh();
        }
    }

    private static class RemoveShareLabelProvider
    extends BaseLabelProvider {
        private RemoveShareLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof DilemmaHandlerConfiguration.RemoveElement) {
                DilemmaHandlerConfiguration.RemoveElement removedShare = (DilemmaHandlerConfiguration.RemoveElement)element;
                label.setText(removedShare.toString());
                ImageDescriptor desc = this.getImageDescriptor(removedShare.getRemovedShare());
                if (desc == null) {
                    desc = UiPlugin.getFileSystemImageDescriptor(null);
                }
                label.setImage(this.getResources().createImageWithDefault(desc));
            }
        }

        private ImageDescriptor getImageDescriptor(IRemovedShare removedShare) {
            IWorkbenchAdapter wbAdapter;
            IResource resource = (IResource)removedShare.getShare().getShareable().getAdapter(IResource.class);
            if (resource != null && (wbAdapter = (IWorkbenchAdapter)resource.getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbAdapter.getImageDescriptor((Object)resource);
            }
            return null;
        }
    }
}

