/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.DilemmaHandlerConfiguration;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PreparedLoadHandler;
import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LoadHandlerIncomingPart
implements IPropertyChangeListener {
    private LoadWizardInput loadOp;
    private PreparedLoadHandler loadHandler;
    private Composite composite;
    private CheckboxTableViewer viewer;
    private String errorMessage;
    private ChangeListenerList changeListenerList = new ChangeListenerList();
    public static final String SELECTION = "LoadHandlerIncomingPart SELECTION";
    public static final String ERROR_MESSAGE = "LoadHandlerIncomingPart ERROR_MESSAGE";
    private Button selectAllNewButton;
    private Button selectAllExistingButton;
    private Button selectAllOutOfSyncButton;
    private Button overwriteLocalChangesButton;

    public LoadHandlerIncomingPart(Composite parent, LoadWizardInput loadOperation) {
        this.loadOp = loadOperation;
        this.loadHandler = this.loadOp.getLoadDilemmaHandler();
        this.composite = new Composite(parent, 0);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LoadHandlerIncomingPart.this.loadOp.removePropertyChangeListener(LoadHandlerIncomingPart.this);
            }
        });
        this.loadOp.addPropertyChangeListener(this);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)this.composite, (int)67584);
        Table table = this.viewer.getTable();
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return LoadHandlerIncomingPart.this.loadOp.getDilemmaHandlerConfiguration().getLoadElementsMap().values().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        final ITableLabelProvider tableLabelProvider = new ITableLabelProvider(){
            private Image projectImage;
            private ResourceManager resources;

            protected final ResourceManager getResources() {
                if (this.resources == null) {
                    this.resources = new LocalResourceManager(JFaceResources.getResources());
                }
                return this.resources;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex != 0) {
                    return null;
                }
                DilemmaHandlerConfiguration.LoadElement loadElement = (DilemmaHandlerConfiguration.LoadElement)element;
                ICollision collision = loadElement.getCollision();
                ImageDescriptor desc = null;
                if (collision != null) {
                    desc = this.getImageDescriptor(collision);
                } else if (loadElement.getToLoad() != null) {
                    if (this.projectImage == null) {
                        this.projectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                    }
                    return this.projectImage;
                }
                if (desc == null) {
                    desc = UiPlugin.getFileSystemImageDescriptor(null);
                }
                return this.getResources().createImageWithDefault(desc);
            }

            private ImageDescriptor getImageDescriptor(ICollision collision) {
                IWorkbenchAdapter wbAdapter;
                IResource resource = (IResource)collision.getShareable().getAdapter(IResource.class);
                if (resource != null && (wbAdapter = (IWorkbenchAdapter)resource.getAdapter(IWorkbenchAdapter.class)) != null) {
                    return wbAdapter.getImageDescriptor((Object)resource);
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                DilemmaHandlerConfiguration.LoadElement loadElement = (DilemmaHandlerConfiguration.LoadElement)element;
                if (loadElement.getToLoad() != null) {
                    return loadElement.getToLoad().getShareableLocalPath();
                }
                return TextProcessor.process((String)loadElement.getCollision().getStatus().getMessage(), (String)"()[]");
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
                if (this.resources != null) {
                    this.resources.dispose();
                    this.resources = null;
                }
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                DilemmaHandlerConfiguration.LoadElement loadElement = (DilemmaHandlerConfiguration.LoadElement)item.getData();
                if (event.detail == 32) {
                    boolean checked = item.getChecked();
                    loadElement.setNewLoad(checked);
                    LoadHandlerIncomingPart.this.calculateIsFinished();
                    LoadHandlerIncomingPart.this.changeListenerList.notifyListeners((Object)this, (Object)LoadHandlerIncomingPart.SELECTION);
                }
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)tableLabelProvider);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return tableLabelProvider.getColumnText(e1, 1).compareTo(tableLabelProvider.getColumnText(e2, 1));
            }
        });
        this.viewer.setInput((Object)this.loadOp);
        int NUM_COLUMNS = 2;
        GridDataFactory.fillDefaults().grab(true, true).hint(150, 150).applyTo((Control)table);
        Composite buttons = this.createButtons(table);
        this.overwriteLocalChangesButton = new Button(this.composite, 32);
        this.overwriteLocalChangesButton.setText(Messages.LoadHandlerIncomingPart_0);
        this.overwriteLocalChangesButton.setToolTipText(Messages.LoadHandlerIncomingPart_1);
        this.overwriteLocalChangesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadHandlerIncomingPart.this.loadOp.setOverwriteLocalChanges(LoadHandlerIncomingPart.this.overwriteLocalChangesButton.getSelection());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.overwriteLocalChangesButton);
        Dialog.applyDialogFont((Control)this.composite);
        GridLayoutFactory.fillDefaults().generateLayout(buttons);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(this.composite);
    }

    private Composite createButtons(final Table table) {
        Composite buttons = new Composite(this.composite, 0);
        Button selectAllButton = new Button(buttons, 8);
        selectAllButton.setText(Messages.LoadHandlerIncomingPart_3);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    DilemmaHandlerConfiguration.LoadElement loadElement = (DilemmaHandlerConfiguration.LoadElement)item.getData();
                    item.setChecked(true);
                    loadElement.setNewLoad(true);
                    ++n2;
                }
                LoadHandlerIncomingPart.this.calculateIsFinished();
                LoadHandlerIncomingPart.this.changeListenerList.notifyListeners((Object)this, (Object)LoadHandlerIncomingPart.SELECTION);
            }
        });
        Button deselectAllButton = new Button(buttons, 8);
        deselectAllButton.setText(Messages.LoadHandlerIncomingPart_4);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(false);
                    ++n2;
                }
                LoadHandlerIncomingPart.this.loadHandler.clearNewLoad();
                LoadHandlerIncomingPart.this.calculateIsFinished();
                LoadHandlerIncomingPart.this.changeListenerList.notifyListeners((Object)this, (Object)LoadHandlerIncomingPart.SELECTION);
            }
        });
        new Label(buttons, 0);
        this.selectAllNewButton = new Button(buttons, 8);
        this.selectAllNewButton.setText(Messages.LoadHandlerIncomingPart_5);
        this.selectAllNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    DilemmaHandlerConfiguration.LoadElement loadElement = (DilemmaHandlerConfiguration.LoadElement)item.getData();
                    if (loadElement.couldBeNewLoad()) {
                        item.setChecked(true);
                        loadElement.setNewLoad(true);
                    }
                    ++n2;
                }
                LoadHandlerIncomingPart.this.calculateIsFinished();
                LoadHandlerIncomingPart.this.changeListenerList.notifyListeners((Object)this, (Object)LoadHandlerIncomingPart.SELECTION);
            }
        });
        this.selectAllExistingButton = new Button(buttons, 8);
        this.selectAllExistingButton.setText(Messages.LoadHandlerIncomingPart_6);
        this.selectAllExistingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    DilemmaHandlerConfiguration.LoadElement loadElement = (DilemmaHandlerConfiguration.LoadElement)item.getData();
                    if (!loadElement.couldBeNewLoad()) {
                        item.setChecked(true);
                        loadElement.setNewLoad(true);
                    }
                    ++n2;
                }
                LoadHandlerIncomingPart.this.calculateIsFinished();
                LoadHandlerIncomingPart.this.changeListenerList.notifyListeners((Object)this, (Object)LoadHandlerIncomingPart.SELECTION);
            }
        });
        this.selectAllOutOfSyncButton = new Button(buttons, 8);
        this.selectAllOutOfSyncButton.setText(Messages.LoadHandlerIncomingPart_7);
        this.selectAllOutOfSyncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    DilemmaHandlerConfiguration.LoadElement loadElement = (DilemmaHandlerConfiguration.LoadElement)item.getData();
                    if (loadElement.isOutOfSync()) {
                        item.setChecked(true);
                        loadElement.setNewLoad(true);
                    }
                    ++n2;
                }
                LoadHandlerIncomingPart.this.calculateIsFinished();
                LoadHandlerIncomingPart.this.changeListenerList.notifyListeners((Object)this, (Object)LoadHandlerIncomingPart.SELECTION);
            }
        });
        return buttons;
    }

    private void calculateIsFinished() {
        int[] selectionCount;
        this.errorMessage = null;
        List<IStatus> stats = this.loadHandler.isPreparedForCollisions(this.loadOp.getLoadOperation());
        if (stats.size() > 0) {
            this.errorMessage = stats.get(0).getMessage();
        }
        if (this.errorMessage == null && (stats = this.loadHandler.isPreparedForNewItemsToLoad(this.loadOp.getLoadOperation())).size() > 0) {
            this.errorMessage = stats.get(0).getMessage();
        }
        if (this.errorMessage == null && (selectionCount = this.getSelectionCount())[1] != 0 && selectionCount[0] == 0) {
            this.errorMessage = Messages.LoadHandlerIncomingPart_9;
        }
        this.changeListenerList.notifyListeners((Object)this.errorMessage, (Object)ERROR_MESSAGE);
    }

    public void add(IChangeListener l) {
        this.changeListenerList.add(l);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Control getControl() {
        return this.composite;
    }

    public int[] getSelectionCount() {
        Table table = this.viewer.getTable();
        int[] nArray = new int[2];
        nArray[1] = table.getItemCount();
        int[] count = nArray;
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                count[0] = count[0] + 1;
            }
            ++n2;
        }
        return count;
    }

    private void refresh() {
        Table table = this.viewer.getTable();
        this.viewer.refresh();
        boolean enableSelectNew = false;
        boolean enableSelectExisting = false;
        boolean enableSelectOutOfSync = false;
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            DilemmaHandlerConfiguration.LoadElement loadElement = (DilemmaHandlerConfiguration.LoadElement)item.getData();
            item.setChecked(loadElement.isNewLoad());
            if (loadElement.couldBeNewLoad()) {
                enableSelectNew = true;
            } else {
                enableSelectExisting = true;
            }
            if (loadElement.isOutOfSync()) {
                enableSelectOutOfSync = true;
            }
            ++n2;
        }
        this.selectAllNewButton.setEnabled(enableSelectNew);
        this.selectAllExistingButton.setEnabled(enableSelectExisting);
        this.selectAllOutOfSyncButton.setEnabled(enableSelectOutOfSync);
        this.overwriteLocalChangesButton.setSelection(this.loadOp.isOverwriteLocalChanges());
        this.calculateIsFinished();
        this.changeListenerList.notifyListeners((Object)this, (Object)SELECTION);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.ibm.team.filesystem.ide.ui.DilemmaHandlerConfigurationProperty")) {
            this.refresh();
        }
    }
}

