/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.ide.ui.internal.util.JFaceObservables;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.CopyFileAreaCombo;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadAsWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.ProjectOptionsRadioPart;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SelectItemsToLoadPage;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.BaseWizardPage;
import java.io.File;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class LoadAsWizardPage
extends BaseWizardPage {
    private final LoadAsWizardInput input;
    private CombinedStatus validationStatus = new CombinedStatus();
    private DataBindingContext dataBindingContext;
    private ISWTObservableValue localPathValue;
    private ExpandableComposite advancedOptions;
    private IChangeListener statusListener;

    protected LoadAsWizardPage(LoadAsWizardInput input, String title) {
        super("LoadAs", title, ImagePool.CHECKOUT_SELECTED_WIZBAN);
        this.input = input;
        if (input.isLoadingComponentRoot()) {
            this.setDescription(NLS.bind((String)Messages.LoadAsWizardPage_PageDescriptionForComponentLoad, (Object)input.getItem().getComponentName()));
        } else if (input.getItem().isFolder()) {
            this.setDescription(NLS.bind((String)Messages.LoadAsWizardPage_Description, (Object)input.getItem().getFQName()));
        } else if (input.getItem().isFile()) {
            this.setDescription(NLS.bind((String)Messages.LoadAsWizardPage_PageDescriptionForFileLoad, (Object)input.getItem().getFQName()));
        } else {
            this.setDescription(NLS.bind((String)Messages.LoadAsWizardPage_PageDescriptionForLinkLoad, (Object)input.getItem().getFQName()));
        }
    }

    protected void createBody(Composite composite) {
        WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
        this.dataBindingContext = new DataBindingContext();
        this.createCopyFileAreaPart(composite, context);
        this.createLocalPathPart(composite, context);
        this.createSeparator(composite, true);
        this.createAdvancedOptionsExpander(composite, context);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).numColumns(3).generateLayout(composite);
        DatabindingUtil.bindMessage((DialogPage)this, (IObservableValue)this.validationStatus);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_load_as");
    }

    private void createAdvancedOptionsExpander(final Composite parent, WidgetFactoryContext context) {
        WidgetToolkit toolkit = context.getToolkit();
        this.advancedOptions = toolkit.createExpandableComposite(parent, 18);
        this.advancedOptions.setText(Messages.LoadAsWizardPage_AdvancedOptions);
        GridDataFactory.defaultsFor((Control)this.advancedOptions).grab(true, false).align(4, 4).span(3, 1).applyTo((Control)this.advancedOptions);
        this.advancedOptions.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.layout();
                IWizardContainer container = LoadAsWizardPage.this.getContainer();
                if (container instanceof IWizardContainer2) {
                    ((IWizardContainer2)container).updateSize();
                }
            }
        });
        this.advancedOptions.setExpanded(false);
        Composite composite = new Composite((Composite)this.advancedOptions, 0);
        this.advancedOptions.setClient((Control)composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAdvancedOptionsArea(composite, context);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
    }

    private void createAdvancedOptionsArea(Composite composite, WidgetFactoryContext context) {
        this.createSeparator(composite, false);
        if (this.input.getItem().isFolder()) {
            ProjectOptionsRadioPart projectOptionsRadioPart = new ProjectOptionsRadioPart(composite, context, this.input, 3, false);
            projectOptionsRadioPart.connectToInput(this.dataBindingContext, this.input);
            this.createSeparator(composite, false);
        }
        SelectItemsToLoadPage.createPreserveFileTimestampCheckbox(composite, this.dataBindingContext, this.input);
    }

    private void createSeparator(Composite composite, boolean grabVertical) {
        Label label = new Label(composite, 0);
        GridDataFactory.defaultsFor((Control)label).grab(true, grabVertical).align(4, 4).span(3, 1).applyTo((Control)label);
    }

    private void createLocalPathPart(Composite composite, WidgetFactoryContext context) {
        WidgetToolkit toolkit = context.getToolkit();
        String labelText = Messages.LoadAsWizardPage_LocalPathLabel;
        Label label = toolkit.createLabel(composite, labelText);
        GridDataFactory.defaultsFor((Control)label).grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        Text pathWithinSandbox = new Text(composite, 2048);
        GridDataFactory.defaultsFor((Control)pathWithinSandbox).grab(true, false).align(4, 0x1000000).span(1, 1).applyTo((Control)pathWithinSandbox);
        final Button browseButton = toolkit.createButton(composite, Messages.LoadAsWizardPage_0, 8);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block10: {
                    String path;
                    block11: {
                        MessageDialog warning;
                        int choice;
                        path = null;
                        do {
                            String defaultPath = LoadAsWizardPage.this.input.getSandboxPath().toOSString();
                            if (LoadAsWizardPage.this.input.getItem().isFolder()) {
                                String preferred = LoadAsWizardPage.this.input.getLocalLocation().toOSString();
                                try {
                                    File f = new File(preferred);
                                    if (f.exists()) {
                                        defaultPath = preferred;
                                    }
                                }
                                catch (Exception f) {
                                    // empty catch block
                                }
                                DirectoryDialog dialog = new DirectoryDialog(browseButton.getShell());
                                dialog.setFilterPath(defaultPath);
                                path = dialog.open();
                            } else if (LoadAsWizardPage.this.input.getItem().isFile()) {
                                String name = LoadAsWizardPage.this.input.getRelativeLocationWithinSandbox().getName();
                                String preferredPath = LoadAsWizardPage.this.input.getLocalLocation().getParent().toOSString();
                                try {
                                    File file = (File)LoadAsWizardPage.this.input.getLocalLocation().getParent().getAdapter(File.class);
                                    while (!file.exists()) {
                                        String parentName = file.getName();
                                        name = String.valueOf(parentName) + File.separator + name;
                                        file = file.getParentFile();
                                    }
                                    preferredPath = file.getAbsolutePath();
                                }
                                catch (Exception file) {
                                    // empty catch block
                                }
                                FileDialog dialog = new FileDialog(browseButton.getShell(), 8192);
                                dialog.setFilterPath(preferredPath);
                                dialog.setFileName(name);
                                dialog.setOverwrite(true);
                                path = dialog.open();
                            }
                            if (path == null) break block10;
                            String sandboxPath = LoadAsWizardPage.this.input.getSandboxPath().toOSString();
                            if (!path.startsWith(sandboxPath)) continue;
                            if (!(path = path.substring(sandboxPath.length())).startsWith("/") && !path.startsWith("\\")) break block11;
                            path = path.substring(1);
                            break block11;
                        } while ((choice = (warning = new MessageDialog(browseButton.getShell(), Messages.LoadAsWizardPage_BAD_PATH_TITLE, null, Messages.LoadAsWizardPage_BAD_PATH_TEXT, 1, new String[]{IDialogConstants.CANCEL_LABEL, IDialogConstants.OK_LABEL}, 0)).open()) != 0 && choice != -1);
                        break block10;
                    }
                    LoadAsWizardPage.this.localPathValue.setValue((Object)path);
                }
            }
        });
        browseButton.setLayoutData((Object)new GridData(4, 2, false, false));
        this.bindLocalPathFieldToModel(pathWithinSandbox);
    }

    private void createCopyFileAreaPart(Composite parent, WidgetFactoryContext context) {
        String description = this.input.getItem().isFolder() ? Messages.LoadAsWizardPage_CopyFileAreaPickerDescription : (this.input.getItem().isFile() ? Messages.LoadAsWizardPage_CopyFileAreaPickerLoadFileDescription : Messages.LoadAsWizardPage_CopyFileAreaPickerLoadLinkDescription);
        CopyFileAreaCombo copyFileAreaCombo = new CopyFileAreaCombo(parent, context, description);
        this.bindCopyFileAreaCombo(copyFileAreaCombo);
    }

    private void bindLocalPathFieldToModel(Text loadPathField) {
        this.localPathValue = WidgetProperties.text((int)24).observe((Widget)loadPathField);
        IObservableValue localPathModelValue = JFaceObservables.observeProperty((Object)this.input, "pathWithinSandbox", "com.ibm.team.filesystem.ide.ui.LocalLocationProperty");
        this.dataBindingContext.bindValue((IObservableValue)this.localPathValue, localPathModelValue);
    }

    private void bindCopyFileAreaCombo(CopyFileAreaCombo copyFileAreaCombo) {
        IObservableValue connectionStatus = copyFileAreaCombo.connectLoadInput(this.input, this.dataBindingContext);
        this.validationStatus.addStatus(connectionStatus);
        this.validationStatus.addStatus(this.input.getValidationStatus());
        if (this.advancedOptions != null) {
            this.statusListener = new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    IStatus status = (IStatus)LoadAsWizardPage.this.input.getValidationStatus().getValue();
                    if (status.getSeverity() == 4) {
                        LoadAsWizardPage.this.advancedOptions.setExpanded(true);
                        LoadAsWizardPage.this.advancedOptions.getParent().layout();
                        IWizardContainer container = LoadAsWizardPage.this.getContainer();
                        if (container instanceof IWizardContainer2) {
                            ((IWizardContainer2)container).updateSize();
                        }
                    }
                }
            };
            this.input.getValidationStatus().addChangeListener(this.statusListener);
        }
    }

    public void dispose() {
        super.dispose();
        this.dataBindingContext.dispose();
        if (this.statusListener != null) {
            this.input.getValidationStatus().removeChangeListener(this.statusListener);
        }
    }
}

