/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.ide.ui.internal.actions.load.LoadAction;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadAsWizard;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LoadAsWizardInput
extends LoadOperationInput {
    public static final String LOCAL_LOCATION_PROPERTY = "com.ibm.team.filesystem.ide.ui.LocalLocationProperty";
    private final NamedSiloedItem namedSiloedItem;
    private IWorkspaceConnection connection;
    private final IComponent component;

    public LoadAsWizardInput(IWorkspaceConnection connection, IComponent component, NamedSiloedItem namedSiloedItem) {
        String fQName;
        this.connection = connection;
        this.component = component;
        this.namedSiloedItem = namedSiloedItem;
        ILocation sandboxPath = this.getSandboxPath();
        if (!"com.ibm.team.filesystem.hfs".equals(sandboxPath.getStorageId())) {
            sandboxPath = new PathLocation(this.getWorkspaceRootPath()).getCanonicalForm();
        }
        this.pathWithinSandbox = fQName = this.isLoadingComponentRoot() ? namedSiloedItem.getTargetProjectName() : namedSiloedItem.getFQName();
        if (!namedSiloedItem.isFolder()) {
            this.setEclipseSpecificOptions(0);
        }
        this.internalUpdateLoadRequest();
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    public NamedSiloedItem getItem() {
        return this.namedSiloedItem;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public void load(final Shell shell, final IOperationRunner operationRunner) {
        SWTUtil.greedyExec((Display)shell.getDisplay(), (Control)shell, (Runnable)new Runnable(){

            @Override
            public void run() {
                LoadAsWizardInput.this.initialize();
                LoadAsWizard loadWizard = new LoadAsWizard(LoadAsWizardInput.this);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)loadWizard);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    LoadAction.requestShowPendingView(LoadAsWizardInput.this.getWorkspaceConnection().getResolvedWorkspace());
                    LoadAsWizardInput.this.doLoad(operationRunner);
                }
            }
        });
    }

    public boolean isLoadingComponentRoot() {
        return this.namedSiloedItem.isComponentRoot();
    }

    @Override
    protected IStatus doValidate() {
        IStatus superStatus = super.doValidate();
        if (superStatus.getSeverity() == 4) {
            return superStatus;
        }
        IStatus localStatus = this.checkLocalPath();
        if (localStatus.getSeverity() == 4) {
            this.removeAllRequests();
        } else {
            this.internalUpdateLoadRequest();
        }
        this.getLoadDilemmaHandler().clearNewLoad();
        this.getLoadDilemmaHandler().clearRemoveShare();
        try {
            IRelativeLocation rel = this.getRelativeLocationWithinSandbox();
            this.getLoadDilemmaHandler().newLoad(rel.toString(), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (localStatus.isOK()) {
            return superStatus;
        }
        return localStatus;
    }

    private void internalUpdateLoadRequest() {
        this.removeAllRequests();
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(this.getSandboxPath(), false);
        IRelativeLocation rel = this.getRelativeLocationWithinSandbox();
        IRelativeLocation relativeLoadPath = rel.getParent();
        if (this.namedSiloedItem.getName().equals(rel.getName())) {
            this.getLoadOperation().requestLoad(sandbox, relativeLoadPath, this.getWorkspaceConnection(), (IComponentHandle)this.getComponent(), Collections.singletonList(this.getItem().toHandle()), true);
        } else {
            this.getLoadOperation().requestLoadAs(sandbox, relativeLoadPath, rel.getName(), this.getWorkspaceConnection(), (IComponentHandle)this.component, this.getItem().toHandle(), true);
        }
    }

    private IStatus checkLocalPath() {
        ILocation loc;
        IRelativeLocation rel;
        if (this.pathWithinSandbox.isEmpty()) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.LoadAsWizardInput_MISSING_LOCAL_PATH);
        }
        try {
            rel = this.getRelativeLocationWithinSandbox();
        }
        catch (IllegalArgumentException e1) {
            return StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.LoadAsWizardInput_INVALID_LOAD_PATH, (Object)this.pathWithinSandbox));
        }
        try {
            loc = this.getSandboxPath().append(rel);
        }
        catch (IllegalStateException e) {
            return StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.LoadAsWizardInput_UNSUPPORTED_PATH, (Object)this.pathWithinSandbox));
        }
        if (loc == null) {
            return StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.LoadAsWizardInput_UNSUPPORTED_PATH, (Object)this.pathWithinSandbox));
        }
        File sandboxRoot = new File(this.getSandboxPath().toOSString());
        String[] segments = this.getRelativeLocationWithinSandbox().removeLastSegments(1).segments();
        File walker = sandboxRoot;
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if ((walker = new File(walker, segment)).exists() && !walker.isDirectory()) {
                return StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.CopyFileAreaRelativePathField_FileAtPath, (Object)walker.getPath()));
            }
            ++n2;
        }
        if (rel.segmentCount() > 0) {
            BadLoadRootReason reason = this.analyzeLoadRootCollisions(loc);
            ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(this.getSandboxPath(), false);
            ResourceType resourceType = this.analyzeResourceType(loc);
            IShare share = null;
            if (resourceType != null) {
                IShareable shareable = sandbox.findShareable(rel, resourceType);
                try {
                    share = shareable.getShare(null);
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
            }
            switch (reason) {
                case OK: {
                    break;
                }
                case DIRECTORY_EXISTS_BUT_IS_EMPTY: {
                    if (share == null) break;
                    return StatusUtil.newStatus((Object)((Object)this), (int)4, (String)NLS.bind((String)Messages.LoadAsWizardInput_COLLISION_BETWEEN_SHARED_AND_NESTED, (Object)rel.toPath().toOSString()));
                }
                case CANNOT_LOAD_DIR_OVER_FILE: {
                    return StatusUtil.newStatus((Object)((Object)this), (int)4, (String)NLS.bind((String)Messages.LoadAsWizardInput_LOAD_DIRECTORY_OVER_FILE, (Object)rel.toPath().toOSString()));
                }
                case CANNOT_LOAD_FILE_OVER_DIR: {
                    return StatusUtil.newStatus((Object)((Object)this), (int)4, (String)NLS.bind((String)Messages.LoadAsWizardInput_LOAD_FILE_OVER_DIRECTORY, (Object)rel.toPath().toOSString()));
                }
                case DIRECTORY_HAS_CHILDREN: {
                    if (share != null) {
                        return StatusUtil.newStatus((Object)((Object)this), (int)4, (String)NLS.bind((String)Messages.LoadAsWizardInput_COLLISION_BETWEEN_SHARED_AND_NESTED, (Object)rel.toPath().toOSString()));
                    }
                    return StatusUtil.newStatus((Object)((Object)this), (int)2, (String)NLS.bind((String)Messages.LoadAsWizardInput_DIRECTORY_HAS_CONTENTS, (Object)rel.toPath().toOSString()));
                }
                case FILE_OVERWRITE: {
                    if (share != null) {
                        return StatusUtil.newStatus((Object)((Object)this), (int)4, (String)NLS.bind((String)Messages.LoadAsWizardInput_COLLISION_BETWEEN_SHARED_AND_NESTED, (Object)rel.toPath().toOSString()));
                    }
                    return StatusUtil.newStatus((Object)((Object)this), (int)2, (String)NLS.bind((String)Messages.LoadAsWizardInput_FileExistsWarningMessage, (Object)rel.toPath().toOSString()));
                }
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    protected String findFolder(IComponentHandle component, IFolderHandle folderToLoad) {
        if (this.namedSiloedItem.toHandle().sameItemId((IItemHandle)folderToLoad)) {
            return this.namedSiloedItem.getFQName();
        }
        return super.findFolder(component, folderToLoad);
    }

    @Override
    protected String getName(IVersionableHandle handle) {
        IFolderHandle fileOrFolderHandle;
        Object object = fileOrFolderHandle = this.namedSiloedItem.isFolder() ? this.namedSiloedItem.toFolderHandle() : this.namedSiloedItem.toHandle();
        if (handle.sameItemId((IItemHandle)fileOrFolderHandle)) {
            return this.namedSiloedItem.getName();
        }
        return super.getName(handle);
    }

    public boolean performPreLoadPrompt(final Shell shell) {
        Collection collisions;
        final List<IStatus> invalidLoadRequestStatus = this.processInvalidLoadRequests();
        if (!invalidLoadRequestStatus.isEmpty()) {
            SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)Messages.LoadAsWizardInput_ProblemsTitle, null, (IStatus)StatusUtil.newStatus((Object)this, (String)Messages.LoadAsWizardInput_ProblemsMessage, (Collection)invalidLoadRequestStatus));
                }
            });
            return false;
        }
        Collection loadOverlaps = this.getLoadOperation().getLoadOverlaps();
        if (!loadOverlaps.isEmpty()) {
            final ArrayList<IStatus> loadOverlapStatus = new ArrayList<IStatus>();
            for (ILoadOverlap loadOverlap : loadOverlaps) {
                this.accumulateStatus(loadOverlap, loadOverlapStatus);
            }
            if (!loadOverlapStatus.isEmpty()) {
                SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError((Shell)shell, (String)Messages.LoadAsWizardInput_OverlapErrorTitle, null, (IStatus)StatusUtil.newStatus((Object)this, (String)Messages.LoadAsWizardInput_OverlapErrorMessage, (Collection)loadOverlapStatus));
                    }
                });
                return false;
            }
        }
        if (!(collisions = this.getLoadOperation().getCollisions()).isEmpty()) {
            ICollision collision = (ICollision)collisions.iterator().next();
            BadLoadRootReason reason = this.analyzeLoadRootCollisions(collision.getShareable().getFullPath());
            IShare share = collision.getShare();
            switch (reason) {
                case OK: {
                    break;
                }
                case DIRECTORY_EXISTS_BUT_IS_EMPTY: {
                    if (share != null) {
                        MessageDialog.openError((Shell)shell, (String)Messages.LoadAsWizardInput_COLLISION_DIALOG_TITLE, (String)NLS.bind((String)Messages.LoadAsWizardInput_COLLISION_BETWEEN_SHARED_AND_NESTED, (Object)collision.getShareable().getFullPath().toOSString()));
                        return false;
                    }
                    this.getLoadDilemmaHandler().setLocation(collision.getShareable().getLocalPath(), (ILoadLocation)collision.getLocations().iterator().next());
                    break;
                }
                case CANNOT_LOAD_DIR_OVER_FILE: {
                    MessageDialog.openError((Shell)shell, (String)Messages.LoadAsWizardInput_COLLISION_DIALOG_TITLE, (String)NLS.bind((String)Messages.LoadAsWizardInput_FILE_IN_WAY, (Object)collision.getShareable().getFullPath().toOSString()));
                    return false;
                }
                case CANNOT_LOAD_FILE_OVER_DIR: {
                    MessageDialog.openError((Shell)shell, (String)Messages.LoadAsWizardInput_COLLISION_DIALOG_TITLE, (String)NLS.bind((String)Messages.LoadAsWizardInput_DIRECTORY_IN_WAY, (Object)collision.getShareable().getFullPath().toOSString()));
                    return false;
                }
                case DIRECTORY_HAS_CHILDREN: {
                    if (share != null) {
                        MessageDialog.openError((Shell)shell, (String)Messages.LoadAsWizardInput_COLLISION_DIALOG_TITLE, (String)NLS.bind((String)Messages.LoadAsWizardInput_COLLISION_BETWEEN_SHARED_AND_NESTED, (Object)collision.getShareable().getFullPath().toOSString()));
                        return false;
                    }
                    boolean response = MessageDialog.openQuestion((Shell)shell, (String)Messages.LoadAsWizardInput_CONFIRM_OVERWRITE_DIALOG_TITLE, (String)NLS.bind((String)Messages.LoadAsWizardInput_DIRECTORY_HAS_CONTENTS_CONFIRMATION, (Object)collision.getShareable().getLocalPath().toPath().toOSString(), (Object)collision.getShareable().getLocalPath().getName()));
                    if (response) {
                        this.getLoadDilemmaHandler().setLocation(collision.getShareable().getLocalPath(), (ILoadLocation)collision.getLocations().iterator().next());
                        break;
                    }
                    return false;
                }
                case FILE_OVERWRITE: {
                    if (share != null) {
                        MessageDialog.openError((Shell)shell, (String)Messages.LoadAsWizardInput_COLLISION_DIALOG_TITLE, (String)NLS.bind((String)Messages.LoadAsWizardInput_COLLISION_BETWEEN_SHARED_AND_NESTED, (Object)collision.getShareable().getFullPath().toOSString()));
                        return false;
                    }
                    boolean result = MessageDialog.openQuestion((Shell)shell, (String)Messages.LoadAsWizardInput_CONFIRM_OVERWRITE_DIALOG_TITLE, (String)NLS.bind((String)Messages.LoadAsWizardInput_FILE_OVERWRITE_WARNING, (Object)collision.getShareable().getLocalPath().toPath().toOSString()));
                    if (result) {
                        this.getLoadDilemmaHandler().setLocation(collision.getShareable().getLocalPath(), (ILoadLocation)collision.getLocations().iterator().next());
                        break;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private ResourceType analyzeResourceType(ILocation loc) {
        File target = new File(loc.toOSString());
        if (target.exists()) {
            if (target.isDirectory()) {
                return ResourceType.FOLDER;
            }
            return ResourceType.FILE;
        }
        return null;
    }

    private BadLoadRootReason analyzeLoadRootCollisions(ILocation loc) {
        File target = new File(loc.toOSString());
        if (target.exists()) {
            if (this.getItem().isFolder()) {
                if (target.isDirectory()) {
                    if (target.list().length == 0) {
                        return BadLoadRootReason.DIRECTORY_EXISTS_BUT_IS_EMPTY;
                    }
                    return BadLoadRootReason.DIRECTORY_HAS_CHILDREN;
                }
                return BadLoadRootReason.CANNOT_LOAD_DIR_OVER_FILE;
            }
            if (this.getItem().isFile()) {
                if (target.isFile()) {
                    return BadLoadRootReason.FILE_OVERWRITE;
                }
                return BadLoadRootReason.CANNOT_LOAD_FILE_OVER_DIR;
            }
        }
        return BadLoadRootReason.OK;
    }

    @Override
    public String getComponentName(UUID component) {
        return this.namedSiloedItem.getComponentName();
    }

    @Override
    protected boolean requiresValidationOnChange(String property) {
        return super.requiresValidationOnChange(property) || property.equals("com.ibm.team.filesystem.ide.ui.PathWithinSandboxProperty");
    }

    private static enum BadLoadRootReason {
        OK,
        DIRECTORY_HAS_CHILDREN,
        DIRECTORY_EXISTS_BUT_IS_EMPTY,
        CANNOT_LOAD_FILE_OVER_DIR,
        CANNOT_LOAD_DIR_OVER_FILE,
        FILE_OVERWRITE;

    }
}

