/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadAsWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadAsWizardPage;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class LoadAsWizard
extends Wizard {
    private final LoadAsWizardInput input;

    public LoadAsWizard(LoadAsWizardInput input) {
        this.input = input;
        this.setWindowTitle(this.getTitle());
    }

    private String getTitle() {
        if (this.input.getItem().isFolder()) {
            return Messages.LoadAsWizard_Title;
        }
        if (this.input.getItem().isFile()) {
            return Messages.LoadAsWizard_LoadFileTitle;
        }
        return Messages.LoadAsWizard_LoadLinkTitle;
    }

    public void addPages() {
        LoadAsWizardPage page = new LoadAsWizardPage(this.input, this.getTitle());
        this.addPage((IWizardPage)page);
    }

    public boolean performFinish() {
        boolean result = this.evaluateState();
        if (result) {
            this.input.finished();
        }
        return result;
    }

    private boolean evaluateState() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CheckoutSelectedWizard_17, (int)100);
                    try {
                        LoadAsWizard.this.input.evaluateLoadRequests((IProgressMonitor)sub.newChild(100));
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return this.input.performPreLoadPrompt(this.getShell());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            IStatus status = cause != null ? FileSystemStatusUtil.getStatusFor((Throwable)cause) : FileSystemStatusUtil.getStatusFor((Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.SelectFromRepoPart_0, null, (IStatus)status);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean needsProgressMonitor() {
        return true;
    }
}

