/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PreparedLoadHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class DilemmaHandlerConfiguration {
    private static Comparator<ILoadLocation> LOCATION_SORTER = new Comparator<ILoadLocation>(){

        private String toString(ILoadLocation location) {
            StringBuffer sb = new StringBuffer();
            sb.append(location.getComponent().getName());
            sb.append(" - ").append(location.getLoadPath());
            return sb.toString();
        }

        @Override
        public int compare(ILoadLocation o1, ILoadLocation o2) {
            return this.toString(o1).compareTo(this.toString(o2));
        }
    };
    private PreparedLoadHandler loadHandler;
    private Map<IRelativeLocation, LoadElement> loadElementsMap = new HashMap<IRelativeLocation, LoadElement>();
    private List<RemoveElement> removedElements = new ArrayList<RemoveElement>();
    private final ILoadOperation loadOperation;

    public DilemmaHandlerConfiguration(ILoadOperation loadOperation, PreparedLoadHandler loadHandler, boolean loadOutOfSync) {
        this.loadOperation = loadOperation;
        this.loadHandler = loadHandler;
        this.initialize(loadOutOfSync);
    }

    private PreparedLoadHandler getLoadDilemmaHandler() {
        return this.loadHandler;
    }

    private ILoadOperation getLoadOperation() {
        return this.loadOperation;
    }

    public Map<IRelativeLocation, LoadElement> getLoadElementsMap() {
        return this.loadElementsMap;
    }

    public List<RemoveElement> getRemovedElements() {
        return this.removedElements;
    }

    private void initialize(boolean loadOutOfSync) {
        LoadElement old;
        LoadElement loadElement;
        HashMap<IRelativeLocation, LoadElement> map = new HashMap<IRelativeLocation, LoadElement>();
        for (ICollision collision : this.getLoadOperation().getCollisions()) {
            loadElement = new LoadElement(collision);
            old = map.put(collision.getShareable().getLocalPath(), loadElement);
            if (old == null) continue;
            ILocation fullPath = collision.getShareable().getFullPath();
            throw new IllegalStateException(NLS.bind((String)Messages.DilemmaHandlerConfiguration_MultipleCollisions, (Object)fullPath));
        }
        for (IShareOutOfSync outOfSync : this.getLoadOperation().getSharesOutOfSync()) {
            IRelativeLocation path = outOfSync.getShare().getPath();
            LoadElement element = (LoadElement)map.get(path);
            element.setOutOfSync(outOfSync);
            element.setNewLoad(loadOutOfSync);
        }
        for (IShareableToLoad toLoad : this.getLoadOperation().getNewSharesToLoad()) {
            loadElement = new LoadElement(toLoad);
            old = map.put(toLoad.getShareable().getLocalPath(), loadElement);
            if (old == null) continue;
            ILocation fullPath = toLoad.getShareable().getFullPath();
            throw new IllegalStateException(NLS.bind((String)Messages.DilemmaHandlerConfiguration_MultipleNewShares, (Object)fullPath));
        }
        this.loadElementsMap = map;
        ArrayList<RemoveElement> removeElements = new ArrayList<RemoveElement>();
        for (IRemovedShare removeShare : this.getLoadOperation().getSharesToBeRemoved()) {
            removeElements.add(new RemoveElement(removeShare));
        }
        this.removedElements = removeElements;
    }

    public final class LoadElement {
        private IShareableToLoad toLoad;
        private ICollision collision;
        private IShareOutOfSync outOfSync;

        public LoadElement(IShareableToLoad toLoad) {
            this.toLoad = toLoad;
            this.isNewLoad(true);
        }

        public LoadElement(ICollision collision) {
            this.collision = collision;
            if (collision.getLocations().size() == 1) {
                DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().setLocation(this.getLocalPath(), (ILoadLocation)collision.getLocations().iterator().next());
            } else {
                DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().setLocation(this.getLocalPath(), null);
            }
            this.isNewLoad(!collision.collidedWithExistingContent());
        }

        public IShareableToLoad getToLoad() {
            return this.toLoad;
        }

        public ICollision getCollision() {
            return this.collision;
        }

        public boolean isOutOfSync() {
            return this.outOfSync != null;
        }

        public void setOutOfSync(IShareOutOfSync outOfSync) {
            this.outOfSync = outOfSync;
        }

        public boolean collidedWithExistingContent() {
            return this.collision != null && this.collision.collidedWithExistingContent();
        }

        public IRelativeLocation getLocalPath() {
            return this.collision.getShareable().getLocalPath();
        }

        public String getNewLoadPath() {
            if (this.collision != null) {
                return this.getLocalPath().toString();
            }
            return this.toLoad.getShareable().getLocalPath().toString();
        }

        public Collection<ILoadLocation> getLoadLocations() {
            if (this.toLoad != null) {
                return Collections.singletonList(this.toLoad.getLoadLocation());
            }
            ArrayList<ILoadLocation> list = new ArrayList<ILoadLocation>();
            list.addAll(this.collision.getLocations());
            Collections.sort(list, LOCATION_SORTER);
            return list;
        }

        public boolean couldBeNewLoad() {
            return this.toLoad != null || !this.collision.collidedWithExistingContent();
        }

        public boolean isNewLoad() {
            return this.isNewLoad(false);
        }

        private boolean isNewLoad(boolean defaultValue) {
            Boolean newLoad = DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().isNewLoad(this.getNewLoadPath());
            if (newLoad == null) {
                newLoad = defaultValue;
                DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().newLoad(this.getNewLoadPath(), newLoad);
            }
            return newLoad;
        }

        public ILoadLocation getLoadLocation() {
            if (this.toLoad != null) {
                return this.toLoad.getLoadLocation();
            }
            return DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().getLocation(this.getLocalPath());
        }

        public void setNewLoad(boolean newLoad) {
            DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().newLoad(this.getNewLoadPath(), newLoad);
            if (this.collision != null) {
                if (this.isOutOfSync()) {
                    DilemmaHandlerConfiguration.this.loadHandler.setOutOfSync(this.outOfSync.getShare().getPath(), newLoad ? this.outOfSync : null);
                } else {
                    DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().setLocation(this.getLocalPath(), newLoad ? this.getLoadLocations().iterator().next() : null);
                }
            }
        }
    }

    public class RemoveElement {
        private IRemovedShare removedShare;

        public RemoveElement(IRemovedShare removeShare) {
            this.removedShare = removeShare;
            String path = removeShare.getLocalPath().toString();
            Boolean remove = DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().isRemoved(path);
            if (remove == null) {
                DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().removeShare(path, false);
            }
        }

        public IRemovedShare getRemovedShare() {
            return this.removedShare;
        }

        public boolean isRemoved() {
            String path = this.removedShare.getLocalPath().toString();
            Boolean remove = DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().isRemoved(path);
            if (remove == null) {
                remove = false;
                DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().removeShare(path, remove);
            }
            return remove;
        }

        public void setRemoved(boolean remove) {
            String path = this.removedShare.getLocalPath().toString();
            DilemmaHandlerConfiguration.this.getLoadDilemmaHandler().removeShare(path, remove);
        }

        public String toString() {
            String name = this.removedShare.getLocalPath().toString();
            IShare share = this.removedShare.getShare();
            if (share != null) {
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                if (share != null) {
                    name = NLS.bind((String)Messages.LoadHandlerRemoveSharePart_0, (Object[])new String[]{name, descriptor.getConnectionName(), descriptor.getComponentName()});
                }
            }
            if (this.removedShare.getUncommittedChangeCount() > 0) {
                name = NLS.bind((String)Messages.LoadHandlerRemoveSharePart_1, (Object)name, (Object)this.removedShare.getUncommittedChangeCount());
            }
            return name;
        }
    }
}

