/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.ide.ui.internal.util.JFaceObservables;
import com.ibm.team.filesystem.ide.ui.internal.util.LocationToSandboxConverter;
import com.ibm.team.filesystem.ide.ui.internal.util.SandboxBaseLabelProvider;
import com.ibm.team.filesystem.ide.ui.internal.util.SandboxToLocationConverter;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class CopyFileAreaCombo {
    private IObservableValue copyFileAreaValue;
    private WritableList knownCopyFileAreasValue;

    public CopyFileAreaCombo(final Composite composite, WidgetFactoryContext context, String description) {
        WidgetToolkit toolkit = context.getToolkit();
        Label descriptionLabel = toolkit.createLabel(composite, description, 64);
        GridDataFactory.defaultsFor((Control)descriptionLabel).grab(true, false).align(4, 4).span(3, 1).applyTo((Control)descriptionLabel);
        Label label = toolkit.createLabel(composite, Messages.CheckoutSelectedWizard_20);
        GridDataFactory.defaultsFor((Control)label).grab(false, false).align(4, 2).applyTo((Control)label);
        Combo cfaText = new Combo(composite, 12);
        GridDataFactory.defaultsFor((Control)cfaText).grab(true, false).align(4, 2).applyTo((Control)cfaText);
        ComboViewer comboViewer = new ComboViewer(cfaText);
        comboViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new SandboxBaseLabelProvider((ILocation)new PathLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation())));
        this.knownCopyFileAreasValue = new WritableList(new ArrayList(), ISandbox.class);
        comboViewer.setInput((Object)this.knownCopyFileAreasValue);
        this.copyFileAreaValue = ViewerProperties.singleSelection().observe((Viewer)comboViewer);
        Button createButton = toolkit.createButton(composite, Messages.CheckoutSelectedWizard_21, 8);
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell shell = composite.getShell();
                final ILocation location = CopyFileAreaCombo.this.createSandboxLocation(shell);
                if (location != null) {
                    CopyFileAreaCombo.this.run(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            final ISandbox sb = SharingManager.getInstance().getSandbox(location, false);
                            final IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(sb.getRoot().getName());
                            if (!shell.isDisposed()) {
                                SWTUtil.greedyExec((Display)shell.getDisplay(), (Control)shell, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (resource == null || MessageDialog.openQuestion((Shell)shell, (String)Messages.LoadAsWizardInput_CONFIRM_USE_ECLIPSE_PROJECT_AS_SANDBOX_DIALOG_TITLE, (String)Messages.LoadAsWizardInput_CONFIRM_USE_ECLIPSE_PROJECT_AS_SANDBOX_DIALOG_MESSAGE)) {
                                            CopyFileAreaCombo.this.knownCopyFileAreasValue.add((Object)sb);
                                            CopyFileAreaCombo.this.copyFileAreaValue.setValue((Object)sb);
                                        }
                                    }
                                });
                            }
                        }
                    }, composite.getShell());
                }
            }
        });
        createButton.setLayoutData((Object)new GridData(4, 2, false, false));
    }

    public IObservableValue connectLoadInput(LoadOperationInput input, DataBindingContext context) {
        ArrayList<ISandbox> knownSandboxesOfType = new ArrayList<ISandbox>();
        for (ISandbox sandbox : input.getKnownSandboxes()) {
            if (this.filterSandbox(sandbox)) continue;
            knownSandboxesOfType.add(sandbox);
        }
        this.knownCopyFileAreasValue.addAll(knownSandboxesOfType);
        IObservableValue modelValue = JFaceObservables.observeProperty((Object)input, "sandboxPath", "com.ibm.team.filesystem.ide.ui.SandboxPathProperty");
        UpdateValueStrategy targetToModelUpdateStrategy = new UpdateValueStrategy();
        targetToModelUpdateStrategy.setConverter((IConverter)new SandboxToLocationConverter());
        UpdateValueStrategy modelToTargetUpdateStrategy = new UpdateValueStrategy();
        modelToTargetUpdateStrategy.setConverter((IConverter)new LocationToSandboxConverter());
        Binding binding = context.bindValue(this.copyFileAreaValue, modelValue, targetToModelUpdateStrategy, modelToTargetUpdateStrategy);
        IObservableValue validationStatus = binding.getValidationStatus();
        return validationStatus;
    }

    protected boolean filterSandbox(ISandbox sandbox) {
        return !"com.ibm.team.filesystem.hfs".equals(sandbox.getRoot().getStorageId());
    }

    protected ILocation createSandboxLocation(Shell shell) {
        DirectoryDialog dialog = new DirectoryDialog(shell);
        dialog.setFilterPath(new PathLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation()).toOSString());
        String pathString = dialog.open();
        if (pathString != null) {
            IPath path = Path.fromOSString((String)pathString);
            return new PathLocation(path);
        }
        return null;
    }

    private boolean run(IRunnableWithProgress runnable, Shell shell) {
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnable);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                CoreException ce = (CoreException)t;
                StatusUtil.log((Object)this, (Throwable)ce);
                ErrorDialog.openError((Shell)shell, null, null, (IStatus)ce.getStatus());
            } else {
                ErrorDialog.openError((Shell)shell, null, null, (IStatus)StatusUtil.newStatus((Object)this, (Throwable)t));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }
}

