/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.ide.ui.internal.wizards.load.IExtraLoadWizard;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class BlindLoadPage
extends WizardPage
implements IPropertyChangeListener {
    static final String EXTRA_LOAD_WIZARDS_EP = "extraLoadWizards";
    static final String EXTRA_LOAD_WIZARD_ID_ATTR = "id";
    private static final String EXTRA_LOAD_WIZARD_LABEL_ATTR = "label";
    static final String EXTRA_LOAD_WIZARD_DEFAULT = "default";
    private Button roots;
    private Button projects;
    private Button browse;
    private Button loadRule;
    private Button sync;
    private Button[] extra;
    private final LoadWizardInput loadOp;

    public BlindLoadPage(LoadWizardInput loadOp) {
        super(BlindLoadPage.class.getName());
        this.loadOp = loadOp;
        this.setTitle(Messages.CheckoutSelectedWizard_7);
        this.setDescription(Messages.CheckoutSelectedWizard_9);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createButtons(composite);
        Dialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_load");
        this.setControl((Control)composite);
        this.initControls();
        this.registerListeners();
    }

    private void createButtons(Composite composite) {
        this.projects = new Button(composite, 80);
        this.projects.setText(Messages.CheckoutSelectedWizard_12);
        this.projects.setData((Object)1);
        this.roots = new Button(composite, 80);
        this.roots.setText(Messages.CheckoutSelectedWizard_11);
        this.roots.setData((Object)2);
        this.browse = new Button(composite, 80);
        this.browse.setText(Messages.CheckoutSelectedWizard_10);
        this.browse.setData((Object)3);
        this.loadRule = new Button(composite, 80);
        this.loadRule.setText(Messages.CheckoutSelectedWizard_16);
        this.loadRule.setData((Object)6);
        Map<String, String> wizardInfos = this.getExtraWizardInformation();
        this.extra = new Button[wizardInfos.size()];
        int i = 0;
        for (Map.Entry<String, String> wizard : wizardInfos.entrySet()) {
            Button wizardButton = new Button(composite, 80);
            wizardButton.setText(wizard.getValue());
            wizardButton.setData((Object)wizard.getKey());
            this.extra[i] = wizardButton;
            ++i;
        }
        this.sync = new Button(composite, 80);
        this.sync.setText(Messages.BlindLoadPage_ReloadOutOfSync);
        this.sync.setData((Object)5);
    }

    private Map<String, String> getExtraWizardInformation() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.team.filesystem.ide.ui", EXTRA_LOAD_WIZARDS_EP);
        HashMap<String, String> infos = new HashMap<String, String>();
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                String id = ce.getAttribute(EXTRA_LOAD_WIZARD_ID_ATTR);
                String label = ce.getAttribute(EXTRA_LOAD_WIZARD_LABEL_ATTR);
                infos.put(id, label);
                ++n4;
            }
            ++n2;
        }
        return infos;
    }

    private IExtraLoadWizard initExtraLoadWizard(String id) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.team.filesystem.ide.ui", EXTRA_LOAD_WIZARDS_EP);
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                try {
                    IExtraLoadWizard wizard = (IExtraLoadWizard)ce.createExecutableExtension("class");
                    if (id.equals(ce.getAttribute(EXTRA_LOAD_WIZARD_ID_ATTR))) {
                        wizard.setLoadWizardInput(this.loadOp);
                        wizard.setContainer(this.getContainer());
                        wizard.addPages();
                        return wizard;
                    }
                }
                catch (CoreException e) {
                    StatusUtil.log((IStatus)e.getStatus());
                }
                catch (ClassCastException e) {
                    StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)e.getMessage(), (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private void registerListeners() {
        this.loadOp.addPropertyChangeListener(this);
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                Object data = source.getData();
                if (source.getSelection() && data instanceof Integer) {
                    BlindLoadPage.this.loadOp.setLoadType((Integer)data);
                } else if (source.getSelection() && data instanceof String) {
                    IExtraLoadWizard wizard = BlindLoadPage.this.initExtraLoadWizard((String)data);
                    BlindLoadPage.this.loadOp.setExtraWizard(wizard, (String)data);
                }
                BlindLoadPage.this.getContainer().updateButtons();
            }
        };
        this.roots.addSelectionListener(listener);
        this.projects.addSelectionListener(listener);
        this.browse.addSelectionListener(listener);
        this.loadRule.addSelectionListener(listener);
        this.sync.addSelectionListener(listener);
        Button[] buttonArray = this.extra;
        int n = this.extra.length;
        int n2 = 0;
        while (n2 < n) {
            Button wizardButton = buttonArray[n2];
            wizardButton.addSelectionListener(listener);
            ++n2;
        }
    }

    public void dispose() {
        this.loadOp.removePropertyChangeListener(this);
        super.dispose();
    }

    private void initControls() {
        this.projects.setSelection(this.loadOp.getLoadType() == 1);
        this.roots.setSelection(this.loadOp.getLoadType() == 2);
        this.browse.setSelection(this.loadOp.getLoadType() == 3);
        this.loadRule.setSelection(this.loadOp.getLoadType() == 6);
        this.sync.setSelection(this.loadOp.getLoadType() == 5);
        int i = 0;
        while (i < this.extra.length) {
            this.extra[i].setSelection(this.extra[i].getData().equals(this.loadOp.getCurrentExtraLoadWizardId()));
            if (this.extra[i].getSelection()) {
                IExtraLoadWizard wizard = this.initExtraLoadWizard(this.loadOp.getCurrentExtraLoadWizardId());
                this.loadOp.setExtraWizard(wizard, (String)this.extra[i].getData());
            }
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            switch (this.loadOp.getLoadType()) {
                case 1: {
                    this.projects.setFocus();
                    break;
                }
                case 2: {
                    this.roots.setFocus();
                    break;
                }
                case 3: {
                    this.browse.setFocus();
                    break;
                }
                case 6: {
                    this.loadRule.setFocus();
                    break;
                }
                case 5: {
                    this.sync.setFocus();
                    break;
                }
                case 7: {
                    int i = 0;
                    while (i < this.extra.length) {
                        if (this.extra[i].getData().equals(this.loadOp.getCurrentExtraLoadWizardId())) {
                            this.extra[i].setFocus();
                        }
                        ++i;
                    }
                    break;
                }
                default: {
                    this.projects.setFocus();
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.ibm.team.filesystem.ide.ui.LoadTypeProperty")) {
            this.getContainer().updateButtons();
        }
    }
}

