/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.List;

public class AncestorReportWrapper {
    private final IAncestorReport report;
    private final IComponent component;

    public AncestorReportWrapper(IAncestorReport report, IComponent component) {
        this.report = report;
        this.component = component;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public IAncestorReport getReport() {
        return this.report;
    }

    public UUID getItemId() {
        return NamedSiloedItem.getProjectFolder(this.report).getItem().getItemId();
    }

    public String getPath() {
        StringBuilder builder = new StringBuilder();
        List pairs = this.report.getNameItemPairs();
        int i = 1;
        while (i < pairs.size() - 1) {
            INameItemPair pair = (INameItemPair)pairs.get(i);
            String name = pair.getName();
            if (i > 1) {
                builder.append('/');
            }
            builder.append(name);
            ++i;
        }
        String path = builder.toString();
        return path;
    }

    public NamedSiloedItem toNamedSiloedItem() {
        return new NamedSiloedItem(this.component, this.report);
    }

    public boolean isComponentRoot() {
        return this.report.getNameItemPairs().size() <= 2;
    }
}

