/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.views;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForQueryItemEditor;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchCriteria;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Composite;

public class CustomAttributeSectionForStreamQueryEditor
extends CustomAttributeSectionForQueryItemEditor {
    private Map<UUID, ITeamArea> teamAreaCache = new HashMap<UUID, ITeamArea>();
    private PlaceSearchCriteria searchCriteria;

    public CustomAttributeSectionForStreamQueryEditor(IOperationRunner opRunner, Composite parent, WidgetToolkit toolkit, PlaceSearchCriteria searchCriteria) {
        super(1, opRunner, parent, toolkit);
        this.searchCriteria = searchCriteria;
    }

    public void setSearchCriteria(PlaceSearchCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    @Override
    protected void setCustomAttributeInSearchCriteria(String name, String newValue) {
        this.searchCriteria.setCustomAttribute(name, newValue);
    }

    @Override
    protected void removeCustomAttributeInSearchCriteria(Collection<CustomAttributeEntry> toRemove) {
        this.searchCriteria.removeCustomAttributes(toRemove);
    }

    @Override
    protected void addCustomAttributeInSearchCriteria(CustomAttributeEntry entry) {
        this.searchCriteria.addCustomAttribute(entry);
    }

    @Override
    protected Object[] getElements(Object inputElement) {
        return this.getCustomAttributes();
    }

    @Override
    public Object[] getCustomAttributes() {
        return this.searchCriteria.getCustomAttributesArray();
    }

    @Override
    protected ITeamRepository getRepository() {
        return this.searchCriteria.getRepository();
    }

    @Override
    protected IProjectAreaHandle getAssociatedProjectArea(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProjectAreaHandle projectAreaHandle = null;
        ITeamRepository repo = this.searchCriteria.getRepository();
        ItemId<? extends IAuditable> owner = this.searchCriteria.getOwnedBy();
        if (repo != null && owner != null && owner.toHandle() instanceof IProcessAreaHandle) {
            IProcessAreaHandle processArea = (IProcessAreaHandle)owner.toHandle();
            if (processArea instanceof IProjectAreaHandle) {
                projectAreaHandle = (IProjectAreaHandle)owner.toHandle();
            } else if (processArea instanceof ITeamAreaHandle) {
                ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)owner.toHandle();
                ITeamArea teamArea = this.teamAreaCache.get(teamAreaHandle.getItemId());
                if (teamArea == null) {
                    try {
                        teamArea = (ITeamArea)repo.itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, (IProgressMonitor)progress.newChild(50));
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                    projectAreaHandle = teamArea.getProjectArea();
                }
                if (teamArea != null) {
                    this.teamAreaCache.put(teamArea.getItemId(), teamArea);
                    projectAreaHandle = teamArea.getProjectArea();
                }
            }
        }
        return projectAreaHandle;
    }

    @Override
    protected String getHelpContextIdForAdd() {
        return "com.ibm.team.filesystem.ide.ui.dialog_addcustomattributestreamquery";
    }

    @Override
    protected String getHelpContextIdForEdit() {
        return "com.ibm.team.filesystem.ide.ui.dialog_editcustomattributestreamquery";
    }
}

