/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.views;

import com.ibm.team.filesystem.ide.ui.internal.views.AbstractCustomAttributeSection;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CustomAttributeSectionForStreamEditor
extends AbstractCustomAttributeSection<FormToolkit>
implements IChangeListener {
    private TeamPlaceWorkingCopy workingCopy;

    public CustomAttributeSectionForStreamEditor(IOperationRunner opRunner, Composite parent, FormToolkit toolkit, TeamPlaceWorkingCopy workingCopy) {
        super(1, opRunner, parent, toolkit);
        this.workingCopy = workingCopy;
        this.workingCopy.addListener(this);
        this.setInput((Object)this.workingCopy);
    }

    @Override
    protected Composite createContents(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 8448);
        section.setText(Messages.CustomAttributeSection_0);
        section.setDescription(Messages.CustomAttributeSection_1);
        Composite composite = this.createComposite(toolkit, (Composite)section, 0);
        section.setClient((Control)composite);
        super.createContents(composite, toolkit);
        return section;
    }

    @Override
    protected Button createPushButton(FormToolkit toolkit, Composite parent, String text, SelectionListener listener) {
        Button button = toolkit.createButton(parent, text, 8);
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }

    @Override
    protected Composite createComposite(FormToolkit toolkit, Composite parent, int style) {
        return toolkit.createComposite(parent, style);
    }

    @Override
    protected Table createTable(FormToolkit toolkit, Composite parent, int style) {
        return toolkit.createTable(parent, style);
    }

    @Override
    protected void setCustomAttribute(String name, String newValue) {
        this.workingCopy.setCustomAttribute(name, newValue);
    }

    @Override
    protected void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
        this.workingCopy.removeCustomAttributes(toRemove);
    }

    @Override
    protected void addCustomAttribute(CustomAttributeEntry entry) {
        this.workingCopy.addCustomAttribute(entry);
    }

    public void changed(Object source, Object property) {
        if (property == TeamPlaceWorkingCopy.PROPERTY.CUSTOM_ATTRIBUTES) {
            this.refreshViewer();
        }
    }

    @Override
    public void dispose() {
        this.workingCopy.removeListener(this);
    }

    @Override
    protected Object[] getElements(Object inputElement) {
        if (inputElement instanceof TeamPlaceWorkingCopy) {
            TeamPlaceWorkingCopy workingCopy = (TeamPlaceWorkingCopy)((Object)inputElement);
            return workingCopy.getCustomAttributeSet().toArray(new CustomAttributeEntry[workingCopy.getCustomAttributeSet().size()]);
        }
        return new CustomAttributeEntry[0];
    }

    @Override
    protected ITeamRepository getRepository() {
        return this.workingCopy.getRepository();
    }

    @Override
    protected IProjectAreaHandle getAssociatedProjectArea(IProgressMonitor monitor) {
        IProjectArea projectAreaHandle = null;
        if (this.workingCopy.getRepository() != null) {
            IAuditable owner = this.workingCopy.getOwner();
            if (owner instanceof IProjectArea) {
                projectAreaHandle = (IProjectArea)owner;
            } else if (owner instanceof ITeamArea) {
                ITeamArea teamArea = (ITeamArea)owner;
                projectAreaHandle = teamArea.getProjectArea();
            }
        }
        return projectAreaHandle;
    }

    @Override
    protected String getHelpContextIdForAdd() {
        return "com.ibm.team.filesystem.ide.ui.dialog_addcustomattributestream";
    }

    @Override
    protected String getHelpContextIdForEdit() {
        return "com.ibm.team.filesystem.ide.ui.dialog_editcustomattributestream";
    }
}

