/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.views;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForQueryItemEditor;
import com.ibm.team.internal.filesystem.ui.views.search.snapshot.SnapshotSearchCriteria;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Composite;

public class CustomAttributeSectionForSnapshotQueryEditor
extends CustomAttributeSectionForQueryItemEditor {
    private Map<UUID, IWorkspace> snapshotOwnerCache = new HashMap<UUID, IWorkspace>();
    private Map<UUID, ITeamArea> teamAreaCache = new HashMap<UUID, ITeamArea>();
    private SnapshotSearchCriteria searchCriteria;

    public CustomAttributeSectionForSnapshotQueryEditor(IOperationRunner opRunner, Composite parent, WidgetToolkit toolkit, SnapshotSearchCriteria searchCriteria) {
        super(4, opRunner, parent, toolkit);
        this.searchCriteria = searchCriteria;
    }

    public void setSearchCriteria(SnapshotSearchCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    @Override
    protected void setCustomAttributeInSearchCriteria(String name, String newValue) {
        this.searchCriteria.setCustomAttribute(name, newValue);
    }

    @Override
    protected void removeCustomAttributeInSearchCriteria(Collection<CustomAttributeEntry> toRemove) {
        this.searchCriteria.removeCustomAttributes(toRemove);
    }

    @Override
    protected void addCustomAttributeInSearchCriteria(CustomAttributeEntry entry) {
        this.searchCriteria.addCustomAttribute(entry);
    }

    @Override
    protected Object[] getElements(Object inputElement) {
        return this.getCustomAttributes();
    }

    @Override
    public Object[] getCustomAttributes() {
        return this.searchCriteria.getCustomAttributesArray();
    }

    @Override
    protected ITeamRepository getRepository() {
        return this.searchCriteria.getRepository();
    }

    @Override
    protected IProjectAreaHandle getAssociatedProjectArea(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProjectAreaHandle projectAreaHandle = null;
        ITeamRepository repo = this.searchCriteria.getRepository();
        IWorkspaceHandle snapshotOwnerHandle = this.searchCriteria.getSnapshotOwner();
        IWorkspace fetchedSnapshotOwner = this.snapshotOwnerCache.get(snapshotOwnerHandle);
        if (snapshotOwnerHandle != null && fetchedSnapshotOwner == null) {
            try {
                IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(Collections.singletonList(snapshotOwnerHandle), 0, (IProgressMonitor)progress.newChild(50));
                if (fetchResult.getRetrievedItems().size() == 1 && fetchResult.getRetrievedItems().get(0) instanceof IWorkspace) {
                    fetchedSnapshotOwner = (IWorkspace)fetchResult.getRetrievedItems().get(0);
                    this.snapshotOwnerCache.put(fetchedSnapshotOwner.getItemId(), fetchedSnapshotOwner);
                }
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
        if (fetchedSnapshotOwner != null) {
            if (fetchedSnapshotOwner.getOwner() instanceof IProjectAreaHandle) {
                projectAreaHandle = (IProjectAreaHandle)fetchedSnapshotOwner.getOwner();
            } else if (fetchedSnapshotOwner.getOwner() instanceof ITeamAreaHandle) {
                ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)fetchedSnapshotOwner.getOwner();
                ITeamArea teamArea = this.teamAreaCache.get(teamAreaHandle.getItemId());
                if (teamArea == null) {
                    try {
                        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(Collections.singletonList(teamAreaHandle), 0, (IProgressMonitor)progress.newChild(50));
                        if (fetchResult.getRetrievedItems().size() == 1 && fetchResult.getRetrievedItems().get(0) instanceof ITeamArea) {
                            teamArea = (ITeamArea)fetchResult.getRetrievedItems().get(0);
                            this.teamAreaCache.put(teamArea.getItemId(), teamArea);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                }
                if (teamArea != null) {
                    projectAreaHandle = teamArea.getProjectArea();
                }
            }
        }
        return projectAreaHandle;
    }

    @Override
    protected String getHelpContextIdForAdd() {
        return "com.ibm.team.filesystem.ide.ui.dialog_addcustomattributesnapshotquery";
    }

    @Override
    protected String getHelpContextIdForEdit() {
        return "com.ibm.team.filesystem.ide.ui.dialog_editcustomattributesnapshotquery";
    }
}

