/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.views;

import com.ibm.team.filesystem.ide.ui.internal.views.AbstractCustomAttributeSection;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CustomAttributeSectionForSnapshotEditor
extends AbstractCustomAttributeSection<FormToolkit>
implements IChangeListener {
    private Label snapshotOwnedByWorkspaceMessage;
    private Map<UUID, ITeamArea> teamAreaCache = new HashMap<UUID, ITeamArea>();
    private TeamPlaceWorkingCopy workingCopy;

    public CustomAttributeSectionForSnapshotEditor(IOperationRunner opRunner, Composite parent, FormToolkit toolkit, TeamPlaceWorkingCopy workingCopy) {
        super(4, opRunner, parent, toolkit);
        this.workingCopy = workingCopy;
        this.workingCopy.addListener(this);
        this.setInput((Object)this.workingCopy);
    }

    @Override
    protected Composite createContents(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 8448);
        section.setText(Messages.CustomAttributeSection_0);
        section.setDescription(Messages.CustomAttributeSection_1);
        Composite composite = this.createComposite(toolkit, (Composite)section, 0);
        section.setClient((Control)composite);
        this.snapshotOwnedByWorkspaceMessage = toolkit.createLabel(composite, Messages.CustomAttributeSectionForSnapshotEditor_SnapshotOwnedByWorkspaceMessage);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.snapshotOwnedByWorkspaceMessage);
        GridData gd = (GridData)this.snapshotOwnedByWorkspaceMessage.getLayoutData();
        this.snapshotOwnedByWorkspaceMessage.setVisible(false);
        gd.exclude = true;
        super.createContents(composite, toolkit);
        return section;
    }

    @Override
    protected Button createPushButton(FormToolkit toolkit, Composite parent, String text, SelectionListener listener) {
        Button button = toolkit.createButton(parent, text, 8);
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }

    @Override
    protected Composite createComposite(FormToolkit toolkit, Composite parent, int style) {
        return toolkit.createComposite(parent, style);
    }

    @Override
    protected Table createTable(FormToolkit toolkit, Composite parent, int style) {
        return toolkit.createTable(parent, style);
    }

    @Override
    protected void setCustomAttribute(String name, String newValue) {
        this.workingCopy.setCustomAttribute(name, newValue);
    }

    @Override
    protected void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
        this.workingCopy.removeCustomAttributes(toRemove);
    }

    @Override
    protected void addCustomAttribute(CustomAttributeEntry entry) {
        this.workingCopy.addCustomAttribute(entry);
    }

    public void changed(Object source, Object property) {
        if (property == TeamPlaceWorkingCopy.PROPERTY.CUSTOM_ATTRIBUTES) {
            this.refreshViewer();
        }
    }

    @Override
    public void dispose() {
        this.workingCopy.removeListener(this);
    }

    @Override
    protected Object[] getElements(Object inputElement) {
        if (inputElement instanceof TeamPlaceWorkingCopy) {
            TeamPlaceWorkingCopy workingCopy = (TeamPlaceWorkingCopy)((Object)inputElement);
            return workingCopy.getCustomAttributeSet().toArray(new CustomAttributeEntry[workingCopy.getCustomAttributeSet().size()]);
        }
        return new CustomAttributeEntry[0];
    }

    @Override
    protected ITeamRepository getRepository() {
        return this.workingCopy.getRepository();
    }

    @Override
    protected IProjectAreaHandle getAssociatedProjectArea(IProgressMonitor monitor) {
        IProjectAreaHandle projectAreaHandle = null;
        ITeamRepository repo = this.workingCopy.getRepository();
        IWorkspace snapshotOwner = this.workingCopy.getSnapshotOwner();
        if (repo != null && snapshotOwner != null) {
            IAuditableHandle workspaceOwner = snapshotOwner.getOwner();
            if (workspaceOwner instanceof IProjectAreaHandle) {
                projectAreaHandle = (IProjectAreaHandle)workspaceOwner;
            } else if (workspaceOwner instanceof ITeamAreaHandle) {
                ITeamArea teamArea = this.teamAreaCache.get(workspaceOwner.getItemId());
                if (teamArea == null) {
                    try {
                        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(workspaceOwner), 0, monitor);
                        if (fetchResult.getRetrievedItems().size() == 1 && fetchResult.getRetrievedItems().get(0) instanceof ITeamArea) {
                            teamArea = (ITeamArea)fetchResult.getRetrievedItems().get(0);
                            this.teamAreaCache.put(teamArea.getItemId(), teamArea);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                }
                if (teamArea != null) {
                    projectAreaHandle = teamArea.getProjectArea();
                }
            }
        }
        return projectAreaHandle;
    }

    @Override
    protected String getHelpContextIdForAdd() {
        return "com.ibm.team.filesystem.ide.ui.dialog_addcustomattributesnapshot";
    }

    @Override
    protected String getHelpContextIdForEdit() {
        return "com.ibm.team.filesystem.ide.ui.dialog_editcustomattributesnapshot";
    }

    public Label getSnapshotOwnedByWorkspaceMessage() {
        return this.snapshotOwnedByWorkspaceMessage;
    }
}

