/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.views;

import com.ibm.team.filesystem.ide.ui.internal.views.AbstractCustomAttributeSection;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;

public abstract class CustomAttributeSectionForQueryItemEditor
extends AbstractCustomAttributeSection<WidgetToolkit> {
    private ChangeListenerList listeners = null;

    public CustomAttributeSectionForQueryItemEditor(int artifactType, IOperationRunner opRunner, Composite parent, WidgetToolkit toolkit) {
        super(artifactType, opRunner, parent, toolkit);
    }

    @Override
    protected Composite createContents(Composite composite, WidgetToolkit toolkit) {
        Group group = new Group(composite, 0);
        group.setText(Messages.CustomAttributeSectionForQueryEditor_0);
        super.createContents((Composite)group, toolkit);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getGroupMargins()).applyTo((Composite)group);
        return group;
    }

    @Override
    protected Table createTable(WidgetToolkit toolkit, Composite parent, int style) {
        return toolkit.createTable(parent, style);
    }

    @Override
    protected Composite createComposite(WidgetToolkit toolkit, Composite parent, int style) {
        return toolkit.createComposite(parent, style);
    }

    @Override
    protected Button createPushButton(WidgetToolkit toolkit, Composite parent, String text, SelectionListener listener) {
        Button button = toolkit.createButton(parent, text, 8);
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }

    protected abstract void setCustomAttributeInSearchCriteria(String var1, String var2);

    protected abstract void removeCustomAttributeInSearchCriteria(Collection<CustomAttributeEntry> var1);

    protected abstract void addCustomAttributeInSearchCriteria(CustomAttributeEntry var1);

    @Override
    protected void setCustomAttribute(String name, String newValue) {
        this.setCustomAttributeInSearchCriteria(name, newValue);
        this.notifyListeners(name);
        this.refreshViewer();
    }

    @Override
    protected void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
        this.removeCustomAttributeInSearchCriteria(toRemove);
        this.notifyListeners(toRemove);
        this.refreshViewer();
    }

    @Override
    protected void addCustomAttribute(CustomAttributeEntry entry) {
        this.addCustomAttributeInSearchCriteria(entry);
        this.notifyListeners(entry);
        this.refreshViewer();
    }

    @Override
    protected Object[] getElements(Object inputElement) {
        return this.getCustomAttributes();
    }

    public abstract Object[] getCustomAttributes();

    public final synchronized void addListener(IChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ChangeListenerList();
        }
        this.listeners.add(listener);
    }

    public final synchronized void removeListener(IChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    protected final synchronized void notifyListeners(Object changeEvent) {
        if (this.listeners != null) {
            this.listeners.notifyListeners((Object)this, changeEvent);
        }
    }
}

