/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.views;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForQueryItemEditor;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetSearchCriteriaPart;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Composite;

public class CustomAttributeSectionForChangeSetQueryEditor
extends CustomAttributeSectionForQueryItemEditor {
    private Map<UUID, IAuditableHandle> componentOwners = new HashMap<UUID, IAuditableHandle>();
    private Map<UUID, ITeamArea> teamAreaCache = new HashMap<UUID, ITeamArea>();
    private Map<UUID, IWorkspace> wsTreamOwners = new HashMap<UUID, IWorkspace>();
    private ChangeSetSearchCriteriaPart.Input searchCriteria;

    public CustomAttributeSectionForChangeSetQueryEditor(IOperationRunner opRunner, Composite parent, WidgetToolkit toolkit, ChangeSetSearchCriteriaPart.Input searchCriteria) {
        super(5, opRunner, parent, toolkit);
        this.searchCriteria = searchCriteria;
    }

    public void setSearchCriteria(ChangeSetSearchCriteriaPart.Input searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public ChangeSetSearchCriteriaPart.Input getSearchCriteria() {
        return this.searchCriteria;
    }

    @Override
    protected void setCustomAttributeInSearchCriteria(String name, String newValue) {
        this.searchCriteria.setCustomAttribute(name, newValue);
    }

    @Override
    protected void removeCustomAttributeInSearchCriteria(Collection<CustomAttributeEntry> toRemove) {
        this.searchCriteria.removeCustomAttributes(toRemove);
    }

    @Override
    protected void addCustomAttributeInSearchCriteria(CustomAttributeEntry entry) {
        this.searchCriteria.addCustomAttribute(entry);
    }

    @Override
    protected Object[] getElements(Object inputElement) {
        return this.getCustomAttributes();
    }

    @Override
    public Object[] getCustomAttributes() {
        return this.searchCriteria.getCustomAttributesArray();
    }

    @Override
    protected ITeamRepository getRepository() {
        return this.searchCriteria.getRepository();
    }

    @Override
    protected IProjectAreaHandle getAssociatedProjectArea(IProgressMonitor monitor) {
        ITeamArea teamArea;
        ITeamAreaHandle teamAreaHandle;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProjectAreaHandle projectAreaHandle = null;
        ITeamRepository repo = this.searchCriteria.getRepository();
        IComponentHandle componentHandle = this.searchCriteria.getComponentHandle();
        IWorkspaceHandle workspaceHandle = this.searchCriteria.getWsStreamHandle();
        IBaselineHandle baselineHandle = this.searchCriteria.getBaselineHandle();
        if (repo != null && baselineHandle != null) {
            try {
                IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(Collections.singletonList(baselineHandle), 0, (IProgressMonitor)progress.newChild(50));
                if (fetchResult.getRetrievedItems().size() == 1 && fetchResult.getRetrievedItems().get(0) instanceof IBaseline) {
                    IBaseline baseline = (IBaseline)fetchResult.getRetrievedItems().get(0);
                    componentHandle = baseline.getComponent();
                }
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
        if (repo != null && workspaceHandle != null) {
            IWorkspace fetchedWsOwner = this.wsTreamOwners.get(workspaceHandle);
            if (workspaceHandle != null && fetchedWsOwner == null) {
                try {
                    IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(Collections.singletonList(workspaceHandle), 0, (IProgressMonitor)progress.newChild(50));
                    if (fetchResult.getRetrievedItems().size() == 1 && fetchResult.getRetrievedItems().get(0) instanceof IWorkspace) {
                        fetchedWsOwner = (IWorkspace)fetchResult.getRetrievedItems().get(0);
                        this.wsTreamOwners.put(fetchedWsOwner.getItemId(), fetchedWsOwner);
                    }
                }
                catch (TeamRepositoryException e) {
                    StatusUtil.log((Object)this, (Throwable)e);
                }
            }
            if (fetchedWsOwner != null) {
                if (fetchedWsOwner.getOwner() instanceof IProjectAreaHandle) {
                    projectAreaHandle = (IProjectAreaHandle)fetchedWsOwner.getOwner();
                } else if (fetchedWsOwner.getOwner() instanceof ITeamAreaHandle) {
                    teamAreaHandle = (ITeamAreaHandle)fetchedWsOwner.getOwner();
                    teamArea = this.teamAreaCache.get(teamAreaHandle.getItemId());
                    if (teamArea == null) {
                        try {
                            IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(Collections.singletonList(teamAreaHandle), 0, (IProgressMonitor)progress.newChild(50));
                            if (fetchResult.getRetrievedItems().size() == 1 && fetchResult.getRetrievedItems().get(0) instanceof ITeamArea) {
                                teamArea = (ITeamArea)fetchResult.getRetrievedItems().get(0);
                                this.teamAreaCache.put(teamArea.getItemId(), teamArea);
                            }
                        }
                        catch (TeamRepositoryException e) {
                            StatusUtil.log((Object)this, (Throwable)e);
                        }
                    }
                    if (teamArea != null) {
                        projectAreaHandle = teamArea.getProjectArea();
                    }
                }
            }
        }
        if (repo != null && componentHandle != null) {
            IAuditableHandle componentOwner = this.componentOwners.get(componentHandle.getItemId());
            if (componentOwner == null) {
                List owners;
                block30: {
                    try {
                        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                        owners = wm.findOwnersForComponents(Arrays.asList(componentHandle), (IProgressMonitor)progress.newChild(50));
                        if (owners.size() == 1 && owners.get(0) instanceof IAuditableHandle) break block30;
                        return null;
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                        return null;
                    }
                }
                componentOwner = (IAuditableHandle)owners.get(0);
                this.componentOwners.put(componentHandle.getItemId(), componentOwner);
            }
            if (componentOwner instanceof IProjectAreaHandle) {
                projectAreaHandle = (IProjectAreaHandle)componentOwner;
            } else if (componentOwner instanceof ITeamAreaHandle) {
                teamAreaHandle = (ITeamAreaHandle)componentOwner;
                teamArea = this.teamAreaCache.get(teamAreaHandle.getItemId());
                if (teamArea == null) {
                    try {
                        teamArea = (ITeamArea)repo.itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, (IProgressMonitor)progress.newChild(50));
                        this.teamAreaCache.put(teamArea.getItemId(), teamArea);
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                }
                if (teamArea != null) {
                    projectAreaHandle = teamArea.getProjectArea();
                }
            }
        }
        return projectAreaHandle;
    }

    @Override
    protected String getHelpContextIdForAdd() {
        return "com.ibm.team.filesystem.ide.ui.dialog_addcustomattributebaselinequery";
    }

    @Override
    protected String getHelpContextIdForEdit() {
        return "com.ibm.team.filesystem.ide.ui.dialog_editcustomattributebaselinequery";
    }
}

