/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.views;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForQueryItemEditor;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchCriteria;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Composite;

public class CustomAttributeSectionForBaselineQueryEditor
extends CustomAttributeSectionForQueryItemEditor {
    private Map<UUID, IAuditableHandle> componentOwners = new HashMap<UUID, IAuditableHandle>();
    private Map<UUID, ITeamArea> teamAreaCache = new HashMap<UUID, ITeamArea>();
    private BaselineSearchCriteria searchCriteria;

    public CustomAttributeSectionForBaselineQueryEditor(IOperationRunner opRunner, Composite parent, WidgetToolkit toolkit, BaselineSearchCriteria searchCriteria) {
        super(3, opRunner, parent, toolkit);
        this.searchCriteria = searchCriteria;
    }

    public void setSearchCriteria(BaselineSearchCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    @Override
    protected void setCustomAttributeInSearchCriteria(String name, String newValue) {
        this.searchCriteria.setCustomAttribute(name, newValue);
    }

    @Override
    protected void removeCustomAttributeInSearchCriteria(Collection<CustomAttributeEntry> toRemove) {
        this.searchCriteria.removeCustomAttributes(toRemove);
    }

    @Override
    protected void addCustomAttributeInSearchCriteria(CustomAttributeEntry entry) {
        this.searchCriteria.addCustomAttribute(entry);
    }

    @Override
    protected Object[] getElements(Object inputElement) {
        return this.getCustomAttributes();
    }

    @Override
    public Object[] getCustomAttributes() {
        return this.searchCriteria.getCustomAttributesArray();
    }

    @Override
    protected ITeamRepository getRepository() {
        return this.searchCriteria.getRepository();
    }

    @Override
    protected IProjectAreaHandle getAssociatedProjectArea(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProjectAreaHandle projectAreaHandle = null;
        ITeamRepository repo = this.searchCriteria.getRepository();
        IComponentHandle componentHandle = this.searchCriteria.getComponentHandle();
        if (repo != null && componentHandle != null) {
            IAuditableHandle componentOwner = this.componentOwners.get(componentHandle.getItemId());
            if (componentOwner == null) {
                List owners;
                block12: {
                    try {
                        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                        owners = wm.findOwnersForComponents(Arrays.asList(componentHandle), (IProgressMonitor)progress.newChild(50));
                        if (owners.size() == 1 && owners.get(0) instanceof IAuditableHandle) break block12;
                        return null;
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                        return null;
                    }
                }
                componentOwner = (IAuditableHandle)owners.get(0);
                this.componentOwners.put(componentHandle.getItemId(), componentOwner);
            }
            if (componentOwner instanceof IProjectAreaHandle) {
                projectAreaHandle = (IProjectAreaHandle)componentOwner;
            } else if (componentOwner instanceof ITeamAreaHandle) {
                ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)componentOwner;
                ITeamArea teamArea = this.teamAreaCache.get(teamAreaHandle.getItemId());
                if (teamArea == null) {
                    try {
                        teamArea = (ITeamArea)repo.itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, (IProgressMonitor)progress.newChild(50));
                        this.teamAreaCache.put(teamArea.getItemId(), teamArea);
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                }
                if (teamArea != null) {
                    projectAreaHandle = teamArea.getProjectArea();
                }
            }
        }
        return projectAreaHandle;
    }

    @Override
    protected String getHelpContextIdForAdd() {
        return "com.ibm.team.filesystem.ide.ui.dialog_addcustomattributebaselinequery";
    }

    @Override
    protected String getHelpContextIdForEdit() {
        return "com.ibm.team.filesystem.ide.ui.dialog_editcustomattributebaselinequery";
    }
}

