/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.views;

import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.views.AbstractCustomAttributeSection;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CustomAttributeSectionForBaselineEditor
extends AbstractCustomAttributeSection<FormToolkit>
implements IChangeListener {
    private Label baselineComponentOwnedByUserMessage;
    private Map<UUID, IAuditableHandle> componentOwners = new HashMap<UUID, IAuditableHandle>();
    private Map<UUID, ITeamArea> teamAreaCache = new HashMap<UUID, ITeamArea>();
    private BaselineEditorWorkingCopy fWorkingCopy;

    public CustomAttributeSectionForBaselineEditor(IOperationRunner opRunner, Composite parent, FormToolkit toolkit, BaselineEditorWorkingCopy workingCopy) {
        super(3, opRunner, parent, toolkit);
        this.fWorkingCopy = workingCopy;
        this.fWorkingCopy.addListener(this);
        this.setInput((Object)this.fWorkingCopy);
    }

    @Override
    protected Composite createContents(Composite parent, FormToolkit toolkit) {
        int sectionStyle = 8514;
        Section section = toolkit.createSection(parent, sectionStyle);
        section.setText(Messages.CustomAttributeSection_0);
        section.setDescription(Messages.CustomAttributeSection_1);
        Composite composite = this.createComposite(toolkit, (Composite)section, 0);
        section.setClient((Control)composite);
        this.baselineComponentOwnedByUserMessage = toolkit.createLabel(composite, Messages.CustomAttributeSectionForBaselineEditor_ComponentOwnedByUserMessage);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.baselineComponentOwnedByUserMessage);
        GridData gd = (GridData)this.baselineComponentOwnedByUserMessage.getLayoutData();
        this.baselineComponentOwnedByUserMessage.setVisible(false);
        gd.exclude = true;
        super.createContents(composite, toolkit);
        return section;
    }

    @Override
    protected Button createPushButton(FormToolkit toolkit, Composite parent, String text, SelectionListener listener) {
        Button button = toolkit.createButton(parent, text, 8);
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }

    @Override
    protected Composite createComposite(FormToolkit toolkit, Composite parent, int style) {
        return toolkit.createComposite(parent, style);
    }

    @Override
    protected Table createTable(FormToolkit toolkit, Composite parent, int style) {
        return toolkit.createTable(parent, style);
    }

    @Override
    protected void setCustomAttribute(String name, String newValue) {
        this.fWorkingCopy.setCustomAttribute(name, newValue);
    }

    @Override
    protected void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
        this.fWorkingCopy.removeCustomAttributes(toRemove);
    }

    @Override
    protected void addCustomAttribute(CustomAttributeEntry entry) {
        this.fWorkingCopy.addCustomAttribute(entry);
    }

    public void changed(Object source, Object property) {
        if (property == BaselineEditorWorkingCopy.PROPERTY.CUSTOM_ATTRIBUTES) {
            this.refreshViewer();
        }
    }

    @Override
    public void dispose() {
        this.fWorkingCopy.removeListener(this);
    }

    @Override
    protected Object[] getElements(Object inputElement) {
        if (inputElement instanceof BaselineEditorWorkingCopy) {
            BaselineEditorWorkingCopy workingCopy = (BaselineEditorWorkingCopy)((Object)inputElement);
            return workingCopy.getCustomAttributeSet().toArray(new CustomAttributeEntry[workingCopy.getCustomAttributeSet().size()]);
        }
        return new CustomAttributeEntry[0];
    }

    @Override
    protected ITeamRepository getRepository() {
        return this.fWorkingCopy.getRepository();
    }

    @Override
    public IProjectAreaHandle getAssociatedProjectArea(IProgressMonitor monitor) {
        return this.getAssociatedProjectArea(false, monitor);
    }

    public IProjectAreaHandle getAssociatedProjectArea(boolean refresh, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProjectAreaHandle projectAreaHandle = null;
        ITeamRepository repo = this.fWorkingCopy.getRepository();
        IComponent componentHandle = null;
        if (this.fWorkingCopy.getBaselineWrapper() != null) {
            componentHandle = this.fWorkingCopy.getBaselineWrapper().getComponent();
        }
        if (repo != null && componentHandle != null) {
            IAuditableHandle componentOwner = this.componentOwners.get(componentHandle.getItemId());
            if (componentOwner == null || refresh) {
                List owners;
                block13: {
                    try {
                        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                        owners = wm.findOwnersForComponents(Arrays.asList(componentHandle), (IProgressMonitor)progress.newChild(50));
                        if (owners.size() == 1 && owners.get(0) instanceof IAuditableHandle) break block13;
                        return null;
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                        return null;
                    }
                }
                componentOwner = (IAuditableHandle)owners.get(0);
                this.componentOwners.put(componentHandle.getItemId(), componentOwner);
            }
            if (componentOwner instanceof IProjectAreaHandle) {
                projectAreaHandle = (IProjectAreaHandle)componentOwner;
            } else if (componentOwner instanceof ITeamAreaHandle) {
                ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)componentOwner;
                ITeamArea teamArea = this.teamAreaCache.get(teamAreaHandle.getItemId());
                if (teamArea == null) {
                    try {
                        teamArea = (ITeamArea)repo.itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, (IProgressMonitor)progress.newChild(50));
                        this.teamAreaCache.put(teamArea.getItemId(), teamArea);
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                }
                if (teamArea != null) {
                    projectAreaHandle = teamArea.getProjectArea();
                }
            }
        }
        return projectAreaHandle;
    }

    @Override
    protected String getHelpContextIdForAdd() {
        return "com.ibm.team.filesystem.ide.ui.dialog_addcustomattributebaseline";
    }

    @Override
    protected String getHelpContextIdForEdit() {
        return "com.ibm.team.filesystem.ide.ui.dialog_editcustomattributebaseline";
    }

    public Label getBaselineComponentOwnedByUserMessage() {
        return this.baselineComponentOwnedByUserMessage;
    }
}

