/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.views;

import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.rcp.ui.internal.properties.SCMPropertyDialog;
import com.ibm.team.filesystem.rcp.ui.internal.properties.SCMPropertyEntry;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ListDialog;

public abstract class AbstractCustomAttributeSection<T> {
    private static final int MIN_TABLE_WIDTH = 100;
    private static final int MIN_TABLE_HEIGHT = -1;
    private final int NAME_COLUMN_WEIGHT = 52;
    private final int NAME_COLUMN_MIN_WIDTH = 125;
    private TableViewer viewer;
    private ViewerComparator viewerComparator;
    private CustomAttributeLabelProvider viewerLabelProvider;
    private CustomAttributeContentProvider viewerContentProvider;
    private Map<UUID, Collection<String>> customAttributesPerProjectAreaCache = new HashMap<UUID, Collection<String>>();
    private ISelectionChangedListener updateEnablementListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractCustomAttributeSection.this.updateEnablement();
        }
    };
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            Object firstElement;
            IStructuredSelection ssel;
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection && (ssel = (IStructuredSelection)sel).size() == 1 && (firstElement = ssel.getFirstElement()) instanceof CustomAttributeEntry) {
                AbstractCustomAttributeSection.this.doEdit((CustomAttributeEntry)firstElement);
            }
        }
    };
    private int artifactType;
    private IOperationRunner opRunner;
    private Composite control;
    private boolean disableAllWidgets = false;
    private Button addButton;
    private Button editButton;
    private Button removeButton;

    public AbstractCustomAttributeSection(int artifactType, IOperationRunner opRunner, Composite parent, T toolkit) {
        this.artifactType = artifactType;
        this.opRunner = opRunner;
        this.control = this.createContents(parent, toolkit);
    }

    public int getArtifactType() {
        return this.artifactType;
    }

    public IOperationRunner getOperationRunner() {
        return this.opRunner;
    }

    public Control getControl() {
        return this.control;
    }

    protected Composite createContents(Composite composite, T toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Composite tableComposite = this.createComposite(toolkit, composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 6).hint(1, 1).minSize(100, -1).applyTo((Control)tableComposite);
        Table table = this.createTable(toolkit, tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    AbstractCustomAttributeSection.this.doRemove();
                }
            }
        });
        TableColumnLayout columnLayout = new TableColumnLayout();
        TableColumn name = new TableColumn(table, 0);
        name.setText(Messages.CustomAttributeSection_2);
        columnLayout.setColumnData((Widget)name, (ColumnLayoutData)new ColumnWeightData(52, 125, true));
        TableColumn value = new TableColumn(table, 0);
        value.setText(Messages.CustomAttributeSection_3);
        columnLayout.setColumnData((Widget)value, (ColumnLayoutData)new ColumnWeightData(52, 125, true));
        tableComposite.setLayout((Layout)columnLayout);
        this.viewer = new TableViewer(table);
        this.viewerLabelProvider = new CustomAttributeLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.viewerLabelProvider);
        this.viewerComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                CustomAttributeEntry e1 = (CustomAttributeEntry)o1;
                CustomAttributeEntry e2 = (CustomAttributeEntry)o2;
                return e1.getName().compareToIgnoreCase(e2.getName());
            }
        };
        this.viewer.setComparator(this.viewerComparator);
        this.viewerContentProvider = new CustomAttributeContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.viewerContentProvider);
        this.viewer.addSelectionChangedListener(this.updateEnablementListener);
        this.viewer.addDoubleClickListener(this.doubleClickListener);
        this.addButton = this.createPushButton(toolkit, composite, Messages.CustomAttributeSection_4, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCustomAttributeSection.this.doAdd();
            }
        });
        this.editButton = this.createPushButton(toolkit, composite, Messages.CustomAttributeSection_6, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCustomAttributeSection.this.doEdit(AbstractCustomAttributeSection.this.getFirstSelection());
            }
        });
        this.removeButton = this.createPushButton(toolkit, composite, Messages.CustomAttributeSection_5, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCustomAttributeSection.this.doRemove();
            }
        });
        this.updateEnablement();
        return composite;
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
    }

    protected abstract Table createTable(T var1, Composite var2, int var3);

    protected abstract Composite createComposite(T var1, Composite var2, int var3);

    protected Collection<String> getAvailableCustomAttributes(IProgressMonitor monitor) {
        TreeSet<String> customAttributes = new TreeSet<String>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProjectAreaHandle projectArea = this.getAssociatedProjectArea((IProgressMonitor)progress.newChild(25));
        if (projectArea != null) {
            Collection<String> cachedCustomAttributes = this.customAttributesPerProjectAreaCache.get(projectArea.getItemId());
            if (cachedCustomAttributes != null) {
                return new ArrayList<String>(cachedCustomAttributes);
            }
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
            try {
                customAttributes.addAll(Arrays.asList(wm.getDefinedCustomAttributeIdentifiers(projectArea, this.getArtifactType(), (IProgressMonitor)progress.newChild(75))));
                this.customAttributesPerProjectAreaCache.put(projectArea.getItemId(), new ArrayList<String>(customAttributes));
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
        progress.done();
        return customAttributes;
    }

    public void setDisableAllWidgets(boolean disableAllWidgets) {
        this.disableAllWidgets = disableAllWidgets;
        this.updateEnablement();
    }

    protected void updateEnablement() {
        if (this.disableAllWidgets) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            List<CustomAttributeEntry> selection = this.getSelectedCustomAttributes();
            this.removeButton.setEnabled(!selection.isEmpty());
            this.editButton.setEnabled(selection.size() == 1);
        }
    }

    protected void doAdd() {
        this.getOperationRunner().enqueue(Messages.AbstractCustomAttributeSection_FetchCustomAttributesJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IProjectAreaHandle projectArea = AbstractCustomAttributeSection.this.getAssociatedProjectArea((IProgressMonitor)progress.newChild(30));
                if (projectArea != null) {
                    final Collection<String> availableCustomAttributes = AbstractCustomAttributeSection.this.getAvailableCustomAttributes((IProgressMonitor)progress.newChild(70));
                    DisplayHelper.asyncExec((Control)AbstractCustomAttributeSection.this.control, new Runnable(){

                        @Override
                        public void run() {
                            SCMPropertyDialog editDialog;
                            int result;
                            if (!availableCustomAttributes.isEmpty()) {
                                Object[] objectArray = AbstractCustomAttributeSection.this.getElements(AbstractCustomAttributeSection.this.viewer.getInput());
                                int n = objectArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object o = objectArray[n2];
                                    if (o instanceof CustomAttributeEntry) {
                                        CustomAttributeEntry entry = (CustomAttributeEntry)o;
                                        availableCustomAttributes.remove(entry.getName());
                                    }
                                    ++n2;
                                }
                            }
                            String customAttribute = null;
                            ListDialog pickerDialog = new ListDialog(AbstractCustomAttributeSection.this.control.getShell()){

                                protected Control createDialogArea(Composite container) {
                                    Control dialogArea = super.createDialogArea(container);
                                    this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                                        public void selectionChanged(SelectionChangedEvent event) {
                                            Button OkButton = this.getOkButton();
                                            if (OkButton != null) {
                                                OkButton.setEnabled(!availableCustomAttributes.isEmpty() && !this.getTableViewer().getSelection().isEmpty());
                                            }
                                        }
                                    });
                                    return dialogArea;
                                }

                                protected void createButtonsForButtonBar(Composite parent) {
                                    super.createButtonsForButtonBar(parent);
                                    Button OkButton = this.getOkButton();
                                    if (OkButton != null) {
                                        OkButton.setEnabled(!availableCustomAttributes.isEmpty() && !this.getTableViewer().getSelection().isEmpty());
                                    }
                                }
                            };
                            pickerDialog.setLabelProvider((ILabelProvider)new LabelProvider());
                            pickerDialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                            pickerDialog.setInput((Object)(availableCustomAttributes.isEmpty() ? Arrays.asList(Messages.AbstractCustomAttributeSection_NoCustomAttributesNode) : availableCustomAttributes));
                            pickerDialog.setTitle(Messages.AbstractCustomAttributeSection_PickCustomAttributeDialogTitle);
                            pickerDialog.setMessage(Messages.AbstractCustomAttributeSection_PickCustomAttributeDialogDescription);
                            pickerDialog.setHelpAvailable(false);
                            pickerDialog.open();
                            Object[] selection = pickerDialog.getResult();
                            if (selection != null && selection.length != 0) {
                                customAttribute = (String)selection[0];
                            }
                            if (!availableCustomAttributes.isEmpty() && customAttribute != null && (result = (editDialog = new SCMPropertyDialog(AbstractCustomAttributeSection.this.control.getShell(), customAttribute, "", Messages.CustomAttributeSection_7, Messages.AbstractCustomAttributeSection_AddCustomAttributeDialogDescription, false, AbstractCustomAttributeSection.this.getHelpContextIdForAdd())).open()) == 0 && editDialog.getPropertyEntry() != null && editDialog.getPropertyEntry().getName() != null) {
                                SCMPropertyEntry propertyEntry = editDialog.getPropertyEntry();
                                CustomAttributeEntry entry = new CustomAttributeEntry(propertyEntry.getName(), propertyEntry.getValue());
                                AbstractCustomAttributeSection.this.addCustomAttribute(entry);
                                AbstractCustomAttributeSection.this.updateEnablement();
                            }
                        }
                    });
                } else {
                    DisplayHelper.asyncExec((Control)AbstractCustomAttributeSection.this.control, new Runnable(){

                        @Override
                        public void run() {
                            SCMPropertyDialog editDialog = new SCMPropertyDialog(AbstractCustomAttributeSection.this.control.getShell(), "", "", Messages.CustomAttributeSection_8, Messages.AbstractCustomAttributeSection_EditCustomAttributeDialogDescription, true, AbstractCustomAttributeSection.this.getHelpContextIdForAdd());
                            int result = editDialog.open();
                            if (result == 0 && editDialog.getPropertyEntry() != null && editDialog.getPropertyEntry().getName() != null) {
                                SCMPropertyEntry propertyEntry = editDialog.getPropertyEntry();
                                CustomAttributeEntry entry = new CustomAttributeEntry(propertyEntry.getName(), propertyEntry.getValue());
                                AbstractCustomAttributeSection.this.addCustomAttribute(entry);
                                AbstractCustomAttributeSection.this.updateEnablement();
                            }
                        }
                    });
                }
            }
        });
    }

    protected abstract ITeamRepository getRepository();

    protected abstract IProjectAreaHandle getAssociatedProjectArea(IProgressMonitor var1);

    protected abstract void addCustomAttribute(CustomAttributeEntry var1);

    protected void doEdit(CustomAttributeEntry attribute) {
        if (attribute == null) {
            return;
        }
        String newValue = this.promptForNewValue(attribute);
        if (newValue != null && !newValue.equals(attribute.getValue())) {
            this.setCustomAttribute(attribute.getName(), newValue);
        }
    }

    private String promptForNewValue(CustomAttributeEntry attribute) {
        SCMPropertyDialog dialog = new SCMPropertyDialog(this.control.getShell(), attribute.getName(), attribute.getValue(), Messages.CustomAttributeSection_7, Messages.AbstractCustomAttributeSection_AddCustomAttributeDialogDescription, false, this.getHelpContextIdForEdit());
        int result = dialog.open();
        if (result == 0) {
            SCMPropertyEntry propertyEntry = dialog.getPropertyEntry();
            return propertyEntry.getValue();
        }
        return null;
    }

    protected abstract String getHelpContextIdForAdd();

    protected abstract String getHelpContextIdForEdit();

    protected abstract void setCustomAttribute(String var1, String var2);

    protected void doRemove() {
        List<CustomAttributeEntry> toRemove = this.getSelectedCustomAttributes();
        if (!toRemove.isEmpty()) {
            this.removeCustomAttributes(toRemove);
            this.updateEnablement();
        }
    }

    protected abstract void removeCustomAttributes(Collection<CustomAttributeEntry> var1);

    protected abstract Button createPushButton(T var1, Composite var2, String var3, SelectionListener var4);

    private CustomAttributeEntry getFirstSelection() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof CustomAttributeEntry)) continue;
                CustomAttributeEntry cae = (CustomAttributeEntry)element;
                return cae;
            }
        }
        return null;
    }

    private List<CustomAttributeEntry> getSelectedCustomAttributes() {
        ISelection selection = this.viewer.getSelection();
        ArrayList<CustomAttributeEntry> result = new ArrayList<CustomAttributeEntry>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof CustomAttributeEntry)) continue;
                CustomAttributeEntry cae = (CustomAttributeEntry)element;
                result.add(cae);
            }
        }
        return result;
    }

    protected void refreshViewer() {
        this.viewer.refresh();
    }

    protected abstract Object[] getElements(Object var1);

    public void dispose() {
    }

    private class CustomAttributeContentProvider
    implements IStructuredContentProvider {
        private CustomAttributeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return AbstractCustomAttributeSection.this.getElements(inputElement);
        }
    }

    private class CustomAttributeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CustomAttributeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((CustomAttributeEntry)element).getName();
                }
                case 1: {
                    String value = ((CustomAttributeEntry)element).getValue();
                    value = value.replaceAll("\r\n", " ");
                    return value.replaceAll("\n", " ");
                }
            }
            return null;
        }
    }
}

