/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableUtil {
    static final String BEST_WIDTH = "com.ibm.team.filesystem.ide.ui.internal.util.TableUtil.BEST_WIDTH";
    static final int TEXT_MARGIN = 3;

    public static void resetColumnSizeHint(Table table) {
        GC gc = new GC((Drawable)table);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            Point pt = gc.textExtent(column.getText());
            pt.x += 24;
            column.setData(BEST_WIDTH, (Object)pt.x);
            column.setWidth(pt.x);
            ++n2;
        }
        gc.dispose();
    }

    public static void multiLines(Table table) {
        TableUtil.resetColumnSizeHint(table);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                int oldBestWidth;
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                Point size = event.gc.textExtent(text);
                event.width = size.x + 6;
                event.height = Math.max(event.height, size.y + 3);
                final TableColumn column = item.getParent().getColumns()[event.index];
                Object data = column.getData(TableUtil.BEST_WIDTH);
                int n = oldBestWidth = data != null ? (Integer)data : 0;
                if (event.width > oldBestWidth) {
                    column.setData(TableUtil.BEST_WIDTH, (Object)event.width);
                    event.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object data = column.getData(TableUtil.BEST_WIDTH);
                            if (data != null) {
                                int width = (Integer)data;
                                if (column.getWidth() == width) {
                                    return;
                                }
                                column.setWidth(width);
                            }
                        }
                    });
                }
            }
        });
        table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                int yOffset = 0;
                Point size = event.gc.textExtent(text);
                yOffset = Math.max(0, (event.height - size.y) / 2);
                event.gc.drawText(text, event.x + 3, event.y + yOffset, true);
            }
        });
    }

    public static String group(Collection<String> elements, String separator, boolean sorted) {
        StringBuffer result = new StringBuffer();
        ArrayList<String> sortedList = new ArrayList<String>(elements);
        if (sorted) {
            Collections.sort(sortedList);
        }
        int i = 0;
        for (String elt : sortedList) {
            result.append(elt);
            if (++i >= sortedList.size()) continue;
            result.append(separator);
        }
        return result.toString();
    }
}

