/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.util;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class SandboxBaseLabelProvider
extends BaseLabelProvider {
    StandardLabelProvider locationProvider = new StandardLabelProvider((ILabelProvider)new BaseLabelProvider(){

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof ISandbox) {
                ISandbox sandbox = (ISandbox)element;
                label.setText(sandbox.getRoot().toString());
                label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
            }
        }
    }, (IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    private ILocation workspaceRoot;

    public SandboxBaseLabelProvider(ILocation wsRoot) {
        this.workspaceRoot = wsRoot;
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (element instanceof ISandbox) {
            ISandbox sandbox = (ISandbox)element;
            this.locationProvider.updateLabel(label, (Object)sandbox.getRoot());
            if (sandbox.getRoot().equals((Object)this.workspaceRoot)) {
                label.setText(NLS.bind((String)Messages.SandboxBaseLabelProvider_ECLIPSE_WORKSPACE_DECORATION, (Object)label.getText()));
            }
        }
    }
}

