/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.compare.ExternalCompareToolsUtil;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFileNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewSymbolicLinkNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ExternalCompareToolUtils {
    public static boolean shouldUseExternalCompareTool(Object obj) {
        VersionableChangeNode parent;
        if (obj instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)obj).getFirstElement();
        }
        String filename = null;
        if (obj instanceof IRemoteChangeSummary) {
            filename = ((IRemoteChangeSummary)obj).getResourceName();
        } else if (obj instanceof IAbstractConflictItem) {
            filename = ((IAbstractConflictItem)obj).getName(false);
        } else if (obj instanceof ILocalChange) {
            filename = ((ILocalChange)obj).getPath().getName();
        } else if (obj instanceof IShareable) {
            filename = ((IShareable)obj).getFullPath().getName();
        } else if (obj instanceof VersionableChangeNode) {
            filename = ((VersionableChangeNode)obj).getName();
        } else if (obj instanceof FileChange) {
            filename = ((FileChange)obj).getFinal().getPath().getName();
        } else if (obj instanceof StructuralChangesViewFileNode) {
            filename = ((StructuralChangesViewFileNode)obj).getChange().getFinal().getPath().getName();
        } else if (obj instanceof StructuralChangesViewSymbolicLinkNode) {
            filename = ((StructuralChangesViewSymbolicLinkNode)obj).getChange().getFinal().getPath().getName();
        } else if (obj instanceof CombinedChangeSetsItemEntry) {
            CombinedChangeSetsItemEntry item = (CombinedChangeSetsItemEntry)obj;
            filename = item.getName() != null ? item.getName() : item.getFallbackName();
        } else if (obj instanceof ContentChangeDetailNode && (parent = ((ContentChangeDetailNode)obj).getParentNode()) != null) {
            filename = parent.getName();
        }
        return ExternalCompareToolUtils.shouldUseExternalCompareTool(filename);
    }

    public static boolean shouldUseExternalCompareTool() {
        IPreferenceStore prefs = UiPlugin.getDefault().getPreferenceStore();
        String policy = prefs.getString("external_compare_tool_policy");
        if ("always".equalsIgnoreCase(policy)) {
            return true;
        }
        if ("never".equalsIgnoreCase(policy)) {
            return false;
        }
        return false;
    }

    public static boolean shouldUseExternalCompareTool(String filename) {
        if (filename == null) {
            return false;
        }
        IPreferenceStore prefs = UiPlugin.getDefault().getPreferenceStore();
        String policy = prefs.getString("external_compare_tool_policy");
        if ("always".equalsIgnoreCase(policy)) {
            return true;
        }
        if ("never".equalsIgnoreCase(policy)) {
            return false;
        }
        String fileExtString = prefs.getString("external_compare_file_patterns_list");
        if ("inclusive".equalsIgnoreCase(policy)) {
            return ExternalCompareToolsUtil.filenameMatches((String)fileExtString, (String)filename, (boolean)true);
        }
        if ("exclusive".equalsIgnoreCase(policy)) {
            return ExternalCompareToolsUtil.filenameMatches((String)fileExtString, (String)filename, (boolean)false);
        }
        return false;
    }
}

