/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.preferences;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SynchronizationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.ibm.team.filesystem.ui.preferences.SynchronizationPreferencePage";
    Map<String, Button> preferenceMap = null;
    private Button autoCommit = null;
    private IntegerFieldEditor commitAfterIdle = null;
    private Button checkInOn = null;
    private Button commitOnSave = null;
    private Button commitOnBlur = null;
    private Button commitOnInterval = null;
    private IntegerFieldEditor commitEvery = null;
    private FieldEditor confirmDelivery;
    private Button nonAtomicCommit = null;
    private IntegerFieldEditor uploadLimit = null;
    private Composite nacGroup;

    public void init(IWorkbench workbench) {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    public boolean performOk() {
        if (this.preferenceMap != null) {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            IPreferenceStore fileSystemStore = UiPlugin.getDefault().getCorePreferenceStore();
            for (Map.Entry<String, Button> entry : this.preferenceMap.entrySet()) {
                if (entry.getKey().equals("non_atomic_commit")) {
                    fileSystemStore.setValue(entry.getKey(), entry.getValue().getSelection());
                    continue;
                }
                store.setValue(entry.getKey(), entry.getValue().getSelection());
            }
            this.commitAfterIdle.store();
            this.commitEvery.store();
            this.uploadLimit.store();
            if (fileSystemStore != null && fileSystemStore.needsSaving() && fileSystemStore instanceof IPersistentPreferenceStore) {
                try {
                    ((IPersistentPreferenceStore)fileSystemStore).save();
                }
                catch (IOException e) {
                    FileSystemResourcesPlugin.log((Throwable)e);
                }
            }
            this.confirmDelivery.store();
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        IPreferenceStore fileSystemStore = UiPlugin.getDefault().getCorePreferenceStore();
        for (Map.Entry<String, Button> entry : this.preferenceMap.entrySet()) {
            if (entry.getKey().equals("non_atomic_commit")) {
                entry.getValue().setSelection(fileSystemStore.getDefaultBoolean(entry.getKey()));
                continue;
            }
            entry.getValue().setSelection(store.getDefaultBoolean(entry.getKey()));
        }
        this.checkInOn.setSelection(!this.commitOnSave.getSelection());
        this.commitAfterIdle.loadDefault();
        this.commitEvery.loadDefault();
        this.updateAutoCommitEnablement();
        this.uploadLimit.loadDefault();
        this.updateNonAtomicCommitEnablement();
        this.confirmDelivery.loadDefault();
        super.performDefaults();
    }

    private Button createCheck(Composite parent, IPreferenceStore store, String preference, String text, int type) {
        Button button = new Button(parent, type);
        button.setText(text);
        if (preference != null) {
            button.setSelection(store.getBoolean(preference));
            this.preferenceMap.put(preference, button);
        }
        return button;
    }

    private Button createCheck(Composite parent, IPreferenceStore store, String preference, String text) {
        return this.createCheck(parent, store, preference, text, 32);
    }

    protected Control createContents(Composite parent) {
        this.preferenceMap = new HashMap<String, Button>();
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        IPreferenceStore fileSystemStore = UiPlugin.getDefault().getCorePreferenceStore();
        Composite composite = new Composite(parent, 0);
        composite.setFont(JFaceResources.getDialogFont());
        this.autoCommit = this.createCheck(composite, store, "auto commit", Messages.SourceControlPreferencePage_6);
        Composite commitGroup = new Composite(composite, 0);
        commitGroup.setFont(JFaceResources.getDialogFont());
        this.createCommitGroup(commitGroup, store);
        Point originalMargins = LayoutConstants.getMargins();
        Rectangle margins = Geometry.createDiffRectangle((int)(originalMargins.x * 2), (int)0, (int)0, (int)0);
        GridLayoutFactory.fillDefaults().extendedMargins(margins).generateLayout(commitGroup);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        this.nonAtomicCommit = this.createCheck(composite, fileSystemStore, "non_atomic_commit", Messages.SynchronizationPreferencePage_0);
        Composite nonAtomicGroup = new Composite(composite, 0);
        this.createNonAtomicGroup(nonAtomicGroup, fileSystemStore);
        margins = Geometry.createDiffRectangle((int)(originalMargins.x * 2), (int)0, (int)0, (int)0);
        GridLayoutFactory.fillDefaults().extendedMargins(margins).generateLayout(nonAtomicGroup);
        Composite group = new Composite(composite, 0);
        group.setFont(JFaceResources.getDialogFont());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        this.confirmDelivery = new BooleanFieldEditor("pref_confirm_deliver", Messages.SynchronizationPreferencePage_ConfirmDeliverPref, group);
        if (this.confirmDelivery != null) {
            this.confirmDelivery.setPreferenceStore(this.getPreferenceStore());
            this.confirmDelivery.load();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.preference_page_checkin");
        this.applyDialogFont(composite);
        return composite;
    }

    private void createCommitGroup(Composite commitGroup, IPreferenceStore store) {
        this.commitOnSave = this.createCheck(commitGroup, store, "commit_on_save", Messages.SourceControlPreferencePage_19, 16);
        this.checkInOn = this.createCheck(commitGroup, store, null, Messages.SourceControlPreferencePage_20, 16);
        if (!this.commitOnSave.getSelection()) {
            this.checkInOn.setSelection(true);
        }
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SynchronizationPreferencePage.this.updateAutoCommitEnablement();
            }
        };
        this.autoCommit.addSelectionListener(listener);
        this.checkInOn.addSelectionListener(listener);
        Composite acGroup = new Composite(commitGroup, 0);
        acGroup.setFont(JFaceResources.getDialogFont());
        this.commitOnBlur = this.createCheck(acGroup, store, "commit_on_blur", Messages.SourceControlPreferencePage_21);
        this.commitOnInterval = this.createCheck(acGroup, store, "commit_interval_enabled", Messages.SourceControlPreferencePage_22);
        this.commitOnInterval.addSelectionListener(listener);
        this.commitEvery = new IntegerFieldEditor("max_commit_interval", Messages.SourceControlPreferencePage_23, acGroup);
        this.commitEvery.setTextLimit(3);
        this.commitEvery.setValidRange(1, 999);
        this.commitEvery.setValidateStrategy(0);
        this.commitEvery.setPreferenceStore(UiPlugin.getDefault().getPreferenceStore());
        this.commitEvery.setPage((DialogPage)this);
        this.commitEvery.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    SynchronizationPreferencePage.this.setValid(SynchronizationPreferencePage.this.commitEvery.isValid());
                }
            }
        });
        this.commitEvery.load();
        this.commitAfterIdle = new IntegerFieldEditor("keyboard_idle_commit", Messages.SourceControlPreferencePage_17, acGroup);
        this.commitAfterIdle.setTextLimit(3);
        this.commitAfterIdle.setValidRange(0, 999);
        this.commitAfterIdle.setValidateStrategy(0);
        this.commitAfterIdle.setPreferenceStore(UiPlugin.getDefault().getPreferenceStore());
        this.commitAfterIdle.setPage((DialogPage)this);
        this.commitAfterIdle.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    SynchronizationPreferencePage.this.setValid(SynchronizationPreferencePage.this.commitAfterIdle.isValid());
                }
            }
        });
        this.commitAfterIdle.load();
        Point originalMargins = LayoutConstants.getMargins();
        Rectangle margins = Geometry.createDiffRectangle((int)(originalMargins.x * 2), (int)0, (int)0, (int)0);
        GridLayoutFactory.fillDefaults().extendedMargins(margins).generateLayout(acGroup);
        assert (this.autoCommit != null);
        this.updateAutoCommitEnablement();
    }

    protected void updateAutoCommitEnablement() {
        boolean ac = this.autoCommit.getSelection();
        Button[] buttonArray = new Button[]{this.commitOnBlur, this.commitOnSave, this.checkInOn, this.commitOnInterval};
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.setEnabled(ac);
            ++n2;
        }
        this.commitAfterIdle.setEnabled(ac && this.commitOnInterval.getSelection(), this.commitOnInterval.getParent());
        this.commitEvery.setEnabled(ac && this.commitOnInterval.getSelection(), this.commitOnInterval.getParent());
        if (!ac) {
            return;
        }
        boolean onEvent = !this.commitOnSave.getSelection();
        Button[] buttonArray2 = new Button[]{this.commitOnBlur, this.commitOnInterval};
        int n3 = buttonArray2.length;
        n = 0;
        while (n < n3) {
            Button b = buttonArray2[n];
            b.setEnabled(onEvent);
            ++n;
        }
        this.commitEvery.setEnabled(onEvent && this.commitOnInterval.getSelection(), this.commitOnInterval.getParent());
        this.commitAfterIdle.setEnabled(onEvent && this.commitOnInterval.getSelection(), this.commitOnInterval.getParent());
    }

    private void createNonAtomicGroup(Composite nonAtomicGroup, IPreferenceStore fileSystemStore) {
        this.nacGroup = new Composite(nonAtomicGroup, 0);
        this.nacGroup.setFont(JFaceResources.getDialogFont());
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SynchronizationPreferencePage.this.updateNonAtomicCommitEnablement();
            }
        };
        this.nonAtomicCommit.addSelectionListener(listener);
        this.uploadLimit = new IntegerFieldEditor("non_atomic_commit_file_update_limit", Messages.SynchronizationPreferencePage_1, this.nacGroup);
        this.uploadLimit.setTextLimit(6);
        this.uploadLimit.setValidRange(1, 999999);
        this.uploadLimit.setValidateStrategy(0);
        this.uploadLimit.setPreferenceStore(fileSystemStore);
        this.uploadLimit.setPage((DialogPage)this);
        this.uploadLimit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    SynchronizationPreferencePage.this.setValid(SynchronizationPreferencePage.this.uploadLimit.isValid());
                }
            }
        });
        this.uploadLimit.load();
        Point originalMargins = LayoutConstants.getMargins();
        Rectangle margins = Geometry.createDiffRectangle((int)(originalMargins.x * 2), (int)0, (int)0, (int)0);
        GridLayoutFactory.fillDefaults().extendedMargins(margins).generateLayout(this.nacGroup);
        assert (this.nonAtomicCommit != null);
        this.updateNonAtomicCommitEnablement();
    }

    protected void updateNonAtomicCommitEnablement() {
        boolean nacEnabled = this.nonAtomicCommit.getSelection();
        this.uploadLimit.setEnabled(nacEnabled, this.nacGroup);
    }
}

