/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.preferences;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.operations.IMetadataValidateOperation;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.corruption.RebuildCFAJob;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.scm.client.SCMPlatform;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class SourceControlPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.ibm.team.internal.filesystem.synchronize.preferences.SourceControlPreferencePage";
    Map<String, Button> preferenceMap = null;
    private IntegerFieldEditor e;
    private BooleanFieldEditor metronomeEnabled;
    private BooleanFieldEditor useExternalBrowser;

    public SourceControlPreferencePage() {
        this.setTitle(Messages.SourceControlPreferencePage_1);
    }

    public void init(IWorkbench workbench) {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        store.setDefault("content_threads", SCMPlatform.getMaxContentThreads());
    }

    protected void performDefaults() {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        for (Map.Entry<String, Button> entry : this.preferenceMap.entrySet()) {
            entry.getValue().setSelection(store.getDefaultBoolean(entry.getKey()));
        }
        this.e.loadDefault();
        if (this.metronomeEnabled != null) {
            this.metronomeEnabled.loadDefault();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.preferenceMap != null) {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            for (Map.Entry<String, Button> entry : this.preferenceMap.entrySet()) {
                store.setValue(entry.getKey(), entry.getValue().getSelection());
            }
            this.e.store();
            int contentTransferThreads = store.getInt("content_threads");
            contentTransferThreads = Math.max(0, Math.min(50, contentTransferThreads));
            SCMPlatform.setMaxContentThreads((int)contentTransferThreads);
            if (this.metronomeEnabled != null) {
                this.metronomeEnabled.store();
            }
            this.useExternalBrowser.store();
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        this.preferenceMap = new HashMap<String, Button>();
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        Composite composite = new Composite(parent, 0);
        Group group = new Group(composite, 0);
        group.setFont(JFaceResources.getDialogFont());
        group.setText(Messages.SourceControlPreferencePage_8);
        this.e = new IntegerFieldEditor("content_threads", Messages.SourceControlPreferencePage_10, (Composite)group, 2);
        this.e.setValidRange(0, 50);
        this.e.setValidateStrategy(0);
        this.e.setPreferenceStore(UiPlugin.getDefault().getPreferenceStore());
        this.e.setPage((DialogPage)this);
        this.e.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    SourceControlPreferencePage.this.setValid(SourceControlPreferencePage.this.e.isValid());
                }
            }
        });
        this.e.load();
        this.e.setStringValue(Integer.toString(SCMPlatform.getMaxContentThreads()));
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)group);
        group = new Group(composite, 0);
        group.setText(Messages.SourceControlPreferencePage_11);
        Composite c2 = new Composite((Composite)group, 0);
        Button dump = new Button(c2, 8);
        dump.setText(Messages.SourceControlPreferencePage_METADATA_DUMP);
        dump.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.display.getActiveShell(), 8192);
                fileDialog.setText(Messages.SourceControlPreferencePage_METADATA_DUMP_SAVE_LOG);
                final String filepath = fileDialog.open();
                if (filepath == null) {
                    return;
                }
                SourceControlPreferencePage.this.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Collection sandboxes = SharingManager.getInstance().getRegisteredSandboxes();
                        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sandboxes.size());
                        for (ISandbox sandbox : sandboxes) {
                            if (submonitor.isCanceled()) break;
                            try {
                                ILocation root = sandbox.getRoot();
                                FileOutputStream fileOutputStream = new FileOutputStream(filepath, true);
                                PrintWriter writer = new PrintWriter(fileOutputStream);
                                IMetadataValidateOperation operation = IOperationFactory.instance.getMetadataValidateOperation(root);
                                operation.setWriter(writer);
                                operation.setDump(true);
                                operation.run((IProgressMonitor)submonitor.newChild(1));
                            }
                            catch (FileSystemStatusException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (FileNotFoundException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                });
            }
        });
        GridDataFactory.defaultsFor((Control)dump).align(1, 1).applyTo((Control)dump);
        Label text = new Label(c2, 64);
        text.setText(Messages.SourceControlPreferencePage_METADATA_DUMP_HELP);
        final Button rebuild = new Button(c2, 8);
        rebuild.setText(Messages.SourceControlPreferencePage_13);
        rebuild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceControlPreferencePage.this.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            RebuildCFAJob.repairSandboxes(FileSystemCore.getSharingManager().getRegisteredSandboxes(), rebuild, monitor);
                        }
                        catch (FileSystemException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
        });
        GridDataFactory.defaultsFor((Control)rebuild).align(1, 1).applyTo((Control)rebuild);
        text = new Label(c2, 64);
        text.setText(Messages.SourceControlPreferencePage_12);
        this.applyDialogFont(c2);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(c2);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)group);
        if (Platform.getBundle((String)"com.ibm.team.metronome") != null) {
            group = new Group(composite, 0);
            group.setFont(JFaceResources.getDialogFont());
            group.setText(Messages.SourceControlPreferencePage_15);
            this.metronomeEnabled = new BooleanFieldEditor("prefs_show_metronome_trim", Messages.SourceControlPreferencePage_16, (Composite)group);
            this.metronomeEnabled.setPreferenceStore(store);
            this.metronomeEnabled.load();
            this.metronomeEnabled.setPage((DialogPage)this);
            GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)group);
        }
        group = new Group(composite, 0);
        group.setFont(JFaceResources.getDialogFont());
        group.setText(Messages.SourceControlPreferencePage_4);
        this.useExternalBrowser = new BooleanFieldEditor("prefs_use_external_browser", Messages.SourceControlPreferencePage_2, (Composite)group);
        this.useExternalBrowser.setPreferenceStore(store);
        this.useExternalBrowser.load();
        this.useExternalBrowser.setPage((DialogPage)this);
        Link openEclipseWebBrowserPrefs = new Link((Composite)group, 0);
        openEclipseWebBrowserPrefs.setText(Messages.SourceControlPreferencePage_3);
        openEclipseWebBrowserPrefs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)SourceControlPreferencePage.this.getShell(), (String)"org.eclipse.ui.browser.preferencePage", null, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)group);
        this.applyDialogFont(composite);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.preference_page_source_control");
        return composite;
    }

    private void run(IRunnableWithProgress runnable) {
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                CoreException ce = (CoreException)t;
                StatusUtil.log((Object)((Object)this), (Throwable)ce);
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)ce.getStatus());
            } else {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)t));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

