/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.preferences;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ShedBackupPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.ibm.team.filesystem.ui.preferences.ShedBackupPreferencePage";
    private static final ISchedulingRule SANDBOX_LISTENING_RULE = ResourcesPlugin.getWorkspace().getRoot();
    Map<String, Button> preferenceMap = null;
    private Button backupEnabled = null;
    private IntegerFieldEditor maxFileSize = null;
    private IntegerFieldEditor shedLifespan = null;
    private Composite backupGroup;
    private Button sandboxListening = null;
    private BooleanFieldEditor refreshEclipseResources = null;

    public void init(IWorkbench workbench) {
        IPreferenceStore store = UiPlugin.getDefault().getCorePreferenceStore();
        this.setPreferenceStore(store);
    }

    public boolean performOk() {
        boolean sandboxListeningState;
        if (this.preferenceMap != null) {
            IPreferenceStore store = UiPlugin.getDefault().getCorePreferenceStore();
            for (Map.Entry<String, Button> entry : this.preferenceMap.entrySet()) {
                store.setValue(entry.getKey(), entry.getValue().getSelection());
            }
            this.maxFileSize.store();
            this.shedLifespan.store();
        }
        if (this.refreshEclipseResources != null) {
            this.refreshEclipseResources.store();
        }
        if (this.sandboxListening != null && this.sandboxListening.isEnabled() && (sandboxListeningState = this.sandboxListening.getSelection()) != FileSystemCore.getSharingManager().isSandboxListeningEnabled()) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        if (sandboxListeningState) {
                            FileSystemCore.getSharingManager().enableSandboxListening((IProgressMonitor)progress.newChild(100));
                        } else {
                            FileSystemCore.getSharingManager().disableSandboxListening((IProgressMonitor)progress.newChild(100));
                        }
                        progress.done();
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runAsync(runnable, SANDBOX_LISTENING_RULE);
            return true;
        }
        return super.performOk();
    }

    private boolean runAsync(final IRunnableWithProgress runnable, ISchedulingRule rule) {
        Job j = new Job(Messages.ShedBackupPreferencePage_10){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    runnable.run(monitor);
                    return Status.OK_STATUS;
                }
                catch (InvocationTargetException e) {
                    return StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (String)e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    return StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (String)e.getMessage(), (Throwable)e);
                }
            }
        };
        j.setRule(rule);
        j.setUser(true);
        j.schedule(500L);
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = UiPlugin.getDefault().getCorePreferenceStore();
        for (Map.Entry<String, Button> entry : this.preferenceMap.entrySet()) {
            entry.getValue().setSelection(store.getDefaultBoolean(entry.getKey()));
        }
        this.maxFileSize.loadDefault();
        this.shedLifespan.loadDefault();
        this.refreshEclipseResources.loadDefault();
        super.performDefaults();
    }

    private Button createCheck(Composite parent, IPreferenceStore store, String preference, String text, int type) {
        Button button = new Button(parent, type);
        button.setText(text);
        if (preference != null) {
            button.setSelection(store.getBoolean(preference));
            this.preferenceMap.put(preference, button);
        }
        return button;
    }

    private Button createCheck(Composite parent, IPreferenceStore store, String preference, String text) {
        return this.createCheck(parent, store, preference, text, 32);
    }

    protected Control createContents(Composite parent) {
        this.preferenceMap = new HashMap<String, Button>();
        GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins());
        IPreferenceStore store = UiPlugin.getDefault().getCorePreferenceStore();
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        Label text = new Label(composite, 64);
        text.setText(Messages.ShedBackupPreferencePage_PAGE_EXPLANATION);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        Group group = new Group(composite, 0);
        group.setText(Messages.ShedBackupPreferencePage_SHED_GROUP_NAME);
        this.createBackupGroup((Composite)group, store);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        layoutFactory.generateLayout((Composite)group);
        Group refresh = new Group(composite, 0);
        refresh.setFont(JFaceResources.getDialogFont());
        refresh.setText(Messages.ShedBackupPreferencePage_AUTOREFRESH_GROUP);
        this.createExternalChangeGroup(refresh, store);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)refresh);
        layoutFactory.generateLayout((Composite)refresh);
        this.applyDialogFont(composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.preference_page_shed_backup");
        return composite;
    }

    private void createExternalChangeGroup(Group group, IPreferenceStore store) {
        Label text = new Label((Composite)group, 64);
        text.setText(Messages.ShedBackupPreferencePage_AUTOREFRESH_CHECKBOX_DESCRIPTION);
        text.setData((Object)new GridData(4, 4, true, false, 2, 1));
        this.sandboxListening = new Button((Composite)group, 32);
        this.sandboxListening.setText(Messages.ShedBackupPreferencePage_3);
        this.sandboxListening.setToolTipText(Messages.ShedBackupPreferencePage_5);
        this.sandboxListening.setEnabled(false);
        final Display display = this.getShell().getDisplay();
        this.runAsync(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                final ISharingManager sharingManager = FileSystemCore.getSharingManager();
                final boolean listeningEnabled = sharingManager.isSandboxListeningEnabled();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ShedBackupPreferencePage.this.sandboxListening != null) {
                            ShedBackupPreferencePage.this.sandboxListening.setSelection(listeningEnabled);
                            ISandbox sbox = sharingManager.getSandbox((ILocation)new PathLocation(ResourcesPlugin.getWorkspace().getRoot().getFullPath().toOSString()), false);
                            if (sharingManager.canSupportSandboxListener(sbox)) {
                                ShedBackupPreferencePage.this.sandboxListening.setEnabled(true);
                            }
                        }
                    }
                });
            }
        }, SANDBOX_LISTENING_RULE);
        this.sandboxListening.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ShedBackupPreferencePage.this.sandboxListening.getSelection()) {
                    MessageDialog.openInformation((Shell)ShedBackupPreferencePage.this.getShell(), (String)Messages.ShedBackupPreferencePage_8, (String)Messages.ShedBackupPreferencePage_9);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createCheck((Composite)group, store, "autorefresh_enabled", Messages.ShedBackupPreferencePage_AUTOREFRESH_CHECKBOX);
        Label notes1 = new Label((Composite)group, 64);
        notes1.setText(Messages.ShedBackupPreferencePage_6);
        notes1.setData((Object)new GridData(4, 4, true, false, 2, 1));
        this.refreshEclipseResources = new BooleanFieldEditor("prefs_skip_eclipse_resources_whenrefreshing", Messages.ShedBackupPreferencePage_4, (Composite)group);
        this.refreshEclipseResources.setPreferenceStore(UiPlugin.getDefault().getPreferenceStore());
        this.refreshEclipseResources.load();
        this.refreshEclipseResources.setPage((DialogPage)this);
        Label notes2 = new Label((Composite)group, 64);
        notes2.setText(Messages.ShedBackupPreferencePage_7);
        notes2.setData((Object)new GridData(4, 4, true, false, 2, 1));
    }

    private void createBackupGroup(Composite shedBackupGroup, IPreferenceStore store) {
        Label text = new Label(shedBackupGroup, 64);
        text.setText(Messages.ShedBackupPreferencePage_SHED_GROUP_DESCRIPTION);
        text.setData((Object)new GridData(4, 4, true, false, 2, 1));
        this.backupEnabled = this.createCheck(shedBackupGroup, store, "backup_in_shed_enabled", Messages.ShedBackupPreferencePage_0);
        this.backupEnabled.setData((Object)new GridData(4, 4, true, false, 2, 1));
        this.backupGroup = new Composite(shedBackupGroup, 0);
        this.backupGroup.setFont(JFaceResources.getDialogFont());
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ShedBackupPreferencePage.this.updateBackupEnablement();
            }
        };
        this.backupEnabled.addSelectionListener(listener);
        this.maxFileSize = new IntegerFieldEditor("backup_in_shed_max_file_size", Messages.ShedBackupPreferencePage_1, this.backupGroup);
        this.maxFileSize.setTextLimit(3);
        this.maxFileSize.setValidRange(1, 999);
        this.maxFileSize.setValidateStrategy(0);
        this.maxFileSize.setPreferenceStore(store);
        this.maxFileSize.setPage((DialogPage)this);
        this.maxFileSize.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    ShedBackupPreferencePage.this.setValid(ShedBackupPreferencePage.this.maxFileSize.isValid());
                }
            }
        });
        this.maxFileSize.load();
        this.shedLifespan = new IntegerFieldEditor("backup_in_shed_lifespan", Messages.ShedBackupPreferencePage_2, this.backupGroup);
        this.shedLifespan.setTextLimit(3);
        this.shedLifespan.setValidRange(1, 999);
        this.shedLifespan.setValidateStrategy(0);
        this.shedLifespan.setPreferenceStore(store);
        this.shedLifespan.setPage((DialogPage)this);
        this.shedLifespan.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    ShedBackupPreferencePage.this.setValid(ShedBackupPreferencePage.this.shedLifespan.isValid());
                }
            }
        });
        this.shedLifespan.load();
        assert (this.backupEnabled != null);
        Point originalMargins = LayoutConstants.getMargins();
        Rectangle margins = Geometry.createDiffRectangle((int)(originalMargins.x * 2), (int)0, (int)0, (int)0);
        GridLayoutFactory.fillDefaults().extendedMargins(margins).applyTo(this.backupGroup);
        this.updateBackupEnablement();
    }

    protected void updateBackupEnablement() {
        boolean be = this.backupEnabled.getSelection();
        this.maxFileSize.setEnabled(be, this.backupGroup);
        this.shedLifespan.setEnabled(be, this.backupGroup);
    }

    public void dispose() {
        this.sandboxListening = null;
        super.dispose();
    }
}

