/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.preferences;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.operations.ISandboxExaminerOperation;
import com.ibm.team.filesystem.ide.ui.internal.preferences.GenerateLoadRulesDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.StatusDialog;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.corruption.RebuildCFAJob;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SandboxPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.ibm.team.filesystem.ide.ui.SandboxPreferencePage";
    private WritableSetWithListeners<ISandbox> sandboxes;
    private SimpleTableViewer<ISandbox> viewer;

    public SandboxPreferencePage() {
    }

    public SandboxPreferencePage(String title) {
        super(title);
    }

    public SandboxPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.sandboxes = new WritableSetWithListeners();
        this.noDefaultAndApplyButton();
        WidgetFactoryContext context = this.createWidgetContext();
        Composite composite = new Composite(parent, 0);
        this.createListandButtons(composite, context);
        this.applyDialogFont(composite);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.preference_page_sandboxes");
        return composite;
    }

    private WidgetFactoryContext createWidgetContext() {
        return WidgetFactoryContext.forPreferencePage((IPreferencePage)this, (String[])new String[0]);
    }

    private void createListandButtons(Composite composite, WidgetFactoryContext context) {
        Label label = new Label(composite, 64);
        label.setText(Messages.SandboxPreferencePage_SandboxesLabel);
        GridDataFactory.defaultsFor((Control)label).span(2, 1).grab(true, false).applyTo((Control)label);
        this.createSandboxView(composite, context);
        this.createButtons(composite, context);
        this.populateView();
    }

    private void createButtons(Composite parent, WidgetFactoryContext context) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.defaultsFor((Control)composite).grab(false, true).align(4, 4).applyTo((Control)composite);
        Button addButton = new Button(composite, 8);
        addButton.setText(Messages.SandboxPreferencePage_AddButtonLabel);
        addButton.setToolTipText(Messages.SandboxPreferencePage_AddButtonTooltip);
        GridDataFactory.defaultsFor((Control)addButton).grab(true, false).align(4, 4).applyTo((Control)addButton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog;
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.team.filesystem.ide.ui", "extraLoadWizards");
                IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                if (ep.getExtensions().length > 0 && !store.getBoolean("com.ibm.team.filesystem.ide.ui.hide_sandbox_warning") && (dialog = MessageDialogWithToggle.openInformation((Shell)SandboxPreferencePage.this.getShell(), (String)Messages.SandboxPreferencePage_0, (String)Messages.SandboxPreferencePage_1, (String)Messages.SandboxPreferencePage_2, (boolean)false, (IPreferenceStore)store, (String)"com.ibm.team.filesystem.ide.ui.hide_sandbox_warning")).getToggleState()) {
                    store.setValue("com.ibm.team.filesystem.ide.ui.hide_sandbox_warning", true);
                }
                dialog = new DirectoryDialog(SandboxPreferencePage.this.getShell());
                dialog.setFilterPath(SandboxPreferencePage.this.getWorkspaceRoot().toOSString());
                String path = dialog.open();
                if (path != null) {
                    PathLocation location = new PathLocation(path);
                    SandboxPreferencePage.this.addFromLocation((ILocation)location);
                }
            }
        });
        final Button removeButton = new Button(composite, 8);
        removeButton.setText(Messages.SandboxPreferencePage_RemoveButtonLabel);
        removeButton.setToolTipText(Messages.SandboxPreferencePage_RemoveButtonTooltip);
        GridDataFactory.defaultsFor((Control)removeButton).grab(true, false).align(4, 4).applyTo((Control)removeButton);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = SandboxPreferencePage.this.viewer.getSelection();
                SandboxPreferencePage.this.removeSandboxes(selection.toList());
            }
        });
        final Button deleteButton = new Button(composite, 8);
        deleteButton.setText(Messages.SandboxPreferencePage_DeleteButtonLabel);
        deleteButton.setToolTipText(Messages.SandboxPreferencePage_DeleteButtonTooltip);
        GridDataFactory.defaultsFor((Control)deleteButton).grab(true, false).align(4, 4).applyTo((Control)deleteButton);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = SandboxPreferencePage.this.viewer.getSelection();
                SandboxPreferencePage.this.deleteSandboxes(selection.toList());
            }
        });
        final Button refreshButton = new Button(composite, 8);
        refreshButton.setText(Messages.SandboxPreferencePage_RefreshButtonLabel);
        refreshButton.setToolTipText(Messages.SandboxPreferencePage_RefreshButtonTooltip);
        GridDataFactory.defaultsFor((Control)refreshButton).grab(true, false).align(4, 4).applyTo((Control)refreshButton);
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = SandboxPreferencePage.this.viewer.getSelection();
                SandboxPreferencePage.this.refreshSandboxes(selection.toList());
            }
        });
        final Button repairButton = new Button(composite, 8);
        repairButton.setText(Messages.SandboxPreferencePage_RepairButtonLabel);
        repairButton.setToolTipText(Messages.SandboxPreferencePage_RepairButtonTooltip);
        GridDataFactory.defaultsFor((Control)repairButton).grab(true, false).align(4, 4).applyTo((Control)repairButton);
        repairButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IStructuredSelection selection = SandboxPreferencePage.this.viewer.getSelection();
                SandboxPreferencePage.this.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            RebuildCFAJob.repairSandboxes(selection.toList(), repairButton, monitor);
                        }
                        catch (FileSystemException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
        });
        final Button generateLoadRulesButton = new Button(composite, 8);
        generateLoadRulesButton.setText(Messages.SandboxPreferencePage_GenerateLoadRulesButtonLabel);
        generateLoadRulesButton.setToolTipText(Messages.SandboxPreferencePage_GenerateLoadRulesButtonTooltip);
        GridDataFactory.defaultsFor((Control)generateLoadRulesButton).grab(true, false).align(4, 4).applyTo((Control)generateLoadRulesButton);
        generateLoadRulesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IStructuredSelection selection = SandboxPreferencePage.this.viewer.getSelection();
                final ISandboxExaminerOperation sandboxExaminer = IOperationFactory.instance.getSandboxExaminerOperation(null);
                final boolean[] errorsOccured = new boolean[1];
                SandboxPreferencePage.this.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + selection.size()));
                            for (ISandbox sandbox : selection.toList()) {
                                sandboxExaminer.inspect(sandbox, IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)progress.newChild(1));
                            }
                            sandboxExaminer.run((IProgressMonitor)progress.newChild(100));
                        }
                        catch (TeamRepositoryException e) {
                            errorsOccured[0] = true;
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                if (!errorsOccured[0]) {
                    Map rules = sandboxExaminer.getLoadRules();
                    if (!rules.isEmpty()) {
                        GenerateLoadRulesDialog dialog = new GenerateLoadRulesDialog(generateLoadRulesButton.getShell(), rules);
                        dialog.open();
                    } else {
                        Dialog dialog = SandboxPreferencePage.this.getNoLoadRulesFoundWarningDialog(generateLoadRulesButton.getShell());
                        dialog.open();
                    }
                }
            }
        });
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean hasSelection = !SandboxPreferencePage.this.viewer.getSelection().isEmpty();
                removeButton.setEnabled(SandboxPreferencePage.this.isRemoveEnabled());
                deleteButton.setEnabled(SandboxPreferencePage.this.isRemoveEnabled());
                refreshButton.setEnabled(hasSelection);
                repairButton.setEnabled(hasSelection);
                generateLoadRulesButton.setEnabled(SandboxPreferencePage.this.viewer.getSelection().size() == 1);
            }
        });
        removeButton.setEnabled(false);
        deleteButton.setEnabled(false);
        refreshButton.setEnabled(false);
        repairButton.setEnabled(false);
        generateLoadRulesButton.setEnabled(false);
    }

    protected Dialog getNoLoadRulesFoundWarningDialog(Shell shell) {
        return new MessageDialog(shell, Messages.SandboxPreferencePage_NoLoadRulesGeneratedWarningDialogTitle, null, Messages.SandboxPreferencePage_NoLoadRulesGeneratedWarningDialogDescription, 4, new String[]{IDialogConstants.OK_LABEL}, 1);
    }

    protected void deleteSandboxes(final Collection<ISandbox> list) {
        IRunnableWithProgress runnable;
        if (this.confirmDelete(list) && this.run(runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SandboxPreferencePage_SandBoxRemoveTaskname, (int)100);
                try {
                    if (SandboxPreferencePage.this.performRemove(list, (IProgressMonitor)progress.newChild(50))) {
                        for (ISandbox sandbox : list) {
                            SandboxPreferencePage.this.delete(new File(sandbox.getRoot().toOSString()), (IProgressMonitor)progress.newChild(50));
                        }
                    }
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (FileSystemException e) {
                    throw new InvocationTargetException(e);
                }
            }
        })) {
            this.sandboxes.removeAll(list);
        }
    }

    private boolean run(IRunnableWithProgress runnable) {
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                CoreException ce = (CoreException)t;
                StatusUtil.log((Object)((Object)this), (Throwable)ce);
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)ce.getStatus());
            } else {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)t));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    private void delete(File file, IProgressMonitor progress) throws IOException, CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (file.delete() || !file.exists()) {
            return;
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
        IFileInfo fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
        if (!fileInfo.getAttribute(32) && fileInfo.isDirectory()) {
            File[] children = file.listFiles();
            monitor.subTask(NLS.bind((String)Messages.SandboxPreferencePage_FileDeleteSubtask, (Object)file.getAbsolutePath()));
            if (children != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.delete(child, (IProgressMonitor)monitor);
                    ++n2;
                }
            }
        }
        if (!file.delete()) {
            throw new IOException(NLS.bind((String)Messages.SandboxPreferencePage_CouldNotDelete, (Object)file.getAbsolutePath()));
        }
    }

    private boolean performRemove(Collection<ISandbox> list, IProgressMonitor monitor) throws FileSystemException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * list.size()));
        Map<ISandbox, Set<IProject>> projects = this.getResources(list);
        for (ISandbox sandbox : list) {
            SubMonitor pp = progress.newChild(90);
            Set<IProject> sandboxProjects = projects.get(sandbox);
            if (sandboxProjects != null && !sandboxProjects.isEmpty()) {
                pp.setWorkRemaining(sandboxProjects.size() + 2);
                ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])sandboxProjects.toArray(new ISchedulingRule[sandboxProjects.size()]));
                try {
                    Job.getJobManager().beginRule(rule, (IProgressMonitor)pp.newChild(1));
                    for (IProject project : sandboxProjects) {
                        project.delete(false, false, (IProgressMonitor)pp.newChild(1));
                    }
                }
                finally {
                    Job.getJobManager().endRule(rule);
                }
            } else {
                pp.setWorkRemaining(1);
            }
            this.performRemove(sandbox, pp.newChild(1));
        }
        return true;
    }

    private void performRemove(ISandbox sandbox, SubMonitor progress) throws FileSystemException {
        FileSystemCore.getSharingManager().deregister(sandbox, (IProgressMonitor)progress);
    }

    private void performAdd(Collection<ISandbox> toAdd, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toAdd.size());
        for (ISandbox sandbox : toAdd) {
            FileSystemCore.getSharingManager().register(sandbox, true, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    protected void refreshSandboxes(final Collection<ISandbox> sandboxes) {
        boolean isDefault = UiPlugin.getDefault().getPreferenceStore().isDefault("prefs_skip_eclipse_resources_whenrefreshing");
        final boolean refreshFlag = isDefault || UiPlugin.getDefault().getPreferenceStore().getBoolean("prefs_skip_eclipse_resources_whenrefreshing");
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ISharingManager sharingManager = FileSystemCore.getSharingManager();
                    if (!sandboxes.isEmpty()) {
                        sharingManager.getLocalChangeManager().refreshChanges(sandboxes.toArray(new ISandbox[sandboxes.size()]), refreshFlag ? ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN : ILocalChangeManager.RefreshType.OPTIMIZED_TRAVERSAL, monitor);
                    }
                }
                catch (FileSystemException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
    }

    private boolean confirmDelete(Collection<ISandbox> list) {
        String message;
        if (list.size() == 1) {
            ISandbox sandbox = list.iterator().next();
            message = NLS.bind((String)Messages.SandboxPreferencePage_ConfirmDeleteOneSandbox, (Object)sandbox.getRoot().toOSString());
        } else {
            message = NLS.bind((String)Messages.SandboxPreferencePage_ConfirmDeleteManySandboxes, (Object)list.size());
        }
        Map<ISandbox, Set<IProject>> projects = this.getResources(list);
        if (projects.size() > 0) {
            ArrayList<IStatus> statusList = new ArrayList<IStatus>();
            for (Map.Entry<ISandbox, Set<IProject>> entry : projects.entrySet()) {
                this.updateStatus(entry.getKey(), entry.getValue(), statusList, Messages.SandboxPreferencePage_DeleteSingleProject);
            }
            if (statusList.size() > 0) {
                MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.ide.ui", 0, statusList.toArray(new IStatus[statusList.size()]), Messages.SandboxPreferencePage_ConfirmDeleteMultiStatus, null);
                StatusDialog dialog = new StatusDialog(this.getShell(), Messages.SandboxPreferencePage_ConfirmDeleteTitle, message, null, (IStatus)multiStatus, 7);
                return dialog.open() == 0;
            }
        }
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.SandboxPreferencePage_ConfirmDeleteTitle, (String)message);
    }

    void removeSandboxes(Collection<ISandbox> collection) {
        if (this.confirmRemove(collection)) {
            this.sandboxes.removeAll(collection);
        }
    }

    private boolean confirmRemove(Collection<ISandbox> collection) {
        Map<ISandbox, Set<IProject>> projects = this.getResources(collection);
        if (projects.size() > 0) {
            ArrayList<IStatus> statusList = new ArrayList<IStatus>();
            for (Map.Entry<ISandbox, Set<IProject>> entry : projects.entrySet()) {
                this.updateStatus(entry.getKey(), entry.getValue(), statusList, Messages.SandboxPreferencePage_RemoveSingleProject);
            }
            if (statusList.size() == 1) {
                return MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.SandboxPreferencePage_ConfirmRemoveTitle, (String)NLS.bind((String)Messages.SandboxPreferencePage_AreYouSure, (Object)((IStatus)statusList.get(0)).getMessage()));
            }
            MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.ide.ui", 0, statusList.toArray(new IStatus[statusList.size()]), NLS.bind((String)Messages.SandboxPreferencePage_RemoveMultiStatusMessage, (Object)statusList.size()), null);
            StatusDialog dialog = new StatusDialog(this.getShell(), Messages.SandboxPreferencePage_ConfirmRemoveTitle, null, null, (IStatus)multiStatus, 7);
            return dialog.open() == 0;
        }
        return true;
    }

    private Map<ISandbox, Set<IProject>> getResources(Collection<ISandbox> sandboxes) {
        IProject[] projects;
        HashMap<ISandbox, Set<IProject>> result = new HashMap<ISandbox, Set<IProject>>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            ISandbox sandbox;
            IProject project = iProjectArray[n2];
            if (RepositoryProvider.isShared((IProject)project) && RepositoryProvider.getProvider((IProject)project, (String)"com.ibm.team.filesystem.rcp.core.provider") != null && (sandbox = this.getSandbox(project)) != null && sandboxes.contains(sandbox)) {
                HashSet<IProject> resources = (HashSet<IProject>)result.get(sandbox);
                if (resources == null) {
                    resources = new HashSet<IProject>();
                    result.put(sandbox, resources);
                }
                resources.add(project);
            }
            ++n2;
        }
        return result;
    }

    private ISandbox getSandbox(IProject project) {
        Object adapted = project.getAdapter(IShareable.class);
        if (adapted instanceof IShareable) {
            IShareable shareable = (IShareable)adapted;
            return shareable.getSandbox();
        }
        return null;
    }

    private void updateStatus(ISandbox sandbox, Set<IProject> projects, List<IStatus> statusList, String projectSandboxMessage) {
        for (IProject project : projects) {
            statusList.add(StatusUtil.newStatus((Object)((Object)this), (int)2, (String)NLS.bind((String)projectSandboxMessage, (Object)project.getName(), (Object)sandbox.getRoot().toOSString())));
        }
    }

    private void addFromLocation(ILocation location) {
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(location, false);
        if (sandbox.isExistingSandbox()) {
            this.sandboxes.add((Object)sandbox);
        } else {
            MessageDialogFactory.showMessage((Shell)this.getShell(), (int)4, (String)Messages.SandboxPreferencePage_NotASandboxTitle, (String)NLS.bind((String)Messages.SandboxPreferencePage_NotASandboxMessage, (Object)location.toOSString()));
        }
    }

    private boolean isRemoveEnabled() {
        IStructuredSelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        ILocation workspaceRoot = this.getWorkspaceRoot();
        for (ISandbox sandbox : selection) {
            if (!sandbox.getRoot().equals((Object)workspaceRoot)) continue;
            return false;
        }
        return true;
    }

    private void createSandboxView(Composite composite, WidgetFactoryContext context) {
        Table table = new Table(composite, 84738);
        this.viewer = new SimpleTableViewer(table);
        GridDataFactory.defaultsFor((Control)table).align(4, 4).grab(true, true).applyTo((Control)table);
        new LabelColumn(this.viewer, Messages.SandboxPreferencePage_SandboxColumnLabel, -1, (IViewerLabelProvider)new BaseLabelProvider(){
            StandardLabelProvider locationProvider = new StandardLabelProvider((ILabelProvider)new BaseLabelProvider(){

                public void updateLabel(ViewerLabel label, Object element) {
                    if (element instanceof ISandbox) {
                        ISandbox sandbox = (ISandbox)element;
                        label.setText(sandbox.getRoot().toOSString());
                        label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
                    }
                }
            }, (IElementRemovedNotifier)new ElementRemovedNotifierImpl());

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof ISandbox) {
                    ISandbox sandbox = (ISandbox)element;
                    this.locationProvider.updateLabel(label, (Object)sandbox.getRoot());
                    if (sandbox.getRoot().equals((Object)SandboxPreferencePage.this.getWorkspaceRoot())) {
                        label.setText(NLS.bind((String)Messages.SandboxPreferencePage_EclipseWorkspaceIndication, (Object)label.getText()));
                    }
                }
            }
        });
        this.viewer.setInput(this.sandboxes);
    }

    private void populateView() {
        Collection cfas = FileSystemCore.getSharingManager().getRegisteredSandboxes();
        this.sandboxes.addAll(cfas);
    }

    private ILocation getWorkspaceRoot() {
        return new PathLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation());
    }

    public boolean performOk() {
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        Collection existing = sharingManager.getRegisteredSandboxes();
        final HashSet<ISandbox> toRemove = new HashSet<ISandbox>();
        final HashSet<ISandbox> toAdd = new HashSet<ISandbox>();
        for (ISandbox sandbox : existing) {
            if (this.sandboxes.contains((Object)sandbox)) continue;
            toRemove.add(sandbox);
        }
        for (ISandbox sandbox : this.sandboxes) {
            if (existing.contains(sandbox)) continue;
            toAdd.add(sandbox);
        }
        if (!toAdd.isEmpty() || !toRemove.isEmpty()) {
            final boolean[] result = new boolean[1];
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(toRemove.size() + toAdd.size() + 100));
                        SandboxPreferencePage.this.performRemove(toRemove, (IProgressMonitor)progress.newChild(toRemove.size()));
                        SandboxPreferencePage.this.performAdd(toAdd, (IProgressMonitor)progress.newChild(toAdd.size()));
                        result[0] = true;
                        progress.done();
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.run(runnable);
            return result[0];
        }
        return true;
    }
}

