/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.preferences;

import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.ui.UiPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PreferencesListener
implements IPropertyChangeListener {
    static PreferencesListener instance;
    IComponentSyncModel model;
    String status = null;

    public PreferencesListener(IComponentSyncModel model) {
        this.model = model;
        UiPlugin plugin = UiPlugin.getDefault();
        if (plugin != null) {
            this.setState();
            plugin.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("auto commit") || property.equals("com.ibm.team.filesystem.ide.ui.prefs_show_pending_view_on_changes") || property.equals("com.ibm.team.filesystem.ide.ui.prefs_show_untracked_workspaces")) {
            this.setState();
        }
    }

    private void setState() {
        ILocalSynchronizationManager localManager = this.model.getLocalSynchronizationManager();
        if (localManager != null) {
            IPreferenceStore preferenceStore = UiPlugin.getDefault().getPreferenceStore();
            localManager.setAutoSave(preferenceStore.getBoolean("auto commit"));
            localManager.setAutoComplete(false);
        }
    }

    public void dispose() {
        UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public static void start(IComponentSyncModel model) {
        if (instance == null) {
            instance = new PreferencesListener(model);
        }
    }

    public static void stop() {
        if (instance != null) {
            instance.dispose();
        }
        instance = null;
    }

    static Shell getActiveShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window != null ? window.getShell() : null;
    }
}

