/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.preferences;

import com.ibm.team.filesystem.ide.ui.internal.preferences.CheckPrefInfo;
import com.ibm.team.filesystem.ide.ui.internal.preferences.PrefInfo;
import com.ibm.team.filesystem.ide.ui.internal.preferences.RadioPrefInfo;
import com.ibm.team.filesystem.ui.UiPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public abstract class PrefInfoPreferencePage
extends FieldEditorPreferencePage {
    protected List<FieldEditor> fields = new ArrayList<FieldEditor>();
    protected Map<Button, PrefInfo> buttonFields = new HashMap<Button, PrefInfo>();

    public PrefInfoPreferencePage() {
    }

    public PrefInfoPreferencePage(int style) {
        super(style);
    }

    public PrefInfoPreferencePage(String title, int style) {
        super(title, style);
    }

    public PrefInfoPreferencePage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    protected Group createPreferencesGroup(Composite composite, String groupName, PrefInfo[] infos) {
        Group group = new Group(composite, 0);
        group.setFont(JFaceResources.getDialogFont());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        group.setText(groupName);
        PrefInfo[] prefInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            PrefInfo prefInfo = prefInfoArray[n2];
            this.setPrefInfo((Composite)group, prefInfo);
            ++n2;
        }
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo((Composite)group);
        return group;
    }

    protected FieldEditor setPrefInfo(Composite parent, PrefInfo prefInfo) {
        BooleanFieldEditor editor = null;
        if (prefInfo instanceof CheckPrefInfo) {
            editor = new BooleanFieldEditor(prefInfo.getPrefKey(), prefInfo.getLabel(), parent);
        } else if (prefInfo instanceof RadioPrefInfo) {
            RadioPrefInfo radioPref = (RadioPrefInfo)prefInfo;
            ArrayList<String[]> prefKeys = radioPref.getOptions();
            String title = prefInfo.getLabel();
            int length = prefKeys.size();
            String[][] labelAndValues = new String[length][2];
            int i = 0;
            while (i < length) {
                labelAndValues[i] = prefKeys.get(i);
                ++i;
            }
            editor = new RadioGroupFieldEditor(prefInfo.getPrefKey(), title, length > 2 ? 1 : 2, labelAndValues, parent);
        }
        if (editor != null) {
            if (prefInfo.getPrefStore() == null) {
                editor.setPreferenceStore(prefInfo.isUiPref() ? UiPlugin.getDefault().getPreferenceStore() : UiPlugin.getDefault().getCorePreferenceStore());
            } else {
                editor.setPreferenceStore(prefInfo.getPrefStore());
            }
            this.addField((FieldEditor)editor);
        }
        return editor;
    }

    protected void initialize() {
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                pe.setPage((DialogPage)this);
                pe.setPropertyChangeListener((IPropertyChangeListener)this);
                if (pe.getPreferenceStore() == null) {
                    pe.setPreferenceStore(this.getPreferenceStore());
                }
                pe.load();
            }
        }
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this.fields.add(editor);
    }
}

