/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.preferences;

import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.client.operations.LoadRuleSerializationDilemmaHandler;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

public class GenerateLoadRulesDialog
extends TitleAreaDialog {
    private final String PREF_KEY_DESTINATION_PATH = "load_rule_destination_path";
    private final String PREF_KEY_GENERATION_POLICY = "load_rule_generation_policy";
    private final String PREF_VALUE_GENERATION_BY_NAME = "name";
    private final String PREF_VALUE_GENERATION_BY_ID = "id";
    private final String PREF_KEY_ECLIPSE_PROJECT_CREATION_POLICY = "load_rule_eclipse_project_creation_policy";
    private final String PREF_KEY_USE_NAME_IN_DOT_PROJECT_FILE = "load_rule_use_name_in_dot_project_file";
    private final String PREF_VALUE_NONE = "none";
    private final String PREF_VALUE_CREATE_PROJECTS_FOR_NEW_SHARE_ROOTS = "shareRoots";
    private final String PREF_VALUE_IMPORT_PROJECTS = "importProjects";
    private Map<ISandbox, Collection<ILoadRule2>> fLoadRules;
    private Map<ILoadRule2, String> fLoadRuleFileNames;
    private Preferences fPrefs;
    private List fLoadRuleList;
    private Button fRenameButton;
    private Button fRemoveButton;
    private Text fDestinationPathText;
    private Button fCreateUsingNamesButton;
    private Button fCreateUsingIdsButton;
    private Button fImportEclipseProjectsButton;
    private Button fCreateEclipseProjectsButton;
    private Button fDoNotCreateEclipseProjectsButton;
    private Button fUseNameInDotProjectFileButton;

    public GenerateLoadRulesDialog(Shell shell, Map<ISandbox, Collection<ILoadRule2>> loadRules) {
        super(shell);
        this.fLoadRules = loadRules;
        this.fLoadRuleFileNames = this.getDefaultLoadRuleFileNames();
        this.fPrefs = this.getInstanceScope();
    }

    private Preferences getInstanceScope() {
        return new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").node(((Object)((Object)this)).getClass().getName());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = this.fLoadRuleFileNames.size() > 1 ? Messages.GenerateLoadRulesDialog_DialogTitlePlural : Messages.GenerateLoadRulesDialog_DialogTitleSingle;
        newShell.setText(title);
    }

    public void create() {
        String description;
        String title;
        super.create();
        if (this.fLoadRuleFileNames.size() > 1) {
            title = Messages.GenerateLoadRulesDialog_DialogTitlePlural;
            description = Messages.GenerateLoadRulesDialog_DialogDescriptionPlural;
        } else {
            title = Messages.GenerateLoadRulesDialog_DialogTitleSingle;
            description = Messages.GenerateLoadRulesDialog_DialogDescriptionSingle;
        }
        this.setTitle(title);
        this.setMessage(description);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.GenerateLoadRulesDialog_GenerateButtonLabel, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateOKEnablement();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayoutFactory.fillDefaults().spacing(3, 3).margins(LayoutConstants.getMargins()).numColumns(2).generateLayout(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GenerateLoadRulesDialog.applyDialogFont((Control)parent);
        this.createFileNameWidgets(composite);
        this.createSpacer(composite, 1, 2);
        this.createDestinationPathWidgets(composite);
        this.createSpacer(composite, 1, 2);
        this.createEclipseProjectCreationWidgets(composite);
        this.createSpacer(composite, 1, 2);
        this.createGenerationPolicyWidgets(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.dialog_generateloadrules");
        return dialogArea;
    }

    private void createFileNameWidgets(Composite composite) {
        WidgetToolkit toolkit = WidgetFactoryContext.forDialogBox().getToolkit();
        Group fileNameGroup = new Group(composite, 0);
        fileNameGroup.setText(this.fLoadRuleFileNames.size() > 1 ? Messages.GenerateLoadRulesDialog_FileNameGroupLabelPlural : Messages.GenerateLoadRulesDialog_FileNameGroupLabelSingle);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout((Composite)fileNameGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)fileNameGroup);
        ISandbox sandbox = this.fLoadRules.entrySet().iterator().next().getKey();
        String loadRuleLabelText = this.fLoadRuleFileNames.size() > 1 ? NLS.bind((String)Messages.GenerateLoadRulesDialog_FileNameGroupDescriptionPlural, (Object)sandbox.getRoot().toOSString()) : NLS.bind((String)Messages.GenerateLoadRulesDialog_FileNameGroupDescriptionSingle, (Object)sandbox.getRoot().toOSString());
        Label loadRuleLabel = toolkit.createLabel((Composite)fileNameGroup, loadRuleLabelText);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)loadRuleLabel);
        this.fLoadRuleList = new List((Composite)fileNameGroup, 2562);
        for (Map.Entry<ILoadRule2, String> entry : this.fLoadRuleFileNames.entrySet()) {
            ILoadRule2 loadRule = entry.getKey();
            String listText = this.createListText(entry.getValue(), loadRule);
            this.fLoadRuleList.add(listText);
            this.fLoadRuleList.setData(listText, (Object)loadRule);
        }
        this.fLoadRuleList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionCount = GenerateLoadRulesDialog.this.fLoadRuleList.getSelectionCount();
                int itemCount = GenerateLoadRulesDialog.this.fLoadRuleList.getItemCount();
                if (selectionCount == 1) {
                    GenerateLoadRulesDialog.this.fRenameButton.setEnabled(true);
                } else {
                    GenerateLoadRulesDialog.this.fRenameButton.setEnabled(false);
                }
                if (itemCount > 1 && selectionCount < itemCount) {
                    GenerateLoadRulesDialog.this.fRemoveButton.setEnabled(true);
                } else {
                    GenerateLoadRulesDialog.this.fRemoveButton.setEnabled(false);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).align(4, 128).indent(0, 2).applyTo((Control)this.fLoadRuleList);
        Composite buttonGroup = new Composite((Composite)fileNameGroup, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(5, 5).generateLayout(buttonGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)buttonGroup);
        this.fRenameButton = toolkit.createButton(buttonGroup, Messages.GenerateLoadRulesDialog_RenameButtonLabel, 8);
        this.fRenameButton.setEnabled(false);
        this.fRenameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = GenerateLoadRulesDialog.this.fLoadRuleList.getSelectionIndex();
                if (selectionIndex >= 0 && GenerateLoadRulesDialog.this.fLoadRuleList.getSelectionCount() == 1) {
                    String afterName;
                    ILoadRule2 loadRule = (ILoadRule2)GenerateLoadRulesDialog.this.fLoadRuleList.getData(GenerateLoadRulesDialog.this.fLoadRuleList.getItem(selectionIndex));
                    String beforeName = (String)GenerateLoadRulesDialog.this.fLoadRuleFileNames.get(loadRule);
                    InputDialog renameDialog = GenerateLoadRulesDialog.this.getRenameFileDialog(beforeName);
                    if (renameDialog.open() == 0 && (afterName = renameDialog.getValue()) != null && afterName.length() > 0) {
                        String listText = GenerateLoadRulesDialog.this.createListText(afterName, loadRule);
                        GenerateLoadRulesDialog.this.fLoadRuleList.setItem(selectionIndex, listText);
                        GenerateLoadRulesDialog.this.fLoadRuleList.setData(listText, (Object)loadRule);
                        GenerateLoadRulesDialog.this.fLoadRuleFileNames.put(loadRule, afterName);
                    }
                }
            }
        });
        this.fRenameButton.setLayoutData((Object)new GridData(4, 2, false, false));
        this.fRemoveButton = toolkit.createButton(buttonGroup, Messages.GenerateLoadRulesDialog_RemoveButtonLabel, 8);
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectionIndices;
                int[] nArray = selectionIndices = GenerateLoadRulesDialog.this.fLoadRuleList.getSelectionIndices();
                int n = selectionIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    ILoadRule2 selectedLoadRule = (ILoadRule2)GenerateLoadRulesDialog.this.fLoadRuleList.getData(GenerateLoadRulesDialog.this.fLoadRuleList.getItem(index));
                    GenerateLoadRulesDialog.this.fLoadRuleFileNames.remove(selectedLoadRule);
                    ++n2;
                }
                GenerateLoadRulesDialog.this.fLoadRuleList.remove(selectionIndices);
                if (GenerateLoadRulesDialog.this.fLoadRuleList.getItemCount() <= 1) {
                    GenerateLoadRulesDialog.this.fRemoveButton.setEnabled(false);
                }
            }
        });
        this.fRemoveButton.setLayoutData((Object)new GridData(4, 2, false, false));
    }

    private String createListText(String fileName, ILoadRule2 loadRule) {
        String listText = String.valueOf(NLS.bind((String)Messages.GenerateLoadRulesDialog_FileNameListText, (Object)fileName, (Object)loadRule.getConnection().getName())) + "\n";
        return listText;
    }

    private InputDialog getRenameFileDialog(String beforeName) {
        return new InputDialog(this.getShell(), Messages.GenerateLoadRulesDialog_RenameFileDialogTitle, Messages.GenerateLoadRulesDialog_RenameFileDialogDescription, beforeName, this.getFilenameValidator());
    }

    protected IInputValidator getFilenameValidator() {
        return new IInputValidator(){

            public String isValid(String fileName) {
                if (fileName.trim().length() == 0) {
                    return Messages.GenerateLoadRulesDialog_RenameFileDialogEmptyNameMessage;
                }
                boolean error = false;
                Pattern pattern = Pattern.compile("[\\\\/:*\\?\\\"<>|]", 2);
                error = pattern.matcher(fileName).find();
                if (error) {
                    return Messages.GenerateLoadRulesDialog_RenameFileDialogIllegalCharacters;
                }
                return null;
            }
        };
    }

    private void createDestinationPathWidgets(Composite composite) {
        WidgetToolkit toolkit = WidgetFactoryContext.forDialogBox().getToolkit();
        Group destinationGroup = new Group(composite, 0);
        destinationGroup.setText(Messages.GenerateLoadRulesDialog_DestinationGroupLabel);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout((Composite)destinationGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)destinationGroup);
        String destinationLabelText = Messages.GenerateLoadRulesDialog_DestinationGroupDescription;
        Label destinationPathLabel = toolkit.createLabel((Composite)destinationGroup, destinationLabelText);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)destinationPathLabel);
        this.fDestinationPathText = new Text((Composite)destinationGroup, 2048);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.fDestinationPathText);
        String destinationString = this.fPrefs.get("load_rule_destination_path", this.getDefaultDestinationPath());
        this.fDestinationPathText.setText(destinationString);
        this.fDestinationPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateLoadRulesDialog.this.updateOKEnablement();
            }
        });
        final Button browseButton = toolkit.createButton((Composite)destinationGroup, Messages.GenerateLoadRulesDialog_BrowseButtonLabel, 8);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(browseButton.getShell());
                dialog.setFilterPath(GenerateLoadRulesDialog.this.fDestinationPathText.getText());
                String path = dialog.open();
                if (path != null) {
                    GenerateLoadRulesDialog.this.fDestinationPathText.setText(path);
                }
            }
        });
        browseButton.setLayoutData((Object)new GridData(4, 2, false, false));
        browseButton.setFocus();
    }

    private void createGenerationPolicyWidgets(Composite composite) {
        WidgetToolkit toolkit = WidgetFactoryContext.forDialogBox().getToolkit();
        Group generationPolicyGroup = new Group(composite, 0);
        generationPolicyGroup.setText(Messages.GenerateLoadRulesDialog_ResourceIdentifiersGroupLabel);
        GridLayoutFactory.fillDefaults().margins(5, 5).generateLayout((Composite)generationPolicyGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)generationPolicyGroup);
        String generationPolicy = this.fPrefs.get("load_rule_generation_policy", "id");
        if (!"id".equals(generationPolicy) && !"name".equals(generationPolicy)) {
            generationPolicy = "id";
        }
        String createUsingIds = Messages.GenerateLoadRulesDialog_UseItemIDs;
        this.fCreateUsingIdsButton = toolkit.createButton((Composite)generationPolicyGroup, createUsingIds, 16);
        this.fCreateUsingIdsButton.setSelection(generationPolicy.equals("id"));
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)this.fCreateUsingIdsButton);
        String createUsingNames = Messages.GenerateLoadRulesDialog_UseNames;
        this.fCreateUsingNamesButton = toolkit.createButton((Composite)generationPolicyGroup, createUsingNames, 16);
        this.fCreateUsingNamesButton.setSelection(generationPolicy.equals("name"));
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)this.fCreateUsingNamesButton);
    }

    private void createEclipseProjectCreationWidgets(Composite composite) {
        WidgetToolkit toolkit = WidgetFactoryContext.forDialogBox().getToolkit();
        Group eclipseProjectCreationGroup = new Group(composite, 0);
        eclipseProjectCreationGroup.setText(Messages.GenerateLoadRulesDialog_EclipseProjectCreationPolicyGroupLabel);
        GridLayoutFactory.fillDefaults().margins(5, 5).generateLayout((Composite)eclipseProjectCreationGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)eclipseProjectCreationGroup);
        String eclipseProjectCreationPolicy = this.fPrefs.get("load_rule_eclipse_project_creation_policy", "importProjects");
        if (eclipseProjectCreationPolicy == null || !eclipseProjectCreationPolicy.equals("importProjects") && !eclipseProjectCreationPolicy.equals("shareRoots") && !eclipseProjectCreationPolicy.equals("none")) {
            eclipseProjectCreationPolicy = "importProjects";
        }
        String importEclipseProjects = Messages.GenerateLoadRulesDialog_ImportEclipseProjectsButtonLabel;
        this.fImportEclipseProjectsButton = toolkit.createButton((Composite)eclipseProjectCreationGroup, importEclipseProjects, 16);
        this.fImportEclipseProjectsButton.setSelection(eclipseProjectCreationPolicy.equals("importProjects"));
        this.fImportEclipseProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateLoadRulesDialog.this.fUseNameInDotProjectFileButton.setEnabled(!GenerateLoadRulesDialog.this.fDoNotCreateEclipseProjectsButton.getSelection());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)this.fImportEclipseProjectsButton);
        String createEclipseProjects = Messages.GenerateLoadRulesDialog_CreateEclipseProjectsButtonLabel;
        this.fCreateEclipseProjectsButton = toolkit.createButton((Composite)eclipseProjectCreationGroup, createEclipseProjects, 16);
        this.fCreateEclipseProjectsButton.setSelection(eclipseProjectCreationPolicy.equals("shareRoots"));
        this.fCreateEclipseProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateLoadRulesDialog.this.fUseNameInDotProjectFileButton.setEnabled(!GenerateLoadRulesDialog.this.fDoNotCreateEclipseProjectsButton.getSelection());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)this.fCreateEclipseProjectsButton);
        String doNotCreateEclipseProjects = Messages.GenerateLoadRulesDialog_DoNotCreateEclipseProjectsButtonLabel;
        this.fDoNotCreateEclipseProjectsButton = toolkit.createButton((Composite)eclipseProjectCreationGroup, doNotCreateEclipseProjects, 16);
        this.fDoNotCreateEclipseProjectsButton.setSelection(eclipseProjectCreationPolicy.equals("none"));
        this.fDoNotCreateEclipseProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateLoadRulesDialog.this.fUseNameInDotProjectFileButton.setEnabled(!GenerateLoadRulesDialog.this.fDoNotCreateEclipseProjectsButton.getSelection());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)this.fDoNotCreateEclipseProjectsButton);
        String useNameInDotProjectFile = Messages.GenerateLoadRulesDialog_UseNameInDotProjectFileButtonLabel;
        this.fUseNameInDotProjectFileButton = toolkit.createButton((Composite)eclipseProjectCreationGroup, useNameInDotProjectFile, 32);
        this.fUseNameInDotProjectFileButton.setSelection(this.fPrefs.getBoolean("load_rule_use_name_in_dot_project_file", false));
        this.fUseNameInDotProjectFileButton.setEnabled(!this.fDoNotCreateEclipseProjectsButton.getSelection());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)this.fUseNameInDotProjectFileButton);
    }

    protected void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = WidgetFactoryContext.forDialogBox().getToolkit().createLabel(parent, "");
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(horizontalSpan, height).applyTo((Control)label);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(0x10060 | GenerateLoadRulesDialog.getDefaultOrientation());
    }

    public int getEclipseProjectCreationPolicy() {
        int policy = 2;
        if (this.fImportEclipseProjectsButton.getSelection()) {
            policy = 2;
        } else if (this.fCreateEclipseProjectsButton.getSelection()) {
            policy = 1;
        } else if (this.fDoNotCreateEclipseProjectsButton.getSelection()) {
            policy = 0;
        }
        if (this.fUseNameInDotProjectFileButton.isEnabled() && this.fUseNameInDotProjectFileButton.getSelection()) {
            policy |= 8;
        }
        return policy;
    }

    protected void okPressed() {
        this.savePreferences();
        final String savePath = this.fDestinationPathText.getText();
        final boolean useNameSelection = this.fCreateUsingNamesButton.getSelection();
        final int eclipseProjectCreationPolicy = this.getEclipseProjectCreationPolicy();
        if (savePath != null) {
            new JobRunner(true).enqueue(Messages.GenerateLoadRulesDialog_GenerateJobName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)GenerateLoadRulesDialog.this.fLoadRules.size());
                        File directory = new File(savePath);
                        if (!directory.exists()) {
                            directory.mkdirs();
                        }
                        progress.setWorkRemaining(GenerateLoadRulesDialog.this.fLoadRules.size());
                        final String sandboxName = ((ISandbox)GenerateLoadRulesDialog.this.fLoadRules.entrySet().iterator().next().getKey()).getRoot().toOSString();
                        for (Map.Entry entry : GenerateLoadRulesDialog.this.fLoadRuleFileNames.entrySet()) {
                            final File loadRuleFile = new File(directory, (String)entry.getValue());
                            final String workspaceName = ((ILoadRule2)entry.getKey()).getConnection().getName();
                            final boolean[] shouldOverwrite = new boolean[1];
                            if (loadRuleFile.exists()) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog dialog = GenerateLoadRulesDialog.this.getOverwriteFileDialog(GenerateLoadRulesDialog.this.getParentShell(), loadRuleFile, sandboxName, workspaceName);
                                        if (dialog.open() == 0) {
                                            shouldOverwrite[0] = true;
                                        }
                                    }
                                });
                                if (!shouldOverwrite[0]) continue;
                            }
                            ArrayList<String> comments = new ArrayList<String>();
                            comments.add(NLS.bind((String)Messages.GenerateLoadRulesDialog_AddedComment, (Object)sandboxName, (Object)((ILoadRule2)entry.getKey()).getConnection().getName()));
                            FileOutputStream fos = new FileOutputStream(loadRuleFile);
                            CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoder);
                            try (BufferedWriter writer = new BufferedWriter(osw);){
                                LoadRuleSerializationDilemmaHandler serializationPref = new LoadRuleSerializationDilemmaHandler(){

                                    public int overrideEclipseLoadOption(int currentEclipseOption) {
                                        return eclipseProjectCreationPolicy;
                                    }

                                    public boolean useComponentName() {
                                        return useNameSelection;
                                    }

                                    public boolean useRepositoryPath() {
                                        return useNameSelection;
                                    }
                                };
                                ((ILoadRule2)entry.getKey()).serializeToXML((Writer)writer, comments, serializationPref, (IProgressMonitor)progress.newChild(1));
                                ((Writer)writer).flush();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new TeamRepositoryException((Throwable)e);
                    }
                }
            });
        }
        super.okPressed();
    }

    private void updateOKEnablement() {
        this.getButton(0).setEnabled(this.validate());
    }

    private boolean validate() {
        boolean valid = true;
        String destination = this.fDestinationPathText.getText();
        if (destination == null || destination.length() == 0) {
            valid = false;
        }
        return valid;
    }

    private String getDefaultDestinationPath() {
        String defaultDir = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(defaultDir);
        if (!tmpDir.exists() || !tmpDir.canWrite()) {
            defaultDir = this.fLoadRules.entrySet().iterator().next().getKey().getRoot().toOSString();
        }
        return defaultDir;
    }

    private Map<ILoadRule2, String> getDefaultLoadRuleFileNames() {
        HashMap<ILoadRule2, String> defaultNames = new HashMap<ILoadRule2, String>();
        ISandbox sandbox = this.fLoadRules.entrySet().iterator().next().getKey();
        Collection<ILoadRule2> rules = this.fLoadRules.entrySet().iterator().next().getValue();
        if (rules.size() > 0) {
            int i = 1;
            for (ILoadRule2 loadRule : rules) {
                String rootName = sandbox.getRoot().getName();
                if (rootName == null || rootName.trim().equals("")) {
                    rootName = Messages.GenerateLoadRulesDialog_DefaultLoadRuleName;
                }
                String DOT = ".";
                String fileName = rules.size() == 1 ? String.valueOf(rootName) + "." + "loadrule" : String.valueOf(rootName) + i++ + "." + "loadrule";
                defaultNames.put(loadRule, fileName);
            }
        }
        return this.sortMapByValue(defaultNames);
    }

    private Map<ILoadRule2, String> sortMapByValue(Map<ILoadRule2, String> map) {
        LinkedList<Map.Entry<ILoadRule2, String>> listForSort = null;
        LinkedHashMap<ILoadRule2, String> sortedList = new LinkedHashMap<ILoadRule2, String>();
        listForSort = new LinkedList<Map.Entry<ILoadRule2, String>>(map.entrySet());
        Collections.sort(listForSort, new Comparator<Map.Entry<ILoadRule2, String>>(){

            @Override
            public int compare(Map.Entry<ILoadRule2, String> value1, Map.Entry<ILoadRule2, String> value2) {
                return value1.getValue().compareTo(value2.getValue());
            }
        });
        for (Map.Entry entry : listForSort) {
            sortedList.put((ILoadRule2)entry.getKey(), (String)entry.getValue());
        }
        return sortedList;
    }

    private MessageDialog getOverwriteFileDialog(Shell shell, File file, String sandboxName, String workspaceName) {
        String dialogTitle = Messages.GenerateLoadRulesDialog_OverwriteFileDialogTitle;
        String confirmation = NLS.bind((String)Messages.GenerateLoadRulesDialog_OverwriteFileDialogConfirmation, (Object)file.getAbsolutePath());
        String generatedFrom = NLS.bind((String)Messages.GenerateLoadRulesDialog_OverwriteFileDialogGeneratedFrom, (Object)file.getAbsolutePath());
        String sandbox = NLS.bind((String)Messages.GenerateLoadRulesDialog_OverwriteFileDialogSandboxName, (Object)sandboxName);
        String workspace = NLS.bind((String)Messages.GenerateLoadRulesDialog_OverwriteFileDialogWorkspaceName, (Object)workspaceName);
        String dialogBody = String.valueOf(confirmation) + "\n\n" + generatedFrom + "\n" + sandbox + "\n" + workspace;
        return new MessageDialog(shell, dialogTitle, null, dialogBody, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
    }

    private void savePreferences() {
        this.fPrefs.put("load_rule_destination_path", this.fDestinationPathText.getText());
        if (this.fCreateUsingNamesButton.getSelection()) {
            this.fPrefs.put("load_rule_generation_policy", "name");
        }
        if (this.fCreateUsingIdsButton.getSelection()) {
            this.fPrefs.put("load_rule_generation_policy", "id");
        }
        if (this.fImportEclipseProjectsButton.getSelection()) {
            this.fPrefs.put("load_rule_eclipse_project_creation_policy", "importProjects");
        }
        if (this.fCreateEclipseProjectsButton.getSelection()) {
            this.fPrefs.put("load_rule_eclipse_project_creation_policy", "shareRoots");
        }
        if (this.fDoNotCreateEclipseProjectsButton.getSelection()) {
            this.fPrefs.put("load_rule_eclipse_project_creation_policy", "none");
        }
        this.fPrefs.putBoolean("load_rule_use_name_in_dot_project_file", this.fUseNameInDotProjectFileButton.getSelection());
    }
}

