/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.preferences;

import com.ibm.team.filesystem.ide.ui.internal.util.KeyStrokeUtil;
import com.ibm.team.filesystem.rcp.core.internal.compare.ExternalCompareToolManager;
import com.ibm.team.filesystem.rcp.core.internal.compare.ExternalCompareToolsUtil;
import com.ibm.team.filesystem.rcp.core.internal.compare.IExternalCompareTool;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ExternalCompareToolsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.ibm.team.filesystem.ide.ui.internal.preferences.ExternalCompareToolsPreferencePage";
    private Map<Object, String> errors = new TreeMap<Object, String>(new Comparator<Object>(){

        @Override
        public int compare(Object object1, Object object2) {
            if (object1 == null && object2 == null) {
                return 0;
            }
            if (object1 == null || object2 == null) {
                return -1;
            }
            return object1.toString().compareTo(object2.toString());
        }
    });
    private IExternalCompareTool customTool = ExternalCompareToolManager.getCustomTool();
    private Map<String, IExternalCompareTool> externalCompareToolsMap;
    private IExternalCompareTool selectedTool;
    private ComboFieldEditor externalToolsComboBox;
    private CustomFileFieldEditor twoWayComparePathFileField;
    private ArgumentStringFieldEditor twoWayLocalCompareArgumentsStringField;
    private ArgumentStringFieldEditor twoWayRemoteCompareArgumentsStringField;
    private CustomFileFieldEditor threeWayConflictComparePathFileField;
    private ArgumentStringFieldEditor threeWayConflictCompareArgumentsStringField;
    private CustomFileFieldEditor autoResolvePathFileField;
    private ArgumentStringFieldEditor threeWayAutoResolveArgumentsStringField;
    private IPersistentPreferenceStore corePreferenceStore;
    private ArgumentStringFieldEditor autoResolveArgumentsStringField;
    private ExternalToolOptionsGroup compareOptions;
    private ExternalToolOptionsGroup autoResolveOptions;
    List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private Group twoWayCompare;
    private Group threeWayMerge;
    private Group autoResolve;

    public ExternalCompareToolsPreferencePage() {
        this.setTitle(Messages.ExternalCompareToolsPreferencePage_0);
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    public void init(IWorkbench workbench) {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.externalCompareToolsMap = ExternalCompareToolManager.getExternalCompareToolsMap();
    }

    protected Control createContents(Composite parent) {
        this.createCompareOptionsGroup(parent);
        new Label(parent, 258).setLayoutData((Object)new GridData(768));
        this.createAutoResolveOptionsGroup(parent);
        new Label(parent, 258).setLayoutData((Object)new GridData(768));
        this.createExternalToolsComboBox(parent);
        this.createTwoWayCompareGroup(parent);
        this.createThreeWayMergeGroup(parent);
        this.createAutoResolveGroup(parent);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo(parent);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.applyDialogFont(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.team.filesystem.ide.ui.preference_external_compare_tools");
        this.initialize();
        String previouslyUsedTool = this.getPreferenceStore().getString("external_compare_previously_selected_compare_tool");
        if (previouslyUsedTool == null || previouslyUsedTool == "") {
            previouslyUsedTool = this.customTool.getName();
        }
        this.selectedTool = this.externalCompareToolsMap.get(previouslyUsedTool);
        this.checkState();
        this.reloadExternalToolArgsFromPrefs();
        this.modifyGroupEnablement();
        return parent;
    }

    protected void initialize() {
        for (FieldEditor field : this.editors) {
            field.setPage((DialogPage)this);
            field.setPropertyChangeListener((IPropertyChangeListener)this);
            if (field.getPreferenceStore() == null) {
                field.setPreferenceStore(this.getPreferenceStore());
            }
            field.load();
        }
        this.compareOptions.initialize();
        this.autoResolveOptions.initialize();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source == this.externalToolsComboBox) {
            this.errors.clear();
        }
        super.propertyChange(event);
        this.compareOptions.propertyChange(event);
        this.autoResolveOptions.propertyChange(event);
        if (source == this.autoResolveOptions.radioFields) {
            this.threeWayAutoResolveArgumentsStringField.doCheckState();
            this.autoResolvePathFileField.doCheckState();
            this.autoResolveArgumentsStringField.doCheckState();
            this.modifyGroupEnablement();
        } else if (source == this.externalToolsComboBox) {
            this.selectedTool = this.externalCompareToolsMap.get((String)event.getNewValue());
            this.reloadExternalToolArgsFromPrefs();
            this.modifyGroupEnablement();
        }
        this.updateErrorMessage();
    }

    private void createCompareOptionsGroup(Composite parent) {
        String[][] labelsAndValues = new String[][]{{Messages.ExternalCompareToolsPreferencePage_RADIO_NEVER, "never"}, {Messages.ExternalCompareToolsPreferencePage_RADIO_ALWAYS, "always"}, {Messages.ExternalCompareToolsPreferencePage_RADIO_INCLUSIVE, "inclusive"}, {Messages.ExternalCompareToolsPreferencePage_RADIO_EXCLUSIVE, "exclusive"}};
        String[] textFieldEnabledValues = new String[]{"inclusive", "exclusive"};
        String[] toolEnabledValues = new String[]{"always", "inclusive", "exclusive"};
        this.compareOptions = new ExternalToolOptionsGroup(parent, Messages.ExternalCompareToolsPreferencePage_COMPARE_TITLE, labelsAndValues, null, "external_compare_tool_policy", "external_compare_file_patterns_list", textFieldEnabledValues, toolEnabledValues);
    }

    private void createAutoResolveOptionsGroup(Composite parent) {
        String[][] labelsAndValues = new String[][]{{Messages.ExternalCompareToolsPreferencePage_RADIO_NEVER, "never"}, {Messages.ExternalCompareToolsPreferencePage_RADIO_ALWAYS, "always"}, {Messages.ExternalCompareToolsPreferencePage_RADIO_INCLUSIVE, "inclusive"}, {Messages.ExternalCompareToolsPreferencePage_RADIO_EXCLUSIVE, "exclusive"}};
        String[] textFieldEnabledValues = new String[]{"inclusive", "exclusive"};
        String[] toolEnabledValues = new String[]{"always", "inclusive", "exclusive"};
        this.autoResolveOptions = new ExternalToolOptionsGroup(parent, Messages.ExternalCompareToolsPreferencePage_AUTO_RESOLVE_TITLE, labelsAndValues, (IPreferenceStore)this.getCorePreferenceStore(), "external_auto_resolve_tool_policy", "external_auto_resolve_tool_file_patterns_list", textFieldEnabledValues, toolEnabledValues);
    }

    private void createExternalToolsComboBox(Composite parent) {
        Composite comboComposite = new Composite(parent, 0);
        comboComposite.setFont(JFaceResources.getDialogFont());
        this.externalToolsComboBox = new ComboFieldEditor("external_compare_previously_selected_compare_tool", Messages.ExternalCompareToolsPreferencePage_2, this.getComboBoxItems(), comboComposite){

            protected void doLoadDefault() {
            }
        };
        this.addField((FieldEditor)this.externalToolsComboBox);
        this.applyDialogFont(comboComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(comboComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comboComposite);
    }

    private void createTwoWayCompareGroup(Composite parent) {
        this.twoWayCompare = new Group(parent, 0);
        this.twoWayCompare.setFont(JFaceResources.getDialogFont());
        this.twoWayCompare.setText(Messages.ExternalCompareToolsPreferencePage_3);
        this.twoWayComparePathFileField = new CustomFileFieldEditor(this.customTool.get2WayCompareExecutablePathPrefKey(), Messages.ExternalCompareToolsPreferencePage_4, false, 0, (Composite)this.twoWayCompare);
        this.twoWayComparePathFileField.setChangeButtonText(Messages.BrowsableFilenameField_0);
        GridDataFactory.fillDefaults().hint(500, -1).grab(true, false).applyTo((Control)this.twoWayComparePathFileField.getTextControl((Composite)this.twoWayCompare));
        this.twoWayComparePathFileField.using2Way(true);
        this.twoWayComparePathFileField.setErrorMessage(Messages.ExternalCompareToolsPreferencePage_10);
        this.addField((FieldEditor)this.twoWayComparePathFileField);
        this.twoWayLocalCompareArgumentsStringField = new ArgumentStringFieldEditor(this.customTool.get2WayLocalCompareArgumentsPrefKey(), Messages.ExternalCompareToolsPreferencePage_5, StringFieldEditor.UNLIMITED, 0, this.twoWayCompare);
        this.twoWayLocalCompareArgumentsStringField.using2WayLocalCompareArguments(true);
        this.twoWayLocalCompareArgumentsStringField.setRequiredLabels(new String[]{"${file1Path}", "${file2Path}"});
        this.twoWayLocalCompareArgumentsStringField.setErrorMessage(NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_11, (Object)"${file1Path}", (Object[])new Object[]{"${file2Path}"}));
        this.addField((FieldEditor)this.twoWayLocalCompareArgumentsStringField);
        this.createContentAssist(this.twoWayLocalCompareArgumentsStringField, (Composite)this.twoWayCompare);
        GridDataFactory.fillDefaults().hint(500, -1).span(2, 1).grab(true, false).applyTo((Control)this.twoWayLocalCompareArgumentsStringField.getTextControl((Composite)this.twoWayCompare));
        this.twoWayRemoteCompareArgumentsStringField = new ArgumentStringFieldEditor(this.customTool.get2WayRemoteCompareArgumentsPrefKey(), Messages.ExternalCompareToolsPreferencePage_6, StringFieldEditor.UNLIMITED, 0, this.twoWayCompare);
        this.twoWayRemoteCompareArgumentsStringField.using2WayRemoteCompareArguments(true);
        this.twoWayRemoteCompareArgumentsStringField.setRequiredLabels(new String[]{"${file1Path}", "${file2Path}"});
        this.twoWayRemoteCompareArgumentsStringField.setErrorMessage(NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_12, (Object)"${file1Path}", (Object[])new Object[]{"${file2Path}"}));
        this.addField((FieldEditor)this.twoWayRemoteCompareArgumentsStringField);
        this.createContentAssist(this.twoWayRemoteCompareArgumentsStringField, (Composite)this.twoWayCompare);
        GridDataFactory.fillDefaults().hint(500, -1).span(2, 1).grab(true, false).applyTo((Control)this.twoWayRemoteCompareArgumentsStringField.getTextControl((Composite)this.twoWayCompare));
        this.applyDialogFont((Composite)this.twoWayCompare);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)this.twoWayCompare);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.twoWayCompare);
    }

    private void createThreeWayMergeGroup(Composite parent) {
        this.threeWayMerge = new Group(parent, 0);
        this.threeWayMerge.setFont(JFaceResources.getDialogFont());
        this.threeWayMerge.setText(Messages.ExternalCompareToolsPreferencePage_7);
        this.threeWayConflictComparePathFileField = new CustomFileFieldEditor(this.customTool.get3WayMergeExecutablePathPrefKey(), Messages.ExternalCompareToolsPreferencePage_8, false, 0, (Composite)this.threeWayMerge);
        this.threeWayConflictComparePathFileField.setChangeButtonText(Messages.JazzInputPatchPage_BROWSE);
        GridDataFactory.fillDefaults().hint(500, -1).grab(true, false).applyTo((Control)this.threeWayConflictComparePathFileField.getTextControl((Composite)this.threeWayMerge));
        this.threeWayConflictComparePathFileField.using3Way(true);
        this.threeWayConflictComparePathFileField.setErrorMessage(Messages.ExternalCompareToolsPreferencePage_13);
        this.addField((FieldEditor)this.threeWayConflictComparePathFileField);
        this.threeWayConflictCompareArgumentsStringField = new ArgumentStringFieldEditor(this.customTool.get3WayMergeArgumentsPrefKey(), Messages.ExternalCompareToolsPreferencePage_9, StringFieldEditor.UNLIMITED, 0, this.threeWayMerge);
        this.threeWayConflictCompareArgumentsStringField.using3WayMergeArguments(true);
        this.threeWayConflictCompareArgumentsStringField.setRequiredLabels(new String[]{"${file1Path}", "${file2Path}", "${ancestorFilePath}"});
        this.threeWayConflictCompareArgumentsStringField.setErrorMessage(NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_14, (Object)"${file1Path}", (Object[])new Object[]{"${file2Path}", "${ancestorFilePath}"}));
        this.addField((FieldEditor)this.threeWayConflictCompareArgumentsStringField);
        this.createContentAssist(this.threeWayConflictCompareArgumentsStringField, (Composite)this.threeWayMerge);
        GridDataFactory.fillDefaults().hint(500, -1).span(2, 1).grab(true, false).applyTo((Control)this.threeWayConflictCompareArgumentsStringField.getTextControl((Composite)this.threeWayMerge));
        this.threeWayAutoResolveArgumentsStringField = new ArgumentStringFieldEditor(this.customTool.getAutoResolveArgumentsPrefKey(), Messages.ExternalCompareToolsPreferencePage_AUTO_RESOLVE_ARGUMENTS_NAME, StringFieldEditor.UNLIMITED, 0, this.threeWayMerge);
        this.threeWayAutoResolveArgumentsStringField.setRequiredLabels(new String[]{"${file1Path}", "${file2Path}", "${ancestorFilePath}", "${mergeFilePath}"});
        this.threeWayAutoResolveArgumentsStringField.setErrorMessage(NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_AUTO_RESOLVE_MISSING_ARGUMENTS, (Object)"${file1Path}", (Object[])new Object[]{"${file2Path}", "${ancestorFilePath}", "${mergeFilePath}"}));
        this.addField((FieldEditor)this.threeWayAutoResolveArgumentsStringField);
        this.createContentAssist(this.threeWayAutoResolveArgumentsStringField, (Composite)this.threeWayMerge);
        GridDataFactory.fillDefaults().hint(500, -1).span(2, 1).grab(true, false).applyTo((Control)this.threeWayAutoResolveArgumentsStringField.getTextControl((Composite)this.threeWayMerge));
        this.threeWayAutoResolveArgumentsStringField.usingAutoResolveArguments(true);
        this.applyDialogFont((Composite)this.threeWayMerge);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)this.threeWayMerge);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.threeWayMerge);
    }

    private void createAutoResolveGroup(Composite parent) {
        this.autoResolve = new Group(parent, 0);
        this.autoResolve.setFont(JFaceResources.getDialogFont());
        this.autoResolve.setText(Messages.ExternalCompareToolsPreferencePage_AUTO_RESOLVE_GROUP_NAME);
        this.autoResolvePathFileField = new CustomFileFieldEditor(this.customTool.getAutoResolveExecutablePathPrefKey(), Messages.ExternalCompareToolsPreferencePage_AUTO_RESOLVE_EXECUTABLE_NAME, false, 0, (Composite)this.autoResolve);
        this.autoResolvePathFileField.setChangeButtonText(Messages.JazzInputPatchPage_BROWSE);
        GridDataFactory.fillDefaults().hint(500, -1).grab(true, false).applyTo((Control)this.autoResolvePathFileField.getTextControl((Composite)this.autoResolve));
        this.autoResolvePathFileField.usingAutoResolve(true);
        this.autoResolvePathFileField.setErrorMessage(Messages.ExternalCompareToolsPreferencePage_AUTO_RESOLVE_EXECUTABLE_ERROR);
        this.addField((FieldEditor)this.autoResolvePathFileField);
        this.autoResolveArgumentsStringField = new ArgumentStringFieldEditor(this.customTool.getCustomAutoResolveArgumentsPrefKey(), Messages.ExternalCompareToolsPreferencePage_AUTO_RESOLVE_ARGUMENTS_NAME, StringFieldEditor.UNLIMITED, 0, this.autoResolve);
        this.autoResolveArgumentsStringField.setRequiredLabels(new String[]{"${file1Path}", "${file2Path}", "${ancestorFilePath}", "${mergeFilePath}"});
        this.autoResolveArgumentsStringField.setErrorMessage(NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_AUTO_RESOLVE_MISSING_ARGUMENTS, (Object)"${file1Path}", (Object[])new Object[]{"${file2Path}", "${ancestorFilePath}", "${mergeFilePath}"}));
        this.addField((FieldEditor)this.autoResolveArgumentsStringField);
        this.createContentAssist(this.autoResolveArgumentsStringField, (Composite)this.autoResolve);
        GridDataFactory.fillDefaults().hint(500, -1).span(2, 1).grab(true, false).applyTo((Control)this.autoResolveArgumentsStringField.getTextControl((Composite)this.autoResolve));
        this.autoResolveArgumentsStringField.usingAutoResolveArguments(true);
        this.applyDialogFont((Composite)this.autoResolve);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)this.autoResolve);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.autoResolve);
    }

    private IPersistentPreferenceStore getCorePreferenceStore() {
        if (this.corePreferenceStore == null) {
            this.corePreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ibm.team.filesystem.rcp.core");
        }
        return this.corePreferenceStore;
    }

    protected void performDefaults() {
        for (FieldEditor field : this.editors) {
            field.loadDefault();
        }
    }

    public boolean performOk() {
        if (this.selectedTool == null) {
            return false;
        }
        if (!this.selectedTool.isCustom()) {
            this.autoResolvePathFileField.setStringValue(this.threeWayConflictComparePathFileField.getStringValue());
            this.autoResolveArgumentsStringField.setStringValue(this.threeWayAutoResolveArgumentsStringField.getStringValue());
        }
        this.autoResolveOptions.store();
        this.getCorePreferenceStore().setValue("external_auto_resolve_tool_path", this.autoResolvePathFileField.getStringValue());
        this.getCorePreferenceStore().setValue("external_auto_resolve_tool_args", this.autoResolveArgumentsStringField.getStringValue());
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("external_compare_previously_selected_compare_tool", this.selectedTool.getName());
        return super.performOk();
    }

    private String[][] getComboBoxItems() {
        ArrayList<String> externalCompareToolNames = new ArrayList<String>();
        if (this.externalCompareToolsMap != null) {
            externalCompareToolNames.addAll(this.externalCompareToolsMap.keySet());
            Collections.sort(externalCompareToolNames);
        }
        String[][] result = new String[externalCompareToolNames.size()][2];
        int i = 0;
        while (i < result.length) {
            String name;
            result[i][0] = name = (String)externalCompareToolNames.get(i);
            result[i][1] = name;
            ++i;
        }
        return result;
    }

    private void reloadExternalToolArgsFromPrefs() {
        if (this.selectedTool != null) {
            this.twoWayComparePathFileField.setPreferenceName(this.selectedTool.get2WayCompareExecutablePathPrefKey());
            this.twoWayComparePathFileField.load();
            this.twoWayLocalCompareArgumentsStringField.setPreferenceName(this.selectedTool.get2WayLocalCompareArgumentsPrefKey());
            this.twoWayLocalCompareArgumentsStringField.load();
            this.twoWayRemoteCompareArgumentsStringField.setPreferenceName(this.selectedTool.get2WayRemoteCompareArgumentsPrefKey());
            this.twoWayRemoteCompareArgumentsStringField.load();
            this.threeWayConflictComparePathFileField.setPreferenceName(this.selectedTool.get3WayMergeExecutablePathPrefKey());
            this.threeWayConflictComparePathFileField.load();
            this.threeWayConflictCompareArgumentsStringField.setPreferenceName(this.selectedTool.get3WayMergeArgumentsPrefKey());
            this.threeWayConflictCompareArgumentsStringField.load();
            this.threeWayAutoResolveArgumentsStringField.setPreferenceName(this.selectedTool.getAutoResolveArgumentsPrefKey());
            this.threeWayAutoResolveArgumentsStringField.load();
            if (this.selectedTool.isCustom()) {
                this.autoResolvePathFileField.setPreferenceName(this.selectedTool.getAutoResolveExecutablePathPrefKey());
                this.autoResolvePathFileField.load();
                this.autoResolveArgumentsStringField.setPreferenceName(this.selectedTool.getCustomAutoResolveArgumentsPrefKey());
                this.autoResolveArgumentsStringField.load();
            }
        } else {
            this.disableAllFields();
        }
    }

    private void modifyGroupEnablement() {
        if (this.selectedTool == null) {
            this.disableAllFields();
            return;
        }
        if (this.selectedTool.isCustom()) {
            this.twoWayComparePathFileField.setEnabled(true, (Composite)this.twoWayCompare);
            this.twoWayLocalCompareArgumentsStringField.setEnabled(true, (Composite)this.twoWayCompare);
            this.twoWayRemoteCompareArgumentsStringField.setEnabled(true, (Composite)this.twoWayCompare);
            this.threeWayConflictComparePathFileField.setEnabled(true, (Composite)this.threeWayMerge);
            this.threeWayConflictCompareArgumentsStringField.setEnabled(true, (Composite)this.threeWayMerge);
            this.threeWayAutoResolveArgumentsStringField.setEnabled(false, (Composite)this.threeWayMerge);
            this.autoResolve.setVisible(true);
            return;
        }
        this.autoResolve.setVisible(false);
        if (this.selectedTool.doesToolSupport2WayCompare()) {
            this.twoWayComparePathFileField.setEnabled(true, (Composite)this.twoWayCompare);
            this.twoWayLocalCompareArgumentsStringField.setEnabled(true, (Composite)this.twoWayCompare);
            this.twoWayRemoteCompareArgumentsStringField.setEnabled(true, (Composite)this.twoWayCompare);
        } else {
            this.twoWayComparePathFileField.setStringValue(null);
            this.twoWayComparePathFileField.setEnabled(false, (Composite)this.twoWayCompare);
            this.twoWayLocalCompareArgumentsStringField.setStringValue(null);
            this.twoWayLocalCompareArgumentsStringField.setEnabled(false, (Composite)this.twoWayCompare);
            this.twoWayRemoteCompareArgumentsStringField.setStringValue(null);
            this.twoWayRemoteCompareArgumentsStringField.setEnabled(false, (Composite)this.twoWayCompare);
        }
        if (this.selectedTool.doesToolSupport3WayMerge()) {
            this.threeWayConflictComparePathFileField.setEnabled(true, (Composite)this.threeWayMerge);
            this.threeWayConflictCompareArgumentsStringField.setEnabled(true, (Composite)this.threeWayMerge);
        } else {
            this.threeWayConflictComparePathFileField.setStringValue(null);
            this.threeWayConflictComparePathFileField.setEnabled(false, (Composite)this.threeWayMerge);
            this.threeWayConflictCompareArgumentsStringField.setStringValue(null);
            this.threeWayConflictCompareArgumentsStringField.setEnabled(false, (Composite)this.threeWayMerge);
        }
        if (this.selectedTool.doesToolSupportAutoResolve()) {
            this.autoResolveOptions.setEnabled(true);
            this.threeWayAutoResolveArgumentsStringField.setEnabled(this.autoResolveOptions.isExternalToolEnabled(), (Composite)this.threeWayMerge);
        } else {
            this.getCorePreferenceStore().setValue("external_auto_resolve_tool_policy", "never");
            this.autoResolveOptions.radioPreferenceValue = "never";
            this.autoResolveOptions.load();
            this.autoResolveOptions.setEnabled(false);
            this.threeWayAutoResolveArgumentsStringField.setEnabled(false, (Composite)this.threeWayMerge);
        }
    }

    private void disableAllFields() {
        this.twoWayComparePathFileField.setPreferenceName("");
        this.twoWayComparePathFileField.setEnabled(false, (Composite)this.twoWayCompare);
        this.twoWayComparePathFileField.setStringValue(null);
        this.twoWayLocalCompareArgumentsStringField.setPreferenceName("");
        this.twoWayLocalCompareArgumentsStringField.setEnabled(false, (Composite)this.twoWayCompare);
        this.twoWayLocalCompareArgumentsStringField.setStringValue(null);
        this.twoWayRemoteCompareArgumentsStringField.setPreferenceName("");
        this.twoWayRemoteCompareArgumentsStringField.setEnabled(false, (Composite)this.twoWayCompare);
        this.twoWayRemoteCompareArgumentsStringField.setStringValue(null);
        this.threeWayConflictComparePathFileField.setPreferenceName("");
        this.threeWayConflictComparePathFileField.setEnabled(false, (Composite)this.threeWayMerge);
        this.threeWayConflictComparePathFileField.setStringValue(null);
        this.threeWayConflictCompareArgumentsStringField.setPreferenceName("");
        this.threeWayConflictCompareArgumentsStringField.setEnabled(false, (Composite)this.threeWayMerge);
        this.threeWayConflictCompareArgumentsStringField.setStringValue(null);
    }

    private void updateErrorMessage() {
        if (this.errors.size() > 0) {
            Map.Entry<Object, String> entry = this.errors.entrySet().iterator().next();
            this.setErrorMessage(entry.getValue());
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private void addError(Object objectId, String message) {
        this.errors.put(objectId, message);
        this.setErrorMessage(message);
        this.setValid(false);
    }

    private void removeError(Object objectId) {
        this.errors.remove(objectId);
        if (this.errors.size() == 0) {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private void createContentAssist(final ArgumentStringFieldEditor argumentsField, Composite parent) {
        final ControlDecoration argsDecoration = new ControlDecoration((Control)argumentsField.getTextControl(parent), 16512);
        argsDecoration.hide();
        Listener nameListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    argsDecoration.show();
                }
                if (event.type == 27) {
                    argsDecoration.hide();
                }
            }
        };
        argumentsField.getTextControl(parent).addListener(26, nameListener);
        argumentsField.getTextControl(parent).addListener(27, nameListener);
        KeyStroke keyStroke = KeyStrokeUtil.getContentProposalKeyStroke();
        String contentMessage = NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_1, (Object)keyStroke.format(), (Object[])new Object[0]);
        argsDecoration.setDescriptionText(contentMessage);
        argsDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        IContentProposalProvider argsProposalProvider = null;
        if (argumentsField == this.twoWayLocalCompareArgumentsStringField) {
            argsProposalProvider = ExternalCompareToolsPreferencePage.getTwoWayLocalCompareArgsProposalProvider();
        } else if (argumentsField == this.twoWayRemoteCompareArgumentsStringField) {
            argsProposalProvider = ExternalCompareToolsPreferencePage.getTwoWayRemoteCompareArgsProposalProvider();
        } else if (argumentsField == this.threeWayConflictCompareArgumentsStringField) {
            argsProposalProvider = ExternalCompareToolsPreferencePage.getThreeWayMergeArgsProposalProvider();
        }
        if (argsProposalProvider != null) {
            ContentProposalAdapter argsProposalAdapter = new ContentProposalAdapter((Control)argumentsField.getTextControl(parent), (IControlContentAdapter)new TextContentAdapter(), argsProposalProvider, keyStroke, null);
            argsProposalAdapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    argumentsField.contentAssistItemAdded();
                }
            });
            if (argumentsField == this.twoWayLocalCompareArgumentsStringField) {
                argsProposalAdapter.setPopupSize(new Point(407, 129));
            } else if (argumentsField == this.twoWayRemoteCompareArgumentsStringField) {
                argsProposalAdapter.setPopupSize(new Point(374, 92));
            } else if (argumentsField == this.threeWayConflictCompareArgumentsStringField) {
                argsProposalAdapter.setPopupSize(new Point(422, 168));
            }
        }
    }

    private static IContentProposalProvider getTwoWayLocalCompareArgsProposalProvider() {
        LinkedHashMap<String, String> proposalMap = new LinkedHashMap<String, String>();
        proposalMap.put("${file1Path}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file1Path}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_3}));
        proposalMap.put("${file1Title}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file1Title}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_4}));
        proposalMap.put("${file2Path}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file2Path}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_5}));
        proposalMap.put("${file2Title}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file2Title}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_6}));
        proposalMap.put("${mergeFilePath}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${mergeFilePath}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_9}));
        proposalMap.put("${mergeFileTitle}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${mergeFileTitle}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_10}));
        CustomContentProposalProvider twoWayCompareProvider = new CustomContentProposalProvider(proposalMap);
        return twoWayCompareProvider;
    }

    private static IContentProposalProvider getTwoWayRemoteCompareArgsProposalProvider() {
        LinkedHashMap<String, String> proposalMap = new LinkedHashMap<String, String>();
        proposalMap.put("${file1Path}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file1Path}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_FILE1_PATH}));
        proposalMap.put("${file1Title}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file1Title}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_FILE1_TITLE}));
        proposalMap.put("${file2Path}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file2Path}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_FILE2_PATH}));
        proposalMap.put("${file2Title}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file2Title}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_FILE2_TITLE}));
        CustomContentProposalProvider twoWayCompareProvider = new CustomContentProposalProvider(proposalMap);
        return twoWayCompareProvider;
    }

    private static IContentProposalProvider getThreeWayMergeArgsProposalProvider() {
        LinkedHashMap<String, String> proposalMap = new LinkedHashMap<String, String>();
        proposalMap.put("${file1Path}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file1Path}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_3}));
        proposalMap.put("${file1Title}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file1Title}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_4}));
        proposalMap.put("${file2Path}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file2Path}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_5}));
        proposalMap.put("${file2Title}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${file2Title}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_6}));
        proposalMap.put("${ancestorFilePath}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${ancestorFilePath}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_7}));
        proposalMap.put("${ancestorFileTitle}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${ancestorFileTitle}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_8}));
        proposalMap.put("${mergeFilePath}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${mergeFilePath}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_9}));
        proposalMap.put("${mergeFileTitle}", NLS.bind((String)Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_2, (Object)"${mergeFileTitle}", (Object[])new Object[]{Messages.ExternalCompareToolsPreferencePage_CONTENT_ASSIST_10}));
        CustomContentProposalProvider threeWayMergeCompareProvider = new CustomContentProposalProvider(proposalMap);
        return threeWayMergeCompareProvider;
    }

    protected void createFieldEditors() {
    }

    private class ArgumentStringFieldEditor
    extends StringFieldEditor {
        private boolean using2WayLocalCompareArguments;
        private boolean using2WayRemoteCompareArguments;
        private boolean using3WayMergeArguments;
        private boolean usingAutoResolveArguments;
        private String[] requiredLabels;

        public ArgumentStringFieldEditor(String name, String labelText, int width, int strategy, Group parent) {
            super(name, labelText, width, strategy, (Composite)parent);
            this.using2WayLocalCompareArguments = false;
            this.using2WayRemoteCompareArguments = false;
            this.using3WayMergeArguments = false;
            this.usingAutoResolveArguments = false;
            this.requiredLabels = null;
        }

        public void using2WayLocalCompareArguments(boolean value) {
            this.using2WayLocalCompareArguments = value;
        }

        public void using2WayRemoteCompareArguments(boolean value) {
            this.using2WayRemoteCompareArguments = value;
        }

        public void using3WayMergeArguments(boolean value) {
            this.using3WayMergeArguments = value;
        }

        public void usingAutoResolveArguments(boolean value) {
            this.usingAutoResolveArguments = value;
        }

        public void setRequiredLabels(String[] requiredLabels) {
            this.requiredLabels = requiredLabels;
        }

        public void contentAssistItemAdded() {
            this.refreshValidState();
        }

        public boolean doCheckState() {
            boolean isValid = true;
            if (ExternalCompareToolsPreferencePage.this.selectedTool != null && this.getTextControl().isVisible() && (this.using2WayLocalCompareArguments && ExternalCompareToolsPreferencePage.this.selectedTool.doesToolSupport2WayCompare() || this.using2WayRemoteCompareArguments && ExternalCompareToolsPreferencePage.this.selectedTool.doesToolSupport2WayCompare() || this.using3WayMergeArguments && ExternalCompareToolsPreferencePage.this.selectedTool.doesToolSupport3WayMerge() || this.usingAutoResolveArguments && ExternalCompareToolsPreferencePage.this.selectedTool.doesToolSupportAutoResolve() && ExternalCompareToolsPreferencePage.this.autoResolveOptions.isExternalToolEnabled())) {
                String fieldText = this.getStringValue();
                if (fieldText == null) {
                    isValid = false;
                } else {
                    if (fieldText.equals("") && !ExternalCompareToolsPreferencePage.this.selectedTool.isCustom()) {
                        isValid = false;
                    }
                    if (this.requiredLabels != null && fieldText.length() > 0) {
                        String[] stringArray = this.requiredLabels;
                        int n = this.requiredLabels.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String label = stringArray[n2];
                            if (!fieldText.contains(label)) {
                                isValid = false;
                            }
                            ++n2;
                        }
                    }
                }
            }
            if (isValid) {
                ExternalCompareToolsPreferencePage.this.removeError((Object)this);
            } else {
                ExternalCompareToolsPreferencePage.this.addError((Object)this, this.getErrorMessage());
            }
            return isValid;
        }
    }

    private static class CustomContentProposalProvider
    implements IContentProposalProvider {
        private IContentProposal[] proposals;

        public CustomContentProposalProvider(Map<String, String> map) {
            this.proposals = new IContentProposal[map.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.proposals[i++] = new CustomContentPropsal(entry.getKey(), entry.getValue());
            }
        }

        public IContentProposal[] getProposals(String contents, int position) {
            return this.proposals;
        }
    }

    private static class CustomContentPropsal
    implements IContentProposal {
        private String content;
        private String label;

        public CustomContentPropsal(String propsal, String label) {
            this.content = propsal;
            this.label = label;
        }

        public String getContent() {
            return this.content;
        }

        public int getCursorPosition() {
            return this.content.length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private class CustomFileFieldEditor
    extends FileFieldEditor {
        private boolean using2Way;
        private boolean using3Way;
        private boolean usingAutoResolve;

        public CustomFileFieldEditor(String name, String labelText, boolean enforceAbsolute, int validationStrategy, Composite parent) {
            super(name, labelText, enforceAbsolute, validationStrategy, parent);
            this.using2Way = false;
            this.using3Way = false;
            this.usingAutoResolve = false;
        }

        public void setChangeButtonText(String text) {
            super.setChangeButtonText(text);
            Text textControl = this.getTextControl();
            if (textControl != null) {
                Button changeButton = this.getChangeControl(textControl.getParent());
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                int widthHint = this.convertHorizontalDLUsToPixels((Control)changeButton, 61);
                gd.widthHint = Math.max(widthHint, changeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
                changeButton.setLayoutData((Object)gd);
            }
        }

        public void using2Way(boolean value) {
            this.using2Way = value;
        }

        public void using3Way(boolean value) {
            this.using3Way = value;
        }

        public void usingAutoResolve(boolean value) {
            this.usingAutoResolve = value;
        }

        protected boolean checkState() {
            return this.doCheckState();
        }

        public boolean doCheckState() {
            boolean isValid = true;
            if (ExternalCompareToolsPreferencePage.this.selectedTool != null && this.getTextControl().isVisible() && (this.using2Way && ExternalCompareToolsPreferencePage.this.selectedTool.doesToolSupport2WayCompare() || this.using3Way && ExternalCompareToolsPreferencePage.this.selectedTool.doesToolSupport3WayMerge() || this.usingAutoResolve && ExternalCompareToolsPreferencePage.this.selectedTool.doesToolSupportAutoResolve() && ExternalCompareToolsPreferencePage.this.autoResolveOptions.isExternalToolEnabled())) {
                String fieldText = this.getStringValue();
                if (fieldText == null) {
                    isValid = false;
                } else {
                    if (fieldText.equals("") && !ExternalCompareToolsPreferencePage.this.selectedTool.isCustom()) {
                        isValid = false;
                    }
                    if (ExternalCompareToolsUtil.isMSWindows() && fieldText.length() > 0) {
                        try {
                            if (!new File(fieldText).exists()) {
                                isValid = false;
                            }
                        }
                        catch (SecurityException e) {
                            isValid = false;
                        }
                    }
                }
            }
            if (isValid) {
                ExternalCompareToolsPreferencePage.this.removeError((Object)this);
            } else {
                ExternalCompareToolsPreferencePage.this.addError((Object)this, this.getErrorMessage());
            }
            return isValid;
        }
    }

    class ExternalToolOptionsGroup {
        private Composite fileExtensionGroup;
        private Composite radioGroup;
        private RadioGroupFieldEditor radioFields;
        private StringFieldEditor textField;
        private String[] textFieldEnabledValues = new String[0];
        private String radioPreferenceKey;
        private String radioPreferenceValue;
        private String[] externalToolEnabledValues;

        public ExternalToolOptionsGroup(Composite parent, String groupLabel, String[][] labelsAndValues, IPreferenceStore store, String radioKey, String textKey, String[] textEnabled, String[] externalToolEnabled) {
            this.radioGroup = new Composite(parent, 0);
            this.radioGroup.setFont(JFaceResources.getDialogFont());
            this.externalToolEnabledValues = externalToolEnabled;
            this.radioPreferenceKey = radioKey;
            this.textFieldEnabledValues = textEnabled;
            this.radioFields = new RadioGroupFieldEditor(radioKey, groupLabel, 1, labelsAndValues, this.radioGroup, true){

                public void loadDefault() {
                    Control[] children;
                    super.loadDefault();
                    String selectedButton = null;
                    Control[] controlArray = children = this.getRadioBoxControl(ExternalToolOptionsGroup.this.radioGroup).getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Button button;
                        Control child = controlArray[n2];
                        if (child instanceof Button && (button = (Button)child).getSelection() && button.getData() instanceof String) {
                            selectedButton = (String)button.getData();
                        }
                        ++n2;
                    }
                    if (selectedButton != null) {
                        ExternalToolOptionsGroup.this.setTextFieldEnabled(selectedButton);
                    }
                }
            };
            ExternalCompareToolsPreferencePage.this.addField((FieldEditor)this.radioFields);
            ExternalCompareToolsPreferencePage.this.applyDialogFont(this.radioGroup);
            this.fileExtensionGroup = new Composite(this.radioGroup, 0);
            this.fileExtensionGroup.setFont(JFaceResources.getDialogFont());
            this.textField = new StringFieldEditor(textKey, Messages.ExternalCompareToolsPreferencePage_FILE_PATTERNS, StringFieldEditor.UNLIMITED, 0, this.fileExtensionGroup);
            ExternalCompareToolsPreferencePage.this.addField((FieldEditor)this.textField);
            if (store != null) {
                this.radioFields.setPreferenceStore(store);
                this.textField.setPreferenceStore(store);
            }
            GridLayoutFactory.fillDefaults().generateLayout(this.radioGroup);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.radioGroup);
            GridLayoutFactory.fillDefaults().generateLayout(this.fileExtensionGroup);
            GridDataFactory.fillDefaults().grab(false, false).indent(Math.abs(LayoutConstants2.getGroupMargins().x * 2), 0).applyTo((Control)this.fileExtensionGroup);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == this.radioFields) {
                this.radioPreferenceValue = (String)event.getNewValue();
                this.setTextFieldEnabled(this.radioPreferenceValue);
            }
        }

        public void setEnabled(boolean value) {
            this.radioFields.setEnabled(value, this.radioGroup);
            if (value) {
                this.setTextFieldEnabled(this.getRadioPreferenceValue());
            } else {
                this.textField.setEnabled(false, this.fileExtensionGroup);
            }
        }

        public void load() {
            this.radioFields.load();
            this.textField.load();
        }

        public void store() {
            this.radioFields.store();
            this.textField.store();
            IPreferenceStore store = this.radioFields.getPreferenceStore();
            if (store instanceof IPersistentPreferenceStore) {
                try {
                    ((IPersistentPreferenceStore)store).save();
                }
                catch (IOException e) {
                    ILog log = UiPlugin.getDefault().getLog();
                    log.log((IStatus)new Status(2, "com.ibm.team.filesystem.ide.ui", Messages.ExternalCompareToolsPreferencePage_ERROR_SAVING_PREFERENCES, (Throwable)e));
                }
            }
        }

        private void setTextFieldEnabled(String value) {
            boolean enabled = false;
            String[] stringArray = this.textFieldEnabledValues;
            int n = this.textFieldEnabledValues.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                enabled = enabled || s.equals(value);
                ++n2;
            }
            this.textField.setEnabled(enabled, this.fileExtensionGroup);
        }

        private String getRadioPreferenceValue() {
            if (this.radioPreferenceValue == null) {
                this.radioPreferenceValue = this.radioFields.getPreferenceStore().getString(this.radioPreferenceKey);
            }
            return this.radioPreferenceValue;
        }

        public void initialize() {
            this.load();
            this.setTextFieldEnabled(this.getRadioPreferenceValue());
        }

        public boolean isExternalToolEnabled() {
            String[] stringArray = this.externalToolEnabledValues;
            int n = this.externalToolEnabledValues.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(this.radioPreferenceValue)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

