/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.ide.ui.internal.logical.ComponentResourceMappingContext;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMWorkspaceConnectionState;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;

public class SCMResourceMappingContext
extends RemoteResourceMappingContext {
    private final SCMWorkspaceConnectionState connection;
    private final Collection<IItemConflictReport> conflicts;
    private final Collection<ResourceMapping> conflictingMappings;
    private Map<UUID, ComponentResourceMappingContext> components = new HashMap<UUID, ComponentResourceMappingContext>();
    private final Collection<ICopyFileArea> copyFileAreasToUpdate;

    public SCMResourceMappingContext(IWorkspaceConnection connection, Collection<IItemConflictReport> conflicts, Collection<ICopyFileArea> copyFileAreasToUpdate) {
        this.connection = new SCMWorkspaceConnectionState(connection);
        this.conflicts = conflicts;
        this.copyFileAreasToUpdate = copyFileAreasToUpdate;
        this.conflictingMappings = new ArrayList<ResourceMapping>(conflicts.size());
    }

    public IStorage fetchBaseContents(IFile file, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            ComponentResourceMappingContext info = this.getComponentInfo((IResource)file, (IProgressMonitor)progress.newChild(1));
            if (info != null) {
                IStorage iStorage = info.fetchAncestorContents((IResource)file, progress.newChild(1));
                return iStorage;
            }
            return null;
        }
        catch (TeamRepositoryException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    public IResource[] fetchMembers(IContainer container, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            HashSet<Object> members = new HashSet<Object>();
            members.addAll(Arrays.asList(container.members()));
            ComponentResourceMappingContext info = this.getComponentInfo((IResource)container, (IProgressMonitor)progress.newChild(1));
            if (info != null) {
                members.addAll(info.members(container, progress.newChild(3)));
            }
            IResource[] iResourceArray = members.toArray(new IResource[members.size()]);
            return iResourceArray;
        }
        catch (TeamRepositoryException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    public IStorage fetchRemoteContents(IFile file, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            ComponentResourceMappingContext info = this.getComponentInfo((IResource)file, (IProgressMonitor)progress.newChild(1));
            if (info != null) {
                IStorage iStorage = info.fetchRemoteContents((IResource)file, progress.newChild(1));
                return iStorage;
            }
            return null;
        }
        catch (TeamRepositoryException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    public IProject[] getProjects() {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (ResourceMapping mapping : this.conflictingMappings) {
            projects.addAll(Arrays.asList(mapping.getProjects()));
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public boolean hasLocalChange(IResource resource, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            ComponentResourceMappingContext info = this.getComponentInfo(resource, (IProgressMonitor)progress.newChild(1));
            if (info != null) {
                boolean bl = info.hasLocalChange(resource, progress.newChild(3));
                return bl;
            }
            return false;
        }
        catch (TeamRepositoryException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    public boolean hasRemoteChange(IResource resource, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            ComponentResourceMappingContext info = this.getComponentInfo(resource, (IProgressMonitor)progress.newChild(1));
            if (info != null) {
                boolean bl = info.hasRemoteChange(resource, progress.newChild(3));
                return bl;
            }
            return false;
        }
        catch (TeamRepositoryException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private ComponentResourceMappingContext getComponentInfo(IResource resource, IProgressMonitor monitor) throws FileSystemException {
        IShare share;
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        if (shareable != null && (share = shareable.getShare(monitor)) != null) {
            IComponentHandle component = share.getSharingDescriptor().getComponent();
            return this.components.get(component.getItemId());
        }
        return null;
    }

    static boolean sameState(IVersionableHandle ancestor, IVersionableHandle remote) {
        if (ancestor == null || remote == null) {
            return ancestor == remote;
        }
        return ancestor.sameItemId((IItemHandle)remote) && ancestor.sameStateId((IItemHandle)remote);
    }

    public boolean isThreeWay() {
        return true;
    }

    public void refresh(ResourceTraversal[] traversals, int flags, IProgressMonitor monitor) throws CoreException {
    }

    public void initialize(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        for (IItemConflictReport conflict : this.conflicts) {
            IComponentHandle component = conflict.getComponent();
            UUID itemId = component.getItemId();
            ComponentResourceMappingContext info = this.components.get(itemId);
            if (info == null) {
                info = new ComponentResourceMappingContext(this.connection, component, this.copyFileAreasToUpdate);
                this.components.put(itemId, info);
            }
            info.add(conflict);
        }
        progress.setWorkRemaining(this.components.size() * 10);
        for (ComponentResourceMappingContext info : this.components.values()) {
            try {
                info.initialize((IProgressMonitor)progress.newChild(9));
                this.conflictingMappings.addAll(info.getConflictingMappings(progress.newChild(1)));
            }
            catch (TeamRepositoryException e) {
                this.reportException(NLS.bind((String)"An error occurred attempting to calculate base for component {0}", (Object)info.componentHandle.getItemId().getUuidValue()), (Exception)((Object)e));
            }
        }
    }

    private void reportException(String message, Exception e) {
        StatusUtil.log((Object)((Object)this), (String)message, (Throwable)e);
    }

    public Collection<ResourceMapping> getConflictingResources() {
        return this.conflictingMappings;
    }

    private void populateTree(ResourceDiffTree tree, ResourceTraversal traversal, SubMonitor monitor) throws CoreException, TeamRepositoryException {
        IResource[] resources = traversal.getResources();
        monitor.setWorkRemaining(resources.length * 100);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.populateTree(tree, resource, traversal.getDepth(), monitor.newChild(100));
            ++n2;
        }
    }

    private void populateTree(ResourceDiffTree tree, IResource resource, int depth, SubMonitor monitor) throws CoreException, TeamRepositoryException {
        IDiff diff;
        ComponentResourceMappingContext info;
        monitor.setWorkRemaining(100);
        if (resource.getType() == 1 && (info = this.getComponentInfo(resource, (IProgressMonitor)monitor.newChild(20))) != null && (diff = info.getDiff(resource, monitor.newChild(20))) != null) {
            tree.add(diff);
        }
        if (depth != 0 && resource.getType() != 1) {
            IResource[] members = this.fetchMembers((IContainer)resource, (IProgressMonitor)monitor.newChild(20));
            monitor.setWorkRemaining(members.length * 100);
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                this.populateTree(tree, member, depth == 2 ? 2 : 0, monitor.newChild(100));
                ++n2;
            }
        }
    }

    public IResource[] handleUpdate(FileAreaUpdate update, ISynchronizationScope scope, Collection<ICopyFileArea> copyFileAreasToUpdate, IProgressMonitor monitor) {
        try {
            IResource resource;
            ComponentResourceMappingContext info = this.components.get(update.getComponent().getItemId());
            if (info != null && (resource = info.findResource(update.getItem(), monitor)) != null && scope.contains(resource) && resource.getType() == 1) {
                return new IResource[]{resource};
            }
        }
        catch (FileSystemException e) {
            this.reportException(NLS.bind((String)"An error occurred attempting to obtain a resource for item {0}", (Object)update.getItem().getItemId().getUuidValue()), (Exception)((Object)e));
        }
        catch (TeamRepositoryException e) {
            this.reportException(NLS.bind((String)"An error occurred attempting to obtain a resource for item {0}", (Object)update.getItem().getItemId().getUuidValue()), (Exception)((Object)e));
        }
        return new IResource[0];
    }

    public void dispose() {
        for (ComponentResourceMappingContext info : this.components.values()) {
            info.dispose();
        }
    }

    public void populateDiffTree(ISynchronizationScope scope, IResourceDiffTree diffTree, IProgressMonitor monitor) throws CoreException, TeamRepositoryException {
        ResourceTraversal[] traversals = scope.getTraversals();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(traversals.length * 100));
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            this.populateTree((ResourceDiffTree)diffTree, traversal, progress.newChild(100));
            ++n2;
        }
    }

    public IWorkspaceConnection getConnection() {
        return this.connection.getConnection();
    }
}

