/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMMergeContext;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMResourceMappingContext;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.provider.DiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelMergeOperation;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPageCompareEditorInput;
import org.eclipse.ui.progress.WorkbenchJob;

public class SCMModelMergeOperation
extends ModelMergeOperation {
    public static final Object MY_FAMILY = new Object();
    private ModelSynchronizeParticipant participant;
    private boolean ownsParticipant = true;
    private UpdateDilemmaHandler updateDilemmaHandler;

    static void dispose(ISynchronizationScopeManager manager) {
        if (manager != null) {
            SynchronizationScopeManager ssm;
            ResourceMappingContext context;
            if (manager instanceof SynchronizationScopeManager && (context = (ssm = (SynchronizationScopeManager)manager).getContext()) instanceof SCMResourceMappingContext) {
                SCMResourceMappingContext srmc = (SCMResourceMappingContext)context;
                srmc.dispose();
            }
            manager.dispose();
        }
    }

    protected SCMModelMergeOperation(ISynchronizationScopeManager manager, UpdateDilemmaHandler dilemmaHandler) {
        super(null, manager);
        this.updateDilemmaHandler = dilemmaHandler;
    }

    protected void initializeContext(IProgressMonitor monitor) throws CoreException {
        if (this.participant == null) {
            this.participant = ModelSynchronizeParticipant.createParticipant((SynchronizationContext)new SCMMergeContext(this.getScopeManager(), this.updateDilemmaHandler), (String)Messages.SCMModelMergeOperation_ParticipantName);
            this.participant.getContext().refresh(this.getScope().getTraversals(), 1, monitor);
            try {
                Job.getJobManager().join((Object)this.participant.getContext(), monitor);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected ISynchronizationContext getContext() {
        if (this.participant != null) {
            return this.participant.getContext();
        }
        return null;
    }

    protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            SCMMergeContext mergeContext = (SCMMergeContext)this.getContext();
            try {
                mergeContext.setDelayMarkAsMerged(true);
                super.execute((IProgressMonitor)progress.newChild(75));
            }
            finally {
                mergeContext.setDelayMarkAsMerged(false);
            }
            try {
                mergeContext.performMarkAsMerged((IProgressMonitor)progress.newChild(25));
            }
            catch (FileSystemException e) {
                throw new InvocationTargetException(e);
            }
            catch (TeamRepositoryException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (this.ownsParticipant && this.participant != null) {
                this.cleanup();
            }
        }
    }

    protected void handleMergeFailure(IStatus status) {
        this.handlePreviewRequest();
    }

    protected void handlePreviewRequest() {
        WorkbenchJob job = new WorkbenchJob(this.getJobName()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    CompareConfiguration cc = new CompareConfiguration();
                    ISynchronizePageConfiguration pageConfiguration = SCMModelMergeOperation.this.participant.createPageConfiguration();
                    if (pageConfiguration.getComparisonType() == "three-way") {
                        pageConfiguration.setSupportedModes(9);
                        pageConfiguration.setMode(1);
                    }
                    SCMCompareEditorInput input = new SCMCompareEditorInput(cc, pageConfiguration, (ISynchronizeParticipant)SCMModelMergeOperation.this.participant);
                    CompareUI.openCompareDialog((CompareEditorInput)input);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    SCMModelMergeOperation.this.cleanup();
                }
            }
        };
        this.ownsParticipant = false;
        job.schedule();
    }

    protected void cleanup() {
        try {
            if (this.participant != null) {
                this.participant.dispose();
            }
        }
        finally {
            SCMModelMergeOperation.dispose(this.getScopeManager());
        }
    }

    public Collection<IShare> getRemainingShares(SubMonitor monitor) throws FileSystemException {
        IDiff[] remainingDiffs = ((DiffTree)this.getContext().getDiffTree()).getDiffs();
        return this.getShares(remainingDiffs, monitor);
    }

    private Collection<IShare> getShares(IDiff[] remainingDiffs, SubMonitor monitor) throws FileSystemException {
        HashSet<IShare> result = new HashSet<IShare>();
        monitor.setWorkRemaining(remainingDiffs.length);
        IDiff[] iDiffArray = remainingDiffs;
        int n = remainingDiffs.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IShare share;
            IDiff diff = iDiffArray[n2];
            if (((IThreeWayDiff)diff).getRemoteChange() != null && (share = this.getShare(resource = ResourceDiffTree.getResourceFor((IDiff)diff), monitor.newChild(1))) != null) {
                result.add(share);
            }
            ++n2;
        }
        return result;
    }

    private IShare getShare(IResource resource, SubMonitor monitor) throws FileSystemException {
        Object adapter = resource.getAdapter(IShareable.class);
        if (adapter instanceof IShareable) {
            IShareable shareable = (IShareable)adapter;
            return shareable.getShare((IProgressMonitor)monitor);
        }
        return null;
    }

    protected String getJobName() {
        return Messages.SCMModelMergeOperation_JobName;
    }

    public boolean belongsTo(Object family) {
        return family == MY_FAMILY;
    }

    protected boolean canRunAsJob() {
        return true;
    }

    private final class SCMCompareEditorInput
    extends ParticipantPageCompareEditorInput {
        Control control;

        private SCMCompareEditorInput(CompareConfiguration configuration, ISynchronizePageConfiguration pageConfiguration, ISynchronizeParticipant participant) {
            super(configuration, pageConfiguration, participant);
        }

        protected boolean isOfferToRememberParticipant() {
            return false;
        }

        public Control createContents(Composite parent) {
            this.control = super.createContents(parent);
            return this.control;
        }

        public void saveChanges(final IProgressMonitor monitor) throws CoreException {
            if (Display.getCurrent() == null) {
                final CoreException[] exception = new CoreException[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SCMCompareEditorInput.super.saveChanges(monitor);
                        }
                        catch (CoreException e) {
                            exception[0] = e;
                        }
                    }
                });
                if (exception[0] != null) {
                    throw exception[0];
                }
            } else {
                super.saveChanges(monitor);
            }
        }
    }
}

