/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IMarkAsMergedOperation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMResourceDiff;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMResourceMappingContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;

public class SCMMergeContext
extends MergeContext {
    private final List<IDiff> toMarkAsMerged = new ArrayList<IDiff>();
    private UpdateDilemmaHandler updateDilemmaHandler;
    private boolean populated = false;
    private boolean delayMarkAsMerged;

    protected SCMMergeContext(ISynchronizationScopeManager manager, UpdateDilemmaHandler updateDilemmaHandler) {
        super(manager, 3, (IResourceDiffTree)new ResourceDiffTree());
        this.updateDilemmaHandler = updateDilemmaHandler;
    }

    protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
        ((ResourceDiffTree)this.getDiffTree()).remove(diff.getPath());
    }

    private static Shareable getShareable(IDiff diff) {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        Shareable shareable = SCMMergeContext.getShareable(resource);
        return shareable;
    }

    public static IItemConflictReport getConflict(IDiff diff) {
        IThreeWayDiff twd;
        ITwoWayDiff remoteChange;
        if (diff instanceof IThreeWayDiff && (remoteChange = (twd = (IThreeWayDiff)diff).getRemoteChange()) instanceof SCMResourceDiff) {
            return ((SCMResourceDiff)remoteChange).getConflict();
        }
        return null;
    }

    private static Shareable getShareable(IResource resource) {
        Object adapter;
        if (resource != null && (adapter = resource.getAdapter(IShareable.class)) instanceof Shareable) {
            return (Shareable)adapter;
        }
        return null;
    }

    public void markAsMerged(final IDiff diff, final boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    SCMMergeContext.this.markAsMergedInternal(diff, inSyncHint, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        this.runWithLocks(runnable, new IDiff[]{diff}, monitor);
    }

    private void markAsMergedInternal(IDiff diff, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        IItemConflictReport conflict = SCMMergeContext.getConflict(diff);
        if (conflict != null) {
            this.toMarkAsMerged.add(diff);
        }
        ((ResourceDiffTree)this.getDiffTree()).remove(diff.getPath());
    }

    public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
        this.markAsMerged(diff, false, monitor);
    }

    public void refresh(ResourceTraversal[] traversals, int flags, IProgressMonitor monitor) throws CoreException {
        if (!this.populated) {
            ResourceMappingContext context = ((SynchronizationScopeManager)this.getScopeManager()).getContext();
            try {
                ((SCMResourceMappingContext)context).populateDiffTree(this.getScope(), this.getDiffTree(), monitor);
            }
            catch (TeamRepositoryException e) {
                throw new CoreException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
            }
            this.populated = true;
        }
    }

    public List<IDiff> getToMarkAsMerged() {
        return this.toMarkAsMerged;
    }

    public IStatus merge(final IDiff diff, final boolean ignoreLocalChanges, IProgressMonitor monitor) throws CoreException {
        final IStatus[] result = new IStatus[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    result[0] = SCMMergeContext.super.merge(diff, ignoreLocalChanges, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        this.runWithLocks(runnable, new IDiff[]{diff}, monitor);
        return result[0];
    }

    public IStatus merge(final IDiff[] deltas, final boolean force, IProgressMonitor monitor) throws CoreException {
        final IStatus[] result = new IStatus[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    result[0] = SCMMergeContext.super.merge(deltas, force, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        this.runWithLocks(runnable, deltas, monitor);
        return result[0];
    }

    public void markAsMerged(final IDiff[] diffs, final boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    SCMMergeContext.super.markAsMerged(diffs, inSyncHint, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        this.runWithLocks(runnable, diffs, monitor);
    }

    public void reject(IDiff[] diffs, IProgressMonitor monitor) throws CoreException {
        this.markAsMerged(diffs, false, monitor);
    }

    public ISchedulingRule getMergeRule(IDiff diff) {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void runWithLocks(final IRunnableWithProgress runnable, IDiff[] deltas, IProgressMonitor monitor) throws CoreException {
        Set<ConfigurationFacade> affectedConfigurations;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        try {
            affectedConfigurations = SCMMergeContext.getAffectedConfigurations(this.getConnection(), deltas, progress.newChild(1));
        }
        catch (FileSystemException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
        if (this.delayMarkAsMerged) {
            this.runWithLocks(runnable, affectedConfigurations, (IProgressMonitor)progress.newChild(100));
        } else {
            IRunnableWithProgress outerRunnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    boolean oldDelayMarkAsMerged = SCMMergeContext.this.delayMarkAsMerged;
                    try {
                        try {
                            SCMMergeContext.this.delayMarkAsMerged = true;
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(oldDelayMarkAsMerged ? 50 : 100));
                            runnable.run((IProgressMonitor)progress.newChild(50));
                            if (!oldDelayMarkAsMerged) {
                                SCMMergeContext.this.performMarkAsMerged((IProgressMonitor)progress.newChild(50));
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        SCMMergeContext.this.delayMarkAsMerged = oldDelayMarkAsMerged;
                    }
                }
            };
            this.runWithLocks(outerRunnable, affectedConfigurations, (IProgressMonitor)progress.newChild(100));
        }
    }

    private void runWithLocks(IRunnableWithProgress runnable, Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IWorkspaceRoot workspaceRule = ResourcesPlugin.getWorkspace().getRoot();
            Job.getJobManager().beginRule((ISchedulingRule)workspaceRule, (IProgressMonitor)progress.newChild(1));
            try {
                try {
                    ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                    ICopyFileAreasLock cfaLock = ICopyFileAreaManager.instance.lock(Collections.singletonList(lockRequest), (IProgressMonitor)progress.newChild(1));
                    try {
                        try {
                            runnable.run((IProgressMonitor)progress.newChild(95));
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof CoreException) {
                                throw (CoreException)cause;
                            }
                            if (cause instanceof FileSystemStatusException) {
                                throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)cause));
                            }
                            throw new CoreException(StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)cause));
                        }
                        catch (InterruptedException e) {
                            throw new OperationCanceledException();
                        }
                    }
                    finally {
                        cfaLock.release((IProgressMonitor)progress.newChild(1));
                    }
                }
                catch (FileSystemException e) {
                    throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
                }
            }
            finally {
                Job.getJobManager().endRule((ISchedulingRule)workspaceRule);
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    public static Set<ConfigurationFacade> getAffectedConfigurations(IWorkspaceConnection connection, IDiff[] deltas, SubMonitor progress) throws FileSystemException {
        HashSet<ConfigurationFacade> result = new HashSet<ConfigurationFacade>();
        progress.setWorkRemaining(deltas.length);
        IDiff[] iDiffArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            IComponentHandle component = SCMMergeContext.getComponent(diff, progress.newChild(1));
            result.add(new ConfigurationFacade((IConnection)connection, component));
            ++n2;
        }
        return result;
    }

    private static IComponentHandle getComponent(IDiff diff, SubMonitor progress) throws FileSystemException {
        Shareable shareable = SCMMergeContext.getShareable(diff);
        IShare share = shareable.getShare((IProgressMonitor)progress);
        return share.getSharingDescriptor().getComponent();
    }

    private IWorkspaceConnection getConnection() {
        return SCMMergeContext.getConnection(this.getScopeManager());
    }

    public static IWorkspaceConnection getConnection(ISynchronizationScopeManager manager) {
        SynchronizationScopeManager scopeManager = (SynchronizationScopeManager)manager;
        SCMResourceMappingContext context = (SCMResourceMappingContext)scopeManager.getContext();
        return context.getConnection();
    }

    public void performMarkAsMerged(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (this.toMarkAsMerged != null && !this.toMarkAsMerged.isEmpty()) {
            IWorkspaceConnection connection = SCMMergeContext.getConnection(this.getScopeManager());
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IFileSystemView fsv = FileSystemCore.getFileSystemManager((ITeamRepository)connection.teamRepository()).getFileSystemView((IConnection)connection);
            ILogicalConflictReport conflictReport = fsv.conflictReport((IProgressMonitor)progress.newChild(10));
            ArrayList changes = new ArrayList();
            for (IDiff diff : this.toMarkAsMerged) {
                IItemConflictReport conflict = SCMMergeContext.getConflict(diff);
                if (conflict == null) continue;
                IVersionableHandle handle = conflict.item();
                Collection conflictChanges = conflictReport.getChange(conflict.getComponent(), handle);
                changes.addAll(conflictChanges);
            }
            MarkAsMergedDilemmaHandler problemHandler = new MarkAsMergedDilemmaHandler(){

                public int uncheckedInChanges(Collection<ILocalChange> changes) {
                    return 0;
                }

                public int unmergedChanges(Collection<ILogicalChange> changes) {
                    return 0;
                }

                public int confirmMarkAsMerged(Collection<ILogicalChange> changes) {
                    return 0;
                }

                public BackupDilemmaHandler getBackupDilemmaHandler() {
                    if (SCMMergeContext.this.updateDilemmaHandler != null) {
                        return SCMMergeContext.this.updateDilemmaHandler.getBackupDilemmaHandler();
                    }
                    return super.getBackupDilemmaHandler();
                }
            };
            try {
                IMarkAsMergedOperation mergedOp = IOperationFactory.instance.getMarkAsMergedOperation(problemHandler);
                mergedOp.setContext(connection, conflictReport);
                mergedOp.addChangesToResolve(changes);
                mergedOp.run((IProgressMonitor)progress.newChild(90));
            }
            finally {
                this.toMarkAsMerged.clear();
            }
        }
    }

    public void setDelayMarkAsMerged(boolean delayMarkAsMerged) {
        this.delayMarkAsMerged = delayMarkAsMerged;
    }
}

