/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.ide.ui.internal.logical.ComponentResourceMappingContext;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class SCMFileRevision
extends FileRevision {
    private final ComponentResourceMappingContext componentInfo;
    private final IFileItem fileItem;

    public SCMFileRevision(ComponentResourceMappingContext componentInfo, IFileItem fileItem) {
        this.componentInfo = componentInfo;
        this.fileItem = fileItem;
    }

    public IFileItem getFileItem() {
        return this.fileItem;
    }

    public String getName() {
        return this.fileItem.getName();
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        try {
            return this.componentInfo.getStorage(this.fileItem, monitor);
        }
        catch (FileSystemException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)e));
        }
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return this;
    }

    public String getContentIdentifier() {
        return this.fileItem.getStateId().getUuidValue();
    }

    public long getTimestamp() {
        return this.fileItem.getFileTimestamp().getTime();
    }

    public String getAuthor() {
        return super.getAuthor();
    }

    public String getComment() {
        return super.getComment();
    }
}

