/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.ide.ui.internal.logical.PartialFileSystemView;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMResourceMappingContext;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMWorkspaceConnectionState;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class RemoteFileSystemView {
    private final SCMWorkspaceConnectionState connection;
    private final IComponentHandle componentHandle;
    private final PartialFileSystemView ancestorFileView;
    private final Map<UUID, IItemConflictReport> conflicts;

    public RemoteFileSystemView(SCMWorkspaceConnectionState connection, IComponentHandle componentHandle, PartialFileSystemView ancestorFileView, Map<UUID, IItemConflictReport> conflicts) {
        this.connection = connection;
        this.componentHandle = componentHandle;
        this.ancestorFileView = ancestorFileView;
        this.conflicts = conflicts;
    }

    private IConfiguration getRemoteConfiguration() throws ItemNotFoundException, ComponentNotInWorkspaceException {
        return this.connection.getConnection().configuration(this.componentHandle);
    }

    public IVersionableHandle getState(IShareable shareable, SubMonitor monitor) throws TeamRepositoryException {
        IItemConflictReport conflict;
        monitor.setWorkRemaining(10);
        IVersionableHandle localState = shareable.getRemote((IProgressMonitor)monitor.newChild(1));
        if (localState != null && (conflict = this.getConflict(localState)) != null) {
            if (!this.isMoved(localState, (IProgressMonitor)monitor.newChild(1))) {
                return conflict.getProposedContributorState();
            }
            return null;
        }
        IVersionableHandle workspaceState = this.getWorkspaceState(shareable, monitor.newChild(1));
        if (workspaceState != null && this.isConflict(workspaceState)) {
            IItemConflictReport conflict2 = this.getConflict(workspaceState);
            return conflict2.getProposedContributorState();
        }
        if (!SCMResourceMappingContext.sameState(workspaceState, localState)) {
            return workspaceState;
        }
        String[] remotePath = null;
        ILogicalConflictReport conflictReport = this.getConflictReport((IProgressMonitor)monitor.newChild(1));
        Collection logicalConflicts = conflictReport.conflicts();
        for (Object object : logicalConflicts) {
            if (!(object instanceof ILogicalConflict)) continue;
            ILogicalConflict lc = (ILogicalConflict)object;
            if (lc.beforeState() == null) {
                if (remotePath == null) {
                    remotePath = this.getWorkspacePath(workspaceState, monitor.newChild(1));
                }
                if (!this.pathsEqual(remotePath, lc.getPathHint())) continue;
                return lc.afterState();
            }
            if (lc.conflictType() == 10) {
                IVersionableHandle ancestorState = this.ancestorFileView.getState(shareable, monitor.newChild(1));
                if (ancestorState == null || !ancestorState.sameStateId((IItemHandle)lc.beforeState())) continue;
                return lc.afterState();
            }
            Collection pendingChanges = conflictReport.getPendingChanges(this.componentHandle, (IChangeSummary)lc);
            for (ILogicalChange pc : pendingChanges) {
                if (!pc.isChangeType(8) || !this.pathsOverlap(shareable, pc.getNewPathHint(), monitor.newChild(1))) continue;
                return pc.afterState();
            }
        }
        return this.ancestorFileView.getState(shareable, monitor.newChild(1));
    }

    private boolean pathsOverlap(IShareable shareable, String[] newPathHint, SubMonitor monitor) throws TeamRepositoryException {
        if (shareable == null || newPathHint == null || newPathHint.length == 0) {
            return false;
        }
        return this.pathsOverlap(shareable, newPathHint, newPathHint.length - 1, monitor);
    }

    private boolean pathsOverlap(IShareable shareable, String[] newPathHint, int segment, SubMonitor monitor) throws TeamRepositoryException {
        IShare share;
        if (segment < 0 || shareable == null) {
            return true;
        }
        if (shareable.getLocalPath().getName().equals(newPathHint[segment])) {
            return this.pathsOverlap(CoreShareablesUtil.getParent((IShareable)shareable), newPathHint, segment - 1, monitor);
        }
        if (shareable.isShare((IProgressMonitor)monitor) && (share = shareable.getShare((IProgressMonitor)monitor)).isLoadedWithAnotherName((IProgressMonitor)monitor)) {
            IVersionable item = this.getRemoteConfiguration().fetchCompleteItem(share.getSharingDescriptor().getRootVersionable(), (IProgressMonitor)monitor);
            return item.getName().equals(newPathHint[segment]);
        }
        return false;
    }

    private boolean isMoved(IVersionableHandle localState, IProgressMonitor monitor) throws TeamRepositoryException {
        ILogicalConflictReport conflictReport = this.getConflictReport(monitor);
        for (ILogicalConflict lc : conflictReport.conflicts()) {
            if (!lc.item().sameItemId((IItemHandle)localState) || !lc.component().sameItemId((IItemHandle)this.componentHandle)) continue;
            Collection pendingChanges = conflictReport.getPendingChanges(this.componentHandle, (IChangeSummary)lc);
            for (ILogicalChange pc : pendingChanges) {
                if (!pc.isChangeType(8)) continue;
                return true;
            }
        }
        return false;
    }

    protected ILogicalConflictReport getConflictReport(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.connection.getConflictReport(monitor);
    }

    private String[] getWorkspacePath(IVersionableHandle state, SubMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        List history = this.determineAncestorsInHistory(Collections.singletonList(state), (IProgressMonitor)monitor);
        IAncestorReport report = (IAncestorReport)history.get(0);
        report.getNameItemPairs();
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : report.getNameItemPairs()) {
            INameItemPair pair = (INameItemPair)object;
            if (pair.getName() == null || pair.getName().length() <= 0) continue;
            result.add(pair.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean pathsEqual(String[] path1, String[] path2) {
        if (path1.length == path2.length) {
            int i = 0;
            while (i < path2.length) {
                if (!path1[i].equals(path2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IVersionableHandle getWorkspaceState(IShareable shareable, SubMonitor monitor) throws FileSystemException {
        String searchPath;
        IShareable parent;
        monitor.setWorkRemaining(11);
        if (shareable.getResourceType((IProgressMonitor)monitor.newChild(1)) == ResourceType.FOLDER) {
            parent = shareable;
            searchPath = "";
        } else {
            parent = CoreShareablesUtil.getParent((IShareable)shareable);
            searchPath = shareable.getLocalPath().getName();
        }
        IVersionable remote = null;
        try {
            while (true) {
                if (shareable == null || remote != null) {
                    if (remote == null) return null;
                    try {
                        if (!PathUtils.isEmptyPath((String)searchPath)) return this.getRemoteConfiguration().resolvePath((IFolderHandle)remote, PathUtils.getSegments((String)searchPath), (IProgressMonitor)monitor.newChild(1));
                        return remote;
                    }
                    catch (ItemNotFoundException parentShareable) {
                        return null;
                    }
                }
                IShareable parentShareable = (IShareable)parent.getAdapter(IShareable.class);
                if (parentShareable == null) {
                    return null;
                }
                IVersionableHandle handle = parentShareable.getRemote((IProgressMonitor)monitor.newChild(1));
                if (handle == null) {
                    searchPath = PathUtils.appendPath((String)parentShareable.getLocalPath().getName(), (String)searchPath);
                } else {
                    try {
                        remote = this.getRemoteConfiguration().fetchCompleteItem(handle, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (ItemNotFoundException itemNotFoundException) {
                        // empty catch block
                    }
                }
                shareable = parentShareable;
            }
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private boolean isConflict(IVersionableHandle handle) {
        return this.getConflict(handle) != null;
    }

    IItemConflictReport getConflict(IVersionableHandle handle) {
        if (handle == null) {
            return null;
        }
        return this.conflicts.get(handle.getItemId());
    }

    public Map childEntries(IFolderHandle folderHandle, IProgressMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        return this.getRemoteConfiguration().childEntries(folderHandle, monitor);
    }

    public List determineAncestorsInHistory(List<IVersionableHandle> versionableHandles, IProgressMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        return this.getRemoteConfiguration().determineAncestorsInHistory(versionableHandles, monitor);
    }

    public IVersionable getItem(IVersionableHandle handle, SubMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        IItemConflictReport conflict = this.getConflict(handle);
        if (conflict != null) {
            ILogicalConflictReport conflictReport = this.getConflictReport((IProgressMonitor)monitor);
            for (ILogicalConflict lc : conflictReport.conflicts()) {
                if (!lc.item().sameItemId((IItemHandle)handle) || !lc.component().sameItemId((IItemHandle)this.componentHandle)) continue;
                Collection pendingChanges = conflictReport.getPendingChanges(this.componentHandle, (IChangeSummary)lc);
                for (ILogicalChange pc : pendingChanges) {
                    if (!pc.isChangeType(8)) continue;
                    IVersionableHandle afterState = pc.afterState();
                    IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.connection.getConnection().teamRepository()).versionableManager();
                    return versionableManager.fetchCompleteState(afterState, (IProgressMonitor)monitor.newChild(1));
                }
            }
        }
        return this.getRemoteConfiguration().fetchCompleteItem(handle, (IProgressMonitor)monitor);
    }

    public IShareable getShareable(IVersionableHandle handle, SubMonitor monitor) throws TeamRepositoryException {
        String relativePath;
        IFolderHandle folder;
        if (handle instanceof IFolderHandle) {
            folder = (IFolderHandle)handle;
            relativePath = "";
        } else {
            IVersionable item = this.getItem(handle, monitor);
            folder = item.getParent();
            relativePath = item.getName();
        }
        while (folder != null) {
            IShareable folderShareable = this.findShareable(folder, monitor);
            if (folderShareable != null) {
                return FileSystemCore.getSharingManager().findShareable(folderShareable.getFullPath().append(relativePath), ResourceType.getResourceType((IVersionableHandle)handle));
            }
            IVersionable item = this.getItem((IVersionableHandle)folder, monitor);
            folder = item.getParent();
            relativePath = PathUtils.appendPath((String)item.getName(), (String)relativePath);
        }
        return null;
    }

    private IShareable findShareable(IFolderHandle folder, SubMonitor monitor) throws FileSystemException {
        Set shareables = CoreShareablesUtil.findShareables((IContextHandle)this.connection.getConnection().getContextHandle(), (IComponentHandle)this.componentHandle, (IVersionableHandle)folder, (IProgressMonitor)monitor.newChild(1));
        for (IShareable shareable : shareables) {
            if (shareable.getAdapter(IResource.class) == null) continue;
            return shareable;
        }
        return null;
    }
}

