/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.ide.ui.internal.logical.IChangeSetFilter;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class PartialFileSystemView {
    private static final NameComparator COMPARATOR = new NameComparator();
    private IWorkspaceConnection workspace;
    private IComponent component;
    private ITeamRepository repo;
    private Map<UUID, IVersionable> latestItemStates;
    private Map<UUID, IVersionableHandle> latestInRepo;
    private SortedMap<NameInParent, IVersionableHandle> childMap;
    private Map<UUID, NameInParent> parentMap;
    private Set<UUID> allChildrenKnown;
    private IFolderHandle root;

    public PartialFileSystemView(IWorkspaceConnection workspace, IComponent component) {
        this.workspace = workspace;
        this.repo = workspace.teamRepository();
        this.latestItemStates = new HashMap<UUID, IVersionable>();
        this.latestInRepo = new HashMap<UUID, IVersionableHandle>();
        this.root = component.getRootFolder();
        this.component = component;
        this.childMap = new TreeMap<NameInParent, IVersionableHandle>(COMPARATOR);
        this.parentMap = new HashMap<UUID, NameInParent>();
        this.allChildrenKnown = new HashSet<UUID>();
        NameInParent nip = new NameInParent("", null);
        this.childMap.put(nip, (IVersionableHandle)this.root);
        this.parentMap.put(this.root.getItemId(), nip);
    }

    public void addChangeSet(IChangeSet changeSet, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IVersionableHandle> toFetch = new ArrayList<IVersionableHandle>(changeSet.changes().size());
        for (IChange change : changeSet.changes()) {
            if (change.afterState() != null) {
                toFetch.add(change.afterState());
                continue;
            }
            this.latestItemStates.put(change.item().getItemId(), null);
        }
        for (IVersionable versionable : this.fetchStates(toFetch, monitor)) {
            this.latestItemStates.put(versionable.getItemId(), versionable);
        }
        this.buildChildMap();
    }

    public void discardChangeSets(IChangeSetFilter changeSetFilter, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PartialFileSystemView_DiscardingChangeSetsTaskName, (int)2100);
        this.latestItemStates = new HashMap<UUID, IVersionable>();
        this.latestInRepo = new HashMap<UUID, IVersionableHandle>();
        HashMap<UUID, IVersionableHandle> latestStates = new HashMap<UUID, IVersionableHandle>();
        HashMap<UUID, IVersionableHandle> itemsInDiscardedChanges = new HashMap<UUID, IVersionableHandle>();
        IUpdateReport report = this.workspace.conflictReport();
        for (IItemConflictReport r : report.getConflictsForComponent((IComponentHandle)this.component)) {
            this.latestInRepo.put(r.item().getItemId(), r.getSelectedContributorState());
        }
        int workLeft = 1000;
        IChangeHistory history = this.workspace.changeHistory((IComponentHandle)this.component);
        while (!(changeSetFilter.allDiscarded() && itemsInDiscardedChanges.isEmpty() || history == null)) {
            int ticks = workLeft / 2;
            workLeft -= ticks;
            SubMonitor subProgress = progress.newChild(ticks);
            subProgress.beginTask("", 100);
            if (changeSetFilter.allDiscarded()) {
                IConfiguration configuration = history.configuration();
                ArrayList itemHandles = new ArrayList(itemsInDiscardedChanges.values());
                List items = configuration.fetchCompleteItems(itemHandles, monitor);
                int i = 0;
                while (i < items.size()) {
                    IVersionable item = (IVersionable)items.get(0);
                    if (item != null) {
                        this.keepState((IVersionableHandle)item, (IVersionableHandle)item, latestStates, itemsInDiscardedChanges);
                    }
                    ++i;
                }
                history = null;
            } else {
                List recentHist = history.recent((IProgressMonitor)subProgress.newChild(30));
                List recent = new ArrayList<IChangeSetHandle>(recentHist.size());
                for (IChangeHistoryEntryChange historyEntry : recentHist) {
                    recent.add(historyEntry.changeSet());
                }
                if (!recent.isEmpty()) {
                    recent = this.repo.itemManager().fetchCompleteItems(recent, 0, (IProgressMonitor)subProgress.newChild(60));
                }
                ListIterator i = recent.listIterator(recent.size());
                while (i.hasPrevious()) {
                    IChangeSet cs = (IChangeSet)i.previous();
                    boolean discard = changeSetFilter.excludeChangeSet(cs);
                    for (IChange change : cs.changes()) {
                        if (!this.latestInRepo.containsKey(change.item().getItemId())) {
                            this.latestInRepo.put(change.item().getItemId(), change.afterState());
                        }
                        if (discard) {
                            this.discardChange(change, latestStates, itemsInDiscardedChanges);
                            continue;
                        }
                        this.keepChange(change, latestStates, itemsInDiscardedChanges);
                    }
                }
                history = history.previousHistory((IProgressMonitor)subProgress.newChild(recent.isEmpty() ? 70 : 10));
            }
            subProgress.done();
        }
        this.updateLatestItemStatesWithDeletions(itemsInDiscardedChanges.keySet());
        this.updateLatestItemStatesWithHandles(latestStates, (IProgressMonitor)progress.newChild(1000 + workLeft));
        this.buildChildMap();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.done();
    }

    private void discardChange(IChange change, Map<UUID, IVersionableHandle> latestStates, Map<UUID, IVersionableHandle> itemsInDiscardedChanges) {
        if (!latestStates.containsKey(change.item().getItemId())) {
            itemsInDiscardedChanges.put(change.item().getItemId(), change.item());
        }
    }

    private void keepChange(IChange change, Map<UUID, IVersionableHandle> latestStates, Map<UUID, IVersionableHandle> itemsInDiscardedChanges) {
        IVersionableHandle item = change.item();
        IVersionableHandle state = change.afterState();
        this.keepState(item, state, latestStates, itemsInDiscardedChanges);
    }

    private void keepState(IVersionableHandle item, IVersionableHandle state, Map<UUID, IVersionableHandle> latestStates, Map<UUID, IVersionableHandle> itemsInDiscardedChanges) {
        if (!latestStates.containsKey(item.getItemId())) {
            latestStates.put(item.getItemId(), state);
            itemsInDiscardedChanges.remove(item.getItemId());
        }
    }

    private void updateLatestItemStatesWithDeletions(Set<UUID> deletions) throws TeamRepositoryException {
        Iterator<UUID> i = deletions.iterator();
        while (i.hasNext()) {
            this.latestItemStates.put(i.next(), null);
        }
    }

    private void updateLatestItemStatesWithHandles(Map<UUID, IVersionableHandle> latestStates, IProgressMonitor monitor) throws TeamRepositoryException {
        List<Object> states = new ArrayList(latestStates.size());
        for (Map.Entry<UUID, IVersionableHandle> entry : latestStates.entrySet()) {
            IVersionableHandle handle = entry.getValue();
            if (handle == null) {
                this.latestItemStates.put(entry.getKey(), null);
                continue;
            }
            IVersionableHandle repostate = this.latestInRepo.get(entry.getKey());
            if (PartialFileSystemView.statesEqual(repostate, handle)) continue;
            states.add(handle);
        }
        states = this.fetchStates(states, monitor);
        for (IVersionable iVersionable : states) {
            this.latestItemStates.put(iVersionable.getItemId(), iVersionable);
        }
    }

    private List<IVersionable> fetchStates(List<? extends IVersionableHandle> states, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!states.isEmpty()) {
            return SCMPlatform.getWorkspaceManager((ITeamRepository)this.repo).versionableManager().fetchCompleteStates(states, monitor);
        }
        monitor.beginTask("", 1);
        monitor.done();
        return Collections.EMPTY_LIST;
    }

    private void buildChildMap() {
        this.childMap = new TreeMap<NameInParent, IVersionableHandle>(COMPARATOR);
        this.parentMap = new HashMap<UUID, NameInParent>();
        this.allChildrenKnown = new HashSet<UUID>();
        NameInParent nip = new NameInParent("", null);
        this.childMap.put(nip, (IVersionableHandle)this.root);
        this.parentMap.put(this.root.getItemId(), nip);
        for (IVersionable versionable : this.latestItemStates.values()) {
            if (versionable == null || versionable.sameItemId((IItemHandle)this.root)) continue;
            nip = new NameInParent(versionable.getName(), versionable.getParent());
            this.childMap.put(nip, (IVersionableHandle)versionable);
            this.parentMap.put(versionable.getItemId(), nip);
        }
    }

    private static boolean statesEqual(IVersionableHandle v1, IVersionableHandle v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (!v1.getItemId().equals((Object)v2.getItemId())) {
            return false;
        }
        if (v1.getStateId() == v2.getStateId()) {
            return true;
        }
        if (v1.getStateId() == null || v2.getStateId() == null) {
            return false;
        }
        return v1.getStateId().equals((Object)v2.getStateId());
    }

    public String getPath(IVersionableHandle item, boolean returnPartial, IProgressMonitor monitor) throws TeamRepositoryException {
        String path = "";
        int ticksLeft = 1000;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ticksLeft);
        HashSet<UUID> seenItems = new HashSet<UUID>();
        block0: while (true) {
            if (item.sameItemId((IItemHandle)this.root)) {
                if (path.length() != 0) break;
                path = "/";
                break;
            }
            if (!seenItems.add(item.getItemId())) {
                monitor.done();
                return returnPartial ? path : null;
            }
            NameInParent nip = this.parentMap.get(item.getItemId());
            if (nip == null) {
                IVersionable fullItem = this.latestItemStates.get(item.getItemId());
                if (fullItem != null) {
                    throw new IllegalStateException();
                }
                if (this.latestItemStates.containsKey(item.getItemId())) {
                    monitor.done();
                    return returnPartial ? path : null;
                }
                int ticks = ticksLeft / 2;
                ticksLeft -= ticks;
                List nameItemPairs = ((IAncestorReport)this.workspace.configuration((IComponentHandle)this.component).locateAncestors(Collections.singletonList(item), (IProgressMonitor)progress.newChild(ticks)).get(0)).getNameItemPairs();
                if (nameItemPairs.size() == 0) {
                    monitor.done();
                    return returnPartial ? path : null;
                }
                ListIterator i = nameItemPairs.listIterator(nameItemPairs.size());
                while (true) {
                    if (i.previousIndex() == 0) {
                        return path;
                    }
                    INameItemPair pair = (INameItemPair)i.previous();
                    IVersionable latest = this.latestItemStates.get(pair.getItem().getItemId());
                    if (latest == null && this.latestItemStates.containsKey(pair.getItem().getItemId())) {
                        monitor.done();
                        return returnPartial ? path : null;
                    }
                    INameItemPair parentPair = (INameItemPair)i.previous();
                    if (latest != null) {
                        path = "/" + latest.getName() + path;
                        if (!latest.getParent().sameItemId((IItemHandle)parentPair.getItem())) {
                            item = latest.getParent();
                            continue block0;
                        }
                    } else {
                        nip = new NameInParent(pair.getName(), (IFolderHandle)parentPair.getItem());
                        this.childMap.put(nip, pair.getItem());
                        this.parentMap.put(pair.getItem().getItemId(), nip);
                        path = "/" + pair.getName() + path;
                    }
                    i.next();
                }
            }
            path = "/" + nip.name + path;
            item = nip.parent;
        }
        monitor.done();
        return path;
    }

    public IVersionable getItem(IVersionableHandle item, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getAndUpdateLatest(item, monitor);
    }

    public Map<String, IVersionableHandle> getChildren(IFolderHandle item, IProgressMonitor monitor) throws TeamRepositoryException {
        this.findAllChildren(item, monitor);
        NameInParent nip = new NameInParent(null, item);
        return this.getChildrenInternal(nip);
    }

    public List<Map<String, IVersionableHandle>> getChildren(List<IFolderHandle> parents, IProgressMonitor monitor) throws TeamRepositoryException {
        this.findAllChildren(parents, monitor);
        NameInParent nip = new NameInParent(null, null);
        ArrayList<Map<String, IVersionableHandle>> result = new ArrayList<Map<String, IVersionableHandle>>(parents.size());
        Iterator<IFolderHandle> iterator = parents.iterator();
        while (iterator.hasNext()) {
            IFolderHandle parent;
            nip.parent = parent = iterator.next();
            result.add(this.getChildrenInternal(nip));
        }
        return result;
    }

    private Map<String, IVersionableHandle> getChildrenInternal(NameInParent nip) {
        HashMap<String, IVersionableHandle> result = new HashMap<String, IVersionableHandle>();
        SortedMap<NameInParent, IVersionableHandle> tail = this.childMap.tailMap(nip);
        for (Map.Entry<NameInParent, IVersionableHandle> entry : tail.entrySet()) {
            NameInParent nip2 = entry.getKey();
            if (!nip.parent.sameItemId((IItemHandle)nip2.parent)) break;
            result.put(nip2.name, entry.getValue());
        }
        return result;
    }

    private void findAllChildren(IFolderHandle item, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (this.allChildrenKnown.contains(item.getItemId())) {
            monitor.done();
            return;
        }
        if (this.latestInRepo.get(item.getItemId()) == null && this.latestInRepo.containsKey(item.getItemId())) {
            monitor.done();
            return;
        }
        Map children = this.workspace.configuration((IComponentHandle)this.component).childEntries(item, (IProgressMonitor)progress.newChild(1));
        for (Map.Entry e : children.entrySet()) {
            if (this.latestItemStates.containsKey(((IVersionableHandle)e.getValue()).getItemId())) continue;
            NameInParent nip = new NameInParent((String)e.getKey(), item);
            this.childMap.put(nip, (IVersionableHandle)e.getValue());
            this.parentMap.put(((IVersionableHandle)e.getValue()).getItemId(), nip);
        }
        this.allChildrenKnown.add(item.getItemId());
        monitor.done();
    }

    private void findAllChildren(List<IFolderHandle> parents, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        ArrayList<IFolderHandle> notDone = new ArrayList<IFolderHandle>(parents.size());
        for (IFolderHandle parent : parents) {
            if (this.allChildrenKnown.contains(parent.getItemId()) || this.latestInRepo.get(parent.getItemId()) == null && this.latestInRepo.containsKey(parent.getItemId())) continue;
            notDone.add(parent);
        }
        List childrenMap = this.workspace.configuration((IComponentHandle)this.component).childEntries(notDone, (IProgressMonitor)progress.newChild(1));
        Iterator it = notDone.iterator();
        for (Map children : childrenMap) {
            IFolderHandle parent = (IFolderHandle)it.next();
            if (children == null) continue;
            for (Map.Entry child : children.entrySet()) {
                if (this.latestItemStates.containsKey(((IVersionableHandle)child.getValue()).getItemId())) continue;
                NameInParent nip = new NameInParent((String)child.getKey(), parent);
                this.childMap.put(nip, (IVersionableHandle)child.getValue());
                this.parentMap.put(((IVersionableHandle)child.getValue()).getItemId(), nip);
            }
            this.allChildrenKnown.add(parent.getItemId());
        }
        monitor.done();
    }

    public List<IVersionable> getItems(List<? extends IVersionableHandle> items, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getAndUpdateLatest(items, monitor);
    }

    public IVersionable locate(String path, IProgressMonitor monitor) throws TeamRepositoryException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String[] segments = path.split("/");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(segments.length + 1));
        if (segments.length == 0 || segments.length == 1 && segments[0].equals("")) {
            IVersionable item = this.getAndUpdateLatest((IVersionableHandle)this.root, (IProgressMonitor)progress.newChild(1));
            monitor.done();
            return item;
        }
        IFolderHandle parent = this.root;
        NameInParent toFind = new NameInParent(null, null);
        int i = 0;
        while (i < segments.length - 1) {
            toFind.name = segments[i];
            toFind.parent = parent;
            IVersionableHandle child = this.findChild(toFind, (IProgressMonitor)progress.newChild(1));
            if (!(child instanceof IFolderHandle)) {
                return null;
            }
            parent = (IFolderHandle)child;
            ++i;
        }
        toFind.name = segments[segments.length - 1];
        toFind.parent = parent;
        IVersionableHandle child = this.findChild(toFind, (IProgressMonitor)progress.newChild(1));
        if (child == null) {
            return null;
        }
        IVersionable item = this.getAndUpdateLatest(child, (IProgressMonitor)progress.newChild(1));
        monitor.done();
        return item;
    }

    private IVersionableHandle findChild(NameInParent toFind, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IVersionableHandle child = (IVersionableHandle)this.childMap.get(toFind);
        if (child != null) {
            monitor.done();
            return child;
        }
        this.findAllChildren(toFind.parent, (IProgressMonitor)progress.newChild(1));
        monitor.done();
        return (IVersionableHandle)this.childMap.get(toFind);
    }

    private IVersionable getAndUpdateLatest(IVersionableHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionable item = this.latestItemStates.get(handle.getItemId());
        if (item == null) {
            if (this.latestItemStates.containsKey(handle.getItemId())) {
                throw new ItemNotFoundException(Messages.PartialFileSystemView_ItemDoesNotExistError);
            }
            item = this.workspace.configuration((IComponentHandle)this.component).fetchCompleteItem(handle, monitor);
            this.updateItemStateFromRepo(item);
        } else {
            monitor.beginTask("", 1);
            monitor.done();
        }
        return item;
    }

    private List<IVersionable> getAndUpdateLatest(List<? extends IVersionableHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        List<Object> toFetch = new ArrayList<IVersionableHandle>();
        for (IVersionableHandle iVersionableHandle : handles) {
            if (this.latestItemStates.containsKey(iVersionableHandle.getItemId())) continue;
            toFetch.add(iVersionableHandle);
        }
        if (!toFetch.isEmpty()) {
            toFetch = this.workspace.configuration((IComponentHandle)this.component).fetchCompleteItems(toFetch, monitor);
        } else {
            monitor.beginTask("", 1);
            monitor.done();
        }
        for (IVersionable iVersionable : toFetch) {
            if (iVersionable == null) continue;
            this.updateItemStateFromRepo(iVersionable);
        }
        ArrayList<IVersionable> arrayList = new ArrayList<IVersionable>(handles.size());
        for (IVersionableHandle iVersionableHandle : handles) {
            arrayList.add(this.latestItemStates.get(iVersionableHandle.getItemId()));
        }
        return arrayList;
    }

    private void updateItemStateFromRepo(IVersionable item) {
        this.latestInRepo.put(item.getItemId(), (IVersionableHandle)item);
        this.latestItemStates.put(item.getItemId(), item);
        NameInParent nip = new NameInParent(item.getName() == null ? "" : item.getName(), item.getParent());
        this.childMap.put(nip, (IVersionableHandle)item);
        this.parentMap.put(item.getItemId(), nip);
    }

    public IWorkspaceConnection createView(String name, IWorkspaceConnection optionalViewTarget, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection newWorkspace;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (optionalViewTarget == null) {
            IAuditableHandle owner = this.workspace.getOwner();
            if (!(owner instanceof IContributorHandle)) {
                owner = this.workspace.teamRepository().loggedInContributor();
            }
            newWorkspace = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repo).createWorkspace((IContributorHandle)owner, name, "", (IProgressMonitor)progress.newChild(5));
        } else {
            newWorkspace = optionalViewTarget;
        }
        progress.setWorkRemaining(100);
        progress = progress.newChild(100);
        if (!this.createChildView(newWorkspace, (IProgressMonitor)progress)) {
            this.createRootView(newWorkspace, (IProgressMonitor)progress);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.done();
        return newWorkspace;
    }

    private static boolean hasComponent(IWorkspaceConnection workspace, IComponentHandle component) throws TeamRepositoryException {
        Iterator i = workspace.getComponents().iterator();
        while (i.hasNext()) {
            if (!((IComponentHandle)i.next()).sameItemId((IItemHandle)component)) continue;
            return true;
        }
        return false;
    }

    private boolean createChildView(IWorkspaceConnection targetWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.workspace.activeChangeSets((IComponentHandle)this.component).isEmpty()) {
            return false;
        }
        ArrayList<IVersionableHandle> reverts = new ArrayList<IVersionableHandle>();
        ArrayList<IVersionableHandle> deletes = new ArrayList<IVersionableHandle>();
        for (Map.Entry<UUID, IVersionable> entry : this.latestItemStates.entrySet()) {
            UUID id = entry.getKey();
            IVersionable item = entry.getValue();
            IVersionableHandle latest = this.latestInRepo.get(id);
            if (PartialFileSystemView.statesEqual(latest, (IVersionableHandle)item)) continue;
            if (item == null) {
                deletes.add(latest);
                continue;
            }
            reverts.add((IVersionableHandle)item);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (PartialFileSystemView.hasComponent(targetWorkspace, (IComponentHandle)this.component)) {
            targetWorkspace.dropComponent((IComponentHandle)this.component, false, (IProgressMonitor)progress.newChild(5));
        }
        progress.setWorkRemaining(100);
        targetWorkspace.addComponent((IComponentHandle)this.component, (IFlowNodeConnection)this.workspace, false, (IProgressMonitor)progress.newChild(50));
        this.commit(reverts, Collections.EMPTY_LIST, deletes, targetWorkspace, (IProgressMonitor)progress.newChild(50));
        monitor.done();
        return true;
    }

    private void createRootView(IWorkspaceConnection targetWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (PartialFileSystemView.hasComponent(targetWorkspace, (IComponentHandle)this.component)) {
            targetWorkspace.dropComponent((IComponentHandle)this.component, false, (IProgressMonitor)progress.newChild(5));
        }
        progress.setWorkRemaining(100);
        targetWorkspace.addComponent((IComponentHandle)this.component, false, (IProgressMonitor)progress.newChild(5));
        if (this.latestItemStates.get(this.root.getItemId()) == null && this.latestItemStates.containsKey(this.root.getItemId())) {
            monitor.done();
            return;
        }
        Collection<IVersionableHandle> reverts = this.traverseTree((IProgressMonitor)progress.newChild(90));
        this.commit(reverts, Collections.EMPTY_LIST, Collections.EMPTY_LIST, targetWorkspace, (IProgressMonitor)progress.newChild(5));
        monitor.done();
    }

    private Collection<IVersionableHandle> traverseTree(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        HashMap<UUID, Object> items = new HashMap<UUID, Object>((int)((double)this.latestItemStates.size() / 0.75));
        ArrayList<IFolderHandle> parents = new ArrayList<IFolderHandle>();
        for (IVersionableHandle iVersionableHandle : this.latestItemStates.values()) {
            if (iVersionableHandle == null) continue;
            items.put(iVersionableHandle.getItemId(), iVersionableHandle);
            if (!(iVersionableHandle instanceof IFolderHandle)) continue;
            parents.add((IFolderHandle)iVersionableHandle);
        }
        parents.add(this.root);
        while (!parents.isEmpty()) {
            progress.setWorkRemaining(6);
            List<Map<String, IVersionableHandle>> list = this.getChildren(parents, (IProgressMonitor)progress.newChild(1));
            ArrayList<IVersionableHandle> toFetch = new ArrayList<IVersionableHandle>();
            for (Map<String, IVersionableHandle> children : list) {
                for (IVersionableHandle child : children.values()) {
                    if (items.containsKey(child.getItemId())) continue;
                    toFetch.add(child);
                }
            }
            List<IVersionable> fetched = this.getItems(toFetch, (IProgressMonitor)progress.newChild(1));
            parents.clear();
            for (IVersionable item : fetched) {
                items.put(item.getItemId(), item);
                if (!(item instanceof IFolderHandle)) continue;
                parents.add((IFolderHandle)item);
            }
        }
        monitor.done();
        return items.values();
    }

    private void commit(Collection<IVersionableHandle> reverts, Collection<IVersionable> saves, Collection<IVersionableHandle> deletes, IWorkspaceConnection workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<Object> ops = new ArrayList<Object>(reverts.size() + saves.size() + deletes.size());
        for (IVersionableHandle iVersionableHandle : reverts) {
            ops.add(workspace.configurationOpFactory().revert(iVersionableHandle));
        }
        for (IVersionable iVersionable : saves) {
            ops.add(workspace.configurationOpFactory().save(iVersionable));
        }
        for (IVersionableHandle iVersionableHandle : deletes) {
            ops.add(workspace.configurationOpFactory().delete(iVersionableHandle));
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IChangeSetHandle changeSet = workspace.createChangeSet((IComponentHandle)this.component, (IProgressMonitor)subMonitor.newChild(25));
        workspace.commit(changeSet, ops, (IProgressMonitor)subMonitor.newChild(50));
        workspace.closeChangeSets(Collections.singletonList(changeSet), (IProgressMonitor)subMonitor.newChild(25));
    }

    public IVersionableHandle getState(IShareable shareable, SubMonitor monitor) throws FileSystemException {
        block12: {
            String searchPath;
            IShareable parent;
            monitor.setWorkRemaining(11);
            if (shareable.getResourceType((IProgressMonitor)monitor.newChild(1)) == ResourceType.FOLDER) {
                parent = shareable;
                searchPath = "";
            } else {
                parent = CoreShareablesUtil.getParent((IShareable)shareable);
                searchPath = shareable.getLocalPath().getName();
            }
            IVersionable remote = null;
            try {
                while (parent != null && remote == null) {
                    IVersionableHandle handle = parent.getRemote((IProgressMonitor)monitor.newChild(1));
                    if (handle != null) {
                        try {
                            remote = this.getItem(handle, (IProgressMonitor)monitor.newChild(1));
                        }
                        catch (ItemNotFoundException itemNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (remote != null) continue;
                    searchPath = PathUtils.appendPath((String)parent.getLocalPath().getName(), (String)searchPath);
                    parent = CoreShareablesUtil.getParent((IShareable)parent);
                }
                if (remote == null) break block12;
                try {
                    if (PathUtils.isEmptyPath((String)searchPath)) {
                        return remote;
                    }
                    String shareRemotePath = this.getPath((IVersionableHandle)remote, false, (IProgressMonitor)monitor.newChild(1));
                    if (shareRemotePath != null) {
                        return this.locate(PathUtils.appendPath((String)shareRemotePath, (String)searchPath), (IProgressMonitor)monitor.newChild(1));
                    }
                }
                catch (ItemNotFoundException shareRemotePath) {}
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        return null;
    }

    private static class NameComparator
    implements Comparator<NameInParent> {
        private NameComparator() {
        }

        @Override
        public int compare(NameInParent o1, NameInParent o2) {
            if (o1.parent == null) {
                if (o2.parent == null) {
                    return 0;
                }
                return -1;
            }
            if (o2.parent == null) {
                return 1;
            }
            if (!o1.parent.sameItemId((IItemHandle)o2.parent)) {
                return o1.parent.getItemId().getUuidValue().compareTo(o2.parent.getItemId().getUuidValue());
            }
            if (o1.name == null) {
                if (o2.name == null) {
                    return 0;
                }
                return -1;
            }
            if (o2.name == null) {
                return 1;
            }
            return o1.name.compareTo(o2.name);
        }
    }

    private static class NameInParent {
        protected String name;
        protected IFolderHandle parent;

        private NameInParent(String name, IFolderHandle parent) {
            this.name = name;
            this.parent = parent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameInParent)) {
                return false;
            }
            NameInParent other = (NameInParent)o;
            if (other.parent == null) {
                if (this.parent != null) {
                    return false;
                }
            } else {
                if (this.parent == null) {
                    return false;
                }
                if (!this.parent.sameItemId((IItemHandle)other.parent)) {
                    return false;
                }
            }
            return other.name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode() ^ (this.parent == null ? 0 : this.parent.getItemId().hashCode());
        }
    }
}

