/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ModelEnablementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer tableViewer;
    private final Map<String, IModelProviderDescriptor> descriptors = new HashMap<String, IModelProviderDescriptor>();
    private BooleanFieldEditor logicalModelSupportEnabled;

    protected Control createContents(Composite parent) {
        IModelProviderDescriptor[] modelProviderDescriptors;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.logicalModelSupportEnabled = new BooleanFieldEditor("logical_model_support", Messages.SourceControlPreferencePage_LogicalModelSupportEnablementButton, composite);
        this.logicalModelSupportEnabled.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), FileSystemResourcesPlugin.getDefault().getBundle().getSymbolicName()));
        this.logicalModelSupportEnabled.load();
        this.logicalModelSupportEnabled.setPage((DialogPage)this);
        this.logicalModelSupportEnabled.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ModelEnablementPreferencePage.this.tableViewer.getTable().setEnabled(ModelEnablementPreferencePage.this.logicalModelSupportEnabled.getBooleanValue());
            }
        });
        Label l = new Label(composite, 64);
        l.setText(Messages.ModelEnablementPreferencePage_0);
        l.setLayoutData((Object)new GridData(768));
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object element) {
                if (element instanceof Map) {
                    return ((Map)element).values().toArray();
                }
                return new Object[0];
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            Map<String, Image> images = new HashMap<String, Image>();

            public String getText(Object element) {
                if (element instanceof IModelProviderDescriptor) {
                    IModelProviderDescriptor desc = (IModelProviderDescriptor)element;
                    return this.getTextFor(desc);
                }
                return super.getText(element);
            }

            private String getTextFor(IModelProviderDescriptor modelDesc) {
                String name;
                ITeamContentProviderDescriptor contentDesc = TeamUI.getTeamContentProviderManager().getDescriptor(modelDesc.getId());
                if (contentDesc != null && (name = contentDesc.getName()) != null && !name.equals("")) {
                    return name;
                }
                name = modelDesc.getLabel();
                if (name != null && !name.equals("")) {
                    return name;
                }
                return modelDesc.getId();
            }

            public Image getImage(Object element) {
                if (element instanceof IModelProviderDescriptor) {
                    IModelProviderDescriptor modelDesc = (IModelProviderDescriptor)element;
                    ITeamContentProviderDescriptor contentDesc = TeamUI.getTeamContentProviderManager().getDescriptor(modelDesc.getId());
                    if (contentDesc != null) {
                        ImageDescriptor idesc;
                        Image image = this.images.get(modelDesc.getId());
                        if (image == null && (idesc = contentDesc.getImageDescriptor()) != null && (image = idesc.createImage()) != null) {
                            this.images.put(modelDesc.getId(), image);
                        }
                        return image;
                    }
                }
                return super.getImage(element);
            }

            public void dispose() {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
                super.dispose();
            }
        });
        IModelProviderDescriptor[] iModelProviderDescriptorArray = modelProviderDescriptors = ModelProvider.getModelProviderDescriptors();
        int n = modelProviderDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor desc = iModelProviderDescriptorArray[n2];
            if (!desc.getId().equals("org.eclipse.core.resources.modelProvider")) {
                this.descriptors.put(desc.getId(), desc);
            }
            ++n2;
        }
        this.tableViewer.setInput(this.descriptors);
        this.updateTable();
        this.applyDialogFont(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.team.filesystem.ide.ui.preference_page_logical_models");
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.logicalModelSupportEnabled.loadDefault();
        this.tableViewer.setAllChecked(false);
    }

    private void updateTable() {
        boolean isEnabled = this.logicalModelSupportEnabled.getBooleanValue();
        this.tableViewer.getTable().setEnabled(isEnabled);
        if (isEnabled) {
            HashSet<IModelProviderDescriptor> toCheck = new HashSet<IModelProviderDescriptor>();
            String providersString = UiPlugin.getDefault().getPluginPreferences().getString("prefs_enabled_model_providers");
            if (providersString != null) {
                StringTokenizer tokenizer = new StringTokenizer(providersString, ",");
                while (tokenizer.hasMoreTokens()) {
                    String id = tokenizer.nextToken().trim();
                    IModelProviderDescriptor desc = this.descriptors.get(id);
                    if (desc == null) continue;
                    toCheck.add(desc);
                }
            }
            this.tableViewer.setCheckedElements(toCheck.toArray());
        }
    }

    public boolean performOk() {
        this.logicalModelSupportEnabled.store();
        try {
            ((ScopedPreferenceStore)this.logicalModelSupportEnabled.getPreferenceStore()).save();
        }
        catch (IOException e) {
            StatusUtil.log((IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
        boolean isEnabled = this.logicalModelSupportEnabled.getBooleanValue();
        if (isEnabled) {
            Object[] checked;
            String providerStrings = "";
            Object[] objectArray = checked = this.tableViewer.getCheckedElements();
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IModelProviderDescriptor) {
                    IModelProviderDescriptor desc = (IModelProviderDescriptor)object;
                    providerStrings = providerStrings.length() == 0 ? desc.getId() : String.valueOf(providerStrings) + "," + desc.getId();
                }
                ++n2;
            }
            UiPlugin.getDefault().getPluginPreferences().setValue("prefs_enabled_model_providers", providerStrings);
        } else {
            UiPlugin.getDefault().getPluginPreferences().setToDefault("prefs_enabled_model_providers");
        }
        return super.performOk();
    }
}

