/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IChangeHistoryDescriptor;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class HistoryIterator {
    private static final int NUMBER_OF_CHANGE_SETS_TO_FETCH = 50;
    private IChangeHistory baseHistory;
    private int index;
    private List<IChangeHistoryDescriptor> historyDescriptors;
    private Map<UUID, IChangeSet> changeSetCache = new HashMap<UUID, IChangeSet>();

    public HistoryIterator(IWorkspaceConnection connection, IComponentHandle componentHandle) throws ItemNotFoundException, ComponentNotInWorkspaceException {
        this.baseHistory = connection.changeHistory(componentHandle);
    }

    public List<IChangeHistoryEntryChange> nextEntry(SubMonitor progress) throws TeamRepositoryException {
        if (this.historyDescriptors == null) {
            progress.setWorkRemaining(100);
            this.historyDescriptors = this.baseHistory.getHistoryDescriptors(50, false, (IProgressMonitor)progress.newChild(50));
            this.index = this.historyDescriptors.size();
            if (this.historyDescriptors.isEmpty()) {
                return null;
            }
            this.updateChangeSets(progress.newChild(50));
        }
        if (this.index <= 0) {
            progress.setWorkRemaining(100);
            IChangeHistory history = this.historyDescriptors.get(0).previousHistory();
            if (history == null) {
                return null;
            }
            this.historyDescriptors = history.getHistoryDescriptors(50, false, (IProgressMonitor)progress.newChild(50));
            this.index = this.historyDescriptors.size();
            if (this.historyDescriptors.isEmpty()) {
                return null;
            }
            this.updateChangeSets(progress.newChild(50));
        }
        return this.historyDescriptors.get(--this.index).recent();
    }

    private void updateChangeSets(SubMonitor progress) throws TeamRepositoryException {
        this.changeSetCache.clear();
        List<IChangeSetHandle> recent = new ArrayList();
        for (IChangeHistoryDescriptor iChangeHistoryDescriptor : this.historyDescriptors) {
            for (IChangeHistoryEntryChange historyEntry : iChangeHistoryDescriptor.recent()) {
                recent.add(historyEntry.changeSet());
            }
        }
        if (!recent.isEmpty()) {
            recent = this.baseHistory.teamRepository().itemManager().fetchCompleteItems(recent, 0, (IProgressMonitor)progress);
            for (Object object : recent) {
                IChangeSet cs = (IChangeSet)object;
                this.changeSetCache.put(cs.getItemId(), cs);
            }
        }
    }

    public IChangeSet getChangeSet(IChangeSetHandle handle, SubMonitor progress) throws TeamRepositoryException {
        IChangeSet cs = this.changeSetCache.get(handle.getItemId());
        if (cs == null) {
            cs = (IChangeSet)this.baseHistory.teamRepository().itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)progress);
            this.changeSetCache.put(cs.getItemId(), cs);
        }
        return cs;
    }
}

