/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.load.IUpdateInfo;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMModelMergeOperation;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMResourceMappingContext;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseWorkspaceMutator;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;

public class EclipseWorkspaceLogicalModelMutator
extends EclipseWorkspaceMutator {
    private final Collection<IItemConflictReport> conflicts;
    private SCMModelMergeOperation mergeOperation;
    private IUpdateInfo orderer;
    private final Collection<ICopyFileArea> copyFileAreasToUpdate;

    public EclipseWorkspaceLogicalModelMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport2 updates, Collection<IItemUpdateReport> rawUpdates, Collection<IItemConflictReport> conflicts, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler problemHandler, IDownloadListener downloadMonitor) {
        super(connection, componentStatesBefore, componentStatesAfter, updates, rawUpdates, copyFileAreasToUpdate, problemHandler, downloadMonitor);
        this.conflicts = conflicts;
        this.copyFileAreasToUpdate = copyFileAreasToUpdate;
    }

    protected void startingUpdates(IUpdateInfo orderer, IProgressMonitor progress) {
        this.orderer = orderer;
    }

    private IResource[] getInScopeResources(SynchronizationScopeManager scopeManager, FileAreaUpdate update, IProgressMonitor monitor) {
        if (scopeManager == null) {
            return new IResource[0];
        }
        if (update.getItem() instanceof ISymbolicLinkHandle) {
            return new IResource[0];
        }
        SynchronizationScopeManager ssm = scopeManager;
        SCMResourceMappingContext context = (SCMResourceMappingContext)ssm.getContext();
        return context.handleUpdate(update, scopeManager.getScope(), this.copyFileAreasToUpdate, monitor);
    }

    protected void folderAddsAndMovesCompleted(IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        ILocation cfa;
        IResource resource;
        int n;
        int n2;
        IResource[] iResourceArray;
        IResource[] resources;
        SynchronizationScopeManager scopeManager = this.createScopeManager(progress);
        if (scopeManager == null) {
            return;
        }
        for (FileAreaUpdate update : this.orderer.getFileMoves()) {
            iResourceArray = resources = this.getInScopeResources(scopeManager, update, progress);
            n2 = resources.length;
            n = 0;
            while (n < n2) {
                resource = iResourceArray[n];
                cfa = this.getCopyFileArea(resource);
                if (cfa != null) {
                    this.skipUpdate(cfa, update, progress);
                }
                ++n;
            }
        }
        for (FileAreaUpdate update : this.orderer.getOrderedDeletes()) {
            iResourceArray = resources = this.getInScopeResources(scopeManager, update, progress);
            n2 = resources.length;
            n = 0;
            while (n < n2) {
                resource = iResourceArray[n];
                cfa = this.getCopyFileArea(resource);
                if (cfa != null) {
                    this.skipUpdate(cfa, update, progress);
                }
                ++n;
            }
        }
        for (FileAreaUpdate update : this.orderer.getGroupedModifies()) {
            if (!(update.getItem() instanceof IFileItemHandle)) continue;
            iResourceArray = resources = this.getInScopeResources(scopeManager, update, progress);
            n2 = resources.length;
            n = 0;
            while (n < n2) {
                resource = iResourceArray[n];
                cfa = this.getCopyFileArea(resource);
                if (cfa != null) {
                    this.skipUpdate(cfa, update, progress);
                }
                ++n;
            }
        }
        for (FileAreaUpdate update : this.orderer.getFileAdds()) {
            iResourceArray = resources = this.getInScopeResources(scopeManager, update, progress);
            n2 = resources.length;
            n = 0;
            while (n < n2) {
                resource = iResourceArray[n];
                cfa = this.getCopyFileArea(resource);
                if (cfa != null) {
                    this.skipUpdate(cfa, update, progress);
                }
                ++n;
            }
        }
        for (FileAreaUpdate update : (List)this.orderer.getInaccessibleUpdates()) {
            iResourceArray = resources = this.getInScopeResources(scopeManager, update, progress);
            n2 = resources.length;
            n = 0;
            while (n < n2) {
                resource = iResourceArray[n];
                cfa = this.getCopyFileArea(resource);
                if (cfa != null) {
                    this.skipUpdate(cfa, update, progress);
                }
                ++n;
            }
        }
        UpdateDilemmaHandler updateDilemmaHandler = UpdateDilemmaHandler.getDefault();
        DilemmaHandler problemHandler = this.getDilemmaHandler();
        if (problemHandler instanceof UpdateDilemmaHandler) {
            updateDilemmaHandler = (UpdateDilemmaHandler)problemHandler;
        }
        this.mergeOperation = new SCMModelMergeOperation((ISynchronizationScopeManager)scopeManager, updateDilemmaHandler);
        try {
            this.mergeOperation.initializeContext(progress);
        }
        catch (CoreException e) {
            throw FileSystemStatusException.fromCoreException(null, (CoreException)e);
        }
    }

    private ILocation getCopyFileArea(IResource resource) {
        Object adapter = resource.getAdapter(IShareable.class);
        if (adapter instanceof IShareable) {
            IShareable shareable = (IShareable)adapter;
            return shareable.getSandbox().getRoot();
        }
        return null;
    }

    private void skipUpdate(ILocation cfa, FileAreaUpdate update, IProgressMonitor progress) {
        this.addUpdateToSkip(cfa, update.getComponent(), update.getItem());
    }

    private SynchronizationScopeManager createScopeManager(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (this.conflicts.isEmpty() || !(this.connection instanceof IWorkspaceConnection)) {
            return null;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<IItemConflictReport> desiredConflicts = this.getConflictsWithEnabledModelProviders(progress.newChild(1));
        if (desiredConflicts.isEmpty()) {
            return null;
        }
        SCMResourceMappingContext resourceMappingContext = this.createResourceMappingContext(desiredConflicts, progress.newChild(50));
        if (resourceMappingContext == null) {
            return null;
        }
        Collection<ResourceMapping> mappings = resourceMappingContext.getConflictingResources();
        SynchronizationScopeManager scopeManager = new SynchronizationScopeManager(Messages.EclipseWorkspaceLogicalModelMutator_ScopeName, mappings.toArray(new ResourceMapping[mappings.size()]), (ResourceMappingContext)resourceMappingContext, true);
        try {
            scopeManager.initialize((IProgressMonitor)progress.newChild(50));
            if (!scopeManager.getScope().hasAdditonalResources() && !this.hasMappingFromEnabledModelProvider(scopeManager)) {
                SCMModelMergeOperation.dispose((ISynchronizationScopeManager)scopeManager);
                return null;
            }
        }
        catch (CoreException e) {
            this.reportException("An error occurred trying to determine the resources involved in a logical conflict", (Exception)((Object)e));
            SCMModelMergeOperation.dispose((ISynchronizationScopeManager)scopeManager);
            return null;
        }
        return scopeManager;
    }

    private boolean hasMappingFromEnabledModelProvider(SynchronizationScopeManager scopeManager) {
        if (scopeManager.getScope().hasAdditionalMappings()) {
            Collection<IModelProviderDescriptor> enabledModelProviders = this.getEnabledModelProviders();
            for (IModelProviderDescriptor modelProviderDescriptor : enabledModelProviders) {
                if (scopeManager.getScope().getMappings(modelProviderDescriptor.getId()).length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<IItemConflictReport> getConflictsWithEnabledModelProviders(SubMonitor progress) throws TeamRepositoryException {
        ArrayList<IItemConflictReport> result = new ArrayList<IItemConflictReport>();
        Collection<IModelProviderDescriptor> enablededDescriptors = this.getEnabledModelProviders();
        if (enablededDescriptors.isEmpty()) {
            return result;
        }
        progress.setWorkRemaining(this.conflicts.size() * 3);
        block2: for (IItemConflictReport conflict : this.conflicts) {
            IContainer parent;
            if (!this.isComponentShared(conflict.getComponent())) continue;
            IResource resource = this.findResource(conflict, progress.newChild(1));
            if (resource == null) {
                if (!this.hasProjectsInComponentForModelProvider(conflict.getComponent(), enablededDescriptors, progress.newChild(1))) continue;
                result.add(conflict);
                continue;
            }
            if (this.hasMappingForResource(enablededDescriptors, resource, progress.newChild(1))) {
                result.add(conflict);
                continue;
            }
            if (resource.exists() || (parent = resource.getParent()).getType() == 8) continue;
            try {
                IResource[] members;
                IResource[] iResourceArray = members = parent.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (this.hasMappingForResource(enablededDescriptors, member, progress.newChild(1))) {
                        result.add(conflict);
                        continue block2;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw FileSystemStatusException.fromCoreException(null, (CoreException)e);
            }
        }
        return result;
    }

    private boolean hasMappingForResource(Collection<IModelProviderDescriptor> enablededDescriptors, IResource resource, SubMonitor progress) {
        progress.setWorkRemaining(enablededDescriptors.size());
        for (IModelProviderDescriptor desc : enablededDescriptors) {
            try {
                ResourceMapping[] mappings = desc.getModelProvider().getMappings(resource, ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)progress.newChild(1));
                if (mappings.length <= 0) continue;
                return true;
            }
            catch (CoreException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
        }
        return false;
    }

    private boolean hasProjectsInComponentForModelProvider(IComponentHandle component, Collection<IModelProviderDescriptor> enablededDescriptors, SubMonitor monitor) throws FileSystemException {
        monitor.setWorkRemaining(this.copyFileAreasToUpdate.size());
        for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
            Collection shares = cfa.allShares(this.connection.getContextHandle(), component, (IProgressMonitor)monitor.newChild(1));
            for (IShare share : shares) {
                IContainer[] containers;
                IShareable shareable = share.getShareable();
                IContainer[] iContainerArray = containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)shareable.getFullPath().getAdapter(IPath.class));
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer container = iContainerArray[n2];
                    if (this.hasMappingForResource(enablededDescriptors, (IResource)container, monitor.newChild(1))) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private Collection<IModelProviderDescriptor> getEnabledModelProviders() {
        HashSet<IModelProviderDescriptor> enabled = new HashSet<IModelProviderDescriptor>();
        String providersString = UiPlugin.getDefault().getPluginPreferences().getString("prefs_enabled_model_providers");
        if (providersString != null) {
            StringTokenizer tokenizer = new StringTokenizer(providersString, ",");
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken().trim();
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)id);
                if (desc == null) continue;
                enabled.add(desc);
            }
        }
        return enabled;
    }

    private IResource findResource(IItemConflictReport conflict, SubMonitor monitor) throws TeamRepositoryException {
        monitor.setWorkRemaining(2);
        IComponentHandle component = conflict.getComponent();
        IVersionableHandle item = conflict.item();
        IResource resource = this.findResource(component, item, monitor.newChild(1));
        if (resource != null) {
            return resource;
        }
        monitor.setWorkRemaining(2);
        IVersionableHandle ancestor = conflict.getCommonAncestorState();
        if (ancestor != null) {
            IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.connection.teamRepository()).versionableManager();
            try {
                IVersionable fullItem = versionableManager.fetchCompleteState(ancestor, (IProgressMonitor)monitor.newChild(1));
                if (fullItem != null && fullItem.getParent() != null && (resource = this.findResource(component, (IVersionableHandle)fullItem.getParent(), monitor.newChild(1))) instanceof IContainer) {
                    if (item instanceof IFileItemHandle) {
                        return ((IContainer)resource).getFile((IPath)new Path(fullItem.getName()));
                    }
                    if (item instanceof IFolderHandle) {
                        return ((IContainer)resource).getFolder((IPath)new Path(fullItem.getName()));
                    }
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private IResource findResource(IComponentHandle component, IVersionableHandle item, SubMonitor monitor) throws FileSystemException {
        monitor.setWorkRemaining(this.copyFileAreasToUpdate.size());
        for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
            Object adapter;
            Sandbox sandbox = new Sandbox(cfa);
            IShareable shareable = sandbox.findShareable(this.connection.getContextHandle(), component, item, (IProgressMonitor)monitor.newChild(1));
            if (shareable == null || !((adapter = shareable.getAdapter(IResource.class)) instanceof IResource)) continue;
            IResource resource = (IResource)adapter;
            return resource;
        }
        return null;
    }

    private void reportException(String message, Exception e) {
        StatusUtil.log((Object)((Object)this), (String)message, (Throwable)e);
    }

    private SCMResourceMappingContext createResourceMappingContext(Collection<IItemConflictReport> conflicts, SubMonitor monitor) throws TeamRepositoryException {
        SCMResourceMappingContext context = new SCMResourceMappingContext((IWorkspaceConnection)this.connection, conflicts, this.copyFileAreasToUpdate);
        context.initialize((IProgressMonitor)monitor);
        Collection<ResourceMapping> mappings = context.getConflictingResources();
        if (mappings.isEmpty()) {
            context.dispose();
            context = null;
        }
        return context;
    }

    protected void updateCompleted(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (this.mergeOperation != null) {
            try {
                this.mergeOperation.run();
                this.mergeOperation = null;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TeamRepositoryException) {
                    TeamRepositoryException tre = (TeamRepositoryException)cause;
                    throw tre;
                }
                if (cause instanceof FileSystemException) {
                    FileSystemException fsce = (FileSystemException)cause;
                    throw fsce;
                }
                if (cause instanceof CoreException) {
                    FileSystemStatusException fsse = FileSystemStatusException.fromCoreException(null, (CoreException)((CoreException)cause));
                    throw fsse;
                }
                throw new FileSystemException(cause);
            }
            catch (InterruptedException e) {
                throw new OperationCanceledException();
            }
        }
        monitor.done();
    }

    protected void endOperation() {
        if (this.mergeOperation != null) {
            this.mergeOperation.cleanup();
        }
        super.endOperation();
    }
}

